/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;

public class PublicationThread
extends Thread {
    public static final Logger logger = Logger.getLogger((String)PublicationThread.class.getName());

    public synchronized void run() {
        logger.info((Object)"setting block");
        RequestAnalyser.getRequestAnalyser().setBlockRequests(true);
        try {
            int publicationDelay = 5000;
            String publicationThreadDelay = CmsPropertyHandler.getPublicationThreadDelay();
            if (publicationThreadDelay != null && !publicationThreadDelay.equalsIgnoreCase("") && publicationThreadDelay.indexOf("publicationThreadDelay") == -1) {
                publicationDelay = Integer.parseInt(publicationThreadDelay);
            }
            logger.info((Object)("\n\n\nSleeping " + publicationDelay + "ms.\n\n\n"));
            PublicationThread.sleep(publicationDelay);
            logger.info((Object)"\n\n\nUpdating all caches as this was a publishing-update\n\n\n");
            CacheController.clearCastorCaches();
            logger.info((Object)"\n\n\nclearing all except page cache as we are in publish mode..\n\n\n");
            CacheController.clearCaches(null, null, new String[]{"ServerNodeProperties", "serverNodePropertiesCache", "pageCache", "pageCacheExtra", "componentCache", "NavigationCache", "pagePathCache", "userCache", "pageCacheParentSiteNodeCache", "pageCacheLatestSiteNodeVersions", "pageCacheSiteNodeTypeDefinition", "JNDIAuthorizationCache", "WebServiceAuthorizationCache"});
            logger.info((Object)"\n\n\nRecaching all caches as this was a publishing-update\n\n\n");
            CacheController.cacheCentralCastorCaches();
            logger.info((Object)"\n\n\nFinally clearing page cache and other caches as this was a publishing-update\n\n\n");
            CacheController.clearCache("ServerNodeProperties");
            CacheController.clearCache("serverNodePropertiesCache");
            CacheController.clearCache("pageCache");
            CacheController.clearCache("pageCacheExtra");
            CacheController.clearCache("componentCache");
            CacheController.clearCache("NavigationCache");
            CacheController.clearCache("pagePathCache");
            CacheController.clearCache("pageCacheParentSiteNodeCache");
            CacheController.clearCache("pageCacheLatestSiteNodeVersions");
            CacheController.clearCache("pageCacheSiteNodeTypeDefinition");
            CacheController.renameCache("newPagePathCache", "pagePathCache");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred in the PublicationThread:" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)"released block \n\n DONE---");
        RequestAnalyser.getRequestAnalyser().setBlockRequests(false);
    }
}

