/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public class MathHelper {
    public int hexToDecimal(String hex) {
        return new Integer(Integer.parseInt(hex, 16));
    }

    public String fileSize(long size) {
        return this.fileSize(size, Locale.getDefault());
    }

    public String fileSize(long size, Locale locale) {
        String[] pfix = new String[]{"byte", "Kb", "Mb", "Gb"};
        double c = new Long(size).doubleValue();
        int cnt = 0;
        while (c > 512.0 && cnt < 3) {
            c /= 1024.0;
            ++cnt;
        }
        NumberFormat nf = NumberFormat.getInstance(locale);
        if (c > 9.0) {
            nf.setMaximumFractionDigits(0);
        } else {
            nf.setMaximumFractionDigits(2);
        }
        return String.valueOf(nf.format(c)) + " " + pfix[cnt];
    }

    public Integer stringToInteger(String value) {
        if (value == null) {
            return null;
        }
        return new Integer(Integer.parseInt(value));
    }

    public Integer floatStringToInteger(String value) {
        if (value == null) {
            return null;
        }
        return new Integer(new Float(value).intValue());
    }

    public Float floatStringToFloat(String value) {
        if (value == null) {
            return null;
        }
        return new Float(value);
    }

    public String getNumberAsString(Object value, Locale locale, String pattern) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        String output = df.format(value);
        return output;
    }

    public String getNumberAsString(Object value, String pattern) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        String output = df.format(value);
        return output;
    }

    public Float divide(Float value, int divider) {
        if (value == null) {
            return null;
        }
        return new Float(value.floatValue() / (float)divider);
    }

    public int getRandom() {
        Random generator = new Random();
        return generator.nextInt();
    }

    public int getRandom(int upperLimit) {
        Random generator = new Random();
        return generator.nextInt(upperLimit);
    }

    public int round(float floatNumber) {
        return Math.round(floatNumber);
    }

    public float multiply(Number first, Number second) {
        return first.floatValue() * second.floatValue();
    }

    public float multiply(float first, float second) {
        return first * second;
    }

    public float divide(Number first, Number second) {
        return first.floatValue() / second.floatValue();
    }

    public float divide(float first, float second) {
        return first / second;
    }
}

