/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.deliver.util.HTUU;

public class HttpUtilities {
    private static final Logger logger = Logger.getLogger((String)HttpUtilities.class.getName());

    public static String postToUrl(String urlAddress, Hashtable inHash) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = HttpUtilities.toEncodedString(inHash);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static String postToUrl(String urlAddress, Hashtable inHash, String userName, String password, boolean shouldEncode) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Authorization", "Basic " + encodedPassword);
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = shouldEncode ? HttpUtilities.toEncodedString(inHash) : HttpUtilities.toString(inHash);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static String getUrlContent(String urlAddress, HttpServletRequest request, boolean includeRequest) throws Exception {
        if (includeRequest) {
            return HttpUtilities.getUrlContent(urlAddress, HttpUtilities.requestToHashtable(request));
        }
        return HttpUtilities.getUrlContent(urlAddress);
    }

    public static String getUrlContent(String urlAddress, HttpServletRequest request, boolean includeRequest, String encoding) throws Exception {
        if (includeRequest) {
            return HttpUtilities.getUrlContent(urlAddress, HttpUtilities.requestToHashtable(request), encoding);
        }
        return HttpUtilities.getUrlContent(urlAddress, encoding);
    }

    public static String getUrlContent(String urlAddress, Hashtable inHash) throws Exception {
        String line;
        String argString = "";
        if (inHash != null) {
            argString = urlAddress.indexOf("?") > -1 ? "&" + HttpUtilities.toEncodedString(inHash) : "?" + HttpUtilities.toEncodedString(inHash);
        }
        logger.info((Object)("Getting content from url: " + urlAddress + argString));
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, "ISO-8859-1");
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static String getUrlContent(String urlAddress, Hashtable inHash, String encoding) throws Exception {
        String line;
        String argString = "";
        if (inHash != null) {
            argString = urlAddress.indexOf("?") > -1 ? "&" + HttpUtilities.toEncodedString(inHash) : "?" + HttpUtilities.toEncodedString(inHash);
        }
        logger.info((Object)("Getting content from url: " + urlAddress + argString));
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, encoding);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        writer.write(readData);
        baos.flush();
        baos.close();
        writer.flush();
        writer.close();
        readData = new String(baos.toString(encoding));
        return readData;
    }

    public static String getUrlContent(String urlAddress) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static String getUrlContent(String urlAddress, String encoding) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, encoding);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        writer.write(readData);
        baos.flush();
        baos.close();
        writer.flush();
        writer.close();
        readData = new String(baos.toString(encoding));
        return readData;
    }

    public static String getUrlContent(String urlAddress, Hashtable inHash, String userName, String password, boolean shouldEncode) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        String argString = "";
        if (inHash != null) {
            argString = shouldEncode ? "?" + HttpUtilities.toEncodedString(inHash) : "?" + HttpUtilities.toString(inHash);
        }
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Authorization", "Basic " + encodedPassword);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static String getUrlContent(String urlAddress, String data, String userName, String password) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        String argString = "?" + data;
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Authorization", "Basic " + encodedPassword);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public static InputStream getURLStream(String urlAddress, Hashtable inHash) throws Exception {
        String argString = "";
        if (inHash != null) {
            argString = "?" + HttpUtilities.toEncodedString(inHash);
        }
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        return inStream;
    }

    public static Hashtable requestToHashtable(HttpServletRequest request) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        if (request != null) {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = request.getParameter(name);
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    private static String toEncodedString(Hashtable inHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8"));
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private static String toString(Hashtable inHash) {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(name) + "=" + value);
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }
}

