/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.deliver.util.HTUU;

public class HttpHelper {
    private static final Logger logger = Logger.getLogger((String)HttpHelper.class.getName());

    public void downloadFile(String urlAddress, File file) throws Exception {
        int count;
        URL url = new URL(urlAddress);
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(in);
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) > 0) {
            bout.write(buffer, 0, count);
        }
        bout.close();
        in.close();
        bis.close();
    }

    public String postToUrl(String urlAddress, HttpServletRequest request, boolean includeRequest) throws Exception {
        if (includeRequest) {
            return this.postToUrl(urlAddress, this.requestToHashtable(request), "UTF-8");
        }
        return this.postToUrl(urlAddress, new Hashtable(), "UTF-8");
    }

    public String postToUrl(String urlAddress, HttpServletRequest request, boolean includeRequest, String encoding) throws Exception {
        if (includeRequest) {
            return this.postToUrl(urlAddress, this.requestToHashtable(request), encoding);
        }
        return this.postToUrl(urlAddress, new Hashtable(), encoding);
    }

    public String postToUrl(String urlAddress, Hashtable inHash, String encoding) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = this.toEncodedString(inHash, encoding);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String postToUrl(String urlAddress, Hashtable inHash, String userName, String password, boolean shouldEncode) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Authorization", "Basic " + encodedPassword);
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = shouldEncode ? this.toEncodedString(inHash, "UTF-8") : this.toString(inHash);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String getUrlContent(String urlAddress, HttpServletRequest request, boolean includeRequest) throws Exception {
        if (includeRequest) {
            return this.getUrlContent(urlAddress, this.requestToHashtable(request));
        }
        return this.getUrlContent(urlAddress);
    }

    public String getUrlContent(String urlAddress, HttpServletRequest request, boolean includeRequest, String encoding) throws Exception {
        if (includeRequest) {
            return this.getUrlContent(urlAddress, this.requestToHashtable(request), encoding);
        }
        return this.getUrlContent(urlAddress, encoding);
    }

    public String getUrlContent(String urlAddress, Hashtable inHash) throws Exception {
        String line;
        String argString = "";
        if (inHash != null) {
            argString = urlAddress.indexOf("?") > -1 ? "&" + this.toEncodedString(inHash, "UTF-8") : "?" + this.toEncodedString(inHash, "UTF-8");
        }
        logger.info((Object)("Getting content from url: " + urlAddress + argString));
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, "ISO-8859-1");
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String getUrlContent(String urlAddress, Hashtable inHash, String encoding) throws Exception {
        String line;
        String argString = "";
        if (inHash != null) {
            argString = urlAddress.indexOf("?") > -1 ? "&" + this.toEncodedString(inHash, encoding) : "?" + this.toEncodedString(inHash, encoding);
        }
        logger.info((Object)("Getting content from url: " + urlAddress + argString));
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, encoding);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        writer.write(readData);
        baos.flush();
        baos.close();
        writer.flush();
        writer.close();
        readData = new String(baos.toString(encoding));
        return readData;
    }

    public String getUrlContent(String urlAddress) throws Exception {
        return this.getUrlContent(urlAddress, 30000);
    }

    public String getUrlContent(String urlAddress, int timeout) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String getUrlContent(String urlAddress, Map requestParameters) throws Exception {
        return this.getUrlContent(urlAddress, requestParameters, 30000);
    }

    public String getUrlContent(String urlAddress, Map requestProperties, int timeout) throws Exception {
        return this.getUrlContent(urlAddress, requestProperties, null, timeout);
    }

    public String getUrlContent(String urlAddress, Map requestProperties, String encoding, int timeout) throws Exception {
        return this.getUrlContent(urlAddress, requestProperties, new HashMap(), encoding, timeout);
    }

    public String getUrlContent(String urlAddress, Map requestProperties, Map requestParameters, String encoding, int timeout) throws Exception {
        int i;
        String argString = "";
        if (requestParameters != null) {
            argString = urlAddress.indexOf("?") > -1 ? "&" + this.toEncodedString(requestParameters, encoding) : "?" + this.toEncodedString(requestParameters, encoding);
        }
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setUseCaches(false);
        for (String key : requestProperties.keySet()) {
            String value = (String)requestProperties.get(key);
            connection.setRequestProperty(key, value);
        }
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = null;
        inStreamReader = encoding == null ? new InputStreamReader(inStream) : new InputStreamReader(inStream, encoding);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((i = buffer.read()) != -1) {
            strbuf.append((char)i);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String getUrlContent(String urlAddress, String encoding) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream, encoding);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        writer.write(readData);
        baos.flush();
        baos.close();
        writer.flush();
        writer.close();
        readData = new String(baos.toString(encoding));
        return readData;
    }

    public String getUrlContent(String urlAddress, Hashtable inHash, String userName, String password, boolean shouldEncode) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        String argString = "";
        if (inHash != null) {
            argString = shouldEncode ? "?" + this.toEncodedString(inHash, "UTF-8") : "?" + this.toString(inHash);
        }
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Authorization", "Basic " + encodedPassword);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public String getUrlContent(String urlAddress, String data, String userName, String password) throws Exception {
        String line;
        String encodedPassword = HTUU.encode(String.valueOf(userName) + ":" + password);
        String argString = "?" + data;
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Authorization", "Basic " + encodedPassword);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    public InputStream getURLStream(String urlAddress, Hashtable inHash) throws Exception {
        String argString = "";
        if (inHash != null) {
            argString = "?" + this.toEncodedString(inHash, "UTF-8");
        }
        URL url = new URL(String.valueOf(urlAddress) + argString);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream inStream = null;
        inStream = connection.getInputStream();
        return inStream;
    }

    public String getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies;
        if (request != null && (cookies = request.getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(cookieName)) {
                    return cookie.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public Hashtable requestToHashtable(HttpServletRequest request) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        if (request != null) {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = request.getParameter(name);
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    private String toEncodedString(Map inMap, String encoding) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Iterator inMapKeyIterator = inMap.keySet().iterator();
        while (inMapKeyIterator.hasNext()) {
            String name = inMapKeyIterator.next().toString();
            String value = inMap.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, encoding)) + "=" + URLEncoder.encode(value, encoding));
            if (!inMapKeyIterator.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private String toEncodedString(Hashtable inHash, String encoding) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, encoding)) + "=" + URLEncoder.encode(value, encoding));
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private String toString(Hashtable inHash) {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(name) + "=" + value);
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public Map toMap(String parameters, String encoding) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (parameters != null && parameters.length() > 0) {
            String[] parametersArray = parameters.split("&");
            int i = 0;
            while (i < parametersArray.length) {
                String parameterNameValueString = parametersArray[i];
                String[] nameValueArray = parameterNameValueString.split("=");
                String name = URLDecoder.decode(nameValueArray[0], encoding);
                String value = "";
                if (nameValueArray.length > 1) {
                    value = URLDecoder.decode(nameValueArray[1], encoding);
                }
                map.put(name, value);
                ++i;
            }
        }
        return map;
    }
}

