/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.base.events.CachewideEvent;
import com.opensymphony.oscache.extra.CacheEntryEventListenerImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.deliver.util.NullObject;

public class ExtendedCacheEntryEventListenerImpl
extends CacheEntryEventListenerImpl {
    private int totalSize = 0;

    private int getOldSize(CacheEntryEvent event) {
        int oldSize = 0;
        try {
            Object content = event.getMap().getFromCache(event.getKey());
            if (content != null && content instanceof byte[]) {
                oldSize = ((byte[])content).length * 2;
            } else if (content != null) {
                if (content instanceof ContentVersionVO) {
                    oldSize = ((ContentVersionVO)content).getVersionValue().length() * 2 + 38 + 400;
                } else if (content instanceof Map || content instanceof Set || content instanceof List) {
                    int size = 0;
                    Iterator<Object> mapIterator = null;
                    mapIterator = content instanceof Map ? ((Map)content).keySet().iterator() : (content instanceof List ? ((List)content).iterator() : ((Set)content).iterator());
                    while (mapIterator.hasNext()) {
                        Object o = mapIterator.next();
                        size += o.toString().length() * 2;
                    }
                    oldSize = size;
                } else {
                    oldSize = content instanceof NullObject ? 10 : content.toString().length() * 2 + 38;
                }
            }
        }
        catch (NeedsRefreshException e) {
            event.getMap().cancelUpdate(event.getKey());
        }
        return oldSize;
    }

    public void cacheEntryAdded(CacheEntryEvent event) {
        super.cacheEntryAdded(event);
        Object content = event.getEntry().getContent();
        if (content != null && content instanceof byte[]) {
            this.totalSize += ((byte[])content).length * 2;
        } else if (content != null) {
            if (content instanceof ContentVersionVO) {
                this.totalSize = this.totalSize + ((ContentVersionVO)content).getVersionValue().length() * 2 + 38 + 400;
            } else if (content instanceof Map || content instanceof Set || content instanceof List) {
                int size = 0;
                Iterator<Object> mapIterator = null;
                mapIterator = content instanceof Map ? ((Map)content).keySet().iterator() : (content instanceof List ? ((List)content).iterator() : ((Set)content).iterator());
                while (mapIterator.hasNext()) {
                    Object o = mapIterator.next();
                    size += o.toString().length() * 2 + 38;
                }
                this.totalSize += size;
            } else {
                this.totalSize = content instanceof NullObject ? (this.totalSize += 10) : this.totalSize + content.toString().length() * 2 + 38;
            }
        }
    }

    public void cacheEntryFlushed(CacheEntryEvent event) {
        super.cacheEntryFlushed(event);
        this.totalSize -= this.getOldSize(event);
    }

    public void cacheEntryRemoved(CacheEntryEvent event) {
        super.cacheEntryRemoved(event);
        this.totalSize -= this.getOldSize(event);
    }

    public void cacheEntryUpdated(CacheEntryEvent event) {
        super.cacheEntryRemoved(event);
    }

    public void cacheFlushed(CachewideEvent event) {
        super.cacheFlushed(event);
        this.totalSize = 0;
    }

    public String toString() {
        return "Added " + this.getEntryAddedCount() + ", Approximate size " + this.totalSize / 1024 + " KB, Cache Flushed " + this.getCacheFlushedCount();
    }
}

