/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import com.opensymphony.oscache.base.OSCacheUtility;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.invokers.ComponentBasedHTMLPageInvoker;
import org.infoglue.deliver.util.CacheController;

public final class DeliverContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger((String)DeliverContextListener.class.getName());
    private static CacheController cacheController = new CacheController();
    private static ServletContext servletContext = null;

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            String intervalString;
            String contextRootPath = event.getServletContext().getRealPath("/");
            if (!contextRootPath.endsWith("/") && !contextRootPath.endsWith("\\")) {
                contextRootPath = String.valueOf(contextRootPath) + "/";
            }
            System.out.println("\n**************************************");
            System.out.println("Initializing deliver context for directory:" + contextRootPath);
            CmsPropertyHandler.setApplicationName("deliver");
            CmsPropertyHandler.setContextRootPath(contextRootPath);
            CmsPropertyHandler.setOperatingMode(CmsPropertyHandler.getProperty("operatingMode"));
            String logPath = CmsPropertyHandler.getLogPath();
            Enumeration enumeration = Logger.getLogger((String)"org.infoglue.cms").getAllAppenders();
            while (enumeration.hasMoreElements()) {
                RollingFileAppender appender = (RollingFileAppender)enumeration.nextElement();
                if (!appender.getName().equalsIgnoreCase("INFOGLUE-FILE")) continue;
                appender.setFile(logPath);
                appender.activateOptions();
                Logger.getLogger(ComponentBasedHTMLPageInvoker.class).addAppender((Appender)appender);
                break;
            }
            String expireCacheAutomaticallyString = CmsPropertyHandler.getExpireCacheAutomatically();
            if (expireCacheAutomaticallyString != null) {
                cacheController.setExpireCacheAutomatically(Boolean.parseBoolean(expireCacheAutomaticallyString));
            }
            if ((intervalString = CmsPropertyHandler.getCacheExpireInterval()) != null) {
                cacheController.setCacheExpireInterval(Integer.parseInt(intervalString));
            }
            if (cacheController.getExpireCacheAutomatically()) {
                cacheController.start();
            }
            OSCacheUtility.setServletCacheParams(event.getServletContext());
            InfoGlueAuthenticationFilter.initializeProperties();
            CmsPropertyHandler.setStartupTime(new Date());
            System.out.println("**************************************\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        System.out.println("contextDestroyed....");
        cacheController.stopThread();
        cacheController.interrupt();
    }
}

