/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class Counter {
    private static Integer count = new Integer(0);
    private static Integer activeCount = new Integer(0);
    private static Integer totalCount = new Integer(0);
    private static Long totalElapsedTime = new Long(0L);
    private static Long maxElapsedTime = new Long(0L);
    private static Map allComponentsStatistics = new HashMap();
    private static LinkedBlockingQueue latestPublications = new LinkedBlockingQueue(5);

    private Counter() {
    }

    static int getNumberOfCurrentRequests() {
        return count;
    }

    static int getNumberOfActiveRequests() {
        return activeCount;
    }

    static int getTotalNumberOfRequests() {
        return totalCount;
    }

    static long getAverageElapsedTime() {
        if (totalElapsedTime != null && totalCount != 0) {
            return totalElapsedTime / (long)totalCount.intValue();
        }
        return 0L;
    }

    static long getMaxElapsedTime() {
        return maxElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getLatestPublications() {
        ArrayList latestPublicationsList = new ArrayList();
        LinkedBlockingQueue linkedBlockingQueue = latestPublications;
        synchronized (linkedBlockingQueue) {
            Iterator latestPublicationsIterator = latestPublications.iterator();
            while (latestPublicationsIterator.hasNext()) {
                latestPublicationsList.add(latestPublicationsIterator.next());
            }
        }
        return latestPublicationsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void addPublication(Date publicationDate) {
        LinkedBlockingQueue linkedBlockingQueue = latestPublications;
        synchronized (linkedBlockingQueue) {
            if (latestPublications.remainingCapacity() == 0) {
                latestPublications.poll();
            }
            latestPublications.add(publicationDate);
        }
    }

    static synchronized void incNumberOfCurrentRequests(boolean active) {
        count = new Integer(count + 1);
        if (active) {
            activeCount = new Integer(activeCount + 1);
        }
    }

    static synchronized void decNumberOfCurrentRequests(long elapsedTime) {
        if (count > 0) {
            count = new Integer(count - 1);
        }
        if (elapsedTime != -1L && activeCount > 0) {
            activeCount = new Integer(activeCount - 1);
        }
        totalCount = new Integer(totalCount + 1);
        if (elapsedTime != -1L) {
            totalElapsedTime = new Long(totalElapsedTime + elapsedTime);
            if (elapsedTime > maxElapsedTime) {
                maxElapsedTime = new Long(elapsedTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Set getAllComponentNames() {
        Map map = allComponentsStatistics;
        synchronized (map) {
            return allComponentsStatistics.keySet();
        }
    }

    private static synchronized Map getComponentStatistics(String componentName) {
        HashMap<String, Number> componentStatistics = (HashMap<String, Number>)allComponentsStatistics.get(componentName);
        if (componentStatistics == null) {
            componentStatistics = new HashMap<String, Number>();
            componentStatistics.put("totalElapsedTime", new Long(0L));
            componentStatistics.put("totalNumberOfInvokations", new Integer(0));
            allComponentsStatistics.put(componentName, componentStatistics);
        }
        return componentStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void registerComponentStatistics(String componentName, long elapsedTime) {
        Map componentStatistics;
        Map map = componentStatistics = Counter.getComponentStatistics(componentName);
        synchronized (map) {
            Long oldTotalElapsedTime = (Long)componentStatistics.get("totalElapsedTime");
            Long totalElapsedTime = new Long(oldTotalElapsedTime + elapsedTime);
            componentStatistics.put("totalElapsedTime", totalElapsedTime);
            Integer oldTotalNumberOfInvokations = (Integer)componentStatistics.get("totalNumberOfInvokations");
            Integer totalNumberOfInvokations = new Integer(oldTotalNumberOfInvokations + 1);
            componentStatistics.put("totalNumberOfInvokations", totalNumberOfInvokations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getAverageElapsedTime(String componentName) {
        Map componentStatistics;
        Map map = componentStatistics = Counter.getComponentStatistics(componentName);
        synchronized (map) {
            Long totalElapsedTime = (Long)componentStatistics.get("totalElapsedTime");
            Integer oldTotalNumberOfInvokations = (Integer)componentStatistics.get("totalNumberOfInvokations");
            return totalElapsedTime / (long)oldTotalNumberOfInvokations.intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNumberOfHits(String componentName) {
        Map componentStatistics;
        Map map = componentStatistics = Counter.getComponentStatistics(componentName);
        synchronized (map) {
            return (Integer)componentStatistics.get("totalNumberOfInvokations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetComponentStatistics() {
        Map map = allComponentsStatistics;
        synchronized (map) {
            allComponentsStatistics.clear();
        }
    }
}

