/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.FakeHttpServletRequest;
import org.infoglue.cms.util.FakeHttpServletResponse;
import org.infoglue.cms.util.FakeHttpSession;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.util.BrowserBean;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.DeliverContextListener;

public class ContentCentricCachePopulator {
    public static final Logger logger = Logger.getLogger((String)ContentCentricCachePopulator.class.getName());

    public void recache(DatabaseWrapper dbWrapper, Integer siteNodeId) throws SystemException, Exception {
        logger.info((Object)"recache starting..");
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(dbWrapper.getDatabase(), siteNodeId);
        if (masterLanguageVO == null) {
            throw new SystemException("There was no master language for the siteNode " + siteNodeId);
        }
        Integer languageId = masterLanguageVO.getLanguageId();
        if (languageId == null) {
            languageId = masterLanguageVO.getLanguageId();
        }
        Integer contentId = new Integer(-1);
        Principal principal = (Principal)CacheController.getCachedObject("userCache", "anonymous");
        if (principal == null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
            arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
            principal = ExtranetController.getController().getAuthenticatedPrincipal(dbWrapper.getDatabase(), arguments);
            if (principal != null) {
                CacheController.cacheObject("userCache", "anonymous", principal);
            }
        }
        FakeHttpSession fakeHttpServletSession = new FakeHttpSession();
        FakeHttpServletResponse fakeHttpServletResponse = new FakeHttpServletResponse();
        FakeHttpServletRequest fakeHttpServletRequest = new FakeHttpServletRequest();
        fakeHttpServletRequest.setParameter("siteNodeId", "" + siteNodeId);
        fakeHttpServletRequest.setParameter("languageId", "" + languageId);
        fakeHttpServletRequest.setParameter("contentId", "" + contentId);
        fakeHttpServletRequest.setRequestURI("ViewPage.action");
        fakeHttpServletRequest.setAttribute("siteNodeId", (Object)("" + siteNodeId));
        fakeHttpServletRequest.setAttribute("languageId", (Object)("" + languageId));
        fakeHttpServletRequest.setAttribute("contentId", (Object)("" + contentId));
        fakeHttpServletRequest.setServletContext(DeliverContextListener.getServletContext());
        BrowserBean browserBean = new BrowserBean();
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId);
        IntegrationDeliveryController integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(siteNodeId, languageId, contentId);
        TemplateController templateController = this.getTemplateController(dbWrapper, siteNodeId, languageId, contentId, (HttpServletRequest)new FakeHttpServletRequest(), (InfoGluePrincipal)principal, false, browserBean, nodeDeliveryController, integrationDeliveryController);
        DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext();
        deliveryContext.setSiteNodeId(siteNodeId);
        deliveryContext.setContentId(contentId);
        deliveryContext.setLanguageId(languageId);
        deliveryContext.setPageKey("" + System.currentTimeMillis());
        deliveryContext.setSession(new Session((HttpSession)fakeHttpServletSession));
        deliveryContext.setInfoGlueAbstractAction(null);
        deliveryContext.setHttpServletRequest((HttpServletRequest)fakeHttpServletRequest);
        deliveryContext.setHttpServletResponse((HttpServletResponse)fakeHttpServletResponse);
        templateController.setDeliveryContext(deliveryContext);
        deliveryContext.setDisablePageCache(true);
        Integer rootMetaInfoContentId = templateController.getMetaInformationContentId(siteNodeId);
        logger.info((Object)("rootMetaInfoContentId:" + rootMetaInfoContentId));
        this.recurseSiteNodeTree(siteNodeId, languageId, templateController);
        Integer topContentId = null;
        ContentVO contentVO = templateController.getContent(rootMetaInfoContentId);
        logger.info((Object)("contentVO:" + contentVO.getName()));
        ContentVO parentContentVO = templateController.getContent(contentVO.getParentContentId());
        logger.info((Object)("parentContentVO:" + parentContentVO.getName()));
        while (parentContentVO != null) {
            topContentId = parentContentVO.getContentId();
            parentContentVO = parentContentVO.getParentContentId() != null ? templateController.getContent(parentContentVO.getParentContentId()) : null;
        }
        logger.info((Object)("topContentId:" + topContentId));
        if (topContentId != null) {
            this.recurseContentTree(topContentId, languageId, templateController);
        }
    }

    private void recurseContentTree(Integer contentId, Integer languageId, TemplateController templateController) throws Exception {
        Content content = ContentController.getContentController().getReadOnlyContentWithId(contentId, templateController.getDatabase());
        ContentVO contentVO = templateController.getContent(contentId);
        Collection childContents = content.getChildren();
        for (Content childContent : childContents) {
            this.recurseContentTree(childContent.getId(), languageId, templateController);
            logger.info((Object)"Before read title of content...");
            templateController.getContentAttribute(childContent.getId(), languageId, "Title", true);
            templateController.getContentAttribute(childContent.getId(), languageId, "NavigationTitle", true);
            logger.info((Object)"Read title of content...");
        }
    }

    private void recurseSiteNodeTree(Integer siteNodeId, Integer languageId, TemplateController templateController) throws Exception {
        SiteNodeController.getController();
        SiteNode siteNode = SiteNodeController.getSiteNodeWithId(siteNodeId, templateController.getDatabase(), true);
        SiteNodeVO siteNodeVO = templateController.getSiteNode(siteNodeId);
        Collection childSiteNodes = siteNode.getChildSiteNodes();
        for (SiteNode childSiteNode : childSiteNodes) {
            this.recurseSiteNodeTree(childSiteNode.getSiteNodeId(), languageId, templateController);
            Integer metaInfoContentId = templateController.getMetaInformationContentId(childSiteNode.getSiteNodeId());
            templateController.getContentAttribute(metaInfoContentId, languageId, "ComponentStructure", true);
        }
    }

    public TemplateController getTemplateController(DatabaseWrapper dbWrapper, Integer siteNodeId, Integer languageId, Integer contentId, HttpServletRequest request, InfoGluePrincipal infoGluePrincipal, boolean allowEditOnSightAtAll, BrowserBean browserBean, NodeDeliveryController nodeDeliveryController, IntegrationDeliveryController integrationDeliveryController) throws SystemException, Exception {
        BasicTemplateController templateController = new BasicTemplateController(dbWrapper, infoGluePrincipal);
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(request);
        templateController.setBrowserBean(browserBean);
        templateController.setDeliveryControllers(nodeDeliveryController, null, integrationDeliveryController);
        return templateController;
    }
}

