/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class CompressionHelper {
    private static final Logger logger = Logger.getLogger((String)CompressionHelper.class.getName());

    public byte[] compress(String string) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(gz);
            oos.writeObject(string);
            oos.flush();
            oos.close();
            fos.close();
            bytes = fos.toByteArray();
            return bytes;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to compress a string:" + e.getMessage()), (Throwable)e);
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (Exception e2) {
                logger.error((Object)("An error occurred when we tried to just return the uncompressed bytes:" + e2.getMessage()), (Throwable)e2);
            }
            return bytes;
        }
    }

    public String decompress(byte[] bytes) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
            GZIPInputStream gs = new GZIPInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(gs);
            String decompressed1 = (String)ois.readObject();
            ois.close();
            fis.close();
            return decompressed1;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to decompress a string:" + e.getMessage()), (Throwable)e);
            return "";
        }
    }
}

