/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.base.events.CacheEntryEventListener;
import com.opensymphony.oscache.base.events.CacheEventListener;
import com.opensymphony.oscache.base.events.CacheMapAccessEventListener;
import com.opensymphony.oscache.extra.CacheMapAccessEventListenerImpl;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.exolab.castor.jdo.CacheManager;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentRelationImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.content.impl.simple.DigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumContentImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentVersionImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallishContentImpl;
import org.infoglue.cms.entities.management.impl.simple.AccessRightImpl;
import org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.FormEntryImpl;
import org.infoglue.cms.entities.management.impl.simple.FormEntryValueImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupPropertiesImpl;
import org.infoglue.cms.entities.management.impl.simple.InterceptionPointImpl;
import org.infoglue.cms.entities.management.impl.simple.InterceptorImpl;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.PropertiesCategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.RedirectImpl;
import org.infoglue.cms.entities.management.impl.simple.RegistryImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.RoleContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.RoleImpl;
import org.infoglue.cms.entities.management.impl.simple.RolePropertiesImpl;
import org.infoglue.cms.entities.management.impl.simple.ServerNodeImpl;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.SiteNodeTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.SubscriptionImpl;
import org.infoglue.cms.entities.management.impl.simple.SystemUserImpl;
import org.infoglue.cms.entities.management.impl.simple.UserContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.UserPropertiesImpl;
import org.infoglue.cms.entities.publishing.impl.simple.PublicationImpl;
import org.infoglue.cms.entities.structure.impl.simple.QualifyerImpl;
import org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl;
import org.infoglue.cms.entities.workflow.impl.simple.ActionDefinitionImpl;
import org.infoglue.cms.entities.workflow.impl.simple.ActionImpl;
import org.infoglue.cms.entities.workflow.impl.simple.ActorImpl;
import org.infoglue.cms.entities.workflow.impl.simple.ConsequenceDefinitionImpl;
import org.infoglue.cms.entities.workflow.impl.simple.ConsequenceImpl;
import org.infoglue.cms.entities.workflow.impl.simple.EventImpl;
import org.infoglue.cms.entities.workflow.impl.simple.WorkflowDefinitionImpl;
import org.infoglue.cms.entities.workflow.impl.simple.WorkflowImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.workflow.InfoGlueJDBCPropertySet;
import org.infoglue.deliver.applications.actions.InfoGlueComponent;
import org.infoglue.deliver.applications.databeans.CacheEvictionBean;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.portal.ServletConfigContainer;
import org.infoglue.deliver.util.ContentCentricCachePopulator;
import org.infoglue.deliver.util.ExtendedCacheEntryEventListenerImpl;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.PublicationThread;
import org.infoglue.deliver.util.RequestAnalyser;
import org.infoglue.deliver.util.RequestAndMetaInfoCentricCachePopulator;
import org.infoglue.deliver.util.RequestCentricCachePopulator;
import org.infoglue.deliver.util.SelectiveLivePublicationThread;
import org.infoglue.deliver.util.WorkingPublicationThread;

public class CacheController
extends Thread {
    public static final Logger logger = Logger.getLogger((String)CacheController.class.getName());
    public static final String SETTINGSPROPERTIESCACHENAME = "serverNodePropertiesCache";
    public static final String SETTINGSPROPERTIESDOCUMENTCACHENAME = "serverNodePropertiesDocumentCache";
    public static List notifications = Collections.synchronizedList(new ArrayList());
    private static Map eventListeners = new HashMap();
    private static ConcurrentMap caches = new ConcurrentHashMap();
    private boolean expireCacheAutomatically = false;
    private int cacheExpireInterval = 1800000;
    private boolean continueRunning = true;
    private static GeneralCacheAdministrator generalCache = new GeneralCacheAdministrator();
    public static Date expireDateTime = null;
    public static Date publishDateTime = null;

    public void setCacheExpireInterval(int cacheExpireInterval) {
        this.cacheExpireInterval = cacheExpireInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameCache(String cacheName, String newCacheName) {
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            Object cacheInstance = caches.get(cacheName);
            if (cacheInstance != null) {
                Object v = cacheInstance;
                synchronized (v) {
                    caches.put(newCacheName, cacheInstance);
                    caches.remove(cacheName);
                }
            }
        }
    }

    public static void clearServerNodeProperty(boolean reCache) {
        CacheController.clearCache(SETTINGSPROPERTIESCACHENAME);
        CacheController.clearCache("encodedStringsCache");
        if (reCache) {
            InfoGlueJDBCPropertySet.reCache();
        } else {
            InfoGlueJDBCPropertySet.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheObject(String cacheName, Object key, Object value) {
        if (cacheName == null || key == null || value == null) {
            return;
        }
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            if (!caches.containsKey(cacheName)) {
                caches.put(cacheName, new HashMap());
            }
        }
        Map cacheInstance = (Map)caches.get(cacheName);
        if (cacheInstance != null && key != null && value != null) {
            Map map = cacheInstance;
            synchronized (map) {
                cacheInstance.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getCachedObject(String cacheName, Object key) {
        if (cacheName == null || key == null) {
            return null;
        }
        Map cacheInstance = (Map)caches.get(cacheName);
        if (cacheInstance != null) {
            Map map = cacheInstance;
            synchronized (map) {
                return cacheInstance.get(key);
            }
        }
        return null;
    }

    public static void cacheObjectInAdvancedCacheWithGroupsAsSet(String cacheName, Object key, Object value, Set groupsAsList, boolean useGroups) {
        Object[] o = groupsAsList.toArray();
        String[] groups = new String[o.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = o[i].toString();
            ++i;
        }
        CacheController.cacheObjectInAdvancedCache(cacheName, key, value, groups, useGroups);
    }

    public static void cacheObjectInAdvancedCache(String cacheName, Object key, Object value) {
        CacheController.cacheObjectInAdvancedCache(cacheName, key, value, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheObjectInAdvancedCache(String cacheName, Object key, Object value, String[] groups, boolean useGroups) {
        GeneralCacheAdministrator cacheAdministrator;
        if (cacheName == null || key == null || value == null || key.toString().length() == 0) {
            return;
        }
        if (!caches.containsKey(cacheName)) {
            cacheAdministrator = null;
            Map cacheSettings = (Map)CacheController.getCachedObject("serverNodePropertiesCacheSettings", "cacheSettings");
            if (cacheSettings == null) {
                cacheSettings = CmsPropertyHandler.getCacheSettings();
                CacheController.cacheObject("serverNodePropertiesCacheSettings", "cacheSettings", cacheSettings);
            }
            String cacheCapacity = (String)cacheSettings.get("CACHE_CAPACITY_" + cacheName);
            if (cacheName != null && cacheName.equalsIgnoreCase("pageCache")) {
                cacheCapacity = "10000";
            }
            if (cacheName != null && cacheName.equalsIgnoreCase("pageCacheExtra")) {
                cacheCapacity = "20000";
            }
            if (cacheName != null && cacheName.equalsIgnoreCase("encodedStringsCache")) {
                cacheCapacity = "2000";
            }
            if (cacheCapacity != null && !cacheCapacity.equals("")) {
                Properties p = new Properties();
                String cacheAlgorithm = (String)cacheSettings.get("CACHE_ALGORITHM_" + cacheName);
                if (cacheAlgorithm == null || cacheAlgorithm.equals("")) {
                    p.setProperty("cache.algorithm", "com.opensymphony.oscache.base.algorithm.ImprovedLRUCache");
                } else {
                    p.setProperty("cache.algorithm", cacheAlgorithm);
                }
                p.setProperty("cache.capacity", cacheCapacity);
                cacheAdministrator = new GeneralCacheAdministrator(p);
            } else {
                cacheAdministrator = new GeneralCacheAdministrator();
            }
            ExtendedCacheEntryEventListenerImpl cacheEntryEventListener = new ExtendedCacheEntryEventListenerImpl();
            CacheMapAccessEventListenerImpl cacheMapAccessEventListener = new CacheMapAccessEventListenerImpl();
            cacheAdministrator.getCache().addCacheEventListener((CacheEventListener)cacheEntryEventListener, CacheEntryEventListener.class);
            cacheAdministrator.getCache().addCacheEventListener((CacheEventListener)cacheMapAccessEventListener, CacheMapAccessEventListener.class);
            caches.put(cacheName, cacheAdministrator);
            eventListeners.put(String.valueOf(cacheName) + "_cacheEntryEventListener", cacheEntryEventListener);
            eventListeners.put(String.valueOf(cacheName) + "_cacheMapAccessEventListener", cacheMapAccessEventListener);
        }
        GeneralCacheAdministrator generalCacheAdministrator = cacheAdministrator = (GeneralCacheAdministrator)caches.get(cacheName);
        synchronized (generalCacheAdministrator) {
            if (useGroups) {
                if (logger.isDebugEnabled() && cacheName.equalsIgnoreCase("componentPropertyCache") && key.toString().indexOf("Article") > 0) {
                    logger.debug((Object)("Caching objects in " + cacheName + "-->\n[" + key.toString() + "]"));
                    int i = 0;
                    while (i < groups.length) {
                        logger.debug((Object)("group:" + groups[i]));
                        ++i;
                    }
                    if (groups.length == 0) {
                        logger.debug((Object)"No group....");
                    }
                }
                cacheAdministrator.putInCache(key.toString(), value, groups);
            } else {
                cacheAdministrator.putInCache(key.toString(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getCachedObjectFromAdvancedCache(String cacheName, String key) {
        if (cacheName == null || key == null || key.length() == 0) {
            return null;
        }
        Object value = null;
        GeneralCacheAdministrator cacheAdministrator = (GeneralCacheAdministrator)caches.get(cacheName);
        if (cacheAdministrator != null) {
            GeneralCacheAdministrator generalCacheAdministrator = cacheAdministrator;
            synchronized (generalCacheAdministrator) {
                try {
                    value = cacheAdministrator == null ? null : cacheAdministrator.getFromCache(key, -1);
                }
                catch (NeedsRefreshException nre) {
                    cacheAdministrator.cancelUpdate(key);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getCachedObjectFromAdvancedCache(String cacheName, String key, int updateInterval) {
        if (cacheName == null || key == null) {
            return null;
        }
        Object value = null;
        GeneralCacheAdministrator cacheAdministrator = (GeneralCacheAdministrator)caches.get(cacheName);
        if (cacheAdministrator != null) {
            GeneralCacheAdministrator generalCacheAdministrator = cacheAdministrator;
            synchronized (generalCacheAdministrator) {
                try {
                    value = cacheAdministrator == null ? null : cacheAdministrator.getFromCache(key, updateInterval);
                }
                catch (NeedsRefreshException nre) {
                    cacheAdministrator.cancelUpdate(key);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(String cacheName) {
        logger.info((Object)("Clearing the cache called " + cacheName));
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            if (caches.containsKey(cacheName)) {
                GeneralCacheAdministrator cacheInstance;
                Object object = caches.get(cacheName);
                if (object instanceof Map) {
                    Map cacheInstance2;
                    Map map = cacheInstance2 = (Map)object;
                    synchronized (map) {
                        cacheInstance2.clear();
                    }
                }
                GeneralCacheAdministrator generalCacheAdministrator = cacheInstance = (GeneralCacheAdministrator)object;
                synchronized (generalCacheAdministrator) {
                    cacheInstance.flushAll();
                }
                caches.remove(cacheName);
                eventListeners.remove(String.valueOf(cacheName) + "_cacheEntryEventListener");
                eventListeners.remove(String.valueOf(cacheName) + "_cacheMapAccessEventListener");
                logger.info((Object)"clearCache stop...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(String cacheName, String key) {
        logger.info((Object)("Clearing the cache called " + cacheName + " and key: " + key));
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            if (caches.containsKey(cacheName)) {
                GeneralCacheAdministrator cacheInstance;
                Object object = caches.get(cacheName);
                if (object instanceof Map) {
                    Map cacheInstance2;
                    Map map = cacheInstance2 = (Map)object;
                    synchronized (map) {
                        cacheInstance2.remove(key);
                    }
                }
                GeneralCacheAdministrator generalCacheAdministrator = cacheInstance = (GeneralCacheAdministrator)object;
                synchronized (generalCacheAdministrator) {
                    cacheInstance.flushEntry(key);
                }
                logger.info((Object)"clearCache stop...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCacheForGroup(String cacheName, String group) {
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            if (caches.containsKey(cacheName)) {
                GeneralCacheAdministrator cacheInstance;
                Object object = caches.get(cacheName);
                if (object instanceof Map) {
                    Map cacheInstance2;
                    Map map = cacheInstance2 = (Map)object;
                    synchronized (map) {
                        cacheInstance2.clear();
                        logger.warn((Object)("Clearing full cache:" + cacheName + " - the call wanted partly clear for [" + group + "] but the cache was a Map."));
                    }
                }
                GeneralCacheAdministrator generalCacheAdministrator = cacheInstance = (GeneralCacheAdministrator)object;
                synchronized (generalCacheAdministrator) {
                    cacheInstance.flushGroup(group);
                    logger.info((Object)("Clearing cache for group:" + cacheName + " - " + group));
                }
            }
        }
    }

    public static void clearCaches(String entity, String entityId, String[] cachesToSkip) throws Exception {
        CacheController.clearCaches(entity, entityId, cachesToSkip, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches(String entity, String entityId, String[] cachesToSkip, boolean forceClear) throws Exception {
        long wait = 0L;
        while (!forceClear && RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() > 0) {
            if (wait == 3000L) {
                logger.warn((Object)("The clearCache method waited over " + wait * 10L / 1000L + " seconds but there seems to be " + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + " requests blocking all the time. Continuing anyway."));
                System.out.println("The clearCache method waited over");
                break;
            }
            Thread.sleep(10L);
            ++wait;
        }
        logger.info((Object)("clearCaches start in " + CmsPropertyHandler.getContextRootPath()));
        if (entity == null) {
            logger.info((Object)"Clearing the caches");
            ConcurrentMap concurrentMap = caches;
            synchronized (concurrentMap) {
                Iterator i = caches.entrySet().iterator();
                while (i.hasNext()) {
                    Map map;
                    Map cacheInstance;
                    Map.Entry e = i.next();
                    logger.info((Object)("e:" + e.getKey()));
                    boolean skip = false;
                    if (cachesToSkip != null) {
                        int index = 0;
                        while (index < cachesToSkip.length) {
                            if (e.getKey().equals(cachesToSkip[index])) {
                                skip = true;
                                break;
                            }
                            ++index;
                        }
                    }
                    if (skip) continue;
                    Object object = e.getValue();
                    if (object instanceof Map) {
                        map = cacheInstance = (Map)e.getValue();
                        synchronized (map) {
                            cacheInstance.clear();
                        }
                    }
                    map = cacheInstance = (GeneralCacheAdministrator)e.getValue();
                    synchronized (map) {
                        cacheInstance.flushAll();
                    }
                    eventListeners.clear();
                    logger.info((Object)("Cleared cache:" + e.getKey()));
                    i.remove();
                }
            }
        }
        logger.info((Object)"Clearing some caches");
        logger.info((Object)("entity:" + entity));
        ConcurrentMap concurrentMap = caches;
        synchronized (concurrentMap) {
            Iterator i = caches.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                logger.info((Object)("e:" + e.getKey()));
                boolean clear = false;
                boolean selectiveCacheUpdate = false;
                String cacheName = e.getKey().toString();
                if (cacheName.equalsIgnoreCase("serviceDefinitionCache") && entity.indexOf("ServiceBinding") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("qualifyerListCache") && (entity.indexOf("Qualifyer") > 0 || entity.indexOf("ServiceBinding") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("availableServiceBindingCache") && entity.indexOf("AvailableServiceBinding") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("languageCache") && entity.indexOf("Language") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("localeCache") && entity.indexOf("Language") > 0) {
                    clear = true;
                }
                if ((cacheName.equalsIgnoreCase("latestSiteNodeVersionCache") || cacheName.equalsIgnoreCase("pageCacheLatestSiteNodeVersions") || cacheName.equalsIgnoreCase("pageCacheSiteNodeTypeDefinition")) && entity.indexOf("SiteNode") > 0) {
                    clear = true;
                }
                if ((cacheName.equalsIgnoreCase("parentSiteNodeCache") || cacheName.equalsIgnoreCase("pageCacheParentSiteNodeCache")) && entity.indexOf("SiteNode") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("NavigationCache") && (entity.indexOf("SiteNode") > 0 || entity.indexOf("Content") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("pagePathCache") && (entity.indexOf("SiteNode") > 0 || entity.indexOf("Content") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("componentEditorCache") && (entity.indexOf("SiteNode") > 0 || entity.indexOf("Content") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("masterLanguageCache") && (entity.indexOf("Repository") > 0 || entity.indexOf("Language") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("parentRepository") && entity.indexOf("Repository") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("contentAttributeCache") && (entity.indexOf("Content") > -1 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("contentVersionCache") && (entity.indexOf("Content") > -1 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("referencingPagesCache") && (entity.indexOf("ContentVersion") > -1 || entity.indexOf("Qualifyer") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("boundSiteNodeCache") && (entity.indexOf("ServiceBinding") > 0 || entity.indexOf("Qualifyer") > 0 || entity.indexOf("SiteNodeVersion") > 0 || entity.indexOf("SiteNodeVersion") > 0 || entity.indexOf("SiteNode") > 0 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("boundContentCache") && (entity.indexOf("ServiceBinding") > 0 || entity.indexOf("Qualifyer") > 0 || entity.indexOf("SiteNodeVersion") > 0 || entity.indexOf("ContentVersion") > 0 || entity.indexOf("Content") > 0 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("pageCache") && entity.indexOf("Registry") == -1) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("pageCacheExtra") && entity.indexOf("Registry") == -1) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("componentCache") && entity.indexOf("Registry") == -1) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("componentPropertyCache") && (entity.indexOf("ContentVersion") > -1 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                    selectiveCacheUpdate = true;
                }
                if (cacheName.equalsIgnoreCase("pageComponentsCache") && (entity.indexOf("ContentVersion") > -1 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("includeCache")) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("authorizationCache") && (entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0 || entity.indexOf("Intercept") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("personalAuthorizationCache") && (entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0 || entity.indexOf("Intercept") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("componentPaletteDivCache") && (entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("userCache") && (entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("principalCache") && (entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if ((cacheName.equalsIgnoreCase("assetUrlCache") || cacheName.equalsIgnoreCase("assetThumbnailUrlCache")) && (entity.indexOf("DigitalAsset") > 0 || entity.indexOf("ContentVersion") > 0 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("digitalAssetCache") && (entity.indexOf("DigitalAsset") > 0 || entity.indexOf("ContentVersion") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("sortedChildContentsCache") && (entity.indexOf("Content") > 0 || entity.indexOf("ContentVersion") > 0 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("matchingContentsCache") && (entity.indexOf("Content") > 0 || entity.indexOf("ContentVersion") > 0 || entity.indexOf("AccessRight") > 0 || entity.indexOf("SystemUser") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("Group") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("workflowCache") && entity.indexOf("WorkflowDefinition") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("rootSiteNodeCache") && entity.indexOf("SiteNode") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("childSiteNodesCache") && entity.indexOf("SiteNode") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("propertySetCache") && entity.indexOf("SiteNode") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("groupVOListCache") && entity.indexOf("Group") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("roleListCache") && entity.indexOf("Role") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("groupPropertiesCache") && entity.indexOf("Group") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("rolePropertiesCache") && entity.indexOf("Role") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("principalPropertyValueCache") && (entity.indexOf("Group") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("User") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("relatedCategoriesCache") && (entity.indexOf("Group") > 0 || entity.indexOf("Role") > 0 || entity.indexOf("User") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("redirectCache") && entity.indexOf("Redirect") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("interceptorsCache") && entity.indexOf("Intercept") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("interceptionPointCache") && entity.indexOf("Intercept") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("siteNodeLanguageCache") && (entity.indexOf("Repository") > 0 || entity.indexOf("Language") > 0 || entity.indexOf("SiteNode") > 0)) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("contentTypeDefinitionCache") && entity.indexOf("ContentTypeDefinition") > 0) {
                    clear = true;
                }
                if (cacheName.equalsIgnoreCase("ServerNodeProperties")) {
                    clear = true;
                }
                if (!cacheName.equalsIgnoreCase(SETTINGSPROPERTIESCACHENAME) && entity.equalsIgnoreCase("ServerNodeProperties")) {
                    clear = true;
                }
                if (!cacheName.equalsIgnoreCase("encodedStringsCache") && entity.equalsIgnoreCase("ServerNodeProperties")) {
                    clear = true;
                }
                logger.info((Object)("clear:" + clear));
                if (clear) {
                    GeneralCacheAdministrator cacheInstance;
                    logger.info((Object)("clearing:" + e.getKey()));
                    Object object = e.getValue();
                    if (object instanceof Map) {
                        Map cacheInstance2;
                        Map map = cacheInstance2 = (Map)e.getValue();
                        synchronized (map) {
                            cacheInstance2.clear();
                        }
                    }
                    String useSelectivePageCacheUpdateString = CmsPropertyHandler.getUseSelectivePageCacheUpdate();
                    boolean useSelectivePageCacheUpdate = false;
                    if (useSelectivePageCacheUpdateString != null && useSelectivePageCacheUpdateString.equalsIgnoreCase("true")) {
                        useSelectivePageCacheUpdate = true;
                    }
                    String operatingMode = CmsPropertyHandler.getOperatingMode();
                    GeneralCacheAdministrator generalCacheAdministrator = cacheInstance = (GeneralCacheAdministrator)e.getValue();
                    synchronized (generalCacheAdministrator) {
                        if (selectiveCacheUpdate && entity.indexOf("SiteNode") > 0) {
                            cacheInstance.flushAll();
                            eventListeners.remove(String.valueOf(cacheName) + "_cacheEntryEventListener");
                            eventListeners.remove(String.valueOf(cacheName) + "_cacheMapAccessEventListener");
                            logger.info((Object)("clearing:" + e.getKey()));
                        } else if (selectiveCacheUpdate && entity.indexOf("ContentVersion") > 0 && useSelectivePageCacheUpdate) {
                            logger.info((Object)"Getting eventListeners...");
                            Object cacheEntryEventListener = eventListeners.get(e.getKey() + "_cacheEntryEventListener");
                            Object cacheMapAccessEventListener = eventListeners.get(e.getKey() + "_cacheMapAccessEventListener");
                            logger.info((Object)"Before flushGroup...");
                            cacheInstance.flushGroup("contentVersion_" + entityId);
                            cacheInstance.flushGroup("selectiveCacheUpdateNonApplicable");
                            logger.info((Object)("clearing " + e.getKey() + " with group " + "contentVersion_" + entityId));
                            try {
                                logger.info((Object)"Before contentVersionVO...");
                                Integer contentId = ContentVersionController.getContentVersionController().getContentIdForContentVersion(new Integer(entityId));
                                if (contentId != null) {
                                    logger.info((Object)"Before flushGroup2...");
                                    cacheInstance.flushGroup("content_" + contentId);
                                    logger.info((Object)"After flushGroup2...");
                                }
                            }
                            catch (SystemException se) {
                                logger.info((Object)("Missing content version: " + se.getMessage()));
                            }
                        } else if (selectiveCacheUpdate && entity.indexOf("Content") > 0 && entity.indexOf("ContentTypeDefinition") == -1 && useSelectivePageCacheUpdate) {
                            cacheInstance.flushGroup("content_" + entityId);
                            cacheInstance.flushGroup("selectiveCacheUpdateNonApplicable");
                            logger.info((Object)("clearing " + e.getKey() + " with group " + "content_" + entityId));
                        } else if (selectiveCacheUpdate && entity.indexOf("Publication") > 0 && useSelectivePageCacheUpdate && operatingMode != null && operatingMode.equalsIgnoreCase("3") && CmsPropertyHandler.getLivePublicationThreadClass().equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                            logger.info((Object)"Now we will ease out the publication...");
                        } else {
                            cacheInstance.flushAll();
                            eventListeners.remove(String.valueOf(cacheName) + "_cacheEntryEventListener");
                            eventListeners.remove(String.valueOf(cacheName) + "_cacheMapAccessEventListener");
                            logger.info((Object)("clearing:" + e.getKey()));
                        }
                    }
                    logger.info((Object)("Cleared cache:" + e.getKey()));
                    if (selectiveCacheUpdate) continue;
                    i.remove();
                    continue;
                }
                logger.info((Object)("Did not clear " + e.getKey()));
            }
        }
        logger.info((Object)"clearCaches stop");
    }

    private static void printThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        int n = tg.activeCount();
        logger.warn((Object)("Number of active threads: " + n));
        Thread[] threadArray = new Thread[n];
        n = tg.enumerate(threadArray, false);
        int i = 0;
        while (i < n) {
            String currentThreadId = "" + threadArray[i].getId();
            Thread t = threadArray[i];
            Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
            for (StackTraceElement[] el : stacks.values()) {
                String stackString = "";
                if (el == null || el.length == 0) continue;
                int j = 0;
                while (j < el.length) {
                    StackTraceElement frame = el[j];
                    stackString = frame == null ? String.valueOf(stackString) + "    null stack frame<br/>" : String.valueOf(stackString) + "    null stack frame" + frame.toString() + "<br/>";
                    ++j;
                }
                logger.warn((Object)("\n\nThreads:\n\n " + stackString));
            }
            ++i;
        }
    }

    public static synchronized void clearCastorCaches() throws Exception {
        logger.info((Object)"Emptying the Castor Caches");
        while (RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() > 0) {
            Thread.sleep(10L);
        }
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                CacheController.clearCache(db, SmallContentImpl.class);
                CacheController.clearCache(db, SmallishContentImpl.class);
                CacheController.clearCache(db, MediumContentImpl.class);
                CacheController.clearCache(db, ContentImpl.class);
                CacheController.clearCache(db, ContentRelationImpl.class);
                CacheController.clearCache(db, SmallContentVersionImpl.class);
                CacheController.clearCache(db, ContentVersionImpl.class);
                CacheController.clearCache(db, DigitalAssetImpl.class);
                CacheController.clearCache(db, SmallDigitalAssetImpl.class);
                CacheController.clearCache(db, MediumDigitalAssetImpl.class);
                CacheController.clearCache(db, SmallAvailableServiceBindingImpl.class);
                CacheController.clearCache(db, AvailableServiceBindingImpl.class);
                CacheController.clearCache(db, ContentTypeDefinitionImpl.class);
                CacheController.clearCache(db, LanguageImpl.class);
                CacheController.clearCache(db, RepositoryImpl.class);
                CacheController.clearCache(db, RepositoryLanguageImpl.class);
                CacheController.clearCache(db, RoleImpl.class);
                CacheController.clearCache(db, GroupImpl.class);
                CacheController.clearCache(db, ServiceDefinitionImpl.class);
                CacheController.clearCache(db, SiteNodeTypeDefinitionImpl.class);
                CacheController.clearCache(db, SystemUserImpl.class);
                CacheController.clearCache(db, QualifyerImpl.class);
                CacheController.clearCache(db, ServiceBindingImpl.class);
                CacheController.clearCache(db, SmallSiteNodeImpl.class);
                CacheController.clearCache(db, SiteNodeImpl.class);
                CacheController.clearCache(db, SiteNodeVersionImpl.class);
                CacheController.clearCache(db, SmallSiteNodeVersionImpl.class);
                CacheController.clearCache(db, PublicationImpl.class);
                CacheController.clearCache(db, ActionImpl.class);
                CacheController.clearCache(db, ActionDefinitionImpl.class);
                CacheController.clearCache(db, ActorImpl.class);
                CacheController.clearCache(db, ConsequenceImpl.class);
                CacheController.clearCache(db, ConsequenceDefinitionImpl.class);
                CacheController.clearCache(db, EventImpl.class);
                CacheController.clearCache(db, WorkflowImpl.class);
                CacheController.clearCache(db, WorkflowDefinitionImpl.class);
                CacheController.clearCache(db, CategoryImpl.class);
                CacheController.clearCache(db, ContentCategoryImpl.class);
                CacheController.clearCache(db, RegistryImpl.class);
                CacheController.clearCache(db, RedirectImpl.class);
                CacheController.clearCache(db, InterceptionPointImpl.class);
                CacheController.clearCache(db, InterceptorImpl.class);
                CacheController.clearCache(db, AccessRightImpl.class);
                CacheController.clearCache(db, RolePropertiesImpl.class);
                CacheController.clearCache(db, UserPropertiesImpl.class);
                CacheController.clearCache(db, GroupPropertiesImpl.class);
                CacheController.clearCache(db, UserContentTypeDefinitionImpl.class);
                CacheController.clearCache(db, RoleContentTypeDefinitionImpl.class);
                CacheController.clearCache(db, GroupContentTypeDefinitionImpl.class);
                CacheController.clearCache(db, PropertiesCategoryImpl.class);
                CacheController.clearCache(db, ServerNodeImpl.class);
                CacheController.clearCache(db, SubscriptionImpl.class);
                CacheController.clearCache(db, FormEntryImpl.class);
                CacheController.clearCache(db, FormEntryValueImpl.class);
                logger.info((Object)"Emptied the Castor Caches");
            }
            catch (Exception e) {
                logger.error((Object)"Exception when tried empty the Castor Caches");
                CacheController.rollbackTransaction(db);
                db.close();
            }
        }
        finally {
            db.close();
        }
    }

    public static synchronized void clearCache(Class type, Object[] ids) throws Exception {
        CacheController.clearCache(type, ids, false);
    }

    public static synchronized void clearCache(Class type, Object[] ids, boolean forceClear) throws Exception {
        long wait = 0L;
        while (!forceClear && RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() > 0) {
            logger.warn((Object)("Number of requests: " + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + " was more than 0 - lets wait a bit."));
            if (wait == 3000L) {
                logger.warn((Object)("The clearCache method waited over " + wait * 10L / 1000L + " seconds but there seems to be " + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + " requests blocking all the time. Continuing anyway."));
                break;
            }
            Thread.sleep(10L);
            ++wait;
        }
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                CacheManager manager = db.getCacheManager();
                manager.expireCache(type, ids);
                if (type.getName().equalsIgnoreCase(SmallContentImpl.class.getName()) || type.getName().equalsIgnoreCase(SmallishContentImpl.class.getName()) || type.getName().equalsIgnoreCase(MediumContentImpl.class.getName()) || type.getName().equalsIgnoreCase(ContentImpl.class.getName()) || type.getName().equalsIgnoreCase(SmallSiteNodeImpl.class.getName()) || type.getName().equalsIgnoreCase(SiteNodeImpl.class.getName())) {
                    expireDateTime = null;
                    publishDateTime = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                db.close();
            }
        }
        finally {
            db.close();
        }
    }

    public static synchronized void clearCache(Class c) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                CacheController.clearCache(db, c);
            }
            catch (Exception e) {
                e.printStackTrace();
                db.close();
            }
        }
        finally {
            db.close();
        }
    }

    public static void clearCache(Class type, Object[] ids, Database db) throws Exception {
        CacheController.clearCache(type, ids, false, db);
    }

    public static void clearCache(Class type, Object[] ids, boolean forceClear, Database db) throws Exception {
        long wait = 0L;
        while (!forceClear && RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() > 0) {
            if (wait == 3000L) {
                logger.warn((Object)("The clearCache method waited over " + wait * 10L / 1000L + " seconds but there seems to be " + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + " requests blocking all the time. Continuing anyway."));
                break;
            }
            Thread.sleep(10L);
            ++wait;
        }
        CacheManager manager = db.getCacheManager();
        manager.expireCache(type, ids);
        if (type.getName().equalsIgnoreCase(SmallContentImpl.class.getName()) || type.getName().equalsIgnoreCase(SmallishContentImpl.class.getName()) || type.getName().equalsIgnoreCase(MediumContentImpl.class.getName()) || type.getName().equalsIgnoreCase(ContentImpl.class.getName()) || type.getName().equalsIgnoreCase(SmallSiteNodeImpl.class.getName()) || type.getName().equalsIgnoreCase(SiteNodeImpl.class.getName())) {
            expireDateTime = null;
            publishDateTime = null;
        }
    }

    private static synchronized void clearCache(Database db, Class c) throws Exception {
        Class[] types = new Class[]{c};
        CacheManager manager = db.getCacheManager();
        manager.expireCache(types);
        if (c.getName().equalsIgnoreCase(SmallContentImpl.class.getName()) || c.getName().equalsIgnoreCase(SmallishContentImpl.class.getName()) || c.getName().equalsIgnoreCase(MediumContentImpl.class.getName()) || c.getName().equalsIgnoreCase(ContentImpl.class.getName()) || c.getName().equalsIgnoreCase(SmallSiteNodeImpl.class.getName()) || c.getName().equalsIgnoreCase(SiteNodeImpl.class.getName())) {
            expireDateTime = null;
            publishDateTime = null;
        }
    }

    public void run() {
        while (this.continueRunning && this.expireCacheAutomatically) {
            logger.info((Object)"Clearing caches");
            try {
                CacheController.clearCastorCaches();
            }
            catch (Exception e) {
                logger.error((Object)("Error clearing cache in expireCacheAutomatically thread:" + e.getMessage()), (Throwable)e);
            }
            logger.info((Object)"Castor cache cleared");
            try {
                CacheController.clearCaches(null, null, null);
            }
            catch (Exception e) {
                logger.error((Object)("Error clearing other caches in expireCacheAutomatically thread:" + e.getMessage()), (Throwable)e);
            }
            logger.info((Object)"All other caches cleared");
            try {
                CacheController.sleep(this.cacheExpireInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static synchronized void cacheCentralCastorCaches() throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        DatabaseWrapper dbWrapper = new DatabaseWrapper(db);
        try {
            try {
                CacheController.beginTransaction(db);
                String siteNodesToRecacheOnPublishing = CmsPropertyHandler.getSiteNodesToRecacheOnPublishing();
                String recachePublishingMethod = CmsPropertyHandler.getRecachePublishingMethod();
                logger.info((Object)("siteNodesToRecacheOnPublishing:" + siteNodesToRecacheOnPublishing));
                if (siteNodesToRecacheOnPublishing != null && !siteNodesToRecacheOnPublishing.equals("") && siteNodesToRecacheOnPublishing.indexOf("siteNodesToRecacheOnPublishing") == -1) {
                    String[] siteNodeIdArray = siteNodesToRecacheOnPublishing.split(",");
                    int i = 0;
                    while (i < siteNodeIdArray.length) {
                        Integer siteNodeId = new Integer(siteNodeIdArray[i]);
                        logger.info((Object)("siteNodeId to recache:" + siteNodeId));
                        if (recachePublishingMethod != null && recachePublishingMethod.equalsIgnoreCase("contentCentric")) {
                            new ContentCentricCachePopulator().recache(dbWrapper, siteNodeId);
                        } else if (recachePublishingMethod != null && recachePublishingMethod.equalsIgnoreCase("requestCentric")) {
                            new RequestCentricCachePopulator().recache(dbWrapper, siteNodeId);
                        } else if (recachePublishingMethod != null && recachePublishingMethod.equalsIgnoreCase("requestAndMetaInfoCentric")) {
                            new RequestAndMetaInfoCentricCachePopulator().recache(dbWrapper, siteNodeId);
                        } else {
                            logger.warn((Object)"No recaching was made during publishing - set the parameter recachePublishingMethod to 'contentCentric' or 'requestCentric' to recache.");
                        }
                        ++i;
                    }
                }
                CacheController.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to rebuild the castor cache:" + e.getMessage()), (Throwable)e);
                CacheController.rollbackTransaction(db);
                CacheController.closeDatabase(db);
            }
        }
        finally {
            CacheController.closeDatabase(db);
        }
    }

    public void stopThread() {
        this.continueRunning = false;
    }

    public boolean getExpireCacheAutomatically() {
        return this.expireCacheAutomatically;
    }

    public void setExpireCacheAutomatically(boolean expireCacheAutomatically) {
        this.expireCacheAutomatically = expireCacheAutomatically;
    }

    public static Map getCaches() {
        return caches;
    }

    public static Map getEventListeners() {
        return eventListeners;
    }

    public static GeneralCacheAdministrator getGeneralCache() {
        return generalCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evictWaitingCache() throws Exception {
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        RequestAnalyser requestAnalyser = RequestAnalyser.getRequestAnalyser();
        synchronized (requestAnalyser) {
            if (RequestAnalyser.getRequestAnalyser().getBlockRequests()) {
                logger.info((Object)"evictWaitingCache allready in progress - returning to avoid conflict");
                return;
            }
            RequestAnalyser.getRequestAnalyser().setBlockRequests(true);
        }
        logger.info((Object)"evictWaitingCache starting");
        logger.info((Object)"blocking");
        WorkingPublicationThread wpt = new WorkingPublicationThread();
        SelectiveLivePublicationThread pt = null;
        String livePublicationThreadClass = "";
        try {
            livePublicationThreadClass = CmsPropertyHandler.getLivePublicationThreadClass();
            if (operatingMode != null && operatingMode.equalsIgnoreCase("3") && livePublicationThreadClass.equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                pt = new SelectiveLivePublicationThread();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not get livePublicationThreadClass:" + e.getMessage()), (Throwable)e);
        }
        ArrayList localNotifications = new ArrayList();
        boolean startedThread = false;
        logger.info((Object)("before notifications:" + notifications.size()));
        List list = notifications;
        synchronized (list) {
            localNotifications.addAll(notifications);
            notifications.clear();
        }
        Iterator i = localNotifications.iterator();
        while (i.hasNext()) {
            CacheEvictionBean cacheEvictionBean = (CacheEvictionBean)i.next();
            String className = cacheEvictionBean.getClassName();
            String objectId = cacheEvictionBean.getObjectId();
            String objectName = cacheEvictionBean.getObjectName();
            String typeId = cacheEvictionBean.getTypeId();
            logger.info((Object)("className:" + className));
            logger.info((Object)("pt:" + pt));
            RequestAnalyser.getRequestAnalyser().addPublication(new Date());
            if (pt == null) {
                wpt.getCacheEvictionBeans().add(cacheEvictionBean);
            } else {
                pt.getCacheEvictionBeans().add(cacheEvictionBean);
            }
            try {
                if (className != null && className.equalsIgnoreCase("ServerNodeProperties")) {
                    try {
                        logger.info((Object)"clearing InfoGlueAuthenticationFilter");
                        CacheController.clearServerNodeProperty(true);
                        logger.info((Object)"cleared InfoGlueAuthenticationFilter");
                        InfoGlueAuthenticationFilter.initializeProperties();
                        logger.info((Object)"initialized InfoGlueAuthenticationFilter");
                    }
                    catch (Exception e1) {
                        logger.warn((Object)("Could not refresh authentication filter:" + e1.getMessage()), (Throwable)e1);
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Could not refresh authentication filter:" + t.getMessage()), t);
                    }
                }
                if (operatingMode != null && !operatingMode.equalsIgnoreCase("3") && className != null && className.equalsIgnoreCase("PortletRegistry")) {
                    logger.info((Object)"clearing portletRegistry");
                    CacheController.clearPortlets();
                    logger.info((Object)"cleared portletRegistry");
                }
                if (operatingMode != null && operatingMode.equalsIgnoreCase("3") && !livePublicationThreadClass.equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                    logger.info((Object)"Starting publication thread...");
                    PublicationThread lpt = new PublicationThread();
                    lpt.setPriority(1);
                    lpt.start();
                    startedThread = true;
                    logger.info((Object)"Done starting publication thread...");
                }
            }
            catch (Exception e) {
                logger.error((Object)("Cache eviction reported an error:" + e.getMessage()), (Throwable)e);
            }
            logger.info((Object)"Cache evicted..");
            i.remove();
        }
        if (operatingMode != null && !operatingMode.equalsIgnoreCase("3")) {
            logger.info((Object)"Starting the work method");
            wpt.work();
            startedThread = true;
            logger.info((Object)"Done starting working publication thread...");
        }
        if (operatingMode != null && operatingMode.equalsIgnoreCase("3") && pt != null && pt.getCacheEvictionBeans().size() > 0) {
            logger.info((Object)("Starting selective publication thread [" + pt.getClass().getName() + "]"));
            pt.setPriority(1);
            pt.start();
            startedThread = true;
            logger.info((Object)"Done starting publication thread...");
        }
        if (!startedThread) {
            RequestAnalyser.getRequestAnalyser().setBlockRequests(false);
        }
        logger.info((Object)"evictWaitingCache stop");
    }

    public static void clearPortlets() {
        String[] svcs = new String[]{"org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistryService", "org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService"};
        int len = svcs.length;
        int i = 0;
        while (i < len) {
            try {
                ServiceManager.hotInit((ServletConfig)ServletConfigContainer.getContainer().getServletConfig(), (String)svcs[i]);
            }
            catch (Throwable e) {
                String svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                String msg = "Initialization of " + svc + " service for hot deployment failed!";
                System.out.println(msg);
                break;
            }
            try {
                ServiceManager.postHotInit((ServletConfig)ServletConfigContainer.getContainer().getServletConfig(), (String)svcs[i]);
            }
            catch (Throwable e) {
                String svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                String msg = "Post initialization of " + svc + " service for hot deployment failed!";
                System.out.println(msg);
                break;
            }
            ++i;
        }
        try {
            PortletEntityRegistry.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getPageCacheKey(HttpSession session, HttpServletRequest request, Integer siteNodeId, Integer languageId, Integer contentId, String userAgent, String queryString, String extra) {
        String originalRequestURL = request.getParameter("originalRequestURL");
        if (originalRequestURL == null || originalRequestURL.length() == 0) {
            originalRequestURL = request.getRequestURL().toString();
        }
        String pageKey = null;
        String pageKeyProperty = CmsPropertyHandler.getPageKey();
        if (pageKeyProperty != null && pageKeyProperty.length() > 0) {
            pageKey = pageKeyProperty;
            pageKey = pageKey.replaceAll("\\$siteNodeId", "" + siteNodeId);
            pageKey = pageKey.replaceAll("\\$languageId", "" + languageId);
            pageKey = pageKey.replaceAll("\\$contentId", "" + contentId);
            pageKey = pageKey.replaceAll("\\$useragent", userAgent);
            pageKey = pageKey.replaceAll("\\$queryString", queryString);
            int sessionAttributeStartIndex = pageKey.indexOf("$session.");
            while (sessionAttributeStartIndex > -1) {
                int sessionAttributeEndIndex = pageKey.indexOf("_", sessionAttributeStartIndex);
                String sessionAttribute = null;
                sessionAttribute = sessionAttributeEndIndex > -1 ? pageKey.substring(sessionAttributeStartIndex + 9, sessionAttributeEndIndex) : pageKey.substring(sessionAttributeStartIndex + 9);
                pageKey = pageKey.replaceAll("\\$session." + sessionAttribute, "" + session.getAttribute(sessionAttribute));
                sessionAttributeStartIndex = pageKey.indexOf("$session.");
            }
            int cookieAttributeStartIndex = pageKey.indexOf("$cookie.");
            while (cookieAttributeStartIndex > -1) {
                int cookieAttributeEndIndex = pageKey.indexOf("_", cookieAttributeStartIndex);
                String cookieAttribute = null;
                cookieAttribute = cookieAttributeEndIndex > -1 ? pageKey.substring(cookieAttributeStartIndex + 8, cookieAttributeEndIndex) : pageKey.substring(cookieAttributeStartIndex + 8);
                HttpHelper httpHelper = new HttpHelper();
                pageKey = pageKey.replaceAll("\\$cookie." + cookieAttribute, httpHelper.getCookie(request, cookieAttribute));
                cookieAttributeStartIndex = pageKey.indexOf("$cookie.");
            }
        } else {
            pageKey = siteNodeId + "_" + languageId + "_" + contentId + "_" + userAgent + "_" + queryString;
        }
        return String.valueOf(originalRequestURL) + "_" + pageKey + extra;
    }

    public static String getComponentCacheKey(String keyPattern, String pageKey, HttpSession session, HttpServletRequest request, Integer siteNodeId, Integer languageId, Integer contentId, String userAgent, String queryString, InfoGlueComponent component, String extra) {
        String originalRequestURL = request.getParameter("originalRequestURL");
        if (originalRequestURL == null || originalRequestURL.length() == 0) {
            originalRequestURL = request.getRequestURL().toString();
        }
        String componentKey = null;
        if (keyPattern != null && keyPattern.length() > 0) {
            componentKey = keyPattern;
            componentKey = componentKey.replaceAll("\\$siteNodeId", "" + siteNodeId);
            componentKey = componentKey.replaceAll("\\$languageId", "" + languageId);
            componentKey = componentKey.replaceAll("\\$contentId", "" + contentId);
            componentKey = componentKey.replaceAll("\\$useragent", userAgent);
            componentKey = componentKey.replaceAll("\\$queryString", queryString);
            componentKey = componentKey.replaceAll("\\$pageKey", pageKey);
            componentKey = componentKey.replaceAll("\\$component.id", "" + component.getId());
            componentKey = componentKey.replaceAll("\\$component.slotName", component.getSlotName());
            componentKey = componentKey.replaceAll("\\$component.contentId", "" + component.getContentId());
            componentKey = componentKey.replaceAll("\\$component.isInherited", "" + component.getIsInherited());
            int sessionAttributeStartIndex = componentKey.indexOf("$session.");
            while (sessionAttributeStartIndex > -1) {
                int sessionAttributeEndIndex = componentKey.indexOf("_", sessionAttributeStartIndex);
                String sessionAttribute = null;
                sessionAttribute = sessionAttributeEndIndex > -1 ? componentKey.substring(sessionAttributeStartIndex + 9, sessionAttributeEndIndex) : componentKey.substring(sessionAttributeStartIndex + 9);
                componentKey = componentKey.replaceAll("\\$session." + sessionAttribute, "" + session.getAttribute(sessionAttribute));
                sessionAttributeStartIndex = componentKey.indexOf("$session.");
            }
            int cookieAttributeStartIndex = componentKey.indexOf("$cookie.");
            while (cookieAttributeStartIndex > -1) {
                int cookieAttributeEndIndex = componentKey.indexOf("_", cookieAttributeStartIndex);
                String cookieAttribute = null;
                cookieAttribute = cookieAttributeEndIndex > -1 ? componentKey.substring(cookieAttributeStartIndex + 8, cookieAttributeEndIndex) : componentKey.substring(cookieAttributeStartIndex + 8);
                HttpHelper httpHelper = new HttpHelper();
                componentKey = componentKey.replaceAll("\\$cookie." + cookieAttribute, httpHelper.getCookie(request, cookieAttribute));
                cookieAttributeStartIndex = componentKey.indexOf("$cookie.");
            }
        }
        return componentKey;
    }

    public static void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage()));
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    private static void commitTransaction(Database db) throws SystemException {
        try {
            if (db.isActive()) {
                db.commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage()));
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    public static void rollbackTransaction(Database db) {
        try {
            if (db.isActive()) {
                db.rollback();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }

    public static void closeDatabase(Database db) {
        try {
            db.close();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to close a database. Reason:" + e.getMessage()), (Throwable)e);
        }
    }
}

