/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.structure;

import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.taglib.component.ComponentLogicTag;
import org.infoglue.deliver.util.Support;

public class PageAttributeTag
extends ComponentLogicTag {
    private static final long serialVersionUID = 3257850991142318897L;
    private static final Logger logger = Logger.getLogger((String)PageAttributeTag.class.getName());
    private Integer siteNodeId;
    private Integer languageId;
    private String attributeName;
    private String mapKeyName;
    private boolean disableEditOnSight = false;
    private boolean useRepositoryInheritance = true;
    private boolean useStructureInheritance = true;
    private boolean useAttributeLanguageFallback = false;
    private boolean parse = false;
    private boolean fullBaseUrl = false;

    public int doStartTag() throws JspException {
        return 1;
    }

    private String getPageAttributeValue(Integer languageId) throws JspException {
        String result = null;
        try {
            SiteNodeVO siteNodeVO = this.getController().getSiteNode();
            if (this.siteNodeId != null) {
                siteNodeVO = this.getController().getSiteNode(this.siteNodeId);
            }
            while (siteNodeVO != null && (result == null || result.equals(""))) {
                result = !this.parse ? this.getController().getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, this.attributeName, this.disableEditOnSight) : this.getController().getParsedContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, this.attributeName, this.disableEditOnSight);
                if (this.useStructureInheritance) {
                    if (siteNodeVO.getParentSiteNodeId() != null) {
                        siteNodeVO = this.getController().getSiteNode(siteNodeVO.getParentSiteNodeId());
                        continue;
                    }
                    if (this.useRepositoryInheritance) {
                        Integer parentRepositoryId = this.getController().getParentRepositoryId(siteNodeVO.getRepositoryId());
                        if (parentRepositoryId != null) {
                            siteNodeVO = this.getController().getRepositoryRootSiteNode(parentRepositoryId);
                            continue;
                        }
                        siteNodeVO = null;
                        continue;
                    }
                    siteNodeVO = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when getting pageAttributeValue:" + e.getMessage()));
            throw new JspException((Throwable)e);
        }
        return result;
    }

    public int doEndTag() throws JspException {
        Map map;
        if (this.languageId == null) {
            this.languageId = this.getController().getLanguageId();
        }
        boolean previousSetting = this.getController().getDeliveryContext().getUseFullUrl();
        String result = null;
        if (previousSetting != this.fullBaseUrl) {
            this.getController().getDeliveryContext().setUseFullUrl(this.fullBaseUrl);
        }
        if (this.mapKeyName != null) {
            this.disableEditOnSight = true;
        }
        if (((result = this.getPageAttributeValue(this.languageId)) == null || result.trim().equals("")) && this.useAttributeLanguageFallback) {
            try {
                LanguageVO masteLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getController().getDatabase(), this.getController().getSiteNodeId());
                result = this.getPageAttributeValue(masteLanguageVO.getLanguageId());
            }
            catch (Exception e) {
                throw new JspException("Error getting the master language for this sitenode:" + this.getController().getSiteNodeId());
            }
        }
        if (this.mapKeyName != null && result != null && (map = Support.convertTextToProperties(result.toString())) != null && !map.isEmpty()) {
            result = (String)map.get(this.mapKeyName);
        }
        this.produceResult(result);
        this.getController().getDeliveryContext().setUseFullUrl(previousSetting);
        this.siteNodeId = null;
        this.languageId = null;
        this.attributeName = null;
        this.mapKeyName = null;
        this.disableEditOnSight = false;
        this.useRepositoryInheritance = true;
        this.useStructureInheritance = true;
        this.useAttributeLanguageFallback = true;
        this.parse = false;
        this.fullBaseUrl = false;
        return 6;
    }

    public void setAttributeName(String attributeName) throws JspException {
        this.attributeName = this.evaluateString("pageAttribute", "attributeName", attributeName);
    }

    public void setDisableEditOnSight(boolean disableEditOnSight) {
        this.disableEditOnSight = disableEditOnSight;
    }

    public void setUseRepositoryInheritance(boolean useRepositoryInheritance) {
        this.useRepositoryInheritance = useRepositoryInheritance;
    }

    public void setUseStructureInheritance(boolean useStructureInheritance) {
        this.useStructureInheritance = useStructureInheritance;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setSiteNodeId(String siteNodeId) throws JspException {
        this.siteNodeId = this.evaluateInteger("pageAttribute", "siteNodeId", siteNodeId);
    }

    public void setLanguageId(String languageId) throws JspException {
        this.languageId = this.evaluateInteger("pageAttribute", "languageId", languageId);
    }

    public void setFullBaseUrl(boolean fullBaseUrl) {
        this.fullBaseUrl = fullBaseUrl;
    }

    public void setMapKeyName(String mapKeyName) {
        this.mapKeyName = mapKeyName;
    }

    public void setUseAttributeLanguageFallback(boolean useAttributeLanguageFallback) {
        this.useAttributeLanguageFallback = useAttributeLanguageFallback;
    }
}

