/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.management;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.taglib.TemplateControllerTag;
import org.infoglue.deliver.util.webservices.DynamicWebservice;

public class UpdateUserServiceTag
extends TemplateControllerTag {
    private static final long serialVersionUID = -1904980538720103871L;
    private String targetEndpointAddress = String.valueOf(CmsPropertyHandler.getWebServicesBaseUrl()) + "RemoteUserService";
    private String operationName = "updateUser";
    private InfoGluePrincipal principal;
    private SystemUserVO systemUserVO;
    private String[] roleNames = new String[0];
    private String[] groupNames = new String[0];

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.principal == null) {
                this.principal = this.getController().getPrincipal();
            }
            DynamicWebservice ws = new DynamicWebservice(this.principal);
            ws.setTargetEndpointAddress(this.targetEndpointAddress);
            ws.setOperationName(this.operationName);
            ws.setReturnType(Boolean.class);
            ConstraintExceptionBuffer ceb = this.systemUserVO.validate();
            ceb.throwIfNotEmpty();
            ws.addArgument("firstName", this.systemUserVO.getFirstName());
            ws.addArgument("lastName", this.systemUserVO.getLastName());
            ws.addArgument("email", this.systemUserVO.getEmail());
            ws.addArgument("userName", this.systemUserVO.getUserName());
            ws.addArgument("password", this.systemUserVO.getPassword());
            ws.addNonSerializedArgument("roleNames", new ArrayList(Arrays.asList(this.roleNames)));
            ws.addNonSerializedArgument("groupNames", new ArrayList(Arrays.asList(this.groupNames)));
            ws.callService();
            this.setResultAttribute(ws.getResult());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspTagException(e.getMessage());
        }
        return 6;
    }

    public void setTargetEndpointAddress(String targetEndpointAddress) throws JspException {
        this.targetEndpointAddress = this.evaluateString("remoteUserService", "targetEndpointAddress", targetEndpointAddress);
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setPrincipal(String principalString) throws JspException {
        this.principal = (InfoGluePrincipal)this.evaluate("remoteUserService", "principal", principalString, InfoGluePrincipal.class);
    }

    public void setSystemUserVO(String systemUserVO) throws JspException {
        this.systemUserVO = (SystemUserVO)this.evaluate("remoteUserService", "systemUserVO", systemUserVO, SystemUserVO.class);
    }

    public void setRoleNames(String roleNames) throws JspException {
        String roleNamesString = this.evaluateString("remoteUserService", "roleNames", roleNames);
        if (roleNamesString != null && !roleNamesString.equals("")) {
            this.roleNames = roleNamesString.split(",");
        }
    }

    public void setGroupNames(String groupNames) throws JspException {
        String groupNamesString = this.evaluateString("remoteUserService", "groupNames", groupNames);
        if (groupNamesString != null && !groupNamesString.equals("")) {
            this.groupNames = groupNamesString.split(",");
        }
    }
}

