/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.content;

import javax.servlet.jsp.JspException;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class ContentVersionTag
extends TemplateControllerTag {
    private static final long serialVersionUID = 3258135773294113587L;
    private ContentVO content;
    private Integer languageId;
    private Integer contentVersionId;
    private boolean useLanguageFallback = true;

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        this.produceResult(this.getContentVersion());
        this.languageId = null;
        this.useLanguageFallback = true;
        return 6;
    }

    private ContentVersionVO getContentVersion() throws JspException {
        if (this.languageId == null) {
            this.languageId = this.getController().getLanguageId();
        }
        if (this.contentVersionId != null) {
            return this.getController().getContentVersionById(this.contentVersionId);
        }
        if (this.content != null) {
            return this.getController().getContentVersion(this.content.getContentId(), this.languageId, this.useLanguageFallback);
        }
        throw new JspException("Must state either content or contentVersionId");
    }

    public void setContentVersionId(String contentVersionId) throws JspException {
        this.contentVersionId = this.evaluateInteger("contentVersion", "contentVersionId", contentVersionId);
    }

    public void setContent(String contentExp) throws JspException {
        this.content = (ContentVO)this.evaluate("contentVersion", "content", contentExp, ContentVO.class);
    }

    public void setLanguageId(String languageId) throws JspException {
        this.languageId = this.evaluateInteger("contentVersion", "languageId", languageId);
    }

    public void setUseLanguageFallback(boolean useLanguageFallback) {
        this.useLanguageFallback = useLanguageFallback;
    }
}

