/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.content;

import java.util.Map;
import javax.servlet.jsp.JspException;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.taglib.component.ComponentLogicTag;
import org.infoglue.deliver.util.Support;

public class ContentAttributeTag
extends ComponentLogicTag {
    private static final long serialVersionUID = 3257850991142318897L;
    private ContentVersionVO contentVersionVO;
    private Integer contentId;
    private String propertyName;
    private String attributeName;
    private Integer languageId;
    private String mapKeyName;
    private boolean disableEditOnSight = false;
    private boolean useInheritance = true;
    private boolean useRepositoryInheritance = true;
    private boolean useStructureInheritance = true;
    private boolean useAttributeLanguageFallback = false;
    private boolean parse = false;
    private boolean fullBaseUrl = false;

    public int doStartTag() throws JspException {
        return 1;
    }

    private String getContentAttributeValue(Integer languageId) throws JspException {
        String result = null;
        if (this.contentVersionVO != null) {
            result = !this.parse ? this.getController().getContentAttribute(this.contentVersionVO, this.attributeName, this.disableEditOnSight) : this.getController().getParsedContentAttribute(this.contentVersionVO, this.attributeName, this.disableEditOnSight);
        } else if (this.contentId != null) {
            result = !this.parse ? this.getController().getContentAttribute(this.contentId, languageId, this.attributeName, this.disableEditOnSight) : this.getController().getParsedContentAttribute(this.contentId, languageId, this.attributeName, this.disableEditOnSight);
        } else if (this.propertyName != null) {
            result = !this.parse ? this.getComponentLogic().getContentAttribute(this.propertyName, languageId, this.attributeName, this.disableEditOnSight, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance) : this.getComponentLogic().getParsedContentAttribute(this.propertyName, languageId, this.attributeName, this.disableEditOnSight, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        } else {
            throw new JspException("You must specify either contentId or propertyName");
        }
        return result;
    }

    public int doEndTag() throws JspException {
        Map map;
        if (this.languageId == null) {
            this.languageId = this.getController().getLanguageId();
        }
        boolean previousSetting = this.getController().getDeliveryContext().getUseFullUrl();
        String result = null;
        if (previousSetting != this.fullBaseUrl) {
            this.getController().getDeliveryContext().setUseFullUrl(this.fullBaseUrl);
        }
        if (this.mapKeyName != null) {
            this.disableEditOnSight = true;
        }
        if (((result = this.getContentAttributeValue(this.languageId)) == null || result.trim().equals("")) && this.useAttributeLanguageFallback) {
            try {
                LanguageVO masteLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getController().getDatabase(), this.getController().getSiteNodeId());
                result = this.getContentAttributeValue(masteLanguageVO.getLanguageId());
            }
            catch (Exception e) {
                throw new JspException("Error getting the master language for this sitenode:" + this.getController().getSiteNodeId());
            }
        }
        if (this.mapKeyName != null && result != null && (map = Support.convertTextToProperties(result.toString())) != null && !map.isEmpty()) {
            result = (String)map.get(this.mapKeyName);
        }
        this.produceResult(result);
        this.getController().getDeliveryContext().setUseFullUrl(previousSetting);
        this.contentId = null;
        this.propertyName = null;
        this.attributeName = null;
        this.mapKeyName = null;
        this.disableEditOnSight = false;
        this.useInheritance = true;
        this.useAttributeLanguageFallback = true;
        this.parse = false;
        this.fullBaseUrl = false;
        this.languageId = null;
        return 6;
    }

    public void setPropertyName(String propertyName) throws JspException {
        this.propertyName = this.evaluateString("contentAttribute", "propertyName", propertyName);
    }

    public void setAttributeName(String attributeName) throws JspException {
        this.attributeName = this.evaluateString("contentAttribute", "attributeName", attributeName);
    }

    public void setDisableEditOnSight(boolean disableEditOnSight) {
        this.disableEditOnSight = disableEditOnSight;
    }

    public void setUseInheritance(boolean useInheritance) {
        this.useInheritance = useInheritance;
    }

    public void setUseRepositoryInheritance(boolean useRepositoryInheritance) {
        this.useRepositoryInheritance = useRepositoryInheritance;
    }

    public void setUseStructureInheritance(boolean useStructureInheritance) {
        this.useStructureInheritance = useStructureInheritance;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setContentId(String contentId) throws JspException {
        this.contentId = this.evaluateInteger("contentAttribute", "contentId", contentId);
    }

    public void setLanguageId(String languageId) throws JspException {
        this.languageId = this.evaluateInteger("contentAttribute", "languageId", languageId);
    }

    public void setContentVersion(String contentVersion) throws JspException {
        this.contentVersionVO = (ContentVersionVO)this.evaluate("contentAttribute", "contentVersion", contentVersion, ContentVersionVO.class);
    }

    public void setFullBaseUrl(boolean fullBaseUrl) {
        this.fullBaseUrl = fullBaseUrl;
    }

    public void setMapKeyName(String mapKeyName) {
        this.mapKeyName = mapKeyName;
    }

    public void setUseAttributeLanguageFallback(boolean useAttributeLanguageFallback) {
        this.useAttributeLanguageFallback = useAttributeLanguageFallback;
    }
}

