/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import org.apache.log4j.Logger;
import org.infoglue.deliver.taglib.TemplateControllerTag;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.Timer;
import org.w3c.dom.Document;

public class XSLTransformTag
extends TemplateControllerTag {
    private static final Logger logger = Logger.getLogger((String)XSLTransformTag.class.getName());
    private static final long serialVersionUID = 8603406098980150888L;
    private Object xml;
    private String xmlFile;
    private String xmlString;
    private Object source;
    private boolean cacheStyle = true;
    private String styleFile;
    private String styleString;
    private String outputFormat = "string";
    private Map parameters = new HashMap();

    public int doStartTag() throws JspException {
        return 1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        Timer timer = new Timer();
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        Object var2_2 = null;
        if (this.xml != null) {
            if (this.xml instanceof String) {
                StreamSource streamSource = new StreamSource(new StringReader(this.xmlString));
            } else if (this.xml instanceof Reader) {
                StreamSource streamSource = new StreamSource((Reader)this.xml);
            }
        } else if (this.source != null) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Input:" + this.source.getClass().getName()));
            }
            if (this.source instanceof DOMResult) {
                DOMSource dOMSource = new DOMSource(((DOMResult)this.source).getNode());
            } else if (this.source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)this.source;
            } else if (this.source instanceof SAXSource) {
                SAXSource sAXSource = (SAXSource)this.source;
            } else if (this.source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)this.source;
            } else if (this.source instanceof Document) {
                DOMSource dOMSource = new DOMSource((Document)this.source);
            } else if (this.source instanceof NodeInfo) {
                Source source = (Source)this.source;
            } else {
                if (!(this.source instanceof TinyDocumentImpl)) throw new JspException("Bad source - must be either org.w3c.Document or javax.xml.transform.Source");
                TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.source;
            }
        } else if (this.xmlFile != null) {
            StreamSource streamSource = new StreamSource(new File(this.xmlFile));
        } else if (this.xmlString != null) {
            StreamSource streamSource = new StreamSource(new StringReader(this.xmlString));
        }
        Templates pss = null;
        Transformer transformer = null;
        try {
            try {
                void var2_14;
                pss = this.tryCache(this.styleFile, this.styleString, this.cacheStyle);
                transformer = pss.newTransformer();
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("outputFormat:" + this.outputFormat));
                }
                if (this.outputFormat.equalsIgnoreCase("string")) {
                    ByteArrayOutputStream outputXmlResult = new ByteArrayOutputStream();
                    BufferedOutputStream bos = new BufferedOutputStream(outputXmlResult);
                    for (String name : this.parameters.keySet()) {
                        Object value = this.parameters.get(name);
                        transformer.setParameter(name, value);
                    }
                    transformer.transform((Source)var2_14, new StreamResult(bos));
                    bos.close();
                    String result = outputXmlResult.toString();
                    this.setResultAttribute(result);
                } else if (this.outputFormat.equalsIgnoreCase("document")) {
                    DOMResult domResult = new DOMResult();
                    for (String name : this.parameters.keySet()) {
                        Object value = this.parameters.get(name);
                        transformer.setParameter(name, value);
                    }
                    transformer.transform((Source)var2_14, domResult);
                    this.setResultAttribute(domResult.getNode());
                } else if (this.outputFormat.equalsIgnoreCase("tinyDocument")) {
                    for (String name : this.parameters.keySet()) {
                        Object value = this.parameters.get(name);
                        transformer.setParameter(name, value);
                    }
                    TinyBuilder builder = new TinyBuilder();
                    transformer.transform((Source)var2_14, (Result)builder);
                    this.setResultAttribute(builder.getCurrentRoot());
                }
                if (!logger.isInfoEnabled()) return 6;
                timer.printElapsedTime("Saxon Transform to dom document took");
                return 6;
            }
            catch (Exception e) {
                logger.error((Object)("Error transforming with SAXON:" + e.getMessage()), (Throwable)e);
                try {
                    transformer.clearParameters();
                    transformer.reset();
                    this.parameters.clear();
                }
                catch (NoSuchMethodError e2) {
                    logger.warn((Object)("Problem resetting transformer -wrong java version:" + e2.getMessage()));
                }
                catch (Exception e3) {
                    logger.warn((Object)("Problem resetting transformer:" + e3.getMessage()), (Throwable)e3);
                }
                transformer = null;
                pss = null;
                Object var2_15 = null;
                this.xml = null;
                this.xmlFile = null;
                this.source = null;
                this.xmlString = null;
                this.styleFile = null;
                this.styleString = null;
                this.outputFormat = null;
                this.cacheStyle = true;
                System.clearProperty("javax.xml.transform.TransformerFactory");
            }
            return 6;
        }
        finally {
            try {
                transformer.clearParameters();
                transformer.reset();
                this.parameters.clear();
            }
            catch (NoSuchMethodError e) {
                logger.warn((Object)("Problem resetting transformer -wrong java version:" + e.getMessage()));
            }
            catch (Exception e) {
                logger.warn((Object)("Problem resetting transformer:" + e.getMessage()), (Throwable)e);
            }
            transformer = null;
            pss = null;
            Object var2_17 = null;
            this.xml = null;
            this.xmlFile = null;
            this.source = null;
            this.xmlString = null;
            this.styleFile = null;
            this.styleString = null;
            this.outputFormat = null;
            this.cacheStyle = true;
            System.clearProperty("javax.xml.transform.TransformerFactory");
        }
    }

    private synchronized Templates tryCache(String url, String xslString, boolean cacheTemplate) throws Exception {
        Templates x = null;
        if (url != null) {
            String path = this.getController().getHttpServletRequest().getRealPath(url);
            if (path == null) {
                throw new Exception("Stylesheet " + url + " not found");
            }
            x = (Templates)CacheController.getCachedObject("XSLTemplatesCache", path);
            if (x == null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                x = factory.newTemplates(new StreamSource(new File(path)));
                if (cacheTemplate) {
                    CacheController.cacheObject("XSLTemplatesCache", path, x);
                }
            }
        } else if (xslString != null && (x = (Templates)CacheController.getCachedObject("XSLTemplatesCache", xslString.hashCode())) == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            x = factory.newTemplates(new StreamSource(new StringReader(xslString)));
            if (cacheTemplate) {
                CacheController.cacheObject("XSLTemplatesCache", xslString.hashCode(), x);
            }
        }
        return x;
    }

    public void setXml(String xml) throws JspException {
        this.xml = this.evaluate("XSLTransform", "xmlFile", this.xmlFile, Object.class);
    }

    public void setXmlFile(String xmlFile) throws JspException {
        this.xmlFile = this.evaluateString("XSLTransform", "xmlFile", xmlFile);
    }

    public void setXmlString(String xmlString) throws JspException {
        this.xmlString = this.evaluateString("XSLTransform", "xmlString", xmlString);
    }

    public void setSource(String source) throws JspException {
        this.source = this.evaluate("XSLTransform", "source", source, Object.class);
    }

    public void setStyleFile(String styleFile) throws JspException {
        this.styleFile = this.evaluateString("XSLTransform", "styleFile", styleFile);
    }

    public void setStyleString(String styleString) throws JspException {
        this.styleString = this.evaluateString("XSLTransform", "styleString", styleString);
    }

    public void setCacheStyle(boolean cacheStyle) throws JspException {
        this.cacheStyle = cacheStyle;
    }

    public void setOutputFormat(String outputFormat) throws JspException {
        this.outputFormat = this.evaluateString("XSLTransform", "outputFormat", outputFormat);
    }

    protected final void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }
}

