/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.apache.log4j.Logger;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class URLTag
extends TemplateControllerTag {
    private static final Logger logger = Logger.getLogger((String)URLTag.class.getName());
    private static final long serialVersionUID = 4433903132736259601L;
    private String baseURL;
    private String query;
    private String excludedQueryStringParameters;
    private boolean fullBaseUrl = false;
    private List parameters;
    private Map parameterNames;
    private boolean disableNiceURI = false;
    private boolean allowMultipleArguments = false;

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        this.addQueryParameters();
        this.produceResult(this.generateURL());
        this.parameters = null;
        this.parameterNames = null;
        return 6;
    }

    private List getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        return this.parameters;
    }

    private Map getParameterNames() {
        if (this.parameterNames == null) {
            this.parameterNames = new HashMap();
        }
        return this.parameterNames;
    }

    protected final void addParameter(String name, String value) {
        this.getParameters().add(String.valueOf(name) + "=" + value);
        this.getParameterNames().put(name, name);
    }

    private String getBaseURL() {
        String newBaseUrl = "";
        try {
            logger.info((Object)("fullBaseUrl:" + this.fullBaseUrl));
            if (this.fullBaseUrl) {
                int indexOfProtocol = this.getRequest().getRequestURL().indexOf("://");
                int indexFirstSlash = this.getRequest().getRequestURL().indexOf("/", indexOfProtocol + 3);
                String base = null;
                base = indexFirstSlash > -1 ? this.getRequest().getRequestURL().substring(0, indexFirstSlash) : this.getRequest().getRequestURL().substring(0);
                String currentPageUrl = this.getController().getCurrentPageUrl().toString();
                currentPageUrl = currentPageUrl.split("\\?")[0];
                newBaseUrl = this.baseURL == null ? String.valueOf(base) + currentPageUrl : this.baseURL;
            } else {
                String currentPageUrl = this.getController().getCurrentPageUrl().toString();
                currentPageUrl = currentPageUrl.split("\\?")[0];
                newBaseUrl = this.baseURL == null ? currentPageUrl : this.baseURL;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error:", (Throwable)e);
            newBaseUrl = this.baseURL == null ? this.getRequest().getRequestURL().toString() : this.baseURL;
        }
        logger.info((Object)("newBaseUrl:" + newBaseUrl));
        return newBaseUrl;
    }

    private String getQuery() {
        String q;
        String string = q = this.query == null ? this.getRequest().getQueryString() : this.query;
        if (q != null && (q.startsWith("?") || q.startsWith("&"))) {
            return q.substring(1);
        }
        return q;
    }

    private final HttpServletRequest getRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    private void addQueryParameters() throws JspException {
        if (this.getQuery() != null) {
            StringTokenizer st = new StringTokenizer(this.getQuery(), "&");
            while (st.hasMoreTokens()) {
                String value;
                String token = st.nextToken();
                StringTokenizer parameter = new StringTokenizer(token, "=");
                if (parameter.countTokens() == 0 || parameter.countTokens() > 2) {
                    throw new JspTagException("Illegal query parameter [" + token + "].");
                }
                String name = parameter.nextToken();
                String string = value = parameter.hasMoreTokens() ? parameter.nextToken() : "";
                if (!this.allowMultipleArguments && this.getParameterNames().containsKey(name) || this.excludedQueryStringParameters != null && this.excludedQueryStringParameters.indexOf(name) != -1) continue;
                this.addParameter(name, value);
            }
        }
    }

    public String generateURL() {
        if (!this.getParameters().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator i = this.getParameters().iterator();
            while (i.hasNext()) {
                String parameter = i.next().toString();
                sb.append(String.valueOf(parameter) + (i.hasNext() ? "&" : ""));
            }
            if (this.getBaseURL().indexOf("?") > -1) {
                return String.valueOf(this.getBaseURL()) + (sb.toString().length() > 0 ? "&" + sb.toString() : "");
            }
            return String.valueOf(this.getBaseURL()) + (sb.toString().length() > 0 ? "?" + sb.toString() : "");
        }
        return this.getBaseURL();
    }

    public void setBaseURL(String baseURL) throws JspException {
        this.baseURL = this.evaluateString("url", "baseURL", baseURL);
    }

    public void setQuery(String query) throws JspException {
        this.query = this.evaluateString("url", "query", query);
    }

    public void setExcludedQueryStringParameters(String excludedQueryStringParameters) throws JspException {
        this.excludedQueryStringParameters = this.evaluateString("url", "excludedQueryStringParameters", excludedQueryStringParameters);
    }

    public void setFullBaseUrl(boolean fullBaseUrl) {
        this.fullBaseUrl = fullBaseUrl;
    }

    public void setDisableNiceURI(boolean disableNiceURI) {
        this.disableNiceURI = disableNiceURI;
    }

    public void setAllowMultipleArguments(boolean allowMultipleArguments) {
        this.allowMultipleArguments = allowMultipleArguments;
    }
}

