/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class TextTransformTag
extends TemplateControllerTag {
    private static final long serialVersionUID = 8603406098980150888L;
    private String text;
    private boolean htmlEncode = false;
    private boolean replaceLineBreaks = false;
    private String lineBreakReplacer = "<br/>";
    private String lineBreakChar = System.getProperty("line.separator");
    private String replaceString = null;
    private String replaceWithString = null;
    private String prefix = null;
    private String addPrefixIfTextMatches = null;
    private String addPrefixIfTextNotMatches = null;
    private String suffix = null;
    private String addSuffixIfTextMatches = null;
    private String addSuffixIfTextNotMatches = null;

    public int doEndTag() throws JspException {
        Matcher matcher;
        Pattern pattern;
        String modifiedText = this.text;
        if (this.replaceString != null && this.replaceWithString != null) {
            pattern = Pattern.compile(this.replaceString);
            matcher = pattern.matcher(modifiedText);
            modifiedText = matcher.replaceAll(this.replaceWithString);
        }
        if (this.replaceLineBreaks) {
            modifiedText = modifiedText.replaceAll(this.lineBreakChar, this.lineBreakReplacer);
        }
        if (this.prefix != null) {
            if (this.addPrefixIfTextMatches != null) {
                pattern = Pattern.compile(this.addPrefixIfTextMatches);
                matcher = pattern.matcher(modifiedText);
                if (matcher.find()) {
                    modifiedText = String.valueOf(this.prefix) + modifiedText;
                }
            } else if (this.addPrefixIfTextNotMatches != null) {
                pattern = Pattern.compile(this.addPrefixIfTextNotMatches);
                matcher = pattern.matcher(modifiedText);
                if (!matcher.find()) {
                    modifiedText = String.valueOf(this.prefix) + modifiedText;
                }
            } else {
                modifiedText = String.valueOf(this.prefix) + modifiedText;
            }
        }
        if (this.suffix != null) {
            if (this.addSuffixIfTextMatches != null) {
                pattern = Pattern.compile(this.addSuffixIfTextMatches);
                matcher = pattern.matcher(modifiedText);
                if (matcher.find()) {
                    modifiedText = String.valueOf(modifiedText) + this.suffix;
                }
            } else if (this.addSuffixIfTextNotMatches != null) {
                pattern = Pattern.compile(this.addSuffixIfTextNotMatches);
                matcher = pattern.matcher(modifiedText);
                if (!matcher.find()) {
                    modifiedText = String.valueOf(modifiedText) + this.suffix;
                }
            } else {
                modifiedText = String.valueOf(modifiedText) + this.suffix;
            }
        }
        if (this.htmlEncode) {
            modifiedText = this.getController().getVisualFormatter().escapeHTMLforXMLService(modifiedText);
        }
        this.setResultAttribute(modifiedText);
        this.prefix = null;
        this.suffix = null;
        this.addPrefixIfTextMatches = null;
        this.addPrefixIfTextNotMatches = null;
        this.addSuffixIfTextMatches = null;
        this.addSuffixIfTextNotMatches = null;
        return 6;
    }

    public void setText(String text) throws JspException {
        this.text = this.evaluateString("cropText", "text", text);
    }

    public void setHtmlEncode(boolean htmlEncode) {
        this.htmlEncode = htmlEncode;
    }

    public void setReplaceLineBreaks(boolean replaceLineBreaks) {
        this.replaceLineBreaks = replaceLineBreaks;
    }

    public void setLineBreakChar(String lineBreakChar) throws JspException {
        this.lineBreakChar = this.evaluateString("TextTransform", "lineBreakChar", lineBreakChar);
    }

    public void setLineBreakReplacer(String lineBreakReplacer) throws JspException {
        this.lineBreakReplacer = this.evaluateString("TextTransform", "lineBreakReplacer", lineBreakReplacer);
    }

    public void setReplaceString(String replaceString) throws JspException {
        this.replaceString = this.evaluateString("TextTransform", "replaceString", replaceString);
    }

    public void setReplaceWithString(String replaceWithString) throws JspException {
        this.replaceWithString = this.evaluateString("TextTransform", "replaceWithString", replaceWithString);
    }

    public void setPrefix(String prefix) throws JspException {
        this.prefix = this.evaluateString("TextTransform", "prefix", prefix);
    }

    public void setAddPrefixIfTextMatches(String addPrefixIfTextMatches) throws JspException {
        this.addPrefixIfTextMatches = this.evaluateString("TextTransform", "addPrefixIfTextMatches", addPrefixIfTextMatches);
    }

    public void setAddPrefixIfTextNotMatches(String addPrefixIfTextNotMatches) throws JspException {
        this.addPrefixIfTextNotMatches = this.evaluateString("TextTransform", "addPrefixIfTextNotMatches", addPrefixIfTextNotMatches);
    }

    public void setSuffix(String suffix) throws JspException {
        this.suffix = this.evaluateString("TextTransform", "suffix", suffix);
    }

    public void setAddSuffixIfTextMatches(String addSuffixIfTextMatches) throws JspException {
        this.addSuffixIfTextMatches = this.evaluateString("TextTransform", "addSuffixIfTextMatches", addSuffixIfTextMatches);
    }

    public void setAddSuffixIfTextNotMatches(String addSuffixIfTextNotMatches) throws JspException {
        this.addSuffixIfTextNotMatches = this.evaluateString("TextTransform", "addSuffixIfTextNotMatches", addSuffixIfTextNotMatches);
    }
}

