/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.infoglue.deliver.taglib.AbstractTag;

public class SublistTag
extends AbstractTag {
    private static final long serialVersionUID = -8053523983744317359L;
    private List list;
    private int startIndex;
    private Integer count;

    public int doEndTag() throws JspException {
        this.checkAttributes();
        this.setResultAttribute(this.getSublist());
        return 6;
    }

    private void checkAttributes() throws JspException {
        if (this.list == null) {
            throw new JspTagException("List is null.");
        }
        if (this.startIndex < 0 || !this.list.isEmpty() && this.startIndex >= this.list.size()) {
            throw new JspTagException("Illegal startIndex [0<=" + this.startIndex + "<" + this.list.size() + "].");
        }
        if (this.count < 0) {
            throw new JspTagException("Illegal count; must be a non-negative integer.");
        }
    }

    private List getSublist() {
        ArrayList result = new ArrayList();
        int endIndex = this.startIndex + this.count;
        if (endIndex > this.list.size()) {
            endIndex = this.list.size();
        }
        int i = this.startIndex;
        while (i < endIndex) {
            result.add(this.list.get(i));
            ++i;
        }
        return result;
    }

    private int getRealCount() {
        return this.count == 0 || this.count > this.list.size() - this.startIndex ? this.list.size() - this.startIndex + 1 : this.count;
    }

    public void setList(String list) throws JspException {
        this.list = this.evaluateList("sublist", "list", list);
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setCount(String count) throws JspException {
        this.count = this.evaluateInteger("sublist", "count", count);
    }
}

