/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.infoglue.deliver.taglib.TemplateControllerTag;
import org.infoglue.deliver.util.rss.RssHelper;

public class RSSFeedTag
extends TemplateControllerTag {
    private static final Logger logger = Logger.getLogger((String)RSSFeedTag.class.getName());
    private static final long serialVersionUID = 8603406098980150888L;
    private String feedType = null;
    private String title = null;
    private String link = null;
    private String description = null;
    private String encoding = "UTF-8";
    private List entries = new ArrayList();

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            try {
                RssHelper rssHelper = new RssHelper();
                SyndFeed feed = rssHelper.getFeed(this.feedType, this.title, this.link, this.description, this.encoding);
                feed.setEntries(this.entries);
                String rss = rssHelper.render(feed);
                this.setResultAttribute(rss);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when generating RSS-feed:" + e.getMessage()), (Throwable)e);
                this.entries = new ArrayList();
            }
        }
        finally {
            this.entries = new ArrayList();
        }
        return 6;
    }

    public void setFeedType(String feedType) throws JspException {
        this.feedType = this.evaluateString("RssFeed", "feedType", feedType);
    }

    public void setDescription(String description) throws JspException {
        this.description = this.evaluateString("RssFeed", "description", description);
    }

    public void setLink(String link) throws JspException {
        this.link = this.evaluateString("RssFeed", "link", link);
    }

    public void setTitle(String title) throws JspException {
        this.title = this.evaluateString("RssFeed", "title", title);
    }

    public void addFeedEntry(SyndEntry entry) {
        this.entries.add(entry);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

