/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.log4j.Logger;
import org.infoglue.deliver.taglib.TemplateControllerTag;
import org.infoglue.deliver.taglib.common.RSSFeedTag;

public class RSSFeedEntryTag
extends TemplateControllerTag {
    private static final Logger logger = Logger.getLogger((String)RSSFeedEntryTag.class.getName());
    private static final long serialVersionUID = 8603406098980150888L;
    private String title = null;
    private String link = null;
    private Date publishedDate = null;
    private String description = null;
    private List categories = new ArrayList();
    private String descriptionContentType = "text/html";

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(this.title);
            entry.setLink(this.link);
            entry.setPublishedDate(this.publishedDate);
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType(this.descriptionContentType);
            syndContent.setValue(this.description);
            entry.setDescription((SyndContent)syndContent);
            entry.setCategories(this.categories);
            this.addEntry((SyndEntry)entry);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when generating RSS-feed:" + e.getMessage()), (Throwable)e);
        }
        return 6;
    }

    protected void addEntry(SyndEntry entry) throws JspException {
        RSSFeedTag parent = (RSSFeedTag)RSSFeedEntryTag.findAncestorWithClass((Tag)this, RSSFeedTag.class);
        if (parent == null) {
            throw new JspTagException("RSSFeedEntryTag must have a RSSFeedTag ancestor.");
        }
        parent.addFeedEntry(entry);
    }

    public void setDescription(String description) throws JspException {
        this.description = this.evaluateString("RssFeedEntry", "description", description);
    }

    public void setLink(String link) throws JspException {
        this.link = this.evaluateString("RssFeedEntry", "link", link);
    }

    public void setTitle(String title) throws JspException {
        this.title = this.evaluateString("RssFeedEntry", "title", title);
    }

    public void setDescriptionContentType(String descriptionContentType) throws JspException {
        this.descriptionContentType = this.evaluateString("RssFeedEntry", "descriptionContentType", descriptionContentType);
    }

    public void setPublishedDate(String publishedDate) throws JspException {
        this.publishedDate = (Date)this.evaluate("RssFeedEntry", "publishedDate", publishedDate, Date.class);
    }

    public void addEntryCategory(SyndCategory category) {
        this.categories.add(category);
    }
}

