/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class ParseMultipartTag
extends TemplateControllerTag {
    public static final Logger logger = Logger.getLogger((String)ParseMultipartTag.class.getName());
    private static final long serialVersionUID = 8603406098980150888L;
    private Integer maxSize = new Integer(100000);
    private String allowedContentTypes;
    private String[] allowedContentTypeArray;
    private boolean ignoreEmpty = false;

    public int doEndTag() throws JspException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(this.maxSize.intValue());
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax((long)this.maxSize.intValue());
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.getController().getHttpServletRequest())) {
                List items = upload.parseRequest(this.getController().getHttpServletRequest());
                ArrayList<FileItem> files = new ArrayList<FileItem>();
                for (FileItem item : items) {
                    if (!item.isFormField()) {
                        String fieldName = item.getFieldName();
                        String fileName = item.getName();
                        String contentType = item.getContentType();
                        boolean isInMemory = item.isInMemory();
                        long sizeInBytes = item.getSize();
                        if (this.isValidContentType(contentType)) {
                            files.add(item);
                            continue;
                        }
                        if ((item.getName() == null || item.getName().equals("")) && this.ignoreEmpty) {
                            logger.warn((Object)"Empty file but that was ok..");
                            continue;
                        }
                        this.pageContext.setAttribute("status", (Object)"nok");
                        this.pageContext.setAttribute("upload_error", (Object)"A field did not have a valid content type");
                        this.pageContext.setAttribute(String.valueOf(fieldName) + "_error", (Object)"Not a valid content type");
                        continue;
                    }
                    String name = item.getFieldName();
                    String value = item.getString();
                    String oldValue = (String)parameters.get(name);
                    if (oldValue != null) {
                        value = String.valueOf(oldValue) + "," + value;
                    }
                    parameters.put(name, value);
                }
                parameters.put("files", files);
                this.setResultAttribute(parameters);
            } else {
                this.setResultAttribute(null);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error doing an upload" + e.getMessage()), (Throwable)e);
            this.pageContext.setAttribute("status", (Object)"nok");
            this.pageContext.setAttribute("upload_error", (Object)e.getMessage());
        }
        return 6;
    }

    private boolean isValidContentType(String contentType) {
        boolean valid = false;
        int i = 0;
        while (i < this.allowedContentTypeArray.length) {
            if (this.allowedContentTypeArray[i].equalsIgnoreCase(contentType)) {
                valid = true;
            }
            ++i;
        }
        return valid;
    }

    public void setMaxSize(String maxSize) throws JspException {
        this.maxSize = this.evaluateInteger("FileUploadTag", "maxSize", maxSize);
    }

    public void setAllowedContentTypes(String allowedContentTypes) throws JspException {
        this.allowedContentTypes = this.evaluateString("FileUploadTag", "allowedContentTypes", allowedContentTypes);
        this.allowedContentTypeArray = this.allowedContentTypes.split(",");
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }
}

