/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import javax.mail.internet.AddressException;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class MailTag
extends TemplateControllerTag {
    private static final Logger logger = Logger.getLogger((String)MailTag.class.getName());
    private static final long serialVersionUID = 4050206323348354355L;
    private String defaultEmailRegexp = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private String emailRegexp;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String recipients;
    private String subject;
    private String type;
    private String charset;
    private String message;
    private String validationRegexp;

    public int doEndTag() throws JspException {
        try {
            boolean emailOk;
            String email;
            int i;
            String[] emailAddresses;
            StringBuffer sb;
            this.emailRegexp = this.validationRegexp != null ? this.validationRegexp : this.defaultEmailRegexp;
            this.from = this.from.trim().toLowerCase();
            this.to = this.to.trim().toLowerCase();
            boolean fromOk = this.from.matches(this.emailRegexp);
            if (!fromOk) {
                throw new AddressException("Invalid from address:" + this.from);
            }
            boolean toOk = this.to.matches(this.emailRegexp);
            if (!toOk) {
                throw new AddressException("Invalid to address:" + this.to);
            }
            if (this.cc != null) {
                sb = new StringBuffer();
                emailAddresses = this.cc.split(";");
                i = 0;
                while (i < emailAddresses.length) {
                    email = emailAddresses[i].trim().toLowerCase();
                    emailOk = email.matches(this.emailRegexp);
                    if (!emailOk && emailAddresses.length == 1) {
                        throw new AddressException("Invalid cc address:" + email);
                    }
                    if (emailOk) {
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(email);
                    }
                    ++i;
                }
                this.cc = sb.toString();
                if (this.cc.equals("")) {
                    this.cc = null;
                }
            }
            if (this.bcc == null && this.recipients != null) {
                this.bcc = this.recipients;
            }
            if (this.bcc != null) {
                sb = new StringBuffer();
                emailAddresses = this.bcc.split(";");
                i = 0;
                while (i < emailAddresses.length) {
                    email = emailAddresses[i].trim().toLowerCase();
                    emailOk = email.matches(this.emailRegexp);
                    if (!emailOk && emailAddresses.length == 1) {
                        throw new AddressException("Invalid bcc/recipients address:" + email);
                    }
                    if (emailOk) {
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(email);
                    }
                    ++i;
                }
                this.bcc = sb.toString();
                if (this.bcc.equals("")) {
                    this.bcc = null;
                }
            }
            if (this.type == null) {
                this.type = "text/html";
            }
            if (this.charset == null) {
                this.charset = "utf-8";
            }
            MailServiceFactory.getService().sendEmail(this.type, this.from, this.to, this.cc, this.bcc, this.subject, this.message, this.charset);
            this.setResultAttribute(true);
        }
        catch (AddressException e) {
            logger.warn((Object)("Problem sending mail due to faulty addresses:" + e.getMessage()));
            logger.warn((Object)("\tfrom:" + this.from));
            logger.warn((Object)("\tto:" + this.to));
            logger.warn((Object)("\tcc:" + this.cc));
            logger.warn((Object)("\tbcc:" + this.bcc));
            logger.warn((Object)("\tSubject:" + this.subject));
            logger.warn((Object)("\tmessage:" + this.message));
            this.setResultAttribute(false);
            this.pageContext.setAttribute("commonMailTagException", (Object)e);
        }
        catch (Exception e) {
            logger.error((Object)("Problem sending mail:" + e.getMessage()));
            logger.error((Object)("\tfrom:" + this.from));
            logger.error((Object)("\tto:" + this.to));
            logger.error((Object)("\tcc:" + this.cc));
            logger.error((Object)("\tbcc:" + this.bcc));
            logger.error((Object)("\tSubject:" + this.subject));
            logger.error((Object)("\tmessage:" + this.message));
            this.setResultAttribute(false);
            this.pageContext.setAttribute("commonMailTagException", (Object)e);
        }
        this.type = null;
        this.charset = null;
        this.recipients = null;
        this.cc = null;
        this.bcc = null;
        this.validationRegexp = null;
        return 6;
    }

    public void setFrom(String from) throws JspException {
        this.from = this.evaluateString("MailTag", "from", from);
    }

    public void setTo(String to) throws JspException {
        this.to = this.evaluateString("MailTag", "valtoue", to);
    }

    public void setRecipients(String recipients) throws JspException {
        this.recipients = this.evaluateString("MailTag", "recipients", recipients);
    }

    public void setCc(String cc) throws JspException {
        this.cc = this.evaluateString("MailTag", "cc", cc);
    }

    public void setBcc(String bcc) throws JspException {
        this.bcc = this.evaluateString("MailTag", "bcc", bcc);
    }

    public void setSubject(String subject) throws JspException {
        this.subject = this.evaluateString("MailTag", "subject", subject);
    }

    public void setType(String type) throws JspException {
        this.type = this.evaluateString("MailTag", "type", type);
    }

    public void setCharset(String charset) throws JspException {
        this.charset = this.evaluateString("MailTag", "charset", charset);
    }

    public void setMessage(String message) throws JspException {
        this.message = this.evaluateString("MailTag", "message", message);
    }

    public void setValidationRegexp(String validationRegexp) throws JspException {
        this.message = this.evaluateString("MailTag", "validationRegexp", validationRegexp);
    }
}

