/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.taglib.common;

import java.io.File;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.taglib.TemplateControllerTag;

public class DocumentConverterTag
extends TemplateControllerTag {
    private static final long serialVersionUID = 4050206323348354355L;
    private String docUrl;
    private String docFilePath;
    private String title;
    private String menuTextLength;
    private List cssList;
    private String rewrite;

    public int doEndTag() throws JspException {
        try {
            File docFile = this.createFileObject();
            this.setResultAttribute(this.getController().getDocumentTransformerHelper().convert(docFile, this.title, this.menuTextLength, this.cssList, this.rewrite));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 6;
    }

    private File createFileObject() {
        File returnFile = null;
        if (this.docFilePath != null && !this.docFilePath.equals("")) {
            returnFile = new File(this.docFilePath);
        } else if (this.docUrl != null && !this.docUrl.equals("")) {
            String fileName = this.docUrl.substring(this.docUrl.lastIndexOf("/") + 1);
            String filePath = CmsPropertyHandler.getDigitalAssetPath();
            int idIndex = fileName.indexOf("_");
            if (idIndex > -1) {
                String fileIdString = fileName.substring(0, idIndex);
                int fileId = Integer.parseInt(fileIdString);
                String folderName = "" + fileId / 1000;
                filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
            }
            String assetPath = String.valueOf(filePath) + File.separator + fileName;
            returnFile = new File(assetPath);
        }
        return returnFile;
    }

    public void setDocUrl(String docUrl) throws JspException {
        this.docUrl = this.evaluateString("DocumentConverterTag", "docUrl", docUrl);
    }

    public void setDocFilePath(String docFilePath) throws JspException {
        this.docFilePath = this.evaluateString("DocumentConverterTag", "docFilePath", docFilePath);
    }

    public void setTitle(String title) throws JspException {
        this.title = this.evaluateString("DocumentConverterTag", "title", title);
    }

    public void setMenuTextLength(String menuTextLength) throws JspException {
        this.menuTextLength = this.evaluateString("DocumentConverterTag", "menuTextLength", menuTextLength);
    }

    public void setCssList(String cssList) throws JspException {
        this.cssList = (List)this.evaluate("DocumentConverterTag", "cssList", cssList, List.class);
    }

    public void setRewrite(String rewrite) throws JspException {
        this.rewrite = this.evaluateString("DocumentConverterTag", "rewrite", rewrite);
    }
}

