/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.services;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.webloggers.CommonLogger;
import org.infoglue.deliver.util.webloggers.Logger;
import org.infoglue.deliver.util.webloggers.W3CExtendedLogger;

public class StatisticsService {
    private static StatisticsService statisticsService = null;
    private Logger logger = new CommonLogger();

    private StatisticsService() {
        String statisticsLogger = CmsPropertyHandler.getStatisticsLogger();
        if (statisticsLogger != null && statisticsLogger.equalsIgnoreCase("W3CExtendedLogger")) {
            this.logger = new W3CExtendedLogger();
        }
    }

    public static StatisticsService getStatisticsService() {
        if (statisticsService == null) {
            statisticsService = new StatisticsService();
        }
        return statisticsService;
    }

    public void registerRequest(HttpServletRequest request, HttpServletResponse response, String pagePath, long elapsedTime) {
        String enabled = CmsPropertyHandler.getStatisticsEnabled();
        if (Boolean.valueOf(enabled).booleanValue()) {
            this.logger.logRequest(request, response, pagePath, elapsedTime);
        }
    }
}

