/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.services;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowListCtrl;
import org.apache.pluto.portalImpl.services.Service;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.infoglue.deliver.portal.om.PortletWindowImpl;
import org.infoglue.deliver.portal.services.PortletWindowRegistryService;

public class PortletWindowRegistryServiceImpl
extends Service
implements PortletWindowRegistryService {
    private static final Log log = LogFactory.getLog(PortletWindowRegistryServiceImpl.class);
    private static Map wid2win = Collections.synchronizedMap(new Hashtable());

    public synchronized PortletWindow createPortletWindow(String windowID, String entityID) throws NameNotFoundException {
        PortletWindow window = (PortletWindow)wid2win.get(windowID);
        if (window == null) {
            log.debug((Object)("Found no portletwindow with id[" + windowID + "], registring new instance"));
            PortletApplicationEntityList applicationList = PortletEntityRegistry.getPortletApplicationEntityList();
            for (PortletApplicationEntity pae : applicationList) {
                log.debug((Object)("Available application: " + pae.getId()));
            }
            PortletEntity entity = PortletEntityRegistry.getPortletEntity((ObjectID)org.apache.pluto.portalImpl.util.ObjectID.createFromString((String)entityID));
            if (entity == null) {
                log.fatal((Object)("Couldn't find entity with id: " + entityID));
                throw new NameNotFoundException("Portlet entity not found: " + entityID);
            }
            window = new PortletWindowImpl(windowID, entity);
            ((PortletWindowListCtrl)entity.getPortletWindowList()).add(window);
            wid2win.put(windowID, window);
        }
        return window;
    }

    public PortletWindow getPortletWindow(String id) {
        return (PortletWindow)wid2win.get(id);
    }
}

