/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.services;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.infoglue.deliver.portal.OmBuilder;
import org.infoglue.deliver.portal.OmBuilderXStreamImpl;
import org.infoglue.deliver.portal.om.PortletApplicationEntityListImpl;

public class PortletEntityRegistryServiceFileImplIG
extends PortletEntityRegistryService {
    private static final Log LOG = LogFactory.getLog(PortletEntityRegistryServiceFileImplIG.class);
    private ServletContext aContext;
    private String filename = "WEB-INF/data/portletentityregistryIG.xml";
    private OmBuilder builder = new OmBuilderXStreamImpl();
    private PortletApplicationEntityListImpl applications;

    protected void init(ServletContext aContext, Properties aProperties) throws Exception {
        super.init(aContext, aProperties);
        this.aContext = aContext;
        this.load();
    }

    public PortletApplicationEntityList getPortletApplicationEntityList() {
        return this.applications;
    }

    public PortletEntity getPortletEntity(ObjectID id) {
        String oid = id.toString();
        int dot = oid.lastIndexOf(".");
        if (dot < 0) {
            LOG.warn((Object)("ID does not contain '.' to separate application- and portlet-id: " + id));
            return null;
        }
        org.apache.pluto.portalImpl.util.ObjectID appID = org.apache.pluto.portalImpl.util.ObjectID.createFromString((String)oid.substring(0, dot));
        PortletApplicationEntity appEntity = this.applications.get((ObjectID)appID);
        if (appEntity == null) {
            LOG.warn((Object)("Application not found: " + appID));
            return null;
        }
        PortletEntity portletEntity = appEntity.getPortletEntityList().get(id);
        if (portletEntity == null) {
            LOG.warn((Object)("Portlet not found: " + id));
        }
        return portletEntity;
    }

    public void store() throws IOException {
        String xml = this.builder.toXML(this.applications);
        LOG.info((Object)xml);
    }

    public void load() throws IOException {
        LOG.info((Object)"Start building PortletApplicationList.....");
        InputStream is = this.aContext.getResourceAsStream(this.filename);
        if (is == null) {
            throw new IOException("Unable to find " + this.filename);
        }
        this.applications = this.builder.getPortletApplicationEntityList(is);
        is.close();
        LOG.info((Object)("Applications: " + this.applications));
        LOG.info((Object)"DONE!");
    }

    public void refresh(PortletEntity portletEntity) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        try {
            PortletEntityRegistryServiceFileImplIG reg = new PortletEntityRegistryServiceFileImplIG();
            reg.load();
            reg.store();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

