/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.PortletAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.portal.OmBuilder;
import org.infoglue.deliver.portal.OmBuilderXStreamImpl;
import org.infoglue.deliver.portal.om.PortletApplicationEntityListImpl;

public class PortletEntityRegistryServiceDBImpl
extends PortletEntityRegistryService {
    private static final Log LOG = LogFactory.getLog(PortletEntityRegistryServiceDBImpl.class);
    public static final String PORTLET_REGISTRY_CONTENT_NAME = "portletentityregistry.xml";
    private ServletContext aContext;
    private OmBuilder builder = new OmBuilderXStreamImpl();
    private PortletApplicationEntityListImpl applications;
    private boolean needRefresh = true;

    public PortletApplicationEntityList getPortletApplicationEntityList() {
        if (this.needRefresh) {
            try {
                this.load();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to load PortletEntityRegistry", (Throwable)e);
            }
        }
        return this.applications;
    }

    public PortletEntity getPortletEntity(ObjectID id) {
        String oid;
        int dot;
        if (this.needRefresh) {
            try {
                this.load();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to load PortletEntityRegistry", (Throwable)e);
                return null;
            }
        }
        if ((dot = (oid = id.toString()).lastIndexOf(".")) < 0) {
            LOG.warn((Object)("ID does not contain '.' to separate application- and portlet-id: " + id));
            return null;
        }
        org.apache.pluto.portalImpl.util.ObjectID appID = org.apache.pluto.portalImpl.util.ObjectID.createFromString((String)oid.substring(0, dot));
        PortletApplicationEntity appEntity = this.applications.get((ObjectID)appID);
        if (appEntity == null) {
            LOG.warn((Object)("Application not found: " + appID));
            LOG.warn((Object)this.toString());
            return null;
        }
        PortletEntity portletEntity = appEntity.getPortletEntityList().get(id);
        if (portletEntity == null) {
            LOG.warn((Object)("Portlet not found: " + id));
            LOG.warn((Object)this.toString());
        }
        return portletEntity;
    }

    public void store() throws IOException {
        String xml = this.builder.toXML(this.applications);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing PortletEntityRegistry...\n" + xml));
        }
        try {
            Database db = CastorDatabaseService.getDatabase();
            db.begin();
            byte[] serial = xml.getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(serial);
            DigitalAsset da = this.getPortletRegistry();
            if (da == null) {
                LOG.info((Object)"Creating new portletentityregistry.xml");
                String filePath = CmsPropertyHandler.getDigitalAssetPath();
                DigitalAssetVO newAsset = new DigitalAssetVO();
                newAsset.setAssetContentType("text/xml");
                newAsset.setAssetKey(PORTLET_REGISTRY_CONTENT_NAME);
                newAsset.setAssetFileName(PORTLET_REGISTRY_CONTENT_NAME);
                newAsset.setAssetFilePath(filePath);
                newAsset.setAssetFileSize(new Integer(serial.length));
                da = PortletAssetController.create(newAsset, is);
                LOG.warn((Object)("portletentityregistry.xml stored as id=" + da.getId()));
            } else {
                LOG.info((Object)"Updating portletentityregistry.xml");
                DigitalAssetVO daVO = da.getValueObject();
                daVO.setAssetFileSize(new Integer(serial.length));
                PortletAssetController.update(daVO, is);
            }
            ((InputStream)is).close();
            db.commit();
            db.close();
            LOG.debug((Object)"Stored PortletEntityRegistry successfully");
        }
        catch (Throwable e) {
            LOG.error((Object)"Failed to store PortletEntityRegistry", e);
        }
    }

    public void load() throws IOException {
        LOG.warn((Object)"Loading PortletEntityRegistry start...");
        try {
            DigitalAsset da = this.getPortletRegistry();
            if (da == null) {
                this.applications = new PortletApplicationEntityListImpl();
            } else {
                InputStream is = da.getAssetBlob();
                this.applications = this.builder.getPortletApplicationEntityList(is);
                is.close();
            }
            this.needRefresh = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Applications: " + this.toString()));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Failed to load PortletEntityRegistry", e);
        }
        LOG.warn((Object)"Loaded PortletEntityRegistry done...");
    }

    public void refresh(PortletEntity entity) {
    }

    public String toString() {
        return this.builder.toXML(this.getPortletApplicationEntityList());
    }

    private DigitalAsset getPortletRegistry() throws Exception {
        List das = PortletAssetController.getDigitalAssetByName(PORTLET_REGISTRY_CONTENT_NAME);
        if (das != null && das.size() > 0) {
            DigitalAsset da = (DigitalAsset)das.get(0);
            LOG.debug((Object)("Registry located as id=" + da.getId()));
            return da;
        }
        LOG.info((Object)"Portlet Registry not found");
        return null;
    }

    protected void init(ServletConfig conf, Properties props) throws Exception {
        LOG.debug((Object)"Calling init()");
        super.init(conf, props);
        this.needRefresh = true;
    }

    protected void postInit(ServletConfig conf) throws Exception {
        LOG.debug((Object)"Calling postInit()");
        super.postInit(conf);
        this.needRefresh = true;
    }
}

