/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistry;
import org.infoglue.deliver.portal.om.PortletWindowListImpl;
import org.infoglue.deliver.portal.om.PreferenceSetImpl;

public class PortletEntityImpl
implements PortletEntity {
    private static final Log log = LogFactory.getLog(PortletEntityImpl.class);
    private String portletName;
    private PortletApplicationEntity applicationEntity;
    private ArrayList preferences = new ArrayList();

    public ObjectID getId() {
        return org.apache.pluto.portalImpl.util.ObjectID.createFromString((String)this.portletName);
    }

    public PreferenceSet getPreferenceSet() {
        return new PreferenceSetImpl(this.preferences);
    }

    public void setPreferenceSet(PreferenceSet p) {
        this.preferences = new ArrayList();
        Iterator it = p.iterator();
        while (it.hasNext()) {
            this.preferences.add(it.next());
        }
    }

    public PortletDefinition getPortletDefinition() {
        PortletDefinition def = PortletDefinitionRegistry.getPortletDefinition((ObjectID)this.getId());
        if (def == null) {
            log.error((Object)("Failed to lookup portlet-definition: " + this.portletName));
            log.debug((Object)"Available portlet-definitions: ");
            for (PortletApplicationDefinition papp : PortletDefinitionRegistry.getPortletApplicationDefinitionList()) {
                for (PortletDefinition portlet : papp.getPortletDefinitionList()) {
                    log.debug((Object)("Ok: " + portlet.getId()));
                }
            }
        }
        return def;
    }

    public PortletApplicationEntity getPortletApplicationEntity() {
        return this.applicationEntity;
    }

    public PortletWindowList getPortletWindowList() {
        return new PortletWindowListImpl();
    }

    public Description getDescription(Locale locale) {
        return this.getPortletDefinition().getDescription(locale);
    }

    public void setPortletApplicationEntity(PortletApplicationEntity applicationEntity) {
        this.applicationEntity = applicationEntity;
    }

    public void setId(String id) {
        this.portletName = id;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PortletEntityImpl[ id:");
        buffer.append(this.portletName.toString());
        buffer.append(" preferences:");
        buffer.append(this.preferences);
        buffer.append("]");
        return buffer.toString();
    }
}

