/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.information;

import java.util.HashSet;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.services.config.Config;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.PortletActionProvider;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.services.information.ResourceURLProvider;
import org.infoglue.deliver.portal.PortalControlURL;
import org.infoglue.deliver.portal.information.PortletActionProviderIG;
import org.infoglue.deliver.portal.information.PortletURLProviderIG;
import org.infoglue.deliver.portal.information.ResourceURLProviderIG;

public class DynamicInformationProviderIG
implements DynamicInformationProvider {
    private static final Log log = LogFactory.getLog(DynamicInformationProviderIG.class);
    private static final int NumberOfKnownMimetypes = 15;
    private ServletConfig config;
    private PortalControlURL url;

    public DynamicInformationProviderIG(HttpServletRequest request, ServletConfig config) {
        this.config = config;
        this.url = new PortalControlURL(request);
    }

    public PortletURLProvider getPortletURLProvider(PortletWindow portletWindow) {
        log.debug((Object)"getPortletURLProvider()");
        return new PortletURLProviderIG(this, portletWindow);
    }

    public ResourceURLProvider getResourceURLProvider(PortletWindow portletWindow) {
        log.debug((Object)"getResourceURLProvider()");
        return new ResourceURLProviderIG(this, portletWindow);
    }

    public PortletActionProvider getPortletActionProvider(PortletWindow portletWindow) {
        log.debug((Object)"getPortletActionProvider()");
        return new PortletActionProviderIG(this, portletWindow);
    }

    public PortletMode getPortletMode(PortletWindow portletWindow) {
        log.debug((Object)"getPortletMode()");
        return this.url.getPortletMode(portletWindow);
    }

    public PortletMode getPreviousPortletMode(PortletWindow portletWindow) {
        log.debug((Object)"getPreviousPortletMode()");
        return this.url.getPreviousPortletMode(portletWindow);
    }

    public WindowState getWindowState(PortletWindow portletWindow) {
        log.debug((Object)"getWindowState()");
        return this.url.getWindowState(portletWindow);
    }

    public WindowState getPreviousWindowState(PortletWindow portletWindow) {
        log.debug((Object)"getPreviousWindowState()");
        return this.url.getPreviousWindowState(portletWindow);
    }

    public String getResponseContentType() {
        log.debug((Object)"getResponseContentType()");
        return "text/html";
    }

    public Iterator getResponseContentTypes() {
        log.debug((Object)"getResponseContentTypes()");
        HashSet<String> responseMimeTypes = new HashSet<String>(15);
        responseMimeTypes.add("text/html");
        return responseMimeTypes.iterator();
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        log.debug((Object)"isPortletModeAllowed()");
        String[] supportedModes = Config.getParameters().getStrings("supported.portletmode");
        int i = 0;
        while (i < supportedModes.length) {
            if (supportedModes[i].equalsIgnoreCase(mode.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        log.debug((Object)"isWindowStateAllowed()");
        String[] supportedStates = Config.getParameters().getStrings("supported.windowstate");
        int i = 0;
        while (i < supportedStates.length) {
            if (supportedStates[i].equalsIgnoreCase(state.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PortalControlURL getPortalURL() {
        return new PortalControlURL(this.url);
    }
}

