/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.dispatcher;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.portalImpl.core.PortletContainerFactory;
import org.apache.pluto.portalImpl.factory.FactoryAccess;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.pluto.portalImpl.services.factorymanager.FactoryManager;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.services.ContainerService;
import org.apache.pluto.services.PortletContainerEnvironment;
import org.infoglue.deliver.portal.ServletConfigContainer;
import org.infoglue.deliver.portal.dispatcher.DeliveryServletDispatcher;

public class PortalServletDispatcher
extends DeliveryServletDispatcher {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(PortalServletDispatcher.class);
    public static final String PORTLET_CONTAINER_NAME = "portal_container_name";
    private static String uniqueContainerName;

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"init of servlet");
        super.init(config);
        ServletConfigContainer.getContainer().setServletConfig(config);
        try {
            ServiceManager.init((ServletConfig)config);
        }
        catch (Throwable exc) {
            log.error((Object)"Initialization failed!", exc);
            throw new UnavailableException("Initialization of one or more services failed.");
        }
        try {
            ServiceManager.postInit((ServletConfig)config);
        }
        catch (Throwable expos) {
            log.error((Object)"Post initialization failed!", expos);
            throw new UnavailableException("Post initialization of one or more services failed.");
        }
        if (!PortletContainerFactory.getPortletContainer().isInitialized()) {
            uniqueContainerName = "pluto-" + System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info((Object)("Initializing PortletContainer [" + uniqueContainerName + "]..."));
            }
            org.apache.pluto.portalImpl.core.PortletContainerEnvironment environment = new org.apache.pluto.portalImpl.core.PortletContainerEnvironment();
            environment.addContainerService((ContainerService)Log.getService());
            environment.addContainerService((ContainerService)FactoryManager.getService());
            environment.addContainerService((ContainerService)FactoryAccess.getInformationProviderContainerService());
            environment.addContainerService((ContainerService)FactoryAccess.getDynamicTitleContainerService());
            Properties properties = new Properties();
            try {
                PortletContainerFactory.getPortletContainer().init(uniqueContainerName, config, (PortletContainerEnvironment)environment, properties);
            }
            catch (Throwable exc) {
                log.warn((Object)"Initialization of the portlet container failed!", exc);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"PortletContainer already initialized");
        }
        log.info((Object)"Ready to serve you.");
    }

    public void destroy() {
        super.destroy();
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down portlet container. . .");
        }
        try {
            PortletContainerFactory.getPortletContainer().shutdown();
            ServiceManager.destroy((ServletConfig)this.getServletConfig());
        }
        catch (Throwable t) {
            this.log("Destruction failed!", t);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (log.isDebugEnabled()) {
            Object o;
            String name;
            log.debug((Object)"\n******************************************** infogluePortal service()");
            Enumeration enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                o = req.getParameter(name);
                log.debug((Object)(String.valueOf(name) + "=" + o));
            }
            enumeration = req.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                o = req.getAttribute(name);
                log.debug((Object)(String.valueOf(name) + "=" + o));
            }
        }
        PortletContainerServices.prepare((String)uniqueContainerName);
        req.setAttribute(PORTLET_CONTAINER_NAME, (Object)uniqueContainerName);
        super.service(req, resp);
    }
}

