/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.dispatcher;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.dispatcher.ServletDispatcher;
import webwork.util.ServletValueStack;

public class DeliveryServletDispatcher
extends ServletDispatcher {
    private String actionExtension = ".action";

    public void service(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException {
        if (CmsPropertyHandler.getApplicationName().equalsIgnoreCase("cms")) {
            super.service(aRequest, aResponse);
            return;
        }
        String servletPath = (String)aRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        String actionName = this.getActionName(servletPath);
        GenericDispatcher gd = new GenericDispatcher(actionName, false);
        ActionContext context = gd.prepareContext();
        InfoGluePrincipal principal = (InfoGluePrincipal)aRequest.getSession().getAttribute("infogluePrincipal");
        if (principal != null) {
            aRequest.setAttribute("infoglueRemoteUser", (Object)principal.getName());
        }
        aRequest.setAttribute("webwork.request_url", (Object)aRequest.getRequestURL());
        ServletActionContext.setContext((HttpServletRequest)aRequest, (HttpServletResponse)aResponse, (ServletContext)this.getServletContext(), (String)actionName);
        gd.prepareValueStack();
        ActionResult ar = null;
        try {
            gd.executeAction();
            ar = gd.finish();
        }
        catch (Throwable e) {
            log.error((Object)"Could not execute action", e);
            try {
                aResponse.sendError(404, "Could not execute action [" + actionName + "]:" + e.getMessage() + this.getHTMLErrorMessage(e));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ar != null && ar.getActionException() != null) {
            log.error((Object)"Could not execute action", (Throwable)ar.getActionException());
            try {
                aResponse.sendError(500, String.valueOf(ar.getActionException().getMessage()) + this.getHTMLErrorMessage(ar.getActionException()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ar != null && ar.getResult() != null && ar.getView() == null && !ar.getResult().equals("none")) {
            try {
                aResponse.sendError(404, "No view for result [" + ar.getResult() + "] exists for action [" + actionName + "]");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ar != null && ar.getView() != null && ar.getActionException() == null) {
            String view = ar.getView().toString();
            log.debug((Object)("Result:" + view));
            RequestDispatcher dispatcher = null;
            try {
                dispatcher = aRequest.getRequestDispatcher(view);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (dispatcher == null) {
                throw new ServletException("No presentation file with name '" + view + "' found!");
            }
            try {
                try {
                    if (aRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                        aRequest.setAttribute("webwork.view_uri", (Object)view);
                        aRequest.setAttribute("webwork.request_uri", (Object)aRequest.getRequestURI());
                        aRequest.setAttribute("webwork.request_url", (Object)aRequest.getRequestURL());
                        dispatcher.forward((ServletRequest)aRequest, (ServletResponse)aResponse);
                    } else {
                        dispatcher.include((ServletRequest)aRequest, (ServletResponse)aResponse);
                    }
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            finally {
                aRequest.setAttribute("webwork.valuestack.head", ServletValueStack.getStack((ServletRequest)aRequest).popValue());
            }
        }
        gd.finalizeContext();
    }

    private String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.lastIndexOf(this.actionExtension);
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }
}

