/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.descriptors.services.PortletAppDescriptorService;
import org.apache.pluto.descriptors.services.WebAppDescriptorService;
import org.apache.pluto.descriptors.services.impl.AbstractWebAppDescriptorService;
import org.apache.pluto.descriptors.services.impl.StreamPortletAppDescriptorServiceImpl;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.portalImpl.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.infoglue.deliver.portal.ServletConfigContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Deploy {
    private static final Log log = LogFactory.getLog(Deploy.class);
    private static final int MAX_POLL_DEPLOY = 30;
    private static final String PORTLET_XML = "WEB-INF/portlet.xml";
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String PORTLET_MAPPING = "portletdefinitionmapping.xml";
    private static final String SERVLET_MAPPING = "servletdefinitionmapping.xml";

    public static boolean deployArchive(String webappsDir, String warName, InputStream is, String containerName) throws FileNotFoundException, IOException {
        File webapps = new File(webappsDir);
        if (!webapps.exists() || !webapps.isDirectory()) {
            throw new FileNotFoundException("Webapps directory not found: " + webappsDir);
        }
        String appName = warName;
        int dot = appName.lastIndexOf(".");
        if (dot > 0) {
            appName = appName.substring(0, dot);
        } else {
            warName = String.valueOf(warName) + ".war";
        }
        File war = new File(webapps, warName);
        if (war.exists()) {
            log.info((Object)(".war-file already exists: " + war.getAbsolutePath()));
        } else {
            FileOutputStream os = new FileOutputStream(war);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            int num = Deploy.copyStream(is, bos);
            bos.close();
            os.close();
            log.info((Object)(String.valueOf(num) + " bytes written to " + war.getAbsolutePath()));
        }
        File appDir = new File(webapps, appName);
        File webInfDir = new File(appDir, "WEB-INF");
        File portletXml = new File(webInfDir, "portlet.xml");
        int i = 0;
        while (!portletXml.exists() && i < 30) {
            log.debug((Object)("Waiting for servlet container to deploy portlet, try " + i + "/" + 30));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Deployment paus interrupted", (Throwable)e);
            }
            ++i;
        }
        if (!portletXml.exists()) {
            log.error((Object)("Failed to deploy portlet: " + war.getAbsolutePath()));
        }
        log.info((Object)("Updating pluto service manager: " + containerName));
        try {
            PortletContainerServices.prepare((String)containerName);
            ServiceManager.init((ServletConfig)ServletConfigContainer.getContainer().getServletConfig());
        }
        catch (Exception e) {
            log.error((Object)"Error during update of pluto service manager", (Throwable)e);
        }
        return true;
    }

    public static PortletApplicationDefinition prepareArchive(File file, File tmp, String appName) throws IOException {
        PortletApplicationDefinitionImpl portletApp = null;
        try {
            int i;
            Mapping pdmXml = new Mapping();
            try {
                URL url = Deploy.class.getResource("/portletdefinitionmapping.xml");
                pdmXml.loadMapping(url);
            }
            catch (Exception e) {
                throw new IOException("Failed to load mapping file portletdefinitionmapping.xml");
            }
            JarFile jar = new JarFile(file);
            ZipEntry portletEntry = jar.getEntry(PORTLET_XML);
            if (portletEntry == null) {
                throw new IOException("Unable to find portlet.xml");
            }
            InputStream pisDebug = jar.getInputStream(portletEntry);
            StringBuffer sb = new StringBuffer();
            while ((i = pisDebug.read()) > -1) {
                sb.append((char)i);
            }
            pisDebug.close();
            InputSource xmlSource = new InputSource(new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
            DOMParser parser = new DOMParser();
            parser.parse(xmlSource);
            Document portletDocument = parser.getDocument();
            InputStream pis = jar.getInputStream(portletEntry);
            ZipEntry webEntry = jar.getEntry(WEB_XML);
            InputStream wis = null;
            if (webEntry != null) {
                wis = jar.getInputStream(webEntry);
            }
            Unmarshaller unmarshaller = new Unmarshaller(pdmXml);
            unmarshaller.setWhitespacePreserve(true);
            unmarshaller.setIgnoreExtraElements(true);
            unmarshaller.setIgnoreExtraAttributes(true);
            portletApp = (PortletApplicationDefinitionImpl)unmarshaller.unmarshal((Node)portletDocument);
            Vector<String> structure = new Vector<String>();
            structure.add(appName);
            structure.add(null);
            structure.add(null);
            portletApp.preBuild(structure);
            FileOutputStream fos = new FileOutputStream(tmp);
            JarOutputStream tempJar = new JarOutputStream(fos);
            byte[] buffer = new byte[1024];
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                JarEntry newEntry = new JarEntry(entry.getName());
                tempJar.putNextEntry(newEntry);
                if (entry.getName().equals(WEB_XML)) {
                    StreamPortletAppDescriptorServiceImpl portletAppDescriptorService = new StreamPortletAppDescriptorServiceImpl(appName, pis, null);
                    File tmpf = File.createTempFile("infoglue-web-xml", null);
                    StreamWebAppDescriptorServiceImpl webAppDescriptorService = new StreamWebAppDescriptorServiceImpl(appName, wis, new FileOutputStream(tmpf));
                    org.apache.pluto.driver.deploy.Deploy d = new org.apache.pluto.driver.deploy.Deploy((WebAppDescriptorService)webAppDescriptorService, (PortletAppDescriptorService)portletAppDescriptorService);
                    d.updateDescriptors();
                    FileInputStream fis = new FileInputStream(tmpf);
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                    tmpf.delete();
                    continue;
                }
                InputStream entryStream = jar.getInputStream(entry);
                if (entryStream == null) continue;
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    tempJar.write(buffer, 0, bytesRead);
                }
            }
            tempJar.flush();
            tempJar.close();
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.error((Object)"Failed to prepare archive", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        return portletApp;
    }

    private static void copy(String from, String to) throws IOException {
        File f = new File(to);
        f.getParentFile().mkdirs();
        FileInputStream fis = new FileInputStream(from);
        FileOutputStream fos = new FileOutputStream(f);
        Deploy.copyStream(fis, fos);
        fos.close();
    }

    private static int copyStream(InputStream is, OutputStream os) throws IOException {
        int total = 0;
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = is.read(buffer)) >= 0) {
            os.write(buffer, 0, length);
            total += length;
        }
        os.flush();
        return total;
    }

    private static int expandArchive(File warFile, File destDir) throws IOException {
        int numEntries = 0;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        JarFile jarFile = new JarFile(warFile);
        Enumeration<JarEntry> files = jarFile.entries();
        while (files.hasMoreElements()) {
            JarEntry entry = files.nextElement();
            String fileName = entry.getName();
            File file = new File(destDir, fileName);
            File dirF = new File(file.getParent());
            dirF.mkdirs();
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                InputStream fis = jarFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(file);
                Deploy.copyStream(fis, fos);
                fos.close();
            }
            ++numEntries;
        }
        return numEntries;
    }

    private static int createArchive(File dir, File archive) throws IOException {
        int BUFFER = 2048;
        BufferedInputStream origin = null;
        FileOutputStream dest = new FileOutputStream(archive);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        byte[] data = new byte[BUFFER];
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File curr = files[i];
            if (!curr.isDirectory()) {
                int count;
                FileInputStream fi = new FileInputStream(curr);
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(curr.getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            ++i;
        }
        out.close();
        return files.length;
    }

    private static void removeAll(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                Deploy.removeAll(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static void main(String[] args) {
        try {
            File file = new File("c:\\infoglueHome\\RssPortlet.war");
            File tmp = new File("c:\\infoglueHome\\RssPortlet2.war");
            Deploy.prepareArchive(file, tmp, "test-portlet.war");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class StreamWebAppDescriptorServiceImpl
    extends AbstractWebAppDescriptorService {
        private InputStream in;
        private OutputStream out;

        public StreamWebAppDescriptorServiceImpl(String contextPath, InputStream in, OutputStream out) {
            super(contextPath);
            this.in = in;
            this.out = out;
        }

        protected InputStream getInputStream() throws IOException {
            return this.in;
        }

        protected OutputStream getOutputStream() throws IOException {
            return this.out;
        }
    }
}

