/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.core.PortletContainerFactory;
import org.apache.pluto.portalImpl.servlet.ServletObjectAccess;
import org.apache.pluto.portalImpl.servlet.ServletResponseImpl;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.deliver.portal.PortalException;
import org.infoglue.deliver.portal.PortletWindowIG;

class PortletWindowIGImpl
implements PortletWindowIG {
    private final Log log = LogFactory.getLog(PortletWindowIGImpl.class);
    private HttpServletResponse response;
    private HttpServletRequest wrappedRequest;
    private PortletWindow renderWindow;
    private PortletContainer portletContainer;

    PortletWindowIGImpl(PortletWindow window, HttpServletRequest request, HttpServletResponse response) throws PortletException, PortletContainerException {
        this.response = response;
        this.renderWindow = window;
        this.portletContainer = PortletContainerFactory.getPortletContainer();
        if (this.portletContainer == null) {
            this.log.error((Object)"Portlet container not found!");
        }
        this.wrappedRequest = ServletObjectAccess.getServletRequest((HttpServletRequest)request, (PortletWindow)this.renderWindow);
        this.log.debug((Object)("Loading portlet: " + this.renderWindow));
        this.portletContainer.portletLoad(this.renderWindow, this.wrappedRequest, response);
        this.log.debug((Object)"Loading OK!");
    }

    public String render() throws PortalException {
        this.log.debug((Object)("render(" + this.renderWindow.getPortletEntity().getId() + ", " + this.renderWindow.getId() + ") invoked"));
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ServletResponseImpl wrappedResponse = (ServletResponseImpl)ServletObjectAccess.getStoredServletResponse((HttpServletResponse)this.response, (PrintWriter)pw);
            InfoGluePrincipal infogluePrincipal = (InfoGluePrincipal)this.wrappedRequest.getSession().getAttribute("infogluePrincipal");
            if (infogluePrincipal != null) {
                this.wrappedRequest.setAttribute("infogluePrincipal", (Object)infogluePrincipal);
                this.wrappedRequest.setAttribute("infoglueRemoteUser", (Object)infogluePrincipal.getName());
                this.wrappedRequest.setAttribute("cmsUserName", (Object)infogluePrincipal.getName());
            }
            this.portletContainer.renderPortlet(this.renderWindow, this.wrappedRequest, (HttpServletResponse)wrappedResponse);
            this.log.debug((Object)"Rendering OK!");
            String contents = sw.toString();
            if (contents.length() == 0) {
                this.log.warn((Object)"Rendering generated an empty string");
            }
            this.log.debug((Object)("render(" + this.renderWindow.getPortletEntity().getId() + ", " + this.renderWindow.getId() + ") done"));
            return contents;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new PortalException(t);
        }
    }

    public void setAttribute(String key, Object value) {
        this.wrappedRequest.setAttribute(key, value);
    }

    public void setParameter(String key, String value) {
        if (this.wrappedRequest.getParameter(key) == null || this.wrappedRequest.getParameter(key).equalsIgnoreCase("")) {
            this.wrappedRequest.getParameterMap().put(key, new String[]{value});
        }
    }
}

