/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import javax.portlet.PortletException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.core.PortletContainerFactory;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.infoglue.deliver.portal.PortalException;
import org.infoglue.deliver.portal.ServletConfigContainer;
import org.infoglue.deliver.portal.information.DynamicInformationProviderIG;
import org.infoglue.deliver.portal.services.PortletWindowRegistryService;

public class PortalService {
    private static final Log log = LogFactory.getLog(PortalService.class);

    public boolean service(HttpServletRequest request, HttpServletResponse response) throws PortalException {
        log.debug((Object)"*** service start");
        ServletConfig cfg = ServletConfigContainer.getContainer().getServletConfig();
        if (cfg == null) {
            throw new RuntimeException("ServletConfig is null (the PortalServletDispatcher should initiate it)");
        }
        String portletWindowId = null;
        try {
            DynamicInformationProviderIG provider = (DynamicInformationProviderIG)InformationProviderAccess.getDynamicProvider((HttpServletRequest)request);
            portletWindowId = provider.getPortalURL().getActionWindowID();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to locate DynamicInformationProviderIG", e);
            throw new PortalException(e);
        }
        if (portletWindowId == null) {
            log.debug((Object)"null actionwindow - no actionrequest returning false");
            return false;
        }
        log.debug((Object)("actionwindow found [" + portletWindowId + "]"));
        PortletWindowRegistryService windowService = (PortletWindowRegistryService)ServiceManager.getService(PortletWindowRegistryService.class);
        PortletWindow actionWindow = windowService.getPortletWindow(portletWindowId);
        if (actionWindow == null) {
            log.error((Object)("PortletWindow action requested but not found: " + portletWindowId));
            return false;
        }
        try {
            log.debug((Object)"ask container to process portlet action");
            PortletContainerFactory.getPortletContainer().processPortletAction(actionWindow, request, response);
            log.debug((Object)"action sent and executed without exception");
        }
        catch (PortletException e) {
            log.error((Object)"PortletException: ", (Throwable)e);
            throw new PortalException(e);
        }
        catch (PortletContainerException e) {
            log.error((Object)"PortletContainerException: ", (Throwable)e);
            throw new PortalException(e);
        }
        catch (Exception e) {
            log.error((Object)("Unknown exception [" + e.getClass().getName() + "]"), (Throwable)e);
            throw new PortalException(e);
        }
        return true;
    }
}

