/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import javax.naming.NameNotFoundException;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.infoglue.deliver.portal.PortalException;
import org.infoglue.deliver.portal.PortletWindowIG;
import org.infoglue.deliver.portal.PortletWindowIGImpl;
import org.infoglue.deliver.portal.services.PortletWindowRegistryService;

public class PortalController {
    public static final String NAME = "portalLogic";
    private static final Log log = LogFactory.getLog(PortalController.class);
    private HttpServletRequest request;
    private HttpServletResponse response;

    public PortalController(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public String renderFragment(String portletID, String windowID) throws NameNotFoundException, PortalException {
        PortletWindowIG window = this.getPortletWindow(portletID, windowID);
        return window.render();
    }

    public PortletWindowIG getPortletWindow(String portletID, String windowID) throws NameNotFoundException, PortalException {
        try {
            PortletWindowRegistryService windowService = (PortletWindowRegistryService)ServiceManager.getService(PortletWindowRegistryService.class);
            PortletWindow renderWindow = windowService.createPortletWindow(windowID, portletID);
            log.info((Object)("Portlet window of " + portletID + "," + windowID + ": " + renderWindow));
            return new PortletWindowIGImpl(renderWindow, this.request, this.response);
        }
        catch (PortletException e) {
            log.error((Object)"", (Throwable)e);
            throw new PortalException(e);
        }
        catch (PortletContainerException e) {
            log.error((Object)"", (Throwable)e);
            throw new PortalException(e);
        }
        catch (Throwable e) {
            log.error((Object)"", e);
            throw new PortalException(e);
        }
    }
}

