/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.window.PortletWindow;
import org.infoglue.deliver.portal.PathParser;

public class PortalControlURL {
    private static final Log log = LogFactory.getLog(PortalControlURL.class);
    public static final String IG = "_ig_";
    public static final String RENDER = "_rp_";
    public static final String ACTION = "_ac";
    public static final String PID = "_pid";
    public static final String MULTI_VALUE = "__";
    private String contextPath;
    private String realPath;
    private String webWorkAction;
    private Map queryParams;
    private Map pathParams;
    private String local;

    public PortalControlURL(HttpServletRequest req) {
        while (req instanceof HttpServletRequestWrapper) {
            req = (HttpServletRequest)((HttpServletRequestWrapper)req).getRequest();
        }
        this.contextPath = req.getContextPath();
        String path = req.getRequestURI();
        if (this.contextPath != null && path.length() > 0) {
            path = path.substring(this.contextPath.length(), path.length());
        }
        if (path.endsWith(".action")) {
            int last = path.lastIndexOf("/");
            this.webWorkAction = path.substring(last + 1);
            path = path.substring(0, last);
        }
        this.realPath = PathParser.getRealPath(path);
        this.queryParams = PathParser.copyParameters(req.getParameterMap());
        this.pathParams = PathParser.parsePathParameters("_", path, true);
        log.debug((Object)("realPath: " + this.realPath));
        log.debug((Object)("wwAction: " + this.webWorkAction));
    }

    public PortalControlURL(PortalControlURL url) {
        this.contextPath = url.contextPath;
        this.realPath = url.realPath;
        this.webWorkAction = url.webWorkAction;
        this.queryParams = new HashMap(url.queryParams.size());
        this.queryParams.putAll(url.queryParams);
        this.pathParams = new HashMap(url.pathParams.size());
        this.pathParams.putAll(url.pathParams);
    }

    public PortletMode getPortletMode(PortletWindow window) {
        return PortletMode.VIEW;
    }

    public PortletMode getPreviousPortletMode(PortletWindow portletWindow) {
        return PortletMode.VIEW;
    }

    public WindowState getWindowState(PortletWindow portletWindow) {
        return WindowState.NORMAL;
    }

    public WindowState getPreviousWindowState(PortletWindow portletWindow) {
        return WindowState.NORMAL;
    }

    public void setPortletMode(PortletWindow window, PortletMode mode) {
    }

    public void setPortletWindowState(PortletWindow window, WindowState state) {
    }

    public void setPortletId(PortletWindow window) {
        this.setPathParameter(PID, new String[]{window.getId().toString()});
    }

    public void setPathParameter(String nsName, String[] values) {
        if (values == null || values.length == 0) {
            this.pathParams.remove(nsName);
        } else {
            this.pathParams.put(nsName, values);
        }
    }

    public String getActionWindowID() {
        String[] values = (String[])this.pathParams.get(ACTION);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setActionParameter(PortletWindow window) {
        this.setPathParameter(ACTION, new String[]{window.getId().toString()});
    }

    public void clearActionParameter() {
        this.pathParams.remove(ACTION);
        this.pathParams.remove(PID);
    }

    public Map getRenderParameterMap(PortletWindow window) {
        HashMap result = new HashMap();
        int nsSize = RENDER.length() + window.getId().toString().length() + 1;
        for (String name : this.pathParams.keySet()) {
            if (!name.startsWith(RENDER + window.getId())) continue;
            String paramName = name.substring(nsSize);
            result.put(paramName, this.pathParams.get(name));
        }
        return result;
    }

    public void setRenderParameter(PortletWindow window, String name, String[] values) {
        String nsName = RENDER + window.getId() + "_" + name;
        this.setPathParameter(nsName, values);
    }

    public void clearRenderParameters(PortletWindow window) {
        Iterator iter = this.pathParams.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(RENDER + window.getId())) continue;
            iter.remove();
        }
    }

    public Map getQueryParameterMap(PortletWindow window) {
        return this.queryParams;
    }

    public Map getQueryParameterMap() {
        return this.queryParams;
    }

    public void setQueryParameter(PortletWindow window, String name, String[] values) {
        String nsName = name;
        if (values == null || values.length == 0) {
            this.queryParams.remove(nsName);
        } else {
            this.queryParams.put(nsName, values);
        }
    }

    public void clearQueryParameters() {
        this.queryParams.clear();
    }

    public String toString() {
        String[] values;
        String name;
        Iterator iter;
        StringBuffer buf = new StringBuffer();
        buf.append(this.contextPath);
        if (this.realPath != null) {
            buf.append(this.realPath);
        }
        if (!this.pathParams.isEmpty()) {
            buf.append("/");
            iter = this.pathParams.keySet().iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                values = (String[])this.pathParams.get(name);
                buf.append(name);
                buf.append("/");
                buf.append(PathParser.encodeValues(values));
                if (!iter.hasNext()) continue;
                buf.append("/");
            }
        }
        if (this.webWorkAction != null) {
            buf.append("/");
            buf.append(this.webWorkAction);
        }
        if (!this.queryParams.isEmpty()) {
            buf.append("?");
            iter = this.queryParams.keySet().iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                values = (String[])this.queryParams.get(name);
                int i = 0;
                while (i < values.length) {
                    buf.append(name);
                    buf.append("=");
                    buf.append(values[i]);
                    if (i < values.length - 1) {
                        buf.append("&");
                    }
                    ++i;
                }
                if (!iter.hasNext()) continue;
                buf.append("&");
            }
        }
        if (this.local != null && this.local.length() > 0) {
            buf.append("#");
            buf.append(this.local);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated URL: " + buf.toString()));
        }
        return buf.toString();
    }

    public boolean isTargeted() {
        return this.pathParams.containsKey(ACTION) || this.pathParams.containsKey(PID);
    }
}

