/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.portalImpl.core.PortalControlParameter;

public class PathParser {
    private static final Log log = LogFactory.getLog(PathParser.class);
    public static final String MULTI_VALUE = "__";
    private String path;
    private String action;
    private Collection parsedPath;
    private Collection globalNavigation;
    private Map stateFullParameterMap;
    private Map stateLessParameterMap;
    private String pid = null;
    private String actionControl = null;

    public PathParser(String pPath) {
        this.path = pPath.substring(0, pPath.lastIndexOf(47));
        String tmp = pPath.substring(pPath.lastIndexOf(47) + 1, pPath.length());
        StringTokenizer actionTok = new StringTokenizer(tmp, ";");
        while (actionTok.hasMoreTokens()) {
            String token = actionTok.nextToken();
            if (!token.endsWith(".action")) continue;
            this.action = token;
        }
        this.parsedPath = new LinkedList();
        StringTokenizer tok = new StringTokenizer(this.path, "/.");
        while (tok.hasMoreTokens()) {
            this.parsedPath.add(tok.nextElement());
        }
        this.stateFullParameterMap = new HashMap();
        this.stateLessParameterMap = new HashMap();
        this.globalNavigation = new LinkedList();
        Iterator iter = this.parsedPath.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (PortalControlParameter.isControlParameter((String)element)) {
                if (PortalControlParameter.isStateFullParameter((String)element)) {
                    if (!iter.hasNext()) continue;
                    this.stateFullParameterMap.put(element, iter.next());
                    continue;
                }
                if (!iter.hasNext()) continue;
                this.stateLessParameterMap.put(element, iter.next());
                continue;
            }
            this.globalNavigation.add(element);
        }
        this.pid = (String)this.stateLessParameterMap.get("_pid");
        this.actionControl = (String)this.stateLessParameterMap.get("_ac");
    }

    public Map getStateFullParameterMap() {
        return this.stateFullParameterMap;
    }

    public Map getStateLessParameterMap() {
        return this.stateLessParameterMap;
    }

    public Collection getParsedPath() {
        return this.parsedPath;
    }

    public Collection getGlobalNavigation() {
        return this.globalNavigation;
    }

    public String getPath() {
        return this.path;
    }

    public String getAction() {
        return this.action;
    }

    public static Map copyParameters(Map parameters) {
        HashMap map = new HashMap(parameters.size());
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            map.put(key, value);
        }
        return map;
    }

    public static String getRealPath(String path) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("_")) break;
            buf.append("/");
            buf.append(token);
        }
        return buf.toString();
    }

    public static Map parsePathParameters(String prefix, String encodedParameters, boolean preserveNamespace) {
        log.debug((Object)("Parsing '" + encodedParameters + "' for " + prefix));
        HashMap<String, String[]> map = new HashMap<String, String[]>(10);
        StringTokenizer tok = new StringTokenizer(encodedParameters, "/");
        String name = tok.hasMoreTokens() ? tok.nextToken() : null;
        while (name != null) {
            if (name.startsWith(prefix)) {
                Vector buffer = new Vector();
                String nextName = PathParser.decodeValues(tok, buffer);
                if (buffer.size() > 0) {
                    if (!preserveNamespace) {
                        name = name.substring(prefix.length());
                    }
                    log.debug((Object)("Adding " + name + "=" + buffer));
                    map.put(name, buffer.toArray(new String[buffer.size()]));
                }
                name = nextName;
                continue;
            }
            String string = name = tok.hasMoreTokens() ? tok.nextToken() : null;
        }
        return map;
    }

    private static String decodeValues(StringTokenizer tok, List buffer) {
        if (tok.hasMoreTokens()) {
            String entry = tok.nextToken();
            if (entry.startsWith(MULTI_VALUE)) {
                while (tok.hasMoreTokens() && entry.startsWith(MULTI_VALUE)) {
                    buffer.add(entry.substring(MULTI_VALUE.length()));
                    entry = tok.nextToken().replaceAll("%2F", "/");
                }
                return entry;
            }
            buffer.add(entry.replaceAll("%2F", "/"));
            return tok.hasMoreElements() ? tok.nextToken() : null;
        }
        return null;
    }

    public static String encodeValues(String[] values) {
        StringBuffer result = new StringBuffer();
        if (values.length == 1) {
            result.append(values[0].replaceAll("/", "%2F"));
        } else {
            int i = 0;
            while (i < values.length) {
                result.append(MULTI_VALUE);
                result.append(values[i].replaceAll("/", "%2F"));
                if (i < values.length - 1) {
                    result.append("/");
                }
                ++i;
            }
        }
        return result.toString();
    }

    public String getPid() {
        return this.pid;
    }

    public String getActionControl() {
        return this.actionControl;
    }

    public boolean isTargetedRequest() {
        return this.pid != null || this.actionControl != null;
    }
}

