/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.portal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.infoglue.deliver.portal.OmBuilder;
import org.infoglue.deliver.portal.om.PortletApplicationEntityImpl;
import org.infoglue.deliver.portal.om.PortletApplicationEntityListImpl;
import org.infoglue.deliver.portal.om.PortletEntityImpl;
import org.infoglue.deliver.portal.om.PreferenceImpl;

public class OmBuilderXStreamImpl
implements OmBuilder {
    private static final Log log = LogFactory.getLog(OmBuilderXStreamImpl.class);
    private XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());

    public OmBuilderXStreamImpl() {
        this.xstream.alias("applications", ArrayList.class);
        this.xstream.alias("application", PortletApplicationEntityImpl.class);
        this.xstream.alias("entities", ArrayList.class);
        this.xstream.alias("entity", PortletEntityImpl.class);
        this.xstream.alias("preferences", ArrayList.class);
        this.xstream.alias("preference", PreferenceImpl.class);
        this.xstream.alias("value", String.class);
        this.xstream.addImplicitCollection(PreferenceImpl.class, "values", String.class);
    }

    public PortletApplicationEntityListImpl getPortletApplicationEntityList(InputStream is) {
        ArrayList apps = new ArrayList();
        try {
            apps = (ArrayList)this.xstream.fromXML((Reader)new InputStreamReader(is));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PortletApplicationEntityListImpl applications = new PortletApplicationEntityListImpl(apps);
        Iterator iter = applications.iterator();
        while (iter.hasNext()) {
            PortletApplicationEntity app = (PortletApplicationEntity)iter.next();
            for (PortletEntityImpl port : app.getPortletEntityList()) {
                if (port.getId().toString().indexOf(".") < 0) {
                    port.setId(app.getId() + "." + port.getId());
                }
                port.setPortletApplicationEntity(app);
            }
        }
        return applications;
    }

    public String toXML(PortletApplicationEntityList pael) {
        ArrayList apps = new ArrayList();
        Iterator it = pael.iterator();
        while (it.hasNext()) {
            apps.add(it.next());
        }
        return this.xstream.toXML(apps);
    }
}

