/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.jobs;

import java.util.Date;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ExpireCacheJob
implements Job {
    private static final Logger logger = Logger.getLogger((String)ExpireCacheJob.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(JobExecutionContext context) throws JobExecutionException {
        block21: {
            try {
                CacheController.evictWaitingCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.info((Object)("---" + context.getJobDetail().getFullName() + " executing.[" + new Date() + "]"));
            try {
                Date firstExpireDateTime = CacheController.expireDateTime;
                logger.info((Object)("firstExpireDateTime:" + firstExpireDateTime));
                Date now = new Date();
                if (firstExpireDateTime != null && now.after(firstExpireDateTime)) {
                    logger.info((Object)"setting block");
                    RequestAnalyser requestAnalyser = RequestAnalyser.getRequestAnalyser();
                    synchronized (requestAnalyser) {
                        if (RequestAnalyser.getRequestAnalyser().getBlockRequests()) {
                            logger.warn((Object)"evictWaitingCache allready in progress - returning to avoid conflict");
                            return;
                        }
                        RequestAnalyser.getRequestAnalyser().setBlockRequests(true);
                    }
                    try {
                        String operatingMode = CmsPropertyHandler.getOperatingMode();
                        if (operatingMode != null && operatingMode.equalsIgnoreCase("3")) {
                            logger.info((Object)"Updating all caches as this was a publishing-update");
                            CacheController.clearCastorCaches();
                            logger.info((Object)"clearing all except page cache as we are in publish mode..");
                            CacheController.clearCaches(null, null, new String[]{"pageCache", "pageCacheExtra", "NavigationCache", "pagePathCache", "userCache", "pageCacheParentSiteNodeCache", "pageCacheLatestSiteNodeVersions", "pageCacheSiteNodeTypeDefinition"});
                            logger.info((Object)"Recaching all caches as this was a publishing-update");
                            CacheController.cacheCentralCastorCaches();
                            logger.info((Object)"Finally clearing page cache as this was a publishing-update");
                            CacheController.clearCache("pageCache");
                            CacheController.clearCache("pageCacheExtra");
                        } else {
                            logger.info((Object)"Updating all caches as this was a publishing-update");
                            CacheController.clearCastorCaches();
                            logger.info((Object)"clearing all except page cache as we are in publish mode..");
                            CacheController.clearCaches(null, null, null);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("An error occurred when we tried to update cache:" + e.getMessage()), (Throwable)e);
                    }
                    logger.info((Object)"releasing block");
                    RequestAnalyser.getRequestAnalyser().setBlockRequests(false);
                }
                Date firstPublishDateTime = CacheController.publishDateTime;
                logger.info((Object)("firstPublishDateTime:" + firstPublishDateTime));
                if (firstPublishDateTime == null || !now.after(firstPublishDateTime)) break block21;
                logger.info((Object)"setting block");
                RequestAnalyser requestAnalyser = RequestAnalyser.getRequestAnalyser();
                synchronized (requestAnalyser) {
                    if (RequestAnalyser.getRequestAnalyser().getBlockRequests()) {
                        logger.warn((Object)"evictWaitingCache allready in progress - returning to avoid conflict");
                        return;
                    }
                    RequestAnalyser.getRequestAnalyser().setBlockRequests(true);
                }
                try {
                    String operatingMode = CmsPropertyHandler.getOperatingMode();
                    if (operatingMode != null && operatingMode.equalsIgnoreCase("3")) {
                        logger.info((Object)"Updating all caches as this was a publishing-update");
                        CacheController.clearCastorCaches();
                        logger.info((Object)"clearing all except page cache as we are in publish mode..");
                        CacheController.clearCaches(null, null, new String[]{"pageCache", "pageCacheExtra", "NavigationCache", "pagePathCache", "userCache", "pageCacheParentSiteNodeCache", "pageCacheLatestSiteNodeVersions", "pageCacheSiteNodeTypeDefinition"});
                        logger.info((Object)"Recaching all caches as this was a publishing-update");
                        CacheController.cacheCentralCastorCaches();
                        logger.info((Object)"Finally clearing page cache as this was a publishing-update");
                        CacheController.clearCache("pageCache");
                        CacheController.clearCache("pageCacheExtra");
                    } else {
                        logger.info((Object)"Updating all caches as this was a publishing-update");
                        CacheController.clearCastorCaches();
                        logger.info((Object)"clearing all except page cache as we are in publish mode..");
                        CacheController.clearCaches(null, null, null);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred when we tried to update cache:" + e.getMessage()), (Throwable)e);
                }
                logger.info((Object)"releasing block");
                RequestAnalyser.getRequestAnalyser().setBlockRequests(false);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to update cache:" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

