/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.invokers;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.NoBaseTemplateFoundException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.portal.PortalController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.CompressionHelper;

public abstract class PageInvoker {
    private static final Logger logger = Logger.getLogger((String)PageInvoker.class.getName());
    private static CompressionHelper compressionHelper = new CompressionHelper();
    private static final VisualFormatter vf = new VisualFormatter();
    private DatabaseWrapper dbWrapper = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private TemplateController templateController = null;
    private DeliveryContext deliveryContext = null;
    private String pageString = null;

    public abstract PageInvoker getDecoratedPageInvoker(TemplateController var1) throws SystemException;

    public void setParameters(DatabaseWrapper dbWrapper, HttpServletRequest request, HttpServletResponse response, TemplateController templateController, DeliveryContext deliveryContext) {
        this.dbWrapper = dbWrapper;
        this.request = request;
        this.response = response;
        this.templateController = templateController;
        this.deliveryContext = deliveryContext;
        this.templateController.setDeliveryContext(this.deliveryContext);
    }

    public Database getDatabase() throws SystemException {
        return this.dbWrapper.getDatabase();
    }

    public abstract void invokePage() throws SystemException, Exception;

    public void deliverPage() throws NoBaseTemplateFoundException, Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("PageKey:" + this.getDeliveryContext().getPageKey()));
            logger.info((Object)("PageCache:" + this.getDeliveryContext().getDisablePageCache()));
        }
        LanguageVO languageVO = LanguageDeliveryController.getLanguageDeliveryController().getLanguageVO(this.getDatabase(), this.getTemplateController().getLanguageId());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("languageVO:" + languageVO));
        }
        if (languageVO == null) {
            throw new SystemException("There was no such active language for the page with languageId:" + this.getTemplateController().getLanguageId());
        }
        String isPageCacheOn = CmsPropertyHandler.getIsPageCacheOn();
        String refresh = this.getRequest().getParameter("refresh");
        if (logger.isInfoEnabled()) {
            logger.info((Object)("isPageCacheOn:" + isPageCacheOn));
        }
        if (isPageCacheOn.equalsIgnoreCase("true") && (refresh == null || !refresh.equalsIgnoreCase("true")) && this.getRequest().getMethod().equals("GET")) {
            String compressPageCache = CmsPropertyHandler.getCompressPageCache();
            Map cachedExtraData = null;
            Integer pageCacheTimeout = this.getTemplateController().getPageCacheTimeout();
            if (compressPageCache != null && compressPageCache.equalsIgnoreCase("true")) {
                byte[] cachedCompressedData = null;
                if (pageCacheTimeout == null) {
                    cachedCompressedData = (byte[])CacheController.getCachedObjectFromAdvancedCache("pageCache", this.getDeliveryContext().getPageKey());
                    cachedExtraData = (Map)CacheController.getCachedObjectFromAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey());
                } else {
                    cachedCompressedData = (byte[])CacheController.getCachedObjectFromAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), pageCacheTimeout);
                    cachedExtraData = (Map)CacheController.getCachedObjectFromAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), pageCacheTimeout);
                }
                if (cachedCompressedData != null) {
                    this.pageString = compressionHelper.decompress(cachedCompressedData);
                }
                if (cachedExtraData != null) {
                    this.getDeliveryContext().populateExtraData(cachedExtraData);
                }
            } else {
                if (pageCacheTimeout == null) {
                    this.pageString = (String)CacheController.getCachedObjectFromAdvancedCache("pageCache", this.getDeliveryContext().getPageKey());
                    cachedExtraData = (Map)CacheController.getCachedObjectFromAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey());
                } else {
                    this.pageString = (String)CacheController.getCachedObjectFromAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), pageCacheTimeout);
                    cachedExtraData = (Map)CacheController.getCachedObjectFromAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), pageCacheTimeout);
                }
                if (cachedExtraData != null) {
                    this.getDeliveryContext().populateExtraData(cachedExtraData);
                }
            }
            if (this.pageString == null) {
                this.invokePage();
                this.pageString = this.getPageString();
                this.getLastModifiedDateTime();
                if (!this.getTemplateController().getIsPageCacheDisabled() && !this.getDeliveryContext().getDisablePageCache()) {
                    if (compressPageCache != null && compressPageCache.equalsIgnoreCase("true")) {
                        long startCompression = System.currentTimeMillis();
                        byte[] compressedData = compressionHelper.compress(this.pageString);
                        logger.info((Object)("Compressing page for pageCache took " + (System.currentTimeMillis() - startCompression) + " with a compressionFactor of " + this.pageString.length() / compressedData.length));
                        if (this.getTemplateController().getOperatingMode() == 3 && !CmsPropertyHandler.getLivePublicationThreadClass().equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                            CacheController.cacheObjectInAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), compressedData, this.getDeliveryContext().getAllUsedEntities(), false);
                            CacheController.cacheObjectInAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), this.getDeliveryContext().getExtraData(), this.getDeliveryContext().getAllUsedEntities(), false);
                        } else {
                            CacheController.cacheObjectInAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), compressedData, this.getDeliveryContext().getAllUsedEntities(), true);
                            CacheController.cacheObjectInAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), this.getDeliveryContext().getExtraData(), this.getDeliveryContext().getAllUsedEntities(), true);
                        }
                    } else if (this.getTemplateController().getOperatingMode() == 3 && !CmsPropertyHandler.getLivePublicationThreadClass().equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                        CacheController.cacheObjectInAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), this.pageString, this.getDeliveryContext().getAllUsedEntities(), false);
                        CacheController.cacheObjectInAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), this.getDeliveryContext().getExtraData(), this.getDeliveryContext().getAllUsedEntities(), false);
                    } else {
                        CacheController.cacheObjectInAdvancedCache("pageCache", this.getDeliveryContext().getPageKey(), this.pageString, this.getDeliveryContext().getAllUsedEntities(), true);
                        CacheController.cacheObjectInAdvancedCache("pageCacheExtra", this.getDeliveryContext().getPageKey(), this.getDeliveryContext().getExtraData(), this.getDeliveryContext().getAllUsedEntities(), true);
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Page caching was disabled for the page " + this.getDeliveryContext().getSiteNodeId() + " with pageKey " + this.getDeliveryContext().getPageKey() + " - modifying the logic to enable page caching would boast performance."));
                }
            } else {
                logger.info((Object)"There was a cached copy...");
            }
            this.getDeliveryContext().setPagePath((String)CacheController.getCachedObject("pagePathCache", this.getDeliveryContext().getPageKey()));
            if (this.getDeliveryContext().getPagePath() == null) {
                this.getDeliveryContext().setPagePath(this.getTemplateController().getCurrentPagePath());
                if (!this.getTemplateController().getIsPageCacheDisabled() && !this.getDeliveryContext().getDisablePageCache()) {
                    CacheController.cacheObject("pagePathCache", this.getDeliveryContext().getPageKey(), this.getDeliveryContext().getPagePath());
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Done caching the pagePath...");
            }
        } else {
            this.invokePage();
            this.pageString = this.getPageString();
            this.getLastModifiedDateTime();
            this.getDeliveryContext().setPagePath(this.templateController.getCurrentPagePath());
        }
        if (this.getRequest().getParameter("includeUsedEntities") != null && this.getRequest().getParameter("includeUsedEntities").equals("true") && (!CmsPropertyHandler.getOperatingMode().equals("3") || CmsPropertyHandler.getLivePublicationThreadClass().equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread"))) {
            StringBuffer sb = new StringBuffer("<usedEntities>");
            String[] usedEntities = this.getDeliveryContext().getAllUsedEntities();
            int i = 0;
            while (i < usedEntities.length) {
                sb.append(usedEntities[i]).append(",");
                ++i;
            }
            sb.append("</usedEntities>");
            this.pageString = String.valueOf(this.pageString) + sb.toString();
        }
        String contentType = this.getTemplateController().getPageContentType();
        if (this.deliveryContext.getContentType() != null && !contentType.equalsIgnoreCase(this.deliveryContext.getContentType())) {
            contentType = this.deliveryContext.getContentType();
        }
        if (this.deliveryContext.getLastModifiedDateTime() != null) {
            this.deliveryContext.getHttpHeaders().put("Last-Modified", this.deliveryContext.getLastModifiedDateTime());
        }
        if (!this.getTemplateController().getOperatingMode().equals("3")) {
            this.getResponse().setHeader("Cache-Control", "no-cache");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setDateHeader("Expires", 0L);
        }
        this.pageString = this.decorateHeadAndPageWithVarsFromComponents(this.pageString);
        if (contentType.indexOf("charset=") > -1) {
            this.getResponse().setContentType(contentType);
        } else {
            this.getResponse().setContentType(String.valueOf(contentType) + "; charset=" + languageVO.getCharset());
        }
        for (String key : this.getDeliveryContext().getHttpHeaders().keySet()) {
            Object value;
            Object valueObject = this.getDeliveryContext().getHttpHeaders().get(key);
            if (valueObject instanceof Date) {
                value = (Date)valueObject;
                this.getResponse().setDateHeader(key, ((Date)value).getTime());
                continue;
            }
            value = (String)valueObject;
            this.getResponse().setHeader(key, (String)value);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contentType:" + contentType + "; charset=" + languageVO.getCharset()));
        }
        String compressPageResponse = CmsPropertyHandler.getCompressPageResponse();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("compressPageResponse:" + compressPageResponse));
        }
        if (compressPageResponse != null && compressPageResponse.equalsIgnoreCase("true")) {
            Object out = null;
            String encodings = this.getRequest().getHeader("Accept-Encoding");
            if (encodings != null && encodings.indexOf("gzip") != -1) {
                this.getResponse().setHeader("Content-Encoding", "gzip");
                out = new GZIPOutputStream((OutputStream)this.getResponse().getOutputStream());
            } else if (encodings != null && encodings.indexOf("compress") != -1) {
                this.getResponse().setHeader("Content-Encoding", "x-compress");
                out = new ZipOutputStream((OutputStream)this.getResponse().getOutputStream());
                ((ZipOutputStream)out).putNextEntry(new ZipEntry("dummy name"));
            } else {
                out = this.getResponse().getOutputStream();
            }
            out.write(this.pageString.getBytes(languageVO.getCharset()));
            out.flush();
            out.close();
        } else {
            PrintWriter out = this.getResponse().getWriter();
            out.println(this.pageString);
            out.flush();
            out.close();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sent all data to client:" + this.pageString.length()));
        }
    }

    private void getLastModifiedDateTime() throws Bug {
        Date lastModifiedDateTime = null;
        if (this.deliveryContext.getUsedContentVersions().size() > 0) {
            for (String usedContentVersion : this.deliveryContext.getUsedContentVersions()) {
                if (usedContentVersion == null || !usedContentVersion.startsWith("contentVersion_")) continue;
                try {
                    String versionId = usedContentVersion.substring(15);
                    if (versionId.equals("null") || versionId.equals("")) continue;
                    Integer contentVersionId = new Integer(versionId);
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.getDatabase());
                    if (lastModifiedDateTime != null && !contentVersion.getModifiedDateTime().after(lastModifiedDateTime)) continue;
                    lastModifiedDateTime = contentVersion.getModifiedDateTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.deliveryContext.setLastModifiedDateTime(lastModifiedDateTime);
        }
    }

    protected String decorateHeadAndPageWithVarsFromComponents(String pageString) {
        if (pageString.length() < 500000) {
            pageString = this.getTemplateController().decoratePage(pageString);
            StringBuffer sb = null;
            List htmlHeadItems = this.getTemplateController().getDeliveryContext().getHtmlHeadItems();
            if (htmlHeadItems != null || htmlHeadItems.size() > 0) {
                int indexOfHeadEndTag = pageString.indexOf("</head");
                if (indexOfHeadEndTag == -1) {
                    indexOfHeadEndTag = pageString.indexOf("</HEAD");
                }
                if (indexOfHeadEndTag != -1) {
                    sb = new StringBuffer(pageString);
                    for (String value : htmlHeadItems) {
                        sb.insert(indexOfHeadEndTag, String.valueOf(value) + "\n");
                    }
                }
            }
            try {
                int lastModifiedDateTimeIndex = sb == null ? pageString.indexOf("<ig:lastModifiedDateTime") : sb.indexOf("<ig:lastModifiedDateTime");
                if (lastModifiedDateTimeIndex > -1) {
                    int formatEndIndex;
                    if (sb == null) {
                        sb = new StringBuffer(pageString);
                    }
                    int lastModifiedDateTimeEndIndex = sb.indexOf("</ig:lastModifiedDateTime>", lastModifiedDateTimeIndex);
                    String tagInfo = sb.substring(lastModifiedDateTimeIndex, lastModifiedDateTimeEndIndex);
                    String dateFormat = "yyyy-MM-dd HH:mm";
                    int formatStartIndex = tagInfo.indexOf("format");
                    if (formatStartIndex > -1 && (formatEndIndex = tagInfo.indexOf("\"", formatStartIndex + 8)) > -1) {
                        dateFormat = tagInfo.substring(formatStartIndex + 8, formatEndIndex);
                    }
                    String dateString = vf.formatDate(this.getTemplateController().getDeliveryContext().getLastModifiedDateTime(), this.getTemplateController().getLocale(), dateFormat);
                    sb.replace(lastModifiedDateTimeIndex, lastModifiedDateTimeEndIndex + "</ig:lastModifiedDateTime>".length(), dateString);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Problem setting lastModifiedDateTime:" + e.getMessage()), (Throwable)e);
            }
            if (sb != null) {
                pageString = sb.toString();
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("pageString was to large (" + pageString.length() + ") so the headers was not inserted."));
        }
        return pageString;
    }

    public void cachePage() {
    }

    public final DeliveryContext getDeliveryContext() {
        return this.deliveryContext;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    public final TemplateController getTemplateController() {
        return this.templateController;
    }

    public String getPageString() {
        return this.pageString;
    }

    public void setPageString(String string) {
        if (string != null && this.deliveryContext.getTrimResponse()) {
            string = string.trim();
        }
        this.pageString = string;
    }

    public Map getDefaultContext() {
        boolean active;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("templateLogic", this.getTemplateController());
        String portalEnabled = CmsPropertyHandler.getEnablePortal();
        boolean bl = active = portalEnabled != null && portalEnabled.equals("true");
        if (active) {
            PortalController pController = new PortalController(this.getRequest(), this.getResponse());
            context.put("portalLogic", pController);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"PortalController.NAME:portalLogic");
                logger.info((Object)("pController:" + pController));
            }
        }
        return context;
    }
}

