/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.invokers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.exception.NoBaseTemplateFoundException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.invokers.PageInvoker;
import org.infoglue.deliver.util.VelocityTemplateProcessor;

public class HTMLPageInvoker
extends PageInvoker {
    private static final Logger logger = Logger.getLogger((String)HTMLPageInvoker.class.getName());

    public PageInvoker getDecoratedPageInvoker(TemplateController templateController) throws SystemException {
        return this;
    }

    public void invokePage() throws NoBaseTemplateFoundException, SystemException, Exception {
        String templateString = this.getPageTemplateString();
        Map context = this.getDefaultContext();
        StringWriter cacheString = new StringWriter();
        PrintWriter cachedStream = new PrintWriter(cacheString);
        new VelocityTemplateProcessor().renderTemplate(context, cachedStream, templateString);
        String pageString = cacheString.toString();
        pageString = this.getTemplateController().decoratePage(pageString);
        this.setPageString(pageString);
    }

    private String getPageTemplateString() throws NoBaseTemplateFoundException, SystemException, Exception {
        String template = null;
        ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), this.getDeliveryContext().getContentId()).getBoundContent(this.getTemplateController().getDatabase(), this.getTemplateController().getPrincipal(), this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), true, "Template", this.getDeliveryContext());
        if (logger.isDebugEnabled()) {
            logger.info((Object)("contentVO:" + contentVO));
        }
        if (contentVO == null) {
            throw new NoBaseTemplateFoundException("There was no template bound to this page which makes it impossible to render.");
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("contentVO:" + contentVO.getName()));
        }
        if ((template = this.getTemplateController().getContentAttribute(contentVO.getContentId(), this.getTemplateController().getTemplateAttributeName())) == null) {
            throw new SystemException("There was no template bound to this page which makes it impossible to render.");
        }
        return template;
    }
}

