/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.invokers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.applications.actions.InfoGlueComponent;
import org.infoglue.deliver.applications.databeans.ComponentBinding;
import org.infoglue.deliver.applications.databeans.ComponentRestriction;
import org.infoglue.deliver.applications.databeans.Slot;
import org.infoglue.deliver.controllers.kernel.impl.simple.ComponentLogic;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.InfoGlueHashSet;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.invokers.AjaxDecoratedComponentBasedHTMLPageInvoker;
import org.infoglue.deliver.invokers.DecoratedComponentBasedHTMLPageInvoker;
import org.infoglue.deliver.invokers.PageInvoker;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import org.infoglue.deliver.util.VelocityTemplateProcessor;

public class ComponentBasedHTMLPageInvoker
extends PageInvoker {
    private static final DOMBuilder domBuilder = new DOMBuilder();
    private static final VisualFormatter vf = new VisualFormatter();
    private static final Logger logger = Logger.getLogger((String)ComponentBasedHTMLPageInvoker.class.getName());

    public PageInvoker getDecoratedPageInvoker(TemplateController templateController) throws SystemException {
        String repositoryDecoratedPageInvoker = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(templateController.getSiteNode().getRepositoryId(), "decoratedPageInvoker");
        if (repositoryDecoratedPageInvoker != null && !repositoryDecoratedPageInvoker.equals("")) {
            if (repositoryDecoratedPageInvoker != null && repositoryDecoratedPageInvoker.equalsIgnoreCase("ajax")) {
                return new AjaxDecoratedComponentBasedHTMLPageInvoker();
            }
            return new DecoratedComponentBasedHTMLPageInvoker();
        }
        String decoratedPageInvoker = CmsPropertyHandler.getDecoratedPageInvoker();
        if (decoratedPageInvoker != null && decoratedPageInvoker.equalsIgnoreCase("ajax")) {
            return new AjaxDecoratedComponentBasedHTMLPageInvoker();
        }
        return new DecoratedComponentBasedHTMLPageInvoker();
    }

    protected String appendPagePartTemplates(String componentXML) throws Exception {
        String resultComponentXML = componentXML;
        ArrayList entries = new ArrayList();
        int isPagePartReferenceIndex = componentXML.indexOf("isPagePartReference");
        while (isPagePartReferenceIndex > -1) {
            int tagStartIndex = componentXML.lastIndexOf("<component ", isPagePartReferenceIndex);
            int n = componentXML.indexOf(">", isPagePartReferenceIndex);
            String componentString = componentXML.substring(tagStartIndex, n);
            int contentIdIndex = componentString.indexOf(" contentId=");
            String contentId = componentString.substring(contentIdIndex + 12, componentString.indexOf("\"", contentIdIndex + 12));
            int idIndex = componentString.indexOf(" id=");
            String id = componentString.substring(idIndex + 5, componentString.indexOf("\"", idIndex + 5));
            int nameIndex = componentString.indexOf(" name=");
            String name = componentString.substring(nameIndex + 7, componentString.indexOf("\"", nameIndex + 7));
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("contentId", contentId);
            entry.put("id", id);
            entry.put("name", name);
            entries.add(entry);
            isPagePartReferenceIndex = componentXML.indexOf("isPagePartReference", isPagePartReferenceIndex + 20);
        }
        for (Map map : entries) {
            String newComponentXML;
            String contentIdString = (String)map.get("contentId");
            Integer contentId = new Integer(contentIdString);
            String id = (String)map.get("id");
            String name = (String)map.get("name");
            ContentTypeDefinitionVO contentTypeDefinitionVO = ContentDeliveryController.getContentDeliveryController().getContentTypeDefinitionVO(this.getDatabase(), contentId);
            if (contentTypeDefinitionVO == null || !contentTypeDefinitionVO.getName().equals("PagePartTemplate")) continue;
            String pagePartString = this.getTemplateController().getContentAttribute(contentId, "ComponentStructure", true);
            logger.info((Object)("pagePartString: " + pagePartString));
            if (pagePartString == null || pagePartString.equals("")) {
                ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(this.getTemplateController().getDatabase(), contentId, this.getTemplateController().getDeliveryContext());
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), this.getTemplateController().getDatabase());
                pagePartString = this.getTemplateController().getContentAttribute(contentId, masterLanguageVO.getId(), "ComponentStructure", true);
                logger.info((Object)("pagePartString: " + pagePartString));
            }
            pagePartString = pagePartString.replaceFirst(" id=\".*?\"", " id=\"" + id + "\"");
            pagePartString = pagePartString.replaceFirst(" name=\".*?\"", " name=\"" + name + "\"");
            pagePartString = pagePartString.replaceFirst(" pagePartTemplateContentId=\".*?\"", " pagePartTemplateContentId=\"" + contentId + "\"");
            logger.info((Object)("Bytte id och namn: " + pagePartString));
            pagePartString = pagePartString.substring(pagePartString.indexOf("<component "));
            pagePartString = pagePartString.substring(0, pagePartString.lastIndexOf("</components>"));
            logger.info((Object)("contentId" + contentId));
            logger.info((Object)("pagePartString" + pagePartString));
            resultComponentXML = newComponentXML = componentXML.replaceAll("<component contentId=\"" + contentId + ".*?</component>", pagePartString);
        }
        return resultComponentXML;
    }

    public void invokePage() throws SystemException, Exception {
        String pageContent = "";
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.getDeliveryContext());
        IntegrationDeliveryController integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(this.getDeliveryContext());
        Integer repositoryId = nodeDeliveryController.getSiteNode(this.getDatabase(), this.getDeliveryContext().getSiteNodeId()).getRepository().getId();
        String componentXML = this.getPageComponentsString(this.getDatabase(), this.getTemplateController(), this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), this.getDeliveryContext().getContentId());
        componentXML = this.appendPagePartTemplates(componentXML);
        InfoGlueComponent baseComponent = null;
        if (componentXML != null && componentXML.length() != 0) {
            Document document = domBuilder.getDocument(componentXML);
            ArrayList unsortedPageComponents = new ArrayList();
            List pageComponents = this.getPageComponents(this.getDatabase(), componentXML, document.getRootElement(), "base", this.getTemplateController(), null, unsortedPageComponents);
            this.preProcessComponents(nodeDeliveryController, repositoryId, unsortedPageComponents, pageComponents);
            if (pageComponents.size() > 0) {
                baseComponent = (InfoGlueComponent)pageComponents.get(0);
            }
            if (baseComponent != null) {
                ContentVO metaInfoContentVO = nodeDeliveryController.getBoundContent(this.getDatabase(), this.getTemplateController().getPrincipal(), this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), true, "Meta information", this.getDeliveryContext());
                pageContent = this.renderComponent(baseComponent, this.getTemplateController(), repositoryId, this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), this.getDeliveryContext().getContentId(), metaInfoContentVO.getId());
            }
        }
        String pageString = pageContent;
        if (this.getDeliveryContext().getEvaluateFullPage()) {
            Map context = this.getDefaultContext();
            StringWriter cacheString = new StringWriter();
            PrintWriter cachedStream = new PrintWriter(cacheString);
            new VelocityTemplateProcessor().renderTemplate(context, cachedStream, pageContent, false, baseComponent);
            pageString = cacheString.toString();
        }
        this.setPageString(pageString);
    }

    protected void preProcessComponents(NodeDeliveryController nodeDeliveryController, Integer repositoryId, List unsortedPageComponents, List pageComponents) throws SystemException, Exception {
        ArrayList<InfoGlueComponent> sortedPageComponents = new ArrayList<InfoGlueComponent>();
        for (InfoGlueComponent component : unsortedPageComponents) {
            this.getTemplateController().setComponentLogic(new ComponentLogic(this.getTemplateController(), component));
            this.getTemplateController().getDeliveryContext().getUsageListeners().add(this.getTemplateController().getComponentLogic().getComponentDeliveryContext());
            int index = 0;
            for (InfoGlueComponent sortedComponent : sortedPageComponents) {
                this.getTemplateController().setComponentLogic(new ComponentLogic(this.getTemplateController(), sortedComponent));
                this.getTemplateController().getDeliveryContext().getUsageListeners().add(this.getTemplateController().getComponentLogic().getComponentDeliveryContext());
                if (sortedComponent.getPreProcessingOrder().compareTo(component.getPreProcessingOrder()) < 0) break;
                ++index;
            }
            sortedPageComponents.add(index, component);
        }
        for (InfoGlueComponent component : sortedPageComponents) {
            this.getTemplateController().setComponentLogic(new ComponentLogic(this.getTemplateController(), component));
            this.getTemplateController().getDeliveryContext().getUsageListeners().add(this.getTemplateController().getComponentLogic().getComponentDeliveryContext());
            ContentVO metaInfoContentVO = nodeDeliveryController.getBoundContent(this.getDatabase(), this.getTemplateController().getPrincipal(), this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), true, "Meta information", this.getDeliveryContext());
            this.preProcessComponent(component, this.getTemplateController(), repositoryId, this.getDeliveryContext().getSiteNodeId(), this.getDeliveryContext().getLanguageId(), this.getDeliveryContext().getContentId(), metaInfoContentVO.getId());
        }
    }

    protected String getPageComponentsString(Database db, TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        SiteNodeVO siteNodeVO = templateController.getSiteNode(siteNodeId);
        ContentVO contentVO = null;
        contentVO = siteNodeVO.getMetaInfoContentId() != null && siteNodeVO.getMetaInfoContentId() > -1 ? templateController.getContent(siteNodeVO.getMetaInfoContentId()) : NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(db, templateController.getPrincipal(), siteNodeId, languageId, true, "Meta information", this.getDeliveryContext());
        if (contentVO == null) {
            throw new SystemException("There was no Meta Information bound to this page which makes it impossible to render.");
        }
        String cacheName = "componentEditorCache";
        String cacheKey = "pageComponentString_" + siteNodeId + "_" + languageId + "_" + contentId;
        String versionKey = String.valueOf(cacheKey) + "_contentVersionId";
        String attributeName = "ComponentStructure";
        String cachedPageComponentsString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        Set contentVersionId = (Set)CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", versionKey);
        if (cachedPageComponentsString != null) {
            if (contentVersionId != null) {
                for (Integer currentContentVersionId : contentVersionId) {
                    templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
                    templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet().add(currentContentVersionId);
                }
            }
            return cachedPageComponentsString;
        }
        String pageComponentsString = null;
        Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId).getId();
        pageComponentsString = templateController.getMetaInfoContentAttribute(contentVO.getContentId(), masterLanguageId, "ComponentStructure", true);
        if (pageComponentsString == null) {
            throw new SystemException("There was no Meta Information bound to this page which makes it impossible to render.");
        }
        logger.info((Object)("pageComponentsString: " + pageComponentsString));
        CacheController.cacheObject(cacheName, cacheKey, pageComponentsString);
        InfoGlueHashSet contentVersionIds = new InfoGlueHashSet();
        contentVersionIds.addAll(templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet());
        InfoGlueHashSet groups = new InfoGlueHashSet();
        if (templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet().size() > 0) {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId((Integer)templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet().toArray()[0], templateController.getDatabase());
            groups.add("contentVersion_" + contentVersion.getId());
            groups.add("content_" + contentVersion.getValueObject().getContentId());
        }
        if (groups.size() > 0) {
            CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("contentVersionCache", versionKey, contentVersionIds, groups, true);
        }
        return pageComponentsString;
    }

    protected Document getPageComponentsDOM4JDocument(Database db, TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "pageComponentDocument_" + siteNodeId + "_" + languageId + "_" + contentId;
        Document cachedPageComponentsDocument = (Document)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedPageComponentsDocument != null) {
            return cachedPageComponentsDocument;
        }
        Document pageComponentsDocument = null;
        try {
            String xml = this.getPageComponentsString(db, templateController, siteNodeId, languageId, contentId);
            pageComponentsDocument = domBuilder.getDocument(xml);
            CacheController.cacheObject(cacheName, cacheKey, pageComponentsDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return pageComponentsDocument;
    }

    protected Map getComponents(Database db, Element element, TemplateController templateController, InfoGlueComponent parentComponent) throws Exception {
        InfoGlueComponent component = null;
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(db, templateController.getLanguageId());
        HashMap<String, InfoGlueComponent> components = new HashMap<String, InfoGlueComponent>();
        String componentXPath = "component";
        List componentNodeList = element.selectNodes(componentXPath);
        for (Element child : componentNodeList) {
            List propertiesNodeList;
            Integer id = new Integer(child.attributeValue("id"));
            Integer contentId = new Integer(child.attributeValue("contentId"));
            String name = child.attributeValue("name");
            ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(contentId, db);
            component = new InfoGlueComponent();
            component.setId(id);
            component.setContentId(contentId);
            component.setName(contentVO.getName());
            component.setSlotName(name);
            component.setParentComponent(parentComponent);
            if (parentComponent != null) {
                component.setIsInherited(parentComponent.getIsInherited());
            }
            if ((propertiesNodeList = child.selectNodes("properties")).size() > 0) {
                Element propertiesElement = (Element)propertiesNodeList.get(0);
                List propertyNodeList = propertiesElement.selectNodes("property");
                for (Element propertyElement : propertyNodeList) {
                    LanguageVO langaugeVO;
                    String propertyName = propertyElement.attributeValue("name");
                    String type = propertyElement.attributeValue("type");
                    String path = propertyElement.attributeValue("path");
                    if (path == null && propertyElement.attributeValue("path_" + (langaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getDatabase(), templateController.getSiteNodeId())).getLanguageCode()) != null) {
                        path = propertyElement.attributeValue("path_" + langaugeVO.getLanguageCode());
                    }
                    if (propertyElement.attributeValue("path_" + locale.getLanguage()) != null) {
                        path = propertyElement.attributeValue("path_" + locale.getLanguage());
                    }
                    if (path == null || path.equals("")) {
                        logger.info((Object)("Falling back to content master language 1 for property:" + propertyName));
                        LanguageVO contentMasterLangaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.getDatabase(), contentVO.getRepositoryId());
                        if (propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode()) != null) {
                            path = propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode());
                        }
                    }
                    HashMap<String, Object> property = new HashMap<String, Object>();
                    property.put("name", propertyName);
                    property.put("path", path);
                    property.put("type", type);
                    if (propertyName.equals("CacheResult") && (path.equalsIgnoreCase("true") || path.equalsIgnoreCase("yes"))) {
                        component.setCacheResult(true);
                    }
                    if (propertyName.equals("UpdateInterval") && !path.equals("")) {
                        try {
                            component.setUpdateInterval(Integer.parseInt(path));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("The component " + component.getName() + " " + "UpdateInterval" + " with a faulty value on page " + this.getTemplateController().getOriginalFullURL() + ":" + e.getMessage()));
                        }
                    }
                    if (propertyName.equals("CacheKey") && !path.equals("")) {
                        component.setCacheKey(path);
                    }
                    if (propertyName.equals("PreRenderOrder") && !path.equals("")) {
                        component.setPreProcessingOrder(path);
                    }
                    ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
                    List bindingNodeList = propertyElement.selectNodes("binding");
                    for (Element bindingElement : bindingNodeList) {
                        String entity = bindingElement.attributeValue("entity");
                        String entityId = bindingElement.attributeValue("entityId");
                        String assetKey = bindingElement.attributeValue("assetKey");
                        ComponentBinding componentBinding = new ComponentBinding();
                        componentBinding.setEntityClass(entity);
                        componentBinding.setEntityId(new Integer(entityId));
                        componentBinding.setAssetKey(assetKey);
                        componentBinding.setBindingPath(path);
                        bindings.add(componentBinding);
                    }
                    property.put("bindings", bindings);
                    component.getProperties().put(propertyName, property);
                }
            }
            this.getComponentRestrictions(child, component, locale, templateController);
            String componentString = this.getComponentString(templateController, contentId, component);
            int offset = 0;
            int slotStartIndex = componentString.indexOf("<ig:slot", offset);
            while (slotStartIndex > -1) {
                int slotStopIndex = componentString.indexOf("</ig:slot>", slotStartIndex);
                String slotString = componentString.substring(slotStartIndex, slotStopIndex + 10);
                String slotId = slotString.substring(slotString.indexOf("id") + 4, slotString.indexOf("\"", slotString.indexOf("id") + 4));
                boolean inherit = true;
                int inheritIndex = slotString.indexOf("inherit");
                if (inheritIndex > -1) {
                    String inheritString = slotString.substring(inheritIndex + 9, slotString.indexOf("\"", inheritIndex + 9));
                    inherit = Boolean.parseBoolean(inheritString);
                }
                boolean disableAccessControl = false;
                int disableAccessControlIndex = slotString.indexOf("disableAccessControl");
                if (disableAccessControlIndex > -1) {
                    String disableAccessControlString = slotString.substring(disableAccessControlIndex + "disableAccessControl".length() + 2, slotString.indexOf("\"", disableAccessControlIndex + "disableAccessControl".length() + 2));
                    disableAccessControl = Boolean.parseBoolean(disableAccessControlString);
                }
                String[] allowedComponentNamesArray = null;
                int allowedComponentNamesIndex = slotString.indexOf(" allowedComponentNames");
                if (allowedComponentNamesIndex > -1) {
                    String allowedComponentNames = slotString.substring(allowedComponentNamesIndex + 24, slotString.indexOf("\"", allowedComponentNamesIndex + 24));
                    allowedComponentNamesArray = allowedComponentNames.split(",");
                }
                String[] disallowedComponentNamesArray = null;
                int disallowedComponentNamesIndex = slotString.indexOf(" disallowedComponentNames");
                if (disallowedComponentNamesIndex > -1) {
                    String disallowedComponentNames = slotString.substring(disallowedComponentNamesIndex + 27, slotString.indexOf("\"", disallowedComponentNamesIndex + 27));
                    disallowedComponentNamesArray = disallowedComponentNames.split(",");
                }
                String addComponentText = null;
                int addComponentTextIndex = slotString.indexOf("addComponentText");
                if (addComponentTextIndex > -1) {
                    addComponentText = slotString.substring(addComponentTextIndex + "addComponentText".length() + 2, slotString.indexOf("\"", addComponentTextIndex + "addComponentText".length() + 2));
                }
                String addComponentLinkHTML = null;
                int addComponentLinkHTMLIndex = slotString.indexOf("addComponentLinkHTML");
                if (addComponentLinkHTMLIndex > -1) {
                    addComponentLinkHTML = slotString.substring(addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2, slotString.indexOf("\"", addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2));
                }
                int allowedNumberOfComponentsInt = -1;
                int allowedNumberOfComponentsIndex = slotString.indexOf("allowedNumberOfComponents");
                if (allowedNumberOfComponentsIndex > -1) {
                    String allowedNumberOfComponents = slotString.substring(allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2, slotString.indexOf("\"", allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2));
                    try {
                        allowedNumberOfComponentsInt = new Integer(allowedNumberOfComponents);
                    }
                    catch (Exception e) {
                        allowedNumberOfComponentsInt = -1;
                    }
                }
                Slot slot = new Slot();
                slot.setId(slotId);
                slot.setInherit(inherit);
                slot.setDisableAccessControl(disableAccessControl);
                slot.setAllowedComponentsArray(allowedComponentNamesArray);
                slot.setDisallowedComponentsArray(disallowedComponentNamesArray);
                slot.setAddComponentLinkHTML(addComponentLinkHTML);
                slot.setAddComponentText(addComponentText);
                slot.setAllowedNumberOfComponents(new Integer(allowedNumberOfComponentsInt));
                List subComponents = this.getComponents(db, templateController, component, templateController.getSiteNodeId(), slotId);
                slot.setComponents(subComponents);
                component.getSlotList().add(slot);
                offset = slotStopIndex;
                slotStartIndex = componentString.indexOf("<ig:slot", offset);
            }
            List anl = child.selectNodes("components");
            if (anl.size() > 0) {
                Element componentsElement = (Element)anl.get(0);
                component.setComponents(this.getComponents(db, componentsElement, templateController, component));
            }
            components.put(name, component);
        }
        return components;
    }

    protected Map getComponent(Database db, Element element, String componentName, TemplateController templateController, InfoGlueComponent parentComponent) throws Exception {
        InfoGlueComponent component = null;
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(db, templateController.getLanguageId());
        HashMap components = new HashMap();
        String componentXPath = String.valueOf(this.getComponentXPath(parentComponent)) + "/components/component[@name='" + componentName + "']";
        List componentNodeList = element.selectNodes(componentXPath);
        for (Element child : componentNodeList) {
            List propertiesNodeList;
            Integer id = new Integer(child.attributeValue("id"));
            Integer contentId = new Integer(child.attributeValue("contentId"));
            String name = child.attributeValue("name");
            ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(contentId, db);
            component = new InfoGlueComponent();
            component.setId(id);
            component.setContentId(contentId);
            component.setName(contentVO.getName());
            component.setSlotName(name);
            component.setParentComponent(parentComponent);
            if (parentComponent != null) {
                component.setIsInherited(parentComponent.getIsInherited());
            }
            if ((propertiesNodeList = child.selectNodes("properties")).size() > 0) {
                Element propertiesElement = (Element)propertiesNodeList.get(0);
                List propertyNodeList = propertiesElement.selectNodes("property");
                for (Element propertyElement : propertyNodeList) {
                    LanguageVO langaugeVO;
                    String propertyName = propertyElement.attributeValue("name");
                    String type = propertyElement.attributeValue("type");
                    String path = propertyElement.attributeValue("path");
                    if (path == null && propertyElement.attributeValue("path_" + (langaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getDatabase(), templateController.getSiteNodeId())).getLanguageCode()) != null) {
                        path = propertyElement.attributeValue("path_" + langaugeVO.getLanguageCode());
                    }
                    if (propertyElement.attributeValue("path_" + locale.getLanguage()) != null) {
                        path = propertyElement.attributeValue("path_" + locale.getLanguage());
                    }
                    if (path == null || path.equals("")) {
                        logger.info((Object)("Falling back to content master language 2 for property:" + propertyName));
                        LanguageVO contentMasterLangaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.getDatabase(), contentVO.getRepositoryId());
                        if (propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode()) != null) {
                            path = propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode());
                        }
                    }
                    HashMap<String, Object> property = new HashMap<String, Object>();
                    property.put("name", propertyName);
                    property.put("path", path);
                    property.put("type", type);
                    if (propertyName.equals("CacheResult") && (path.equalsIgnoreCase("true") || path.equalsIgnoreCase("yes"))) {
                        component.setCacheResult(true);
                    }
                    if (propertyName.equals("UpdateInterval") && !path.equals("")) {
                        try {
                            component.setUpdateInterval(Integer.parseInt(path));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("The component " + component.getName() + " " + "UpdateInterval" + " with a faulty value on page " + this.getTemplateController().getOriginalFullURL() + ":" + e.getMessage()));
                        }
                    }
                    if (propertyName.equals("CacheKey") && !path.equals("")) {
                        component.setCacheKey(path);
                    }
                    if (propertyName.equals("PreRenderOrder") && !path.equals("")) {
                        component.setPreProcessingOrder(path);
                    }
                    ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
                    List bindingNodeList = propertyElement.selectNodes("binding");
                    for (Element bindingElement : bindingNodeList) {
                        String entity = bindingElement.attributeValue("entity");
                        String entityId = bindingElement.attributeValue("entityId");
                        String assetKey = bindingElement.attributeValue("assetKey");
                        ComponentBinding componentBinding = new ComponentBinding();
                        componentBinding.setEntityClass(entity);
                        componentBinding.setEntityId(new Integer(entityId));
                        componentBinding.setAssetKey(assetKey);
                        componentBinding.setBindingPath(path);
                        bindings.add(componentBinding);
                    }
                    property.put("bindings", bindings);
                    component.getProperties().put(propertyName, property);
                }
            }
            this.getComponentRestrictions(child, component, locale, templateController);
            List anl = child.selectNodes("components");
            if (anl.size() > 0) {
                Element componentsElement = (Element)anl.get(0);
                component.setComponents(this.getComponents(db, componentsElement, templateController, component));
            }
            List<InfoGlueComponent> componentList = new ArrayList<InfoGlueComponent>();
            if (components.containsKey(name)) {
                componentList = (List)components.get(name);
            }
            componentList.add(component);
            components.put(name, componentList);
        }
        return components;
    }

    private String renderComponent(InfoGlueComponent component, TemplateController templateController, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, Integer metainfoContentId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n\n**** Rendering component ****");
            logger.debug((Object)("id: " + component.getId()));
            logger.debug((Object)("contentId: " + component.getContentId()));
            logger.debug((Object)("name: " + component.getName()));
            logger.debug((Object)("slotName: " + component.getSlotName()));
        }
        StringBuffer decoratedComponent = new StringBuffer();
        String componentEditorUrl = CmsPropertyHandler.getComponentEditorUrl();
        templateController.setComponentLogic(new ComponentLogic(templateController, component));
        templateController.getDeliveryContext().getUsageListeners().add(templateController.getComponentLogic().getComponentDeliveryContext());
        boolean renderComponent = false;
        boolean cacheComponent = false;
        boolean cacheResult = component.getCacheResult();
        int updateInterval = component.getUpdateInterval();
        String componentCacheKey = component.getCacheKey();
        if (componentCacheKey == null || componentCacheKey.equals("")) {
            componentCacheKey = CmsPropertyHandler.getComponentKey();
        }
        if (componentCacheKey != null && !componentCacheKey.equals("")) {
            componentCacheKey = CacheController.getComponentCacheKey(componentCacheKey, templateController.getComponentLogic().getComponentDeliveryContext().getPageKey(), templateController.getHttpServletRequest().getSession(), templateController.getHttpServletRequest(), siteNodeId, languageId, contentId, templateController.getBrowserBean().getUseragent(), templateController.getHttpServletRequest().getQueryString(), component, "");
        } else {
            StringBuffer componentCacheKeySB = new StringBuffer();
            componentCacheKeySB.append(templateController.getComponentLogic().getComponentDeliveryContext().getPageKey()).append("_").append(component.getId()).append("_").append(component.getSlotName()).append("_").append(component.getContentId()).append("_").append(component.getIsInherited());
            componentCacheKey = componentCacheKeySB.toString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cacheResult:" + cacheResult));
            logger.debug((Object)("updateInterval:" + updateInterval));
            logger.debug((Object)("componentCacheKey:" + componentCacheKey));
        }
        if (!cacheResult) {
            renderComponent = true;
        } else {
            cacheComponent = true;
            String refresh = this.getRequest().getParameter("refresh");
            if (refresh != null && refresh.equalsIgnoreCase("true")) {
                renderComponent = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("renderComponent:" + renderComponent));
        }
        if (!renderComponent) {
            String cachedString;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("componentCacheKey:" + componentCacheKey));
            }
            if (updateInterval > 0) {
                cachedString = (String)CacheController.getCachedObjectFromAdvancedCache("componentCache", componentCacheKey, updateInterval);
                if (cachedString != null) {
                    decoratedComponent.append(cachedString);
                }
            } else {
                cachedString = (String)CacheController.getCachedObjectFromAdvancedCache("componentCache", componentCacheKey);
                if (cachedString != null) {
                    decoratedComponent.append(cachedString);
                }
            }
            if (decoratedComponent == null || decoratedComponent.length() == 0) {
                renderComponent = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will we render component:" + component.getName() + ":" + renderComponent));
        }
        if (renderComponent) {
            decoratedComponent.append("");
            try {
                String componentString = this.getComponentString(templateController, component.getContentId(), component);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("componentString:" + componentString));
                }
                Map context = this.getDefaultContext();
                context.put("templateLogic", templateController);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, componentString, false, component);
                componentString = cacheString.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("componentString:" + componentString));
                }
                int offset = 0;
                int slotStartIndex = componentString.indexOf("<ig:slot", offset);
                int slotStopIndex = 0;
                while (slotStartIndex > -1) {
                    if (offset > 0) {
                        decoratedComponent.append(componentString.substring(offset + 10, slotStartIndex));
                    } else {
                        decoratedComponent.append(componentString.substring(offset, slotStartIndex));
                    }
                    slotStopIndex = componentString.indexOf("</ig:slot>", slotStartIndex);
                    String slot = componentString.substring(slotStartIndex, slotStopIndex + 10);
                    String id = slot.substring(slot.indexOf("id") + 4, slot.indexOf("\"", slot.indexOf("id") + 4));
                    boolean inherit = true;
                    int inheritIndex = slot.indexOf("inherit");
                    if (inheritIndex > -1) {
                        String inheritString = slot.substring(inheritIndex + 9, slot.indexOf("\"", inheritIndex + 9));
                        inherit = Boolean.parseBoolean(inheritString);
                    }
                    List subComponents = this.getInheritedComponents(templateController.getDatabase(), templateController, component, templateController.getSiteNodeId(), id, inherit);
                    for (InfoGlueComponent subComponent : subComponents) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)(String.valueOf(component.getName()) + " had subcomponent " + subComponent.getName() + ":" + subComponent.getId()));
                        }
                        String subComponentString = "";
                        if (subComponent != null) {
                            subComponentString = this.renderComponent(subComponent, templateController, repositoryId, siteNodeId, languageId, contentId, metainfoContentId);
                        }
                        decoratedComponent.append(subComponentString.trim());
                    }
                    offset = slotStopIndex;
                    slotStartIndex = componentString.indexOf("<ig:slot", offset);
                }
                if (offset > 0) {
                    decoratedComponent.append(componentString.substring(offset + 10));
                } else {
                    decoratedComponent.append(componentString.substring(offset));
                }
                if (cacheComponent) {
                    if (this.getTemplateController().getOperatingMode() == 3 && !CmsPropertyHandler.getLivePublicationThreadClass().equalsIgnoreCase("org.infoglue.deliver.util.SelectiveLivePublicationThread")) {
                        CacheController.cacheObjectInAdvancedCache("componentCache", componentCacheKey, decoratedComponent.toString(), templateController.getComponentLogic().getComponentDeliveryContext().getAllUsedEntities(), false);
                    } else {
                        CacheController.cacheObjectInAdvancedCache("componentCache", componentCacheKey, decoratedComponent.toString(), templateController.getComponentLogic().getComponentDeliveryContext().getAllUsedEntities(), true);
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)("An component with either an empty template or with no template in the sitelanguages was found:" + e.getMessage()), (Throwable)e);
            }
        }
        templateController.getDeliveryContext().getUsageListeners().remove(templateController.getComponentLogic().getComponentDeliveryContext());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("decoratedComponent:" + decoratedComponent.toString()));
        }
        return decoratedComponent.toString();
    }

    private String preProcessComponent(InfoGlueComponent component, TemplateController templateController, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, Integer metainfoContentId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n\n**** Pre processing component ****");
            logger.debug((Object)("id: " + component.getId()));
            logger.debug((Object)("contentId: " + component.getContentId()));
            logger.debug((Object)("name: " + component.getName()));
            logger.debug((Object)("slotName: " + component.getSlotName()));
        }
        StringBuffer decoratedComponent = new StringBuffer();
        templateController.setComponentLogic(new ComponentLogic(templateController, component));
        templateController.getDeliveryContext().getUsageListeners().add(templateController.getComponentLogic().getComponentDeliveryContext());
        try {
            String componentString = this.getComponentPreProcessingTemplateString(templateController, component.getContentId(), component);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("componentString:" + componentString));
            }
            if (componentString != null && !componentString.equals("")) {
                Map context = this.getDefaultContext();
                context.put("templateLogic", templateController);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, componentString, false, component, " - PreTemplate");
                componentString = cacheString.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("An component with either an empty template or with no template in the sitelanguages was found:" + e.getMessage()), (Throwable)e);
        }
        templateController.getDeliveryContext().getUsageListeners().remove(templateController.getComponentLogic().getComponentDeliveryContext());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("decoratedComponent:" + decoratedComponent.toString()));
        }
        return decoratedComponent.toString();
    }

    protected String getComponentString(TemplateController templateController, Integer contentId, InfoGlueComponent component) throws SystemException, Exception {
        String template = null;
        try {
            if (templateController.getDeliveryContext().getShowSimple()) {
                String componentString = templateController.getContentAttribute(contentId, templateController.getTemplateAttributeName(), true);
                String slots = "";
                int offset = 0;
                int index = componentString.indexOf("<ig:slot");
                int end = componentString.indexOf("</ig:slot>", offset);
                while (index > -1 && end > -1) {
                    offset = end;
                    slots = String.valueOf(slots) + componentString.substring(index, end + 10);
                    index = componentString.indexOf("<ig:slot", offset + 1);
                    end = componentString.indexOf("</ig:slot>", index);
                }
                template = "<div style=\"position:relative; padding: 5px 5px 5px 5px; font-family:verdana, sans-serif; font-size:10px; border: 1px solid black;\">" + component.getName() + slots + "</div>";
            } else {
                template = templateController.getContentAttribute(contentId, templateController.getTemplateAttributeName(), true);
            }
            if (template == null) {
                throw new SystemException("There was no template available on the content with id " + contentId + ". Check so that the templates language are active on your site.");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return template;
    }

    protected String getComponentPreProcessingTemplateString(TemplateController templateController, Integer contentId, InfoGlueComponent component) throws SystemException, Exception {
        String template = null;
        try {
            template = templateController.getContentAttribute(contentId, "PreTemplate", true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return template;
    }

    protected List getInheritedComponents(Database db, TemplateController templateController, InfoGlueComponent component, Integer siteNodeId, String id, boolean inherit) throws Exception {
        List inheritedComponents = new ArrayList<InfoGlueComponent>();
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(templateController.getSiteNodeId(), templateController.getLanguageId(), templateController.getContentId());
        for (Slot slot : component.getSlotList()) {
            if (!slot.getId().equalsIgnoreCase(id)) continue;
            for (InfoGlueComponent infoGlueComponent : slot.getComponents()) {
                inheritedComponents.add(infoGlueComponent);
            }
        }
        SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, siteNodeId);
        boolean restrictAll = false;
        for (ComponentRestriction restriction : component.getRestrictions()) {
            if (!restriction.getType().equalsIgnoreCase("blockComponents") || !restriction.getSlotId().equalsIgnoreCase(id) || !restriction.getArguments().equalsIgnoreCase("*")) continue;
            restrictAll = true;
        }
        while (inheritedComponents.size() == 0 && parentSiteNodeVO != null && inherit && !restrictAll) {
            String componentXML = this.getPageComponentsString(db, templateController, parentSiteNodeVO.getId(), templateController.getLanguageId(), component.getContentId());
            String key = parentSiteNodeVO.getId() + "_" + componentXML.hashCode();
            String mapKey = parentSiteNodeVO.getId() + "_" + componentXML.hashCode() + "_" + id + "_components";
            Map components = (Map)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", mapKey);
            if (components == null) {
                Object componentsCandidate = CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", key);
                Document document = null;
                document = componentsCandidate == null ? domBuilder.getDocument(componentXML) : (Document)componentsCandidate;
                components = this.getComponent(db, document.getRootElement(), id, templateController, component);
                if (components != null) {
                    CacheController.cacheObjectInAdvancedCache("componentPropertyCache", mapKey, components, null, false);
                }
            }
            if (components.containsKey(id)) {
                inheritedComponents = (List)components.get(id);
                for (InfoGlueComponent infoGlueComponent : inheritedComponents) {
                    infoGlueComponent.setIsInherited(true);
                }
            }
            parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, parentSiteNodeVO.getId());
        }
        return inheritedComponents;
    }

    private String getComponentXPath(InfoGlueComponent infoGlueComponent) {
        String path = "";
        String parentPath = "";
        InfoGlueComponent parentInfoGlueComponent = infoGlueComponent.getParentComponent();
        if (parentInfoGlueComponent != null && parentInfoGlueComponent.getId().intValue() != infoGlueComponent.getId().intValue()) {
            parentPath = this.getComponentXPath(parentInfoGlueComponent);
        }
        path = String.valueOf(parentPath) + "/components/component[@name='" + infoGlueComponent.getSlotName() + "']";
        return path;
    }

    protected InfoGlueComponent getComponent(Database db, TemplateController templateController, InfoGlueComponent component, Integer siteNodeId, String id) throws Exception {
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(templateController.getSiteNodeId(), templateController.getLanguageId(), templateController.getContentId());
        String componentXML = this.getPageComponentsString(db, templateController, siteNodeId, templateController.getLanguageId(), component.getContentId());
        Document document = domBuilder.getDocument(componentXML);
        Map components = this.getComponent(db, document.getRootElement(), id, templateController, component);
        InfoGlueComponent infoGlueComponent = (InfoGlueComponent)components.get(id);
        SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, siteNodeId);
        while (infoGlueComponent == null && parentSiteNodeVO != null) {
            componentXML = this.getPageComponentsString(db, templateController, parentSiteNodeVO.getId(), templateController.getLanguageId(), component.getContentId());
            document = domBuilder.getDocument(componentXML);
            components = this.getComponent(db, document.getRootElement(), id, templateController, component);
            infoGlueComponent = (InfoGlueComponent)components.get(id);
            if (infoGlueComponent != null) {
                infoGlueComponent.setIsInherited(true);
            }
            parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, parentSiteNodeVO.getId());
        }
        return infoGlueComponent;
    }

    protected List getComponents(Database db, TemplateController templateController, InfoGlueComponent component, Integer siteNodeId, String id) throws Exception {
        List subComponents = new ArrayList();
        try {
            NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(templateController.getSiteNodeId(), templateController.getLanguageId(), templateController.getContentId());
            String componentStructureXML = this.getPageComponentsString(db, templateController, siteNodeId, templateController.getLanguageId(), component.getContentId());
            Document document = domBuilder.getDocument(componentStructureXML);
            Map components = this.getComponent(db, document.getRootElement(), id, templateController, component);
            if (components.containsKey(id)) {
                subComponents = (List)components.get(id);
            }
            SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, siteNodeId);
            while ((subComponents == null || subComponents.size() == 0) && parentSiteNodeVO != null) {
                componentStructureXML = this.getPageComponentsString(db, templateController, parentSiteNodeVO.getId(), templateController.getLanguageId(), component.getContentId());
                document = domBuilder.getDocument(componentStructureXML);
                components = this.getComponent(db, document.getRootElement(), id, templateController, component);
                if (components.containsKey(id)) {
                    subComponents = (List)components.get(id);
                }
                if (subComponents != null) {
                    for (InfoGlueComponent infoGlueComponent : subComponents) {
                        infoGlueComponent.setIsInherited(true);
                    }
                }
                parentSiteNodeVO = nodeDeliveryController.getParentSiteNode(db, parentSiteNodeVO.getId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return subComponents;
    }

    protected List getPageComponents(Database db, String componentXML, Element element, String slotName, TemplateController templateController, InfoGlueComponent parentComponent, List sortedPageComponents) throws Exception {
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(db, templateController.getLanguageId());
        String key = componentXML.hashCode() + "_" + templateController.getLanguageId() + "_" + slotName;
        if (parentComponent != null) {
            key = componentXML.hashCode() + "_" + templateController.getLanguageId() + "_" + slotName + "_" + parentComponent.getId() + "_" + parentComponent.getName() + "_" + parentComponent.getIsInherited();
        }
        String keyChildComponents = String.valueOf(key) + "_childComponents";
        Object componentsCandidate = CacheController.getCachedObjectFromAdvancedCache("pageComponentsCache", key);
        Object childComponentsCandidate = CacheController.getCachedObjectFromAdvancedCache("pageComponentsCache", keyChildComponents);
        List components = new ArrayList();
        List childComponents = new ArrayList();
        String[] groups = null;
        if (childComponentsCandidate != null) {
            childComponents = componentsCandidate instanceof NullObject ? Collections.EMPTY_LIST : (List)childComponentsCandidate;
        }
        if (componentsCandidate != null) {
            components = componentsCandidate instanceof NullObject ? null : (List)componentsCandidate;
        } else {
            String componentXPath = "component[@name='" + slotName + "']";
            List componentElements = element.selectNodes(componentXPath);
            Iterator componentIterator = componentElements.iterator();
            int slotPosition = 0;
            while (componentIterator.hasNext()) {
                Element componentElement = (Element)componentIterator.next();
                Integer id = new Integer(componentElement.attributeValue("id"));
                Integer contentId = new Integer(componentElement.attributeValue("contentId"));
                String name = componentElement.attributeValue("name");
                String isInherited = componentElement.attributeValue("isInherited");
                String pagePartTemplateContentId = componentElement.attributeValue("pagePartTemplateContentId");
                try {
                    List propertiesNodeList;
                    ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(contentId, db);
                    groups = new String[]{"content_" + contentVO.getId()};
                    InfoGlueComponent component = new InfoGlueComponent();
                    component.setPositionInSlot(new Integer(slotPosition));
                    component.setId(id);
                    component.setContentId(contentId);
                    component.setName(contentVO.getName());
                    component.setSlotName(name);
                    component.setParentComponent(parentComponent);
                    if (isInherited != null && isInherited.equals("true")) {
                        component.setIsInherited(true);
                    } else if (parentComponent != null) {
                        component.setIsInherited(parentComponent.getIsInherited());
                    }
                    if (pagePartTemplateContentId != null && !pagePartTemplateContentId.equals("") && !pagePartTemplateContentId.equals("-1")) {
                        Integer pptContentId = new Integer(pagePartTemplateContentId);
                        ContentVO pptContentIdContentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(pptContentId, db);
                        InfoGlueComponent partTemplateReferenceComponent = new InfoGlueComponent();
                        partTemplateReferenceComponent.setPositionInSlot(new Integer(slotPosition));
                        partTemplateReferenceComponent.setId(id);
                        partTemplateReferenceComponent.setContentId(pptContentId);
                        partTemplateReferenceComponent.setName(pptContentIdContentVO.getName());
                        partTemplateReferenceComponent.setSlotName(name);
                        partTemplateReferenceComponent.setParentComponent(parentComponent);
                        partTemplateReferenceComponent.setIsInherited(true);
                        component.setPagePartTemplateContentId(pptContentId);
                        component.setPagePartTemplateComponent(partTemplateReferenceComponent);
                    }
                    if ((propertiesNodeList = componentElement.selectNodes("properties")).size() > 0) {
                        Element propertiesElement = (Element)propertiesNodeList.get(0);
                        List propertyNodeList = propertiesElement.selectNodes("property");
                        for (Element propertyElement : propertyNodeList) {
                            LanguageVO langaugeVO;
                            String propertyName = propertyElement.attributeValue("name");
                            String type = propertyElement.attributeValue("type");
                            String path = propertyElement.attributeValue("path");
                            if (path == null && propertyElement.attributeValue("path_" + (langaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getDatabase(), templateController.getSiteNodeId())).getLanguageCode()) != null) {
                                path = propertyElement.attributeValue("path_" + langaugeVO.getLanguageCode());
                            }
                            if (propertyElement.attributeValue("path_" + locale.getLanguage()) != null) {
                                path = propertyElement.attributeValue("path_" + locale.getLanguage());
                            }
                            if (path == null || path.equals("")) {
                                logger.info((Object)("Falling back to content master language 1 for property:" + propertyName));
                                LanguageVO contentMasterLangaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.getDatabase(), contentVO.getRepositoryId());
                                if (propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode()) != null) {
                                    path = propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode());
                                }
                            }
                            HashMap<String, Object> property = new HashMap<String, Object>();
                            property.put("name", propertyName);
                            property.put("path", path);
                            property.put("type", type);
                            if (propertyName.equals("CacheResult") && (path.equalsIgnoreCase("true") || path.equalsIgnoreCase("yes"))) {
                                component.setCacheResult(true);
                            }
                            if (propertyName.equals("UpdateInterval") && !path.equals("")) {
                                try {
                                    component.setUpdateInterval(Integer.parseInt(path));
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("The component " + component.getName() + " " + "UpdateInterval" + " with a faulty value on page " + this.getTemplateController().getOriginalFullURL() + ":" + e.getMessage()));
                                }
                            }
                            if (propertyName.equals("CacheKey") && !path.equals("")) {
                                component.setCacheKey(path);
                            }
                            if (propertyName.equals("PreRenderOrder") && !path.equals("")) {
                                component.setPreProcessingOrder(path);
                            }
                            ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
                            List bindingNodeList = propertyElement.selectNodes("binding");
                            for (Element bindingElement : bindingNodeList) {
                                String entity = bindingElement.attributeValue("entity");
                                String entityId = bindingElement.attributeValue("entityId");
                                String assetKey = bindingElement.attributeValue("assetKey");
                                ComponentBinding componentBinding = new ComponentBinding();
                                componentBinding.setEntityClass(entity);
                                componentBinding.setEntityId(new Integer(entityId));
                                componentBinding.setAssetKey(assetKey);
                                componentBinding.setBindingPath(path);
                                bindings.add(componentBinding);
                            }
                            property.put("bindings", bindings);
                            component.getProperties().put(propertyName, property);
                        }
                    }
                    this.getComponentRestrictions(componentElement, component, locale, templateController);
                    try {
                        String componentString = this.getComponentString(templateController, contentId, component);
                        int offset = 0;
                        int slotStartIndex = componentString.indexOf("<ig:slot", offset);
                        while (slotStartIndex > -1) {
                            int slotStopIndex = componentString.indexOf("</ig:slot>", slotStartIndex);
                            String slotString = componentString.substring(slotStartIndex, slotStopIndex + 10);
                            String slotId = slotString.substring(slotString.indexOf("id") + 4, slotString.indexOf("\"", slotString.indexOf("id") + 4));
                            boolean inherit = true;
                            int inheritIndex = slotString.indexOf("inherit");
                            if (inheritIndex > -1) {
                                String inheritString = slotString.substring(inheritIndex + 9, slotString.indexOf("\"", inheritIndex + 9));
                                inherit = Boolean.parseBoolean(inheritString);
                            }
                            boolean disableAccessControl = false;
                            int disableAccessControlIndex = slotString.indexOf("disableAccessControl");
                            if (disableAccessControlIndex > -1) {
                                String disableAccessControlString = slotString.substring(disableAccessControlIndex + "disableAccessControl".length() + 2, slotString.indexOf("\"", disableAccessControlIndex + "disableAccessControl".length() + 2));
                                disableAccessControl = Boolean.parseBoolean(disableAccessControlString);
                            }
                            String[] allowedComponentNamesArray = null;
                            int allowedComponentNamesIndex = slotString.indexOf(" allowedComponentNames");
                            if (allowedComponentNamesIndex > -1) {
                                String allowedComponentNames = slotString.substring(allowedComponentNamesIndex + 24, slotString.indexOf("\"", allowedComponentNamesIndex + 24));
                                allowedComponentNamesArray = allowedComponentNames.split(",");
                            }
                            String[] disallowedComponentNamesArray = null;
                            int disallowedComponentNamesIndex = slotString.indexOf(" disallowedComponentNames");
                            if (disallowedComponentNamesIndex > -1) {
                                String disallowedComponentNames = slotString.substring(disallowedComponentNamesIndex + 27, slotString.indexOf("\"", disallowedComponentNamesIndex + 27));
                                disallowedComponentNamesArray = disallowedComponentNames.split(",");
                            }
                            String addComponentText = null;
                            int addComponentTextIndex = slotString.indexOf("addComponentText");
                            if (addComponentTextIndex > -1) {
                                addComponentText = slotString.substring(addComponentTextIndex + "addComponentText".length() + 2, slotString.indexOf("\"", addComponentTextIndex + "addComponentText".length() + 2));
                            }
                            String addComponentLinkHTML = null;
                            int addComponentLinkHTMLIndex = slotString.indexOf("addComponentLinkHTML");
                            if (addComponentLinkHTMLIndex > -1) {
                                addComponentLinkHTML = slotString.substring(addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2, slotString.indexOf("\"", addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2));
                            }
                            int allowedNumberOfComponentsInt = -1;
                            int allowedNumberOfComponentsIndex = slotString.indexOf("allowedNumberOfComponents");
                            if (allowedNumberOfComponentsIndex > -1) {
                                String allowedNumberOfComponents = slotString.substring(allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2, slotString.indexOf("\"", allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2));
                                try {
                                    allowedNumberOfComponentsInt = new Integer(allowedNumberOfComponents);
                                }
                                catch (Exception e) {
                                    allowedNumberOfComponentsInt = -1;
                                }
                            }
                            Slot slot = new Slot();
                            slot.setId(slotId);
                            slot.setInherit(inherit);
                            slot.setDisableAccessControl(disableAccessControl);
                            slot.setAllowedComponentsArray(allowedComponentNamesArray);
                            slot.setDisallowedComponentsArray(disallowedComponentNamesArray);
                            slot.setAddComponentLinkHTML(addComponentLinkHTML);
                            slot.setAddComponentText(addComponentText);
                            slot.setAllowedNumberOfComponents(new Integer(allowedNumberOfComponentsInt));
                            Element componentsElement = (Element)componentElement.selectSingleNode("components");
                            ArrayList tempChildComponents = new ArrayList();
                            List subComponents = this.getPageComponents(db, componentXML, componentsElement, slotId, templateController, component, childComponents);
                            childComponents.addAll(tempChildComponents);
                            slot.setComponents(subComponents);
                            component.getSlotList().add(slot);
                            offset = slotStopIndex;
                            slotStartIndex = componentString.indexOf("<ig:slot", offset);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An component with either an empty template or with no template in the sitelanguages was found:" + e.getMessage()), (Throwable)e);
                    }
                    components.add(component);
                }
                catch (Exception e) {
                    logger.warn((Object)("There was deleted referenced component or some other problem when rendering siteNode: " + templateController.getCurrentPagePath() + "(" + templateController.getSiteNodeId() + ") in language " + templateController.getLanguageId() + ":" + e.getMessage()), (Throwable)e);
                }
                ++slotPosition;
            }
            if (groups == null) {
                groups = new String[]{"selectiveCacheUpdateNonApplicable"};
            }
            if (components != null) {
                CacheController.cacheObjectInAdvancedCache("pageComponentsCache", key, components, groups, false);
                CacheController.cacheObjectInAdvancedCache("pageComponentsCache", keyChildComponents, childComponents, groups, false);
            } else {
                CacheController.cacheObjectInAdvancedCache("pageComponentsCache", key, new NullObject(), groups, false);
                CacheController.cacheObjectInAdvancedCache("pageComponentsCache", keyChildComponents, new NullObject(), groups, false);
            }
        }
        if (sortedPageComponents != null) {
            sortedPageComponents.addAll(components);
            sortedPageComponents.addAll(childComponents);
        }
        return components;
    }

    private void getComponentRestrictions(Element child, InfoGlueComponent component, Locale locale, TemplateController templateController) throws Exception {
        List restrictionsNodeList = child.selectNodes("restrictions");
        if (restrictionsNodeList.size() > 0) {
            Element restrictionsElement = (Element)restrictionsNodeList.get(0);
            List restrictionNodeList = restrictionsElement.selectNodes("restriction");
            for (Element restrictionElement : restrictionNodeList) {
                ComponentRestriction restriction = new ComponentRestriction();
                String type = restrictionElement.attributeValue("type");
                if (type.equals("blockComponents")) {
                    String slotId = restrictionElement.attributeValue("slotId");
                    String arguments = restrictionElement.attributeValue("arguments");
                    restriction.setType(type);
                    restriction.setSlotId(slotId);
                    restriction.setArguments(arguments);
                }
                component.getRestrictions().add(restriction);
            }
        }
    }
}

