/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class RepositoryDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)RepositoryDeliveryController.class.getName());
    private static final RepositoryDeliveryController repositoryDeliveryController = new RepositoryDeliveryController();

    private RepositoryDeliveryController() {
    }

    public static RepositoryDeliveryController getRepositoryDeliveryController() {
        return repositoryDeliveryController;
    }

    public RepositoryVO getMasterRepository(Database db) throws SystemException, Exception {
        RepositoryVO repositoryVO = (RepositoryVO)CacheController.getCachedObject("masterRepository", "masterRepository");
        if (repositoryVO != null) {
            return repositoryVO;
        }
        OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RepositoryImpl r ORDER BY r.repositoryId");
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            Repository repository = (Repository)results.next();
            repositoryVO = repository.getValueObject();
        }
        results.close();
        oql.close();
        if (repositoryVO != null) {
            CacheController.cacheObject("masterRepository", "masterRepository", repositoryVO);
        }
        return repositoryVO;
    }

    public List getRepositoryVOListFromServerName(String serverName, String portNumber, String repositoryName) throws SystemException, Exception {
        List repositories = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                db.begin();
                repositories = this.getRepositoryVOListFromServerName(db, serverName, portNumber, repositoryName);
                db.commit();
            }
            catch (Exception e) {
                try {
                    db.rollback();
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
                db.close();
            }
        }
        finally {
            db.close();
        }
        return repositories;
    }

    public List getRepositoryVOListFromServerName(Database db, String serverName, String portNumber, String repositoryName) throws SystemException, Exception {
        ArrayList<RepositoryVO> repositories = new ArrayList<RepositoryVO>();
        ArrayList<RepositoryVO> cachedRepositories = (ArrayList<RepositoryVO>)CacheController.getCachedObject("masterRepository", "allDNSRepositories");
        if (cachedRepositories == null) {
            cachedRepositories = new ArrayList<RepositoryVO>();
            OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RepositoryImpl r WHERE is_defined(r.dnsName)");
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Repository repository = (Repository)results.next();
                cachedRepositories.add(repository.getValueObject());
            }
            results.close();
            oql.close();
            if (cachedRepositories.size() > 0) {
                CacheController.cacheObject("masterRepository", "allDNSRepositories", cachedRepositories);
            }
        }
        for (RepositoryVO repositoryVO : cachedRepositories) {
            logger.info((Object)("repository:" + repositoryVO.getDnsName()));
            String[] dnsNames = this.splitStrings(repositoryVO.getDnsName());
            logger.info((Object)("dnsNames:" + dnsNames));
            int i = 0;
            while (i < dnsNames.length) {
                logger.info((Object)("dnsNames[i]:" + dnsNames[i]));
                String dnsName = dnsNames[i];
                int protocolIndex = dnsName.indexOf("://");
                if (protocolIndex > -1) {
                    dnsName = dnsName.substring(protocolIndex + 3);
                }
                logger.info((Object)("Matching only server name - removed protocol if there:" + dnsName));
                if (dnsName.indexOf(":") == -1 && dnsName.indexOf(serverName) == 0 || dnsName.indexOf(String.valueOf(serverName) + ":" + portNumber) == 0) {
                    if (repositoryName != null && repositoryName.length() > 0) {
                        logger.info((Object)("Has to check repositoryName also:" + repositoryName));
                        if (repositoryVO.getName().equalsIgnoreCase(repositoryName)) {
                            repositories.add(repositoryVO);
                        }
                    } else {
                        repositories.add(repositoryVO);
                    }
                }
                ++i;
            }
        }
        return repositories;
    }

    private String[] splitStrings(String str) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            list.add(token);
        }
        return list.toArray(new String[0]);
    }

    public List getRepositoryVOList(Database db) throws SystemException, Exception {
        ArrayList<RepositoryVO> repositoryVOList = new ArrayList<RepositoryVO>();
        OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RepositoryImpl r ORDER BY r.repositoryId");
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            Repository repository = (Repository)results.next();
            RepositoryVO repositoryVO = repository.getValueObject();
            repositoryVOList.add(repositoryVO);
        }
        results.close();
        oql.close();
        return repositoryVOList;
    }

    public String getPropertyValue(Integer repositoryId, String propertyName) {
        String key = "parentRepository_" + repositoryId + "_" + propertyName;
        logger.info((Object)("key:" + key));
        Object object = CacheController.getCachedObject("parentRepository", key);
        if (object instanceof NullObject) {
            logger.info((Object)("There was an cached property but it was null:" + object));
            return null;
        }
        if (object != null) {
            logger.info((Object)("There was an cached property:" + object));
            return (String)object;
        }
        String propertyValue = null;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        propertyValue = ps.getString("repository_" + repositoryId + "_" + propertyName);
        logger.info((Object)("propertyValue:" + propertyValue));
        if (propertyValue != null) {
            CacheController.cacheObject("parentRepository", key, propertyValue);
        } else {
            CacheController.cacheObject("parentRepository", key, new NullObject());
        }
        return propertyValue;
    }

    public String getExtraPropertyValue(Integer repositoryId, String propertyName) {
        String key = "repository_" + repositoryId + "_" + propertyName;
        logger.info((Object)("key:" + key));
        Object object = CacheController.getCachedObject("parentRepository", key);
        if (object instanceof NullObject) {
            logger.info((Object)("There was an cached property but it was null:" + object));
            return null;
        }
        if (object != null) {
            logger.info((Object)("There was an cached property:" + object));
            return (String)object;
        }
        String propertyValue = null;
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
            byte[] extraPropertiesBytes = ps.getData("repository_" + repositoryId + "_extraProperties");
            if (extraPropertiesBytes != null) {
                String extraProperties = new String(extraPropertiesBytes, "UTF-8");
                Properties properties = new Properties();
                ByteArrayInputStream is = new ByteArrayInputStream(extraProperties.getBytes("UTF-8"));
                properties.load(is);
                propertyValue = properties.getProperty(propertyName);
            }
            logger.info((Object)("propertyValue:" + propertyValue));
            if (propertyValue != null) {
                CacheController.cacheObject("parentRepository", key, propertyValue);
            } else {
                CacheController.cacheObject("parentRepository", key, new NullObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Could not fetch extra property: " + e.getMessage()), (Throwable)e);
        }
        return propertyValue;
    }
}

