/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.databeans.ReferenceBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ComponentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.applications.actions.InfoGlueComponent;
import org.infoglue.deliver.applications.databeans.ComponentBinding;
import org.infoglue.deliver.applications.databeans.ComponentProperty;
import org.infoglue.deliver.applications.databeans.ComponentPropertyOption;
import org.infoglue.deliver.applications.databeans.ComponentRestriction;
import org.infoglue.deliver.applications.databeans.ComponentTask;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.databeans.Slot;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.integration.dataproviders.PropertyOptionsDataProvider;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.NullObject;
import org.infoglue.deliver.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEditorHelper
extends BaseDeliveryController {
    private final String separator = System.getProperty("line.separator");
    private static final DOMBuilder domBuilder = new DOMBuilder();
    private static final VisualFormatter formatter = new VisualFormatter();
    private static final HttpHelper httpHelper = new HttpHelper();
    private static final Logger logger = Logger.getLogger((String)PageEditorHelper.class.getName());

    public String getComponentPropertiesDiv(Database db, InfoGluePrincipal principal, HttpServletRequest request, Locale locale, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, Integer componentId, Integer componentContentId, String slotName, String showSimple, String originalFullURL, String showLegend, String targetDiv) throws Exception {
        if (request.getParameter("skipPropertiesDiv") != null && request.getParameter("skipPropertiesDiv").equalsIgnoreCase("true")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String componentEditorUrl = CmsPropertyHandler.getComponentEditorUrl();
        Document document = this.getComponentPropertiesDOM4JDocument(siteNodeId, languageId, componentContentId, db, principal);
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(componentContentId, db);
        String componentName = contentVO.getName();
        if (componentName.length() > 20) {
            componentName = String.valueOf(componentName.substring(0, 20)) + "...";
        }
        if (slotName.length() > 10) {
            slotName = String.valueOf(slotName.substring(0, 10)) + "...";
        }
        List languages = LanguageDeliveryController.getLanguageDeliveryController().getLanguagesForSiteNode(db, siteNodeId, principal);
        sb.append("<div id=\"componentProperties\">");
        sb.append("\t<div id=\"componentPropertiesHandle\"><div id=\"leftComponentPropertiesHandle\">Properties - " + componentName + " - " + slotName + "</div><div id=\"rightComponentPropertiesHandle\"><a href=\"javascript:closeDiv('componentProperties');\" class=\"white\"><img src=\"" + componentEditorUrl + "/images/closeIcon.gif\" border=\"0\"/></a></div></div>");
        sb.append("\t<div id=\"componentPropertiesBody\">");
        sb.append("\t<form id=\"componentPropertiesForm\" name=\"component" + componentId + "PropertiesForm\" action=\"" + componentEditorUrl + "ViewSiteNodePageComponents!updateComponentProperties.action\" method=\"POST\">");
        if (showLegend != null && showLegend.equals("true")) {
            sb.append("\t\t<fieldset>");
            sb.append("\t\t<legend>Component properties</legend>");
        } else {
            sb.append("\t\t<fieldset class=\"hiddenFieldSet\">");
        }
        if (languages.size() == 1) {
            sb.append("<input type=\"hidden\" name=\"languageId\" value=\"" + ((LanguageVO)languages.get(0)).getId() + "\">");
        } else {
            int index;
            sb.append("\t<div class=\"propertyRow\">");
            sb.append("\t\t<div class=\"propertyRowLeft\">");
            sb.append("\t\t\t<label for=\"languageId\">" + this.getLocalizedString(locale, "deliver.editOnSight.changeLanguage") + "</label>");
            sb.append("\t\t</div>");
            sb.append("\t\t<div class=\"propertyRowRight\">");
            sb.append("\t\t\t<div class=\"fieldGroup\">");
            sb.append("\t\t\t<select name=\"languageId\" onChange=\"javascript:changeLanguage(" + siteNodeId + ", this, " + contentId + ");\">");
            Iterator languageIterator = languages.iterator();
            int languageIndex = index = 0;
            while (languageIterator.hasNext()) {
                LanguageVO languageVO = (LanguageVO)languageIterator.next();
                if (languageVO.getLanguageId().intValue() == languageId.intValue()) {
                    sb.append("\t\t\t\t\t<option value=\"" + languageVO.getLanguageId() + "\" selected>" + languageVO.getName() + "</option>");
                    languageIndex = index;
                } else {
                    sb.append("\t\t\t\t\t<option value=\"" + languageVO.getLanguageId() + "\">" + languageVO.getName() + "</option>");
                }
                ++index;
            }
            sb.append("\t\t\t</select>");
            sb.append("\t\t\t</div>");
            sb.append("\t\t</div>");
            sb.append("\t</div>");
            sb.append("\t<div style=\"clear:both;\"></div>");
        }
        List componentProperties = this.getComponentProperties(componentId, document, siteNodeId, languageId, contentId, locale, db, principal);
        String hideProtectedProperties = CmsPropertyHandler.getHideProtectedProperties();
        int numberOfHiddenProperties = 0;
        int propertyIndex = 0;
        boolean isAdvancedProperties = false;
        for (ComponentProperty componentProperty : componentProperties) {
            boolean hasAccessToProperty = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentPropertyEditor.EditProperty", componentContentId + "_" + componentProperty.getName());
            boolean isFirstAdvancedProperty = false;
            if (componentProperty.getName().equalsIgnoreCase("CacheResult")) {
                isFirstAdvancedProperty = true;
                isAdvancedProperties = true;
            }
            if (componentProperty.getName().equalsIgnoreCase("CacheResult") || componentProperty.getName().equalsIgnoreCase("UpdateInterval") || componentProperty.getName().equalsIgnoreCase("CacheKey") || componentProperty.getName().equalsIgnoreCase("PreRenderOrder")) {
                hasAccessToProperty = true;
            }
            if (isFirstAdvancedProperty) {
                if (componentProperties.size() - numberOfHiddenProperties < 1) {
                    sb.append("\t<div class=\"propertyRow\">");
                    sb.append("\t\t<div class=\"propertyRowLeft\">");
                    sb.append("\t\t\t<label>" + this.getLocalizedString(locale, "deliver.editOnSight.noPropertiesVisible") + "</label>");
                    sb.append("\t\t</div>");
                    sb.append("\t</div>");
                    sb.append("\t<div style=\"clear:both;\"></div>");
                }
                sb.append("\t<div class=\"propertyRow\">");
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t\t" + this.getLocalizedString(locale, "deliver.editOnSight.advancedProperties") + " <img src='images/downArrow.gif' onclick=\"$('.advancedProperty" + componentId + "').toggle();\"/>");
                sb.append("\t\t</div>");
                sb.append("\t</div>");
                sb.append("\t<div style=\"clear:both;\"></div>");
            }
            if (!hasAccessToProperty && hideProtectedProperties.equalsIgnoreCase("true")) {
                ++numberOfHiddenProperties;
                continue;
            }
            if (componentProperty.getType().equalsIgnoreCase("binding")) {
                String allowedContentTypeIdParameters;
                String assignUrl = "";
                String createUrl = "";
                if (componentProperty.getVisualizingAction() != null && !componentProperty.getVisualizingAction().equals("")) {
                    assignUrl = String.valueOf(componentEditorUrl) + componentProperty.getVisualizingAction() + "?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple;
                } else if (componentProperty.getEntityClass().equalsIgnoreCase("Content")) {
                    allowedContentTypeIdParameters = "";
                    if (componentProperty.getAllowedContentTypeNamesArray() != null && componentProperty.getAllowedContentTypeNamesArray().length > 0) {
                        allowedContentTypeIdParameters = "&" + componentProperty.getAllowedContentTypeIdAsUrlEncodedString(db);
                    }
                    if (componentProperty.getIsMultipleBinding()) {
                        assignUrl = componentProperty.getIsAssetBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTreeForMultipleAssetBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&showSimple=" + showSimple : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&showSimple=" + showSimple;
                    } else if (componentProperty.getIsAssetBinding()) {
                        String assignedParameters = "";
                        for (ComponentBinding componentBinding : componentProperty.getBindings()) {
                            assignedParameters = "&assignedContentId=" + componentBinding.getEntityId() + "&assignedAssetKey=" + componentBinding.getAssetKey() + "&assignedPath=" + formatter.encodeURI(componentProperty.getValue());
                        }
                        assignUrl = String.valueOf(componentEditorUrl) + "ViewContentVersion!viewAssetsForComponentBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&showSimple=" + showSimple + assignedParameters;
                    } else {
                        assignUrl = String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&showSimple=" + showSimple;
                    }
                } else if (componentProperty.getEntityClass().equalsIgnoreCase("SiteNode")) {
                    assignUrl = componentProperty.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showStructureTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showStructureTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple;
                } else if (componentProperty.getEntityClass().equalsIgnoreCase("Category")) {
                    assignUrl = componentProperty.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showCategoryTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showCategoryTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple;
                }
                if (componentProperty.getCreateAction() != null && !componentProperty.getCreateAction().equals("")) {
                    createUrl = String.valueOf(componentEditorUrl) + componentProperty.getCreateAction() + "?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple;
                } else if (componentProperty.getVisualizingAction() != null && !componentProperty.getVisualizingAction().equals("")) {
                    createUrl = assignUrl;
                } else if (componentProperty.getEntityClass().equalsIgnoreCase("Content")) {
                    allowedContentTypeIdParameters = "";
                    if (componentProperty.getAllowedContentTypeNamesArray() != null && componentProperty.getAllowedContentTypeNamesArray().length > 0) {
                        allowedContentTypeIdParameters = "&" + componentProperty.getAllowedContentTypeIdAsUrlEncodedString(db);
                    }
                    String returnAddress = URLEncoder.encode("ViewSiteNodePageComponents!addComponentPropertyBinding.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=-1&entity=Content&entityId=#entityId&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&path=#path&showSimple=" + showSimple, "UTF-8");
                    String cancelKey = originalFullURL;
                    String cancelAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", cancelKey);
                    if (cancelAddress == null) {
                        cancelAddress = URLEncoder.encode(cancelKey, "UTF-8");
                        CacheController.cacheObjectInAdvancedCache("encodedStringsCache", cancelKey, cancelAddress);
                    }
                    createUrl = componentProperty.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "CreateContentWizardFinish.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + showSimple : String.valueOf(componentEditorUrl) + "CreateContentWizardFinish.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + allowedContentTypeIdParameters + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + showSimple;
                } else if (componentProperty.getEntityClass().equalsIgnoreCase("SiteNode")) {
                    String returnAddress = URLEncoder.encode("ViewSiteNodePageComponents!addComponentPropertyBinding.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=-1&entity=Content&entityId=#entityId&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&path=#path&showSimple=" + showSimple, "UTF-8");
                    String cancelKey = originalFullURL;
                    String cancelAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", cancelKey);
                    if (cancelAddress == null) {
                        cancelAddress = URLEncoder.encode(cancelKey, "UTF-8");
                        CacheController.cacheObjectInAdvancedCache("encodedStringsCache", cancelKey, cancelAddress);
                    }
                    createUrl = componentProperty.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "CreateSiteNodeWizardFinish.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + showSimple : String.valueOf(componentEditorUrl) + "CreateSiteNodeWizardFinish.action?repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + showSimple;
                }
                boolean isPuffContentForPage = false;
                if (componentProperty.getType().equalsIgnoreCase("binding") && componentProperty.getEntityClass().equalsIgnoreCase("Content") && componentProperty.getIsPuffContentForPage()) {
                    isPuffContentForPage = true;
                }
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\"" + (isPuffContentForPage ? " style='border-bottom: 0px;'" : "") + ">");
                }
                sb.append("\t\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t\t\t<label for=\"" + componentProperty.getName() + "\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t\t</div>");
                sb.append("\t\t\t<div class=\"propertyRowRight\">");
                if (hasAccessToProperty) {
                    String warningText = this.getLocalizedString(locale, "deliver.editOnSight.dirtyWarning");
                    sb.append("\t\t\t<div class=\"fieldGroup\">");
                    sb.append("\t\t\t\t<a name=\"" + componentProperty.getName() + "\" class=\"componentEditorLink\" href=\"javascript:openAssignDialog('" + warningText + "', '" + assignUrl + "');\">");
                }
                sb.append("\t\t\t\t\t" + (componentProperty.getValue() == null || componentProperty.getValue().equalsIgnoreCase("") ? componentProperty.getDefaultValue() : componentProperty.getValue()) + (componentProperty.getIsAssetBinding() ? " (" + componentProperty.getAssetKey() + ")" : ""));
                if (hasAccessToProperty) {
                    sb.append("\t\t\t\t</a>");
                    sb.append("\t\t\t</div>");
                }
                sb.append("\t\t\t\t<div class=\"actionGroup\">");
                if (componentProperty.getValue() != null && componentProperty.getValue().equalsIgnoreCase("Undefined")) {
                    if (hasAccessToProperty && createUrl != null) {
                        sb.append("\t\t\t<a class=\"componentEditorLink\" href=\"" + createUrl + "\"><img src=\"" + componentEditorUrl + "/images/createContent.gif\" border=\"0\" alt=\"Create new content to show\"></a>");
                    }
                } else if (hasAccessToProperty) {
                    sb.append("\t\t\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + componentProperty.getName() + "&showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                }
                sb.append("\t\t\t</div>");
                sb.append("\t\t\t</div>");
                sb.append("\t\t</div>");
                if (isPuffContentForPage && componentProperty.getBindings() != null && componentProperty.getBindings().size() > 0) {
                    sb.append("\t<div class=\"propertyRow\">");
                    ComponentBinding binding = componentProperty.getBindings().get(0);
                    List referencingPages = this.getReferencingPages(binding.getEntityId(), siteNodeId, 50, new Boolean(true), db);
                    if (referencingPages.size() == 0) {
                        sb.append("\t<div class=\"propertyRowLeft\">");
                        sb.append("\t\t<label>" + this.getLocalizedString(locale, "deliver.editOnSight.noDetailPageWithContentBinding.label") + "</label>");
                        sb.append("\t</div>");
                    } else if (referencingPages.size() == 1) {
                        SiteNodeVO siteNodeVO = (SiteNodeVO)referencingPages.get(0);
                        String path = this.getPagePath(siteNodeVO.getId(), languageId, db, principal);
                        sb.append("\t<div class=\"propertyRowLeft\">");
                        sb.append("\t\t<label>" + this.getLocalizedString(locale, "deliver.editOnSight.detailPageWithContentBinding.label") + "<span title='" + path + "'>" + siteNodeVO.getName() + "(" + siteNodeVO.getSiteNodeId() + ")</span>" + "</label>");
                        sb.append("\t</div>");
                    } else {
                        sb.append("\t<div class=\"propertyRowLeft\">");
                        sb.append("\t\t<label>" + this.getLocalizedString(locale, "deliver.editOnSight.detailPagesWithContentBinding.label") + "</label>");
                        sb.append("\t</div>");
                        sb.append("\t<div class=\"propertyRowRight\">");
                        sb.append("\t\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "_detailSiteNodeId\"/>");
                        sb.append("\t\t<select class=\"propertyselect\" name=\"" + componentProperty.getName() + "_detailSiteNodeId\">");
                        for (SiteNodeVO siteNodeVO : referencingPages) {
                            String path = this.getPagePath(siteNodeVO.getId(), languageId, db, principal);
                            Integer detailSiteNodeId = componentProperty.getDetailSiteNodeId();
                            if (detailSiteNodeId != null && detailSiteNodeId.equals(siteNodeVO.getSiteNodeId())) {
                                sb.append("\t<option value='" + siteNodeVO.getSiteNodeId() + "' title='" + path + "' selected=\"1\">" + siteNodeVO.getName() + "(" + siteNodeVO.getSiteNodeId() + ")" + "</option>");
                                continue;
                            }
                            sb.append("\t<option value='" + siteNodeVO.getSiteNodeId() + "' title='" + path + "'>" + siteNodeVO.getName() + "(" + siteNodeVO.getSiteNodeId() + ")" + "</option>");
                        }
                        sb.append("\t\t</select>");
                        sb.append("\t</div>");
                        if (hasAccessToProperty) {
                            ++propertyIndex;
                        }
                    }
                    sb.append("\t</div>");
                }
            } else if (componentProperty.getType().equalsIgnoreCase("textfield")) {
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\">");
                }
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t\t<label for=\"" + componentProperty.getName() + "\" onMouseOver=\"showDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\" onMouseOut=\"javascript:hideDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t</div>");
                sb.append("\t\t<div class=\"propertyRowRight\">");
                sb.append("\t\t\t<div class=\"fieldGroup\">");
                if (hasAccessToProperty) {
                    sb.append("\t\t\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "\"/>");
                    sb.append("\t\t\t<input type=\"text\" class=\"propertytextfield\" name=\"" + componentProperty.getName() + "\" value=\"" + componentProperty.getValue() + "\" onkeydown=\"setDirty();\"/>");
                } else {
                    sb.append("\t" + componentProperty.getValue());
                }
                sb.append("\t\t\t</div>");
                if (hasAccessToProperty) {
                    sb.append("\t<div class=\"actionGroup\">");
                    sb.append("\t\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&amp;languageId=" + languageId + "&amp;contentId=" + contentId + "&amp;componentId=" + componentId + "&amp;propertyName=" + componentProperty.getName() + "&amp;showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                    sb.append("\t</div>");
                }
                sb.append("\t</div>");
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    ++propertyIndex;
                }
            } else if (componentProperty.getType().equalsIgnoreCase("datefield")) {
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\">");
                }
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t\t<label for=\"" + componentProperty.getName() + "\" onMouseOver=\"showDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\" onMouseOut=\"javascript:hideDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t</div>");
                sb.append("\t\t<div class=\"propertyRowRight\">");
                sb.append("\t\t\t<div class=\"fieldGroup\">");
                if (hasAccessToProperty) {
                    sb.append("\t\t\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "\"/>");
                    sb.append("\t\t\t<input type=\"text\" class=\"propertydatefield\" style=\"width: 100px;\" id=\"" + componentProperty.getName() + "\" name=\"" + componentProperty.getName() + "\" value=\"" + componentProperty.getValue() + "\" onkeydown=\"setDirty();\"/>&nbsp;<a name=\"calendar_" + componentProperty.getName() + "\" id=\"calendar_" + componentProperty.getName() + "\"><img src=\"" + componentEditorUrl + "/images/calendar.gif\" border=\"0\"/></a>");
                    sb.append("\t\t\t<script type=\"text/javascript\">");
                    sb.append("\t\t\t\tCalendar.setup({");
                    sb.append("\t        \t\tinputField     :    \"" + componentProperty.getName() + "\",");
                    sb.append("\t        \t\tifFormat       :    \"%Y-%m-%d %H:%M\",");
                    sb.append("\t        \t\tbutton         :    \"calendar_" + componentProperty.getName() + "\",");
                    sb.append("\t        \t\talign          :    \"BR\",");
                    sb.append("\t        \t\tsingleClick    :    true,");
                    sb.append("\t        \t\tfirstDay  \t   : \t1,");
                    sb.append("\t        \t\tshowsTime\t   :    true,");
                    sb.append("\t        \t\ttimeFormat     :    \"24\"");
                    sb.append("\t\t\t\t});");
                    sb.append("\t\t\t</script>");
                } else {
                    sb.append("\t" + componentProperty.getValue());
                }
                sb.append("\t\t\t</div>");
                if (hasAccessToProperty) {
                    sb.append("\t<div class=\"actionGroup\">");
                    sb.append("\t\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&amp;languageId=" + languageId + "&amp;contentId=" + contentId + "&amp;componentId=" + componentId + "&amp;propertyName=" + componentProperty.getName() + "&amp;showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                    sb.append("\t</div>");
                }
                sb.append("\t</div>");
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    ++propertyIndex;
                }
            } else if (componentProperty.getType().equalsIgnoreCase("textarea")) {
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\">");
                }
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t<label for=\"" + componentProperty.getName() + "\" onMouseOver=\"showDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\" onMouseOut=\"javascript:hideDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t</div>");
                sb.append("\t\t<div class=\"propertyRowRight\">");
                sb.append("\t\t\t<div class=\"fieldGroup\">");
                if (hasAccessToProperty) {
                    sb.append("\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "\"/>");
                    if (componentProperty.getIsWYSIWYGEnabled()) {
                        sb.append("\t<textarea toolbarName=\"" + componentProperty.getWYSIWYGToolbar() + "\" class=\"propertytextarea wysiwygeditor\" id=\"" + componentProperty.getName() + "\" name=\"" + componentProperty.getName() + "\" onkeydown=\"setDirty();\">" + (componentProperty.getValue() == null ? "" : componentProperty.getValue()) + "</textarea>");
                    } else {
                        sb.append("\t<textarea class=\"propertytextarea\" id=\"" + componentProperty.getName() + "\" name=\"" + componentProperty.getName() + "\" onkeydown=\"setDirty();\">" + (componentProperty.getValue() == null ? "" : componentProperty.getValue()) + "</textarea>");
                    }
                } else {
                    sb.append("\t" + componentProperty.getValue());
                }
                sb.append("\t\t\t</div>");
                if (hasAccessToProperty) {
                    sb.append("\t<div class=\"actionGroup\">");
                    sb.append("\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&amp;languageId=" + languageId + "&amp;contentId=" + contentId + "&amp;componentId=" + componentId + "&amp;propertyName=" + componentProperty.getName() + "&amp;showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                    sb.append("\t</div>");
                }
                sb.append("\t</div>");
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    ++propertyIndex;
                }
            } else if (componentProperty.getType().equalsIgnoreCase("select")) {
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\">");
                }
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t<label for=\"" + componentProperty.getName() + "\" onMouseOver=\"showDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\" onMouseOut=\"javascript:hideDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t</div>");
                sb.append("\t\t<div class=\"propertyRowRight\">");
                sb.append("\t\t\t<div class=\"fieldGroup\">");
                if (hasAccessToProperty) {
                    sb.append("\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "\">");
                    sb.append("\t<select class=\"propertyselect\" name=\"" + componentProperty.getName() + "\" onchange=\"setDirty();\">");
                    Iterator<Object> optionsIterator = componentProperty.getOptions().iterator();
                    if (componentProperty.getDataProvider() != null && !componentProperty.getDataProvider().equals("")) {
                        try {
                            PropertyOptionsDataProvider provider = (PropertyOptionsDataProvider)Class.forName(componentProperty.getDataProvider()).newInstance();
                            Map parameters = httpHelper.toMap(componentProperty.getDataProviderParameters(), "UTF-8");
                            optionsIterator = provider.getPropertyOptions(parameters, principal, db).iterator();
                        }
                        catch (Exception e) {
                            logger.warn((Object)("A problem loading the data provider for property " + componentProperty.getName() + ":" + e.getMessage()), (Throwable)e);
                            ArrayList<ComponentPropertyOption> errorOptions = new ArrayList<ComponentPropertyOption>();
                            ComponentPropertyOption componentPropertyOption = new ComponentPropertyOption();
                            componentPropertyOption.setName("Error:" + e.getMessage());
                            componentPropertyOption.setValue("");
                            errorOptions.add(componentPropertyOption);
                            optionsIterator = errorOptions.iterator();
                        }
                    }
                    while (optionsIterator.hasNext()) {
                        ComponentPropertyOption option = (ComponentPropertyOption)optionsIterator.next();
                        boolean isSame = false;
                        if (componentProperty != null && componentProperty.getValue() != null && option != null && option.getValue() != null) {
                            isSame = componentProperty.getValue().equals(option.getValue());
                        }
                        sb.append("<option value=\"" + option.getValue() + "\"" + (isSame ? " selected=\"1\"" : "") + ">" + option.getName() + "</option>");
                    }
                    sb.append("\t</select>");
                } else {
                    sb.append("\t" + componentProperty.getName());
                }
                sb.append("\t\t</div>");
                if (hasAccessToProperty) {
                    sb.append("\t<div class=\"actionGroup\">");
                    sb.append("\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&amp;languageId=" + languageId + "&amp;contentId=" + contentId + "&amp;componentId=" + componentId + "&amp;propertyName=" + componentProperty.getName() + "&amp;showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                    sb.append("\t</div>");
                }
                sb.append("\t</div>");
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    ++propertyIndex;
                }
            } else if (componentProperty.getType().equalsIgnoreCase("checkbox")) {
                if (isAdvancedProperties) {
                    sb.append("\t<div class=\"propertyRow advancedProperty" + componentId + "\" style='display:none;'>");
                } else {
                    sb.append("\t<div class=\"propertyRow\">");
                }
                sb.append("\t\t<div class=\"propertyRowLeft\">");
                sb.append("\t\t<label for=\"" + componentProperty.getName() + "\" onMouseOver=\"showDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\" onMouseOut=\"javascript:hideDiv('helpLayer" + componentProperty.getComponentId() + "_" + componentProperty.getName() + "');\">" + componentProperty.getDisplayName() + "</label>");
                sb.append("\t\t</div>");
                sb.append("\t\t<div class=\"propertyRowRight\">");
                sb.append("\t\t\t<div class=\"fieldGroup\">");
                if (hasAccessToProperty) {
                    sb.append("\t\t<input type=\"hidden\" name=\"" + propertyIndex + "_propertyName\" value=\"" + componentProperty.getName() + "\">");
                    int numberOfCheckboxes = 0;
                    for (ComponentPropertyOption option : componentProperty.getOptions()) {
                        boolean isSame = false;
                        if (componentProperty != null && componentProperty.getValue() != null && option != null && option.getValue() != null) {
                            String[] values = componentProperty.getValue().split(",");
                            int i = 0;
                            while (i < values.length) {
                                isSame = values[i].equals(option.getValue());
                                if (isSame) break;
                                ++i;
                            }
                        }
                        sb.append("<input type=\"checkbox\" style=\"width: 20px; border: 0px;\" name=\"" + componentProperty.getName() + "\" value=\"" + option.getValue() + "\"" + (isSame ? " checked=\"1\"" : "") + " onclicked=\"setDirty();\"/>" + option.getName() + " ");
                        if (++numberOfCheckboxes != 2) continue;
                        numberOfCheckboxes = 0;
                    }
                } else {
                    sb.append("\t" + componentProperty.getName());
                }
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    sb.append("\t<div class=\"actionGroup\">");
                    sb.append("\t<a class=\"componentEditorLink\" href=\"" + componentEditorUrl + "ViewSiteNodePageComponents!deleteComponentPropertyValue.action?siteNodeId=" + siteNodeId + "&amp;languageId=" + languageId + "&amp;contentId=" + contentId + "&amp;componentId=" + componentId + "&amp;propertyName=" + componentProperty.getName() + "&amp;showSimple=" + showSimple + "\"><img src=\"" + componentEditorUrl + "/images/delete.gif\" border=\"0\"/></a>");
                    sb.append("\t</div>");
                }
                sb.append("\t</div>");
                sb.append("\t</div>");
                if (hasAccessToProperty) {
                    ++propertyIndex;
                }
            }
            sb.append("\t<div style=\"clear:both;\"></div>");
        }
        if (numberOfHiddenProperties > 0) {
            sb.append("\t\t<div class=\"buttonRow\" style=\"margin-bottom: 10px; padding-left: 2px; color: darkred;\">" + this.getLocalizedString(locale, "deliver.editOnSight.protectedPropertiesExists") + "</div>");
        }
        sb.append("\t\t<div class=\"buttonRow\">");
        sb.append("\t\t\t<input type=\"image\" style=\"width: 50px; height: 25px; border: 0px;\" src=\"" + componentEditorUrl + this.getLocalizedString(locale, "images.contenttool.buttons.save") + "\" width=\"50\" height=\"25\" border=\"0\"/>");
        sb.append("\t\t\t<a href=\"javascript:clearComponentPropertiesInDiv('" + targetDiv + "');\"><img src=\"" + componentEditorUrl + this.getLocalizedString(locale, "images.contenttool.buttons.close") + "\" width=\"50\" height=\"25\" border=\"0\"/></a>");
        sb.append("\t\t</div>");
        sb.append("\t\t</fieldset>");
        sb.append("\t\t<input type=\"hidden\" name=\"repositoryId\" value=\"" + repositoryId + "\"/>");
        sb.append("\t\t<input type=\"hidden\" name=\"siteNodeId\" value=\"" + siteNodeId + "\"/>");
        sb.append("\t\t<input type=\"hidden\" name=\"languageId\" value=\"" + languageId + "\"/>");
        sb.append("\t\t<input type=\"hidden\" name=\"contentId\" value=\"" + contentId + "\"/>");
        sb.append("\t\t<input type=\"hidden\" name=\"componentId\" value=\"" + componentId + "\"/>");
        sb.append("\t\t<input type=\"hidden\" name=\"showSimple\" value=\"" + showSimple + "\"/>");
        sb.append("\t\t</form>");
        sb.append("\t</div>");
        sb.append("\t</div>");
        return sb.toString();
    }

    public String getComponentTasksDiv(Database db, InfoGluePrincipal principal, HttpServletRequest request, Locale locale, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, Integer componentId, Integer componentContentId, String slotName, String slotId, String showSimple, String originalFullURL, String showLegend, String targetDiv, String slotClicked, boolean treeItem) throws Exception {
        StringBuffer sb = new StringBuffer();
        String componentEditorUrl = CmsPropertyHandler.getComponentEditorUrl();
        String componentRendererUrl = CmsPropertyHandler.getComponentRendererUrl();
        ContentVO metaInfoContentVO = this.getPageMetaInfoContentVO(db, siteNodeId, languageId, contentId, principal);
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId);
        String pageComponentsString = this.getPageComponentsString(db, siteNodeId, languageId, contentId, principal);
        if (pageComponentsString != null && pageComponentsString.length() != 0) {
            boolean hasSaveTemplateAccess;
            Document document = domBuilder.getDocument(pageComponentsString);
            List pageComponents = this.getPageComponents(db, pageComponentsString, document.getRootElement(), "base", null, null, siteNodeId, languageId, principal);
            InfoGlueComponent component = (InfoGlueComponent)pageComponents.get(0);
            if (!component.getId().equals(componentId)) {
                component = this.getComponentWithId(component, componentId);
            }
            boolean hasAccessToAccessRights = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.ChangeSlotAccess", "");
            boolean hasAccessToAddComponent = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.AddComponent", (component.getParentComponent() == null ? component.getContentId() : component.getParentComponent().getContentId()) + "_" + component.getSlotName());
            boolean hasAccessToDeleteComponent = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.DeleteComponent", (component.getParentComponent() == null ? component.getContentId() : component.getParentComponent().getContentId()) + "_" + component.getSlotName());
            boolean hasAccessToChangeComponent = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.ChangeComponent", (component.getParentComponent() == null ? component.getContentId() : component.getParentComponent().getContentId()) + "_" + component.getSlotName());
            boolean hasSavePagePartTemplateAccess = hasSaveTemplateAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "StructureTool.SaveTemplate", "");
            if (slotClicked != null && slotClicked.equalsIgnoreCase("true")) {
                hasAccessToAddComponent = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.AddComponent", component.getContentId() + "_" + slotId);
            }
            boolean hasSubmitToPublishAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.SubmitToPublish", "");
            boolean hasPageStructureAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.PageStructure", "");
            boolean hasOpenInNewWindowAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.OpenInNewWindow", "");
            boolean hasViewSourceAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "ComponentEditor.ViewSource", "");
            boolean hasMaxComponents = false;
            if (component.getParentComponent() != null && component.getParentComponent().getSlotList() != null) {
                for (Slot slot : component.getParentComponent().getSlotList()) {
                    if (!slot.getId().equalsIgnoreCase(slotName) || slot.getAllowedNumberOfComponents() == -1 || slot.getComponents().size() < slot.getAllowedNumberOfComponents()) continue;
                    hasMaxComponents = true;
                }
            }
            if (component.getContainerSlot() != null && component.getContainerSlot().getDisableAccessControl()) {
                hasAccessToAddComponent = true;
                hasAccessToDeleteComponent = true;
            }
            if (hasMaxComponents) {
                hasAccessToAddComponent = false;
            }
            if (component.getIsInherited()) {
                StringBuffer sb2 = new StringBuffer();
                return sb2.toString();
            }
            sb.append("<div id=\"componentMenu\" class=\"skin0 editOnSightMenuDiv\">");
            Document componentTasksDocument = this.getComponentTasksDOM4JDocument(masterLanguageVO.getId(), metaInfoContentVO.getId(), db);
            List componentTasks = this.getComponentTasks(componentId, componentTasksDocument);
            boolean taskIndex = false;
            for (ComponentTask componentTask : componentTasks) {
                String view = componentTask.getView();
                boolean openInPopup = componentTask.getOpenInPopup();
                String icon = componentTask.getIcon();
                view = view.replaceAll("\\$componentEditorUrl", componentEditorUrl);
                view = view.replaceAll("\\$originalFullURL", originalFullURL);
                view = view.replaceAll("\\$componentRendererUrl", componentRendererUrl);
                view = view.replaceAll("\\$repositoryId", repositoryId.toString());
                view = view.replaceAll("\\$siteNodeId", siteNodeId.toString());
                view = view.replaceAll("\\$languageId", languageId.toString());
                view = view.replaceAll("\\$componentId", componentId.toString());
                sb.append("<div class=\"igmenuitems linkComponentTask\" " + (icon != null && !icon.equals("") ? "style=\"background-image:url(" + icon + ")\"" : "") + " onClick=\"executeTask('" + view + "', " + openInPopup + ");\"><a href='#'>" + componentTask.getName() + "</a></div>");
            }
            String editHTML = this.getLocalizedString(locale, "deliver.editOnSight.editHTML");
            String editInlineHTML = this.getLocalizedString(locale, "deliver.editOnSight.editContentInlineLabel");
            String submitToPublishHTML = this.getLocalizedString(locale, "deliver.editOnSight.submitToPublish");
            String addComponentHTML = this.getLocalizedString(locale, "deliver.editOnSight.addComponentHTML");
            String deleteComponentHTML = this.getLocalizedString(locale, "deliver.editOnSight.deleteComponentHTML");
            String changeComponentHTML = this.getLocalizedString(locale, "deliver.editOnSight.changeComponentHTML");
            String moveComponentUpHTML = this.getLocalizedString(locale, "deliver.editOnSight.moveComponentUpHTML");
            String moveComponentDownHTML = this.getLocalizedString(locale, "deliver.editOnSight.moveComponentDownHTML");
            String propertiesHTML = this.getLocalizedString(locale, "deliver.editOnSight.propertiesHTML");
            String accessRightsHTML = this.getLocalizedString(locale, "deliver.editOnSight.accessRightsHTML");
            String pageComponentsHTML = this.getLocalizedString(locale, "deliver.editOnSight.pageComponentsHTML");
            String viewSourceHTML = this.getLocalizedString(locale, "deliver.editOnSight.viewSourceHTML");
            String componentEditorInNewWindowHTML = this.getLocalizedString(locale, "deliver.editOnSight.componentEditorInNewWindowHTML");
            String savePageTemplateHTML = this.getLocalizedString(locale, "deliver.editOnSight.savePageTemplateHTML");
            String savePagePartTemplateHTML = this.getLocalizedString(locale, "deliver.editOnSight.savePagePartTemplateHTML");
            Slot slot = null;
            InfoGlueComponent parentComponent = null;
            if (slotClicked == null || slotClicked.equalsIgnoreCase("true")) {
                slot = component.getSlot(slotId);
                parentComponent = component;
            } else {
                slot = component.getContainerSlot();
                parentComponent = component.getParentComponent();
            }
            String allowedComponentNamesAsEncodedString = "";
            String disallowedComponentNamesAsEncodedString = "";
            if (slot != null) {
                allowedComponentNamesAsEncodedString = slot.getAllowedComponentsArrayAsUrlEncodedString();
                disallowedComponentNamesAsEncodedString = slot.getDisallowedComponentsArrayAsUrlEncodedString();
            }
            String addComponentUrl = "";
            String deleteComponentUrl = "";
            String changeComponentUrl = "";
            String savePartTemplateUrl = "";
            if (parentComponent != null) {
                addComponentUrl = componentEditorUrl + "ViewSiteNodePageComponents!listComponents.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&parentComponentId=" + parentComponent.getId() + "&slotId=" + slotId + "&showSimple=" + showSimple + (allowedComponentNamesAsEncodedString != null ? "&" + allowedComponentNamesAsEncodedString : "") + (disallowedComponentNamesAsEncodedString != null ? "&" + disallowedComponentNamesAsEncodedString : "");
                deleteComponentUrl = componentEditorUrl + "ViewSiteNodePageComponents!deleteComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&slotId=" + slotId + "&showSimple=" + showSimple;
                changeComponentUrl = componentEditorUrl + "ViewSiteNodePageComponents!listComponentsForChange.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&slotId=" + slotId + "&showSimple=" + showSimple + (allowedComponentNamesAsEncodedString != null ? "&" + allowedComponentNamesAsEncodedString : "") + (disallowedComponentNamesAsEncodedString != null ? "&" + disallowedComponentNamesAsEncodedString : "");
                savePartTemplateUrl = "savePartComponentStructure('" + componentEditorUrl + "CreatePageTemplate!input.action?contentId=" + metaInfoContentVO.getId() + "', '" + component.getId() + "');";
            } else {
                addComponentUrl = "";
                deleteComponentUrl = componentEditorUrl + "ViewSiteNodePageComponents!deleteComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&slotId=" + slotId + "&showSimple=" + showSimple;
                changeComponentUrl = componentEditorUrl + "ViewSiteNodePageComponents!listComponentsForChange.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&slotId=" + slotId + "&showSimple=" + showSimple + (allowedComponentNamesAsEncodedString != null ? "&" + allowedComponentNamesAsEncodedString : "") + (disallowedComponentNamesAsEncodedString != null ? "&" + disallowedComponentNamesAsEncodedString : "");
                savePartTemplateUrl = "";
                hasAccessToAddComponent = false;
                hasSavePagePartTemplateAccess = false;
            }
            if (!treeItem) {
                sb.append("<div id=\"editDiv\" class=\"igmenuitems linkEditArticle\"><a href='#'>" + editHTML + "</a></div>");
            }
            if (!treeItem) {
                sb.append("<div id=\"editInlineDiv\" class=\"igmenuitems linkEditArticle\"><a href='#'>" + editInlineHTML + "</a></div>");
            }
            if (!treeItem && hasSubmitToPublishAccess) {
                sb.append("<div class=\"igmenuitems linkPublish\" onClick=\"submitToPublish(" + siteNodeId + ", " + repositoryId + ", '" + URLEncoder.encode(originalFullURL, "UTF-8") + "');\"><a href='#'>" + submitToPublishHTML + "</a></div>");
            }
            if (hasAccessToAddComponent) {
                sb.append("<div class=\"igmenuitems linkAddComponent\" onClick=\"insertComponentByUrl('" + addComponentUrl + "');\"><a href='#'>" + addComponentHTML + "</a></div>");
            }
            if (hasAccessToDeleteComponent) {
                sb.append("<div class=\"igmenuitems linkDeleteComponent\" onClick=\"deleteComponentByUrl('" + deleteComponentUrl + "');\"><a href='#'>" + deleteComponentHTML + "</a></div>");
            }
            if (hasAccessToChangeComponent) {
                sb.append("<div class=\"igmenuitems linkChangeComponent\" onClick=\"changeComponentByUrl('" + changeComponentUrl + "');\"><a href='#'>" + changeComponentHTML + "</a></div>");
            }
            if (hasSaveTemplateAccess) {
                sb.append("<div class=\"igmenuitems linkCreatePageTemplate\" onClick=\"saveComponentStructure('" + componentEditorUrl + "CreatePageTemplate!input.action?contentId=" + metaInfoContentVO.getId() + "');\"><a href='#'>" + savePageTemplateHTML + "</a></div>");
            }
            if (hasSavePagePartTemplateAccess) {
                sb.append("<div class=\"igmenuitems linkCreatePageTemplate\" onClick=\"" + savePartTemplateUrl + "\"><a href='#'>" + savePagePartTemplateHTML + "</a></div>");
            }
            String upUrl = String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!moveComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&direction=0&showSimple=" + showSimple;
            String downUrl = String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!moveComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&direction=1&showSimple=" + showSimple;
            if (component.getPositionInSlot() > 0) {
                sb.append("<div class=\"igmenuitems linkMoveComponentUp\" onClick=\"invokeAddress('" + upUrl + "');\"><a href='#'>" + moveComponentUpHTML + "</a></div>");
            }
            if (component.getContainerSlot() != null && component.getContainerSlot().getComponents().size() - 1 > component.getPositionInSlot()) {
                sb.append("<div class=\"igmenuitems linkMoveComponentDown\" onClick=\"invokeAddress('" + downUrl + "');\"><a href='#'>" + moveComponentDownHTML + "</a></div>");
            }
            if (hasAccessToAccessRights) {
                sb.append("<div class=\"igmenuitems linkAccessRights\" onClick=\"setAccessRights('" + slotId + "', " + componentContentId + ");\"><a href='#'>" + accessRightsHTML + "</a></div>");
            }
            sb.append("<div style='border-top: 1px solid #bbb; height: 1px; margin: 0px; padding: 0px; line-height: 1px;'></div>");
            sb.append("<div class=\"igmenuitems linkComponentProperties\" onClick=\"showComponentInDiv('componentPropertiesDiv', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&componentContentId=" + componentContentId + "&slotName=" + component.getSlotName() + "&showSimple=" + showSimple + "&showLegend=false&originalUrl=" + URLEncoder.encode(originalFullURL, "UTF-8") + "', false);\"><a href='#'>" + propertiesHTML + "</a></div>");
            if (hasPageStructureAccess || hasOpenInNewWindowAccess || hasViewSourceAccess) {
                sb.append("<div style='border-top: 1px solid #bbb; height: 1px; margin:0px; padding: 0px; line-height: 1px;'></div>");
            }
            if (!treeItem && hasPageStructureAccess) {
                sb.append("<div class=\"igmenuitems linkPageComponents\" onClick=\"showComponentStructure('componentStructure', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&originalUrl=" + URLEncoder.encode(originalFullURL, "UTF-8") + "', event);\"><a href='#'>" + pageComponentsHTML + "</a></div>");
            }
            if (hasOpenInNewWindowAccess) {
                sb.append("<div id=\"componentEditorInNewWindowDiv\" class=\"igmenuitems linkOpenInNewWindow\"  onClick=\"window.open(document.location.href,'PageComponents','');\"><a href='#'>" + componentEditorInNewWindowHTML + "</a></div>");
            }
            if (hasViewSourceAccess) {
                sb.append("<div class=\"igmenuitems linkViewSource\" onClick=\"javascript:viewSource();\"><a href='javascript:viewSource();'>" + viewSourceHTML + "</a></div>");
            }
            sb.append("</div>");
        }
        return sb.toString();
    }

    public String getComponentStructureDiv(Database db, InfoGluePrincipal principal, HttpServletRequest request, Locale locale, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, String showSimple, String originalFullURL, String showLegend, String targetDiv) throws Exception {
        StringBuffer sb = new StringBuffer();
        String contextPath = request.getContextPath();
        ContentVO metaInfoContentVO = this.getPageMetaInfoContentVO(db, siteNodeId, languageId, contentId, principal);
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId);
        String pageComponentsString = this.getPageComponentsString(db, siteNodeId, languageId, contentId, principal);
        if (pageComponentsString != null && pageComponentsString.length() != 0) {
            Document document = domBuilder.getDocument(pageComponentsString);
            List pageComponents = this.getPageComponents(db, pageComponentsString, document.getRootElement(), "base", null, null, siteNodeId, languageId, principal);
            InfoGlueComponent component = (InfoGlueComponent)pageComponents.get(0);
            sb.append("<div id=\"pageComponents\" style=\"left:0px; top:0px; width: 450px; height: 500px;\">");
            sb.append("\t <div id=\"dragCorner\" style=\"position: absolute; width: 16px; height: 16px; background-color: white; bottom: 0px; right: 0px;\"><a href=\"javascript:expandWindow('pageComponents');\"><img src=\"" + contextPath + "/images/enlarge.gif\" border=\"0\" width=\"16\" height=\"16\"></a></div>");
            sb.append("\t <div id=\"pageComponentsHandle\" class=\"componentPropertiesHandle\"><div id=\"leftHandleNarrow\">Page components</div><div id=\"rightPaletteHandle\"><a href=\"javascript:hideDiv('pageComponents');\" class=\"white\"><img src=\"" + contextPath + "/images/closeIcon.gif\" border=\"0\"/></a></div></div>");
            sb.append("\t <div id=\"pageComponentsBody\" class=\"componentPropertiesBody\" style=\"height: 480px;\"><table class=\"igtable\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
            sb.append("\t <tr class=\"igtr\">");
            sb.append("\t\t<td class=\"igtd\" colspan=\"20\"><img src=\"" + contextPath + "/images/tcross.png\" width=\"19\" height=\"16\"><span id=\"" + component.getId() + component.getSlotName() + "ClickableDiv\" class=\"iglabel\"><img src=\"" + contextPath + "/images/slotIcon.gif\" width=\"16\" height=\"16\"><img src=\"" + contextPath + "/images/trans.gif\" width=\"5\" height=\"1\">" + component.getName() + "</span><script type=\"text/javascript\">initializeSlotEventHandler('" + component.getId() + component.getSlotName() + "ClickableDiv', '" + contextPath + "ViewSiteNodePageComponents!listComponents.action?CCC=1&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&parentComponentId=" + component.getId() + "&slotId=base&showSimple=" + showSimple + "', '', '', 'base', '" + component.getContentId() + "');</script></td>");
            sb.append("\t </tr>");
            this.renderComponentTree(db, sb, component, 0, 0, 1, contextPath, repositoryId, siteNodeId, languageId, contentId, showSimple, originalFullURL);
            sb.append("\t <tr class=\"igtr\">");
            int i = 0;
            while (i < 20) {
                sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/trans.gif\" width=\"19\" height=\"1\"></td>");
                ++i;
            }
            sb.append("\t </tr>");
            sb.append("\t </table>");
            sb.append("\t </div>");
            sb.append("</div>");
        }
        return sb.toString();
    }

    private void renderComponentTree(Database db, StringBuffer sb, InfoGlueComponent component, int level, int position, int maxPosition, String contextPath, Integer repositoryId, Integer siteNodeId, Integer languageId, Integer contentId, String showSimple, String originalUrl) throws Exception {
        String componentEditorUrl = CmsPropertyHandler.getComponentEditorUrl();
        ContentVO componentContentVO = ContentController.getContentController().getContentVOWithId(component.getContentId(), db);
        int colspan = 20 - level;
        sb.append("\t\t<tr class=\"igtr\">");
        sb.append("\t\t\t<td class=\"igtd\"><img src=\"" + contextPath + "/images/trans.gif\" width=\"19\" height=\"16\"></td>");
        int i = 0;
        while (i < level) {
            sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/vline.png\" width=\"19\" height=\"16\"></td>");
            ++i;
        }
        String tasks = "";
        tasks = component.getPagePartTemplateComponent() != null ? "showComponentTasks('componentTasks', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getPagePartTemplateComponent().getId() + "&componentContentId=" + component.getPagePartTemplateComponent().getContentId() + "&slotId=" + component.getPagePartTemplateComponent().getContainerSlot().getId() + "&showSimple=false&showLegend=false&slotClicked=false&treeItem=true&originalUrl=" + URLEncoder.encode(originalUrl, "UTF-8") + "', false, event);" : (component.getContainerSlot() != null ? "showComponentTasks('componentTasks', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&componentContentId=" + component.getContentId() + "&slotId=" + component.getContainerSlot().getId() + "&showSimple=false&showLegend=false&slotClicked=false&treeItem=true&originalUrl=" + URLEncoder.encode(originalUrl, "UTF-8") + "', false, event);" : "showComponentTasks('componentTasks', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&componentContentId=" + component.getContentId() + "&slotId=-1&showSimple=false&showLegend=false&slotClicked=false&treeItem=true&originalUrl=" + URLEncoder.encode(originalUrl, "UTF-8") + "', false, event);");
        sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/tcross.png\" width=\"19\" height=\"16\"></td><td class=\"igtd\"><img src=\"" + contextPath + "/images/componentIcon.gif\" width=\"16\" height=\"16\"></td><td class=\"igtd\" colspan=\"" + (colspan - 2) + "\"><span id=\"" + component.getId() + "\" onclick=\"" + tasks + "\" oncontextmenu=\"hideDiv('pageComponents');\">" + componentContentVO.getName() + "</span>");
        String upUrl = String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!moveComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&direction=0&showSimple=" + showSimple;
        String downUrl = String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!moveComponent.action?siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&direction=1&showSimple=" + showSimple;
        if (position > 0) {
            sb.append("<a href=\"" + upUrl + "\"><img src=\"" + contextPath + "/images/upArrow.gif\" border=\"0\" width=\"11\" width=\"10\"></a>");
        }
        if (maxPosition > position) {
            sb.append("<a href=\"" + downUrl + "\"><img src=\"" + contextPath + "/images/downArrow.gif\" border=\"0\" width=\"11\" width=\"10\"></a>");
        }
        sb.append("</td>");
        sb.append("\t\t</tr>");
        for (Slot slot : component.getSlotList()) {
            sb.append("\t\t<tr class=\"igtr\">");
            sb.append("\t\t\t<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/trans.gif\" width=\"19\" height=\"16\"></td><td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/vline.png\" width=\"19\" height=\"16\"></td>");
            int i2 = 0;
            while (i2 < level) {
                sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/vline.png\" width=\"19\" height=\"16\"></td>");
                ++i2;
            }
            if (slot.getComponents().size() > 0) {
                sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/tcross.png\" width=\"19\" height=\"16\"></td><td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/slotIcon.gif\" width=\"16\" height=\"16\"></td>");
            } else {
                sb.append("<td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/endline.png\" width=\"19\" height=\"16\"></td><td class=\"igtd\" width=\"19\"><img src=\"" + contextPath + "/images/slotIcon.gif\" width=\"16\" height=\"16\"></td>");
            }
            String allowedComponentNamesAsEncodedString = slot.getAllowedComponentsArrayAsUrlEncodedString();
            String disallowedComponentNamesAsEncodedString = slot.getDisallowedComponentsArrayAsUrlEncodedString();
            String slotTasks = "showComponentTasks('componentTasks', 'repositoryId=" + repositoryId + "&siteNodeId=" + siteNodeId + "&languageId=" + languageId + "&contentId=" + contentId + "&componentId=" + component.getId() + "&componentContentId=" + component.getContentId() + "&slotId=" + slot.getId() + "&showSimple=false&showLegend=false&slotClicked=true&treeItem=true&originalUrl=" + URLEncoder.encode(originalUrl, "UTF-8") + "', false, event);";
            sb.append("<td class=\"igtd\" colspan=\"" + (colspan - 4) + "\"><span id=\"" + slot.getId() + "ClickableDiv\" class=\"iglabel\" onclick=\"" + slotTasks + "\" oncontextmenu=\"hideDiv('pageComponents');\">" + slot.getId() + "</span></td>");
            sb.append("\t\t</tr>");
            List slotComponents = slot.getComponents();
            if (slotComponents == null) continue;
            Iterator slotComponentIterator = slotComponents.iterator();
            int newPosition = 0;
            while (slotComponentIterator.hasNext()) {
                InfoGlueComponent slotComponent = (InfoGlueComponent)slotComponentIterator.next();
                ContentVO componentContent = ContentController.getContentController().getContentVOWithId(slotComponent.getContentId(), db);
                String imageUrl = contextPath + "/images/componentIcon.gif";
                this.renderComponentTree(db, sb, slotComponent, level + 2, newPosition, slotComponents.size() - 1, contextPath, repositoryId, siteNodeId, languageId, contentId, showSimple, originalUrl);
                ++newPosition;
            }
        }
    }

    public List getComponentContents(Database db) throws Exception {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("method", "selectListOnContentTypeName");
        ArrayList argumentList = new ArrayList();
        HashMap<String, String> argument = new HashMap<String, String>();
        argument.put("contentTypeDefinitionName", "HTMLTemplate");
        argumentList.add(argument);
        arguments.put("arguments", argumentList);
        return ContentController.getContentController().getContentVOList(arguments, db);
    }

    private List getComponentProperties(Integer componentId, Document document, Integer siteNodeId, Integer languageId, Integer contentId, Locale locale, Database db, InfoGluePrincipal principal) throws Exception {
        ArrayList<ComponentProperty> componentProperties = new ArrayList<ComponentProperty>();
        Timer timer = new Timer();
        timer.setActive(false);
        try {
            if (document != null) {
                timer.printElapsedTime("Read document");
                String propertyXPath = "//property";
                List anl = document.selectNodes(propertyXPath);
                timer.printElapsedTime("Set property xpath");
                for (Element binding : anl) {
                    ComponentPropertyOption cpo;
                    String optionValue;
                    String optionName;
                    String value;
                    String name = binding.attributeValue("name");
                    String displayName = binding.attributeValue("displayName");
                    String description = binding.attributeValue("description");
                    String defaultValue = binding.attributeValue("defaultValue");
                    String dataProvider = binding.attributeValue("dataProvider");
                    String dataProviderParameters = binding.attributeValue("dataProviderParameters");
                    String type = binding.attributeValue("type");
                    String allowedContentTypeNamesString = binding.attributeValue("allowedContentTypeDefinitionNames");
                    String visualizingAction = binding.attributeValue("visualizingAction");
                    String createAction = binding.attributeValue("createAction");
                    ComponentProperty property = new ComponentProperty();
                    property.setComponentId(componentId);
                    property.setName(name);
                    property.setDisplayName(displayName);
                    property.setDescription(description);
                    property.setDefaultValue(defaultValue);
                    property.setDataProvider(dataProvider);
                    property.setDataProviderParameters(dataProviderParameters);
                    property.setType(type);
                    property.setVisualizingAction(visualizingAction);
                    property.setCreateAction(createAction);
                    if (allowedContentTypeNamesString != null && allowedContentTypeNamesString.length() > 0) {
                        String[] allowedContentTypeNamesArray = allowedContentTypeNamesString.split(",");
                        property.setAllowedContentTypeNamesArray(allowedContentTypeNamesArray);
                    }
                    if (type.equalsIgnoreCase("binding")) {
                        String entity = binding.attributeValue("entity");
                        boolean isMultipleBinding = new Boolean(binding.attributeValue("multiple"));
                        boolean isAssetBinding = new Boolean(binding.attributeValue("assetBinding"));
                        boolean isPuffContentForPage = new Boolean(binding.attributeValue("isPuffContentForPage"));
                        property.setEntityClass(entity);
                        String value2 = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        property.setValue(value2);
                        property.setIsMultipleBinding(isMultipleBinding);
                        property.setIsAssetBinding(isAssetBinding);
                        property.setIsPuffContentForPage(isPuffContentForPage);
                        List<ComponentBinding> bindings = this.getComponentPropertyBindings(componentId, name, siteNodeId, languageId, contentId, locale, db, principal);
                        property.setBindings(bindings);
                    } else if (type.equalsIgnoreCase("textfield")) {
                        value = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        timer.printElapsedTime("Set property2");
                        property.setValue(value);
                    } else if (type.equalsIgnoreCase("datefield")) {
                        value = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        timer.printElapsedTime("Set property2");
                        property.setValue(value);
                    } else if (type.equalsIgnoreCase("customfield")) {
                        value = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        String customMarkup = binding.attributeValue("customMarkup");
                        String processedMarkup = customMarkup.replaceAll("propertyName", name);
                        processedMarkup = processedMarkup.replaceAll("propertyValue", value);
                        property.setCustomMarkup(processedMarkup);
                        property.setValue(value);
                    } else if (type.equalsIgnoreCase("textarea")) {
                        boolean WYSIWYGEnabled = new Boolean(binding.attributeValue("WYSIWYGEnabled"));
                        property.setWYSIWYGEnabled(WYSIWYGEnabled);
                        String WYSIWYGToolbar = binding.attributeValue("WYSIWYGToolbar");
                        property.setWYSIWYGToolbar(WYSIWYGToolbar);
                        String value3 = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        timer.printElapsedTime("Set property2");
                        property.setValue(value3);
                    } else if (type.equalsIgnoreCase("select")) {
                        value = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        timer.printElapsedTime("Set property2");
                        List optionList = binding.elements("option");
                        for (Element option : optionList) {
                            optionName = option.attributeValue("name");
                            optionValue = option.attributeValue("value");
                            cpo = new ComponentPropertyOption();
                            cpo.setName(optionName);
                            cpo.setValue(optionValue);
                            property.getOptions().add(cpo);
                        }
                        property.setValue(value);
                    } else if (type.equalsIgnoreCase("checkbox")) {
                        value = this.getComponentPropertyValue(componentId, name, siteNodeId, languageId, contentId, locale, db, principal, property);
                        timer.printElapsedTime("Set property3");
                        List optionList = binding.elements("option");
                        for (Element option : optionList) {
                            optionName = option.attributeValue("name");
                            optionValue = option.attributeValue("value");
                            cpo = new ComponentPropertyOption();
                            cpo.setName(optionName);
                            cpo.setValue(optionValue);
                            property.getOptions().add(cpo);
                        }
                        property.setValue(value);
                    }
                    componentProperties.add(property);
                }
            }
            this.addSystemProperties(componentProperties, componentId, siteNodeId, languageId, contentId, locale, db, principal);
        }
        catch (Exception e) {
            logger.warn((Object)("The component with id " + componentId + " had a incorrect xml defining it's properties:" + e.getMessage()), (Throwable)e);
        }
        return componentProperties;
    }

    private String getComponentPropertyValue(Integer componentId, String name, Integer siteNodeId, Integer languageId, Integer contentId, Locale locale, Database db, InfoGluePrincipal principal, ComponentProperty componentProperty) throws Exception {
        String value = componentProperty.getDefaultValue();
        Timer timer = new Timer();
        timer.setActive(false);
        Document document = this.getPageComponentsDOM4JDocument(db, siteNodeId, languageId, contentId, principal);
        String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']";
        List anl = document.selectNodes(componentXPath);
        for (Element property : anl) {
            String id = property.attributeValue("type");
            String path = property.attributeValue("path");
            if (property.attribute("path_" + locale.getLanguage()) != null) {
                path = property.attributeValue("path_" + locale.getLanguage());
            }
            if ((value = path) == null) continue;
            value = value.replaceAll("igbr", this.separator);
        }
        return value;
    }

    public String getLocalizedString(Locale locale, String key) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key);
    }

    private List<ComponentBinding> getComponentPropertyBindings(Integer componentId, String name, Integer siteNodeId, Integer languageId, Integer contentId, Locale locale, Database db, InfoGluePrincipal principal) throws Exception {
        ArrayList<ComponentBinding> componentBindings = new ArrayList<ComponentBinding>();
        Document document = this.getPageComponentsDOM4JDocument(db, siteNodeId, languageId, contentId, principal);
        String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']/binding";
        List anl = document.selectNodes(componentXPath);
        for (Element property : anl) {
            String entity = property.attributeValue("entity");
            String entityId = property.attributeValue("entityId");
            String assetKey = property.attributeValue("assetKey");
            ComponentBinding componentBinding = new ComponentBinding();
            componentBinding.setEntityClass(entity);
            componentBinding.setEntityId(new Integer(entityId));
            componentBinding.setAssetKey(assetKey);
            componentBindings.add(componentBinding);
        }
        return componentBindings;
    }

    protected Document getPageComponentsDOM4JDocument(Database db, Integer siteNodeId, Integer languageId, Integer contentId, InfoGluePrincipal principal) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "pageComponentDocument_" + siteNodeId + "_" + languageId + "_" + contentId;
        Document cachedPageComponentsDocument = (Document)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedPageComponentsDocument != null) {
            return cachedPageComponentsDocument;
        }
        Document pageComponentsDocument = null;
        try {
            String xml = this.getPageComponentsString(db, siteNodeId, languageId, contentId, principal);
            pageComponentsDocument = domBuilder.getDocument(xml);
            CacheController.cacheObject(cacheName, cacheKey, pageComponentsDocument);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return pageComponentsDocument;
    }

    protected ContentVO getPageMetaInfoContentVO(Database db, Integer siteNodeId, Integer languageId, Integer contentId, InfoGluePrincipal principal) throws SystemException, Exception {
        SiteNodeController.getController();
        SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
        ContentVO contentVO = null;
        contentVO = siteNodeVO.getMetaInfoContentId() != null && siteNodeVO.getMetaInfoContentId() > -1 ? ContentController.getContentController().getContentVOWithId(siteNodeVO.getMetaInfoContentId(), db) : NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(db, principal, siteNodeId, languageId, true, "Meta information", null);
        if (contentVO == null) {
            throw new SystemException("There was no Meta Information bound to this page which makes it impossible to render.");
        }
        return contentVO;
    }

    protected String getPageComponentsString(Database db, Integer siteNodeId, Integer languageId, Integer contentId, InfoGluePrincipal principal) throws SystemException, Exception {
        SiteNodeController.getController();
        SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
        ContentVO contentVO = null;
        contentVO = siteNodeVO.getMetaInfoContentId() != null && siteNodeVO.getMetaInfoContentId() > -1 ? ContentController.getContentController().getContentVOWithId(siteNodeVO.getMetaInfoContentId(), db) : NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(db, principal, siteNodeId, languageId, true, "Meta information", null);
        if (contentVO == null) {
            throw new SystemException("There was no Meta Information bound to this page which makes it impossible to render.");
        }
        String cacheName = "componentEditorCache";
        String cacheKey = "pageComponentString_" + siteNodeId + "_" + languageId + "_" + contentId;
        String versionKey = String.valueOf(cacheKey) + "_contentVersionId";
        String attributeName = "ComponentStructure";
        String cachedPageComponentsString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        Set contentVersionId = (Set)CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", versionKey);
        if (cachedPageComponentsString != null) {
            return cachedPageComponentsString;
        }
        String pageComponentsString = null;
        Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId).getId();
        pageComponentsString = ContentController.getContentController().getContentAttribute(db, contentVO.getContentId(), masterLanguageId, "ComponentStructure");
        if (pageComponentsString == null) {
            throw new SystemException("There was no Meta Information bound to this page which makes it impossible to render.");
        }
        return pageComponentsString;
    }

    public Document getComponentPropertiesDOM4JDocument(Integer siteNodeId, Integer languageId, Integer contentId, Database db, InfoGluePrincipal principal) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "componentPropertiesDocument_" + siteNodeId + "_" + languageId + "_" + contentId;
        Document cachedComponentPropertiesDocument = (Document)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedComponentPropertiesDocument != null) {
            return cachedComponentPropertiesDocument;
        }
        Document componentPropertiesDocument = null;
        try {
            String xml = this.getComponentPropertiesString(siteNodeId, languageId, contentId, db, principal);
            if (xml != null && xml.length() > 0) {
                componentPropertiesDocument = domBuilder.getDocument(xml);
                CacheController.cacheObject(cacheName, cacheKey, componentPropertiesDocument);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return componentPropertiesDocument;
    }

    private String getComponentPropertiesString(Integer siteNodeId, Integer languageId, Integer contentId, Database db, InfoGluePrincipal principal) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "componentPropertiesString_" + siteNodeId + "_" + languageId + "_" + contentId;
        String cachedComponentPropertiesString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedComponentPropertiesString != null) {
            return cachedComponentPropertiesString;
        }
        String componentPropertiesString = null;
        try {
            Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId).getId();
            componentPropertiesString = ContentController.getContentController().getContentAttribute(db, contentId, masterLanguageId, "ComponentProperties", true);
            if (componentPropertiesString == null) {
                throw new SystemException("There was no properties assigned to this content.");
            }
            CacheController.cacheObject(cacheName, cacheKey, componentPropertiesString);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return componentPropertiesString;
    }

    private String getComponentTemplateString(Integer componentContentId, Integer languageId, Database db, InfoGluePrincipal principal) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "componentTemplateString_" + componentContentId + "_" + languageId;
        String cachedComponentPropertiesString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedComponentPropertiesString != null) {
            return cachedComponentPropertiesString;
        }
        String templateString = null;
        try {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(componentContentId, db);
            Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(contentVO.getRepositoryId(), db).getId();
            templateString = ContentController.getContentController().getContentAttribute(db, componentContentId, masterLanguageId, "Template", true);
            if (templateString == null) {
                throw new SystemException("There was no template on the content: " + componentContentId);
            }
            CacheController.cacheObject(cacheName, cacheKey, templateString);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return templateString;
    }

    public String getAvailableComponentsDiv(Database db, InfoGluePrincipal principal, Locale locale, Integer repositoryId, Integer languageId, Integer componentContentId, String slotName, String showLegend, String targetDiv) {
        StringBuffer sb = new StringBuffer();
        try {
            List<Slot> slots = this.getSlots(componentContentId, languageId, db, principal);
            Iterator<Slot> slotsIterator = slots.iterator();
            if (slotsIterator.hasNext()) {
                Slot slot = slotsIterator.next();
                if (slot.getId().equals(slotName)) {
                    // empty if block
                }
                String direction = "asc";
                List componentVOList = ComponentController.getController().getComponentVOList("name", direction, slot.getAllowedComponentsArray(), slot.getDisallowedComponentsArray(), db, principal);
                Iterator componentVOListIterator = componentVOList.iterator();
                sb.append("<fieldset>");
                sb.append("<legend>Drag component to slot</legend>");
                sb.append("<div id=\"availableComponents\">");
                int i = 0;
                while (componentVOListIterator.hasNext()) {
                    ContentVO componentContentVO = (ContentVO)componentVOListIterator.next();
                    if (repositoryId != null && !componentContentVO.getRepositoryId().equals(repositoryId)) continue;
                    String imageUrl = this.getDigitalAssetUrl(componentContentVO.getId(), "thumbnail", db);
                    if (imageUrl == null || imageUrl.length() == 0) {
                        imageUrl = "images/componentIcon.gif";
                    }
                    sb.append("<div id=\"componentRow\" name=\"" + componentContentVO.getId() + "\" class=\"dragable\">");
                    ++i;
                    sb.append("\t<div id=\"componentName\" style=\"padding-left: 22px; background-image: url('" + imageUrl + "'); background-repeat: no-repeat;\">" + componentContentVO.getName() + "</div>");
                    sb.append("</div>");
                }
                sb.append("</fieldset>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public List<Slot> getSlots(Integer componentContentId, Integer languageId, InfoGluePrincipal principal) throws Exception {
        ArrayList<Slot> slots = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        PageEditorHelper.beginTransaction(db);
        try {
            slots = this.getSlots(componentContentId, languageId, db, principal);
            PageEditorHelper.commitTransaction(db);
        }
        catch (Exception e) {
            PageEditorHelper.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return slots;
    }

    public List<Slot> getSlots(Integer componentContentId, Integer languageId, Database db, InfoGluePrincipal principal) throws Exception {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        String template = this.getComponentTemplateString(componentContentId, languageId, db, principal);
        int offset = 0;
        int slotStartIndex = template.indexOf("<ig:slot", offset);
        while (slotStartIndex > -1) {
            int slotStopIndex = template.indexOf("</ig:slot>", slotStartIndex);
            String slot = template.substring(slotStartIndex, slotStopIndex + 10);
            String id = slot.substring(slot.indexOf("id") + 4, slot.indexOf("\"", slot.indexOf("id") + 4));
            Slot slotBean = new Slot();
            slotBean.setId(id);
            String[] allowedComponentNamesArray = null;
            int allowedComponentNamesIndex = slot.indexOf(" allowedComponentNames");
            if (allowedComponentNamesIndex > -1) {
                String allowedComponentNames = slot.substring(allowedComponentNamesIndex + 24, slot.indexOf("\"", allowedComponentNamesIndex + 24));
                allowedComponentNamesArray = allowedComponentNames.split(",");
                slotBean.setAllowedComponentsArray(allowedComponentNamesArray);
            }
            String[] disallowedComponentNamesArray = null;
            int disallowedComponentNamesIndex = slot.indexOf(" disallowedComponentNames");
            if (disallowedComponentNamesIndex > -1) {
                String disallowedComponentNames = slot.substring(disallowedComponentNamesIndex + 27, slot.indexOf("\"", disallowedComponentNamesIndex + 27));
                disallowedComponentNamesArray = disallowedComponentNames.split(",");
                slotBean.setDisallowedComponentsArray(disallowedComponentNamesArray);
            }
            boolean inherit = true;
            int inheritIndex = slot.indexOf("inherit");
            if (inheritIndex > -1) {
                String inheritString = slot.substring(inheritIndex + 9, slot.indexOf("\"", inheritIndex + 9));
                inherit = Boolean.parseBoolean(inheritString);
            }
            slotBean.setInherit(inherit);
            boolean disableAccessControl = false;
            int disableAccessControlIndex = slot.indexOf("disableAccessControl");
            if (disableAccessControlIndex > -1) {
                String disableAccessControlString = slot.substring(disableAccessControlIndex + "disableAccessControl".length() + 2, slot.indexOf("\"", disableAccessControlIndex + "disableAccessControl".length() + 2));
                disableAccessControl = Boolean.parseBoolean(disableAccessControlString);
            }
            String addComponentText = null;
            int addComponentTextIndex = slot.indexOf("addComponentText");
            if (addComponentTextIndex > -1) {
                addComponentText = slot.substring(addComponentTextIndex + "addComponentText".length() + 2, slot.indexOf("\"", addComponentTextIndex + "addComponentText".length() + 2));
            }
            String addComponentLinkHTML = null;
            int addComponentLinkHTMLIndex = slot.indexOf("addComponentLinkHTML");
            if (addComponentLinkHTMLIndex > -1) {
                addComponentLinkHTML = slot.substring(addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2, slot.indexOf("\"", addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2));
            }
            int allowedNumberOfComponentsInt = -1;
            int allowedNumberOfComponentsIndex = slot.indexOf("allowedNumberOfComponents");
            if (allowedNumberOfComponentsIndex > -1) {
                String allowedNumberOfComponents = slot.substring(allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2, slot.indexOf("\"", allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2));
                try {
                    allowedNumberOfComponentsInt = new Integer(allowedNumberOfComponents);
                }
                catch (Exception e) {
                    allowedNumberOfComponentsInt = -1;
                }
            }
            slotBean.setDisableAccessControl(disableAccessControl);
            slotBean.setAddComponentLinkHTML(addComponentLinkHTML);
            slotBean.setAddComponentText(addComponentText);
            slotBean.setAllowedNumberOfComponents(new Integer(allowedNumberOfComponentsInt));
            slots.add(slotBean);
            offset = slotStopIndex + 10;
            slotStartIndex = template.indexOf("<ig:slot", offset);
        }
        return slots;
    }

    public String getDigitalAssetUrl(Integer contentId, String key, Database db) throws Exception {
        String imageHref;
        block3: {
            imageHref = null;
            try {
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(ContentController.getContentController().getContentVOWithId(contentId, db).getRepositoryId(), db);
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguage.getId(), db);
                if (contentVersionVO == null) break block3;
                List digitalAssets = DigitalAssetController.getDigitalAssetVOList(contentVersionVO.getId(), db);
                for (DigitalAssetVO digitalAssetVO : digitalAssets) {
                    if (!digitalAssetVO.getAssetKey().equals(key)) continue;
                    imageHref = DigitalAssetController.getController().getDigitalAssetUrl(digitalAssetVO, db);
                    break;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
                imageHref = e.getMessage();
            }
        }
        return imageHref;
    }

    protected List getPageComponents(Database db, String componentXML, Element element, String slotName, Slot containerSlot, InfoGlueComponent parentComponent, Integer siteNodeId, Integer languageId, InfoGluePrincipal principal) throws Exception {
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(db, languageId);
        String key = componentXML.hashCode() + "_" + languageId + "_" + slotName;
        if (parentComponent != null) {
            key = componentXML.hashCode() + "_" + languageId + "_" + slotName + "_" + parentComponent.getId() + "_" + parentComponent.getName() + "_" + parentComponent.getIsInherited();
        }
        Object componentsCandidate = CacheController.getCachedObjectFromAdvancedCache("pageComponentsCache", key);
        List components = new ArrayList();
        String[] groups = null;
        if (componentsCandidate != null) {
            components = componentsCandidate instanceof NullObject ? null : (List)componentsCandidate;
        } else {
            String componentXPath = "component[@name='" + slotName + "']";
            List componentElements = element.selectNodes(componentXPath);
            Iterator componentIterator = componentElements.iterator();
            int slotPosition = 0;
            while (componentIterator.hasNext()) {
                Element componentElement = (Element)componentIterator.next();
                Integer id = new Integer(componentElement.attributeValue("id"));
                Integer contentId = new Integer(componentElement.attributeValue("contentId"));
                String name = componentElement.attributeValue("name");
                String isInherited = componentElement.attributeValue("isInherited");
                String pagePartTemplateContentId = componentElement.attributeValue("pagePartTemplateContentId");
                try {
                    List propertiesNodeList;
                    ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(contentId, db);
                    groups = new String[]{"content_" + contentVO.getId()};
                    InfoGlueComponent component = new InfoGlueComponent();
                    component.setPositionInSlot(new Integer(slotPosition));
                    component.setId(id);
                    component.setContentId(contentId);
                    component.setName(contentVO.getName());
                    component.setSlotName(name);
                    component.setParentComponent(parentComponent);
                    if (containerSlot != null) {
                        component.setContainerSlot(containerSlot);
                    }
                    if (isInherited != null && isInherited.equals("true")) {
                        component.setIsInherited(true);
                    } else if (parentComponent != null) {
                        component.setIsInherited(parentComponent.getIsInherited());
                    }
                    if (pagePartTemplateContentId != null && !pagePartTemplateContentId.equals("") && !pagePartTemplateContentId.equals("-1")) {
                        Integer pptContentId = new Integer(pagePartTemplateContentId);
                        ContentVO pptContentIdContentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(pptContentId, db);
                        InfoGlueComponent partTemplateReferenceComponent = new InfoGlueComponent();
                        partTemplateReferenceComponent.setPositionInSlot(new Integer(slotPosition));
                        partTemplateReferenceComponent.setId(id);
                        partTemplateReferenceComponent.setContentId(pptContentId);
                        partTemplateReferenceComponent.setName(pptContentIdContentVO.getName());
                        partTemplateReferenceComponent.setSlotName(name);
                        partTemplateReferenceComponent.setParentComponent(parentComponent);
                        if (containerSlot != null) {
                            partTemplateReferenceComponent.setContainerSlot(containerSlot);
                        }
                        partTemplateReferenceComponent.setIsInherited(true);
                        component.setPagePartTemplateContentId(pptContentId);
                        component.setPagePartTemplateComponent(partTemplateReferenceComponent);
                    }
                    if ((propertiesNodeList = componentElement.selectNodes("properties")).size() > 0) {
                        Element propertiesElement = (Element)propertiesNodeList.get(0);
                        List propertyNodeList = propertiesElement.selectNodes("property");
                        for (Element propertyElement : propertyNodeList) {
                            LanguageVO langaugeVO;
                            String propertyName = propertyElement.attributeValue("name");
                            String type = propertyElement.attributeValue("type");
                            String path = propertyElement.attributeValue("path");
                            if (path == null && propertyElement.attributeValue("path_" + (langaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageCode()) != null) {
                                path = propertyElement.attributeValue("path_" + langaugeVO.getLanguageCode());
                            }
                            if (propertyElement.attributeValue("path_" + locale.getLanguage()) != null) {
                                path = propertyElement.attributeValue("path_" + locale.getLanguage());
                            }
                            if (path == null || path.equals("")) {
                                logger.info((Object)("Falling back to content master language 1 for property:" + propertyName));
                                LanguageVO contentMasterLangaugeVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(db, contentVO.getRepositoryId());
                                if (propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode()) != null) {
                                    path = propertyElement.attributeValue("path_" + contentMasterLangaugeVO.getLanguageCode());
                                }
                            }
                            HashMap<String, Object> property = new HashMap<String, Object>();
                            property.put("name", propertyName);
                            property.put("path", path);
                            property.put("type", type);
                            if (propertyName.equals("CacheResult") && (path.equalsIgnoreCase("true") || path.equalsIgnoreCase("yes"))) {
                                component.setCacheResult(true);
                            }
                            if (propertyName.equals("UpdateInterval") && !path.equals("")) {
                                try {
                                    component.setUpdateInterval(Integer.parseInt(path));
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("The component " + component.getName() + " " + "UpdateInterval" + " with a faulty value on page with siteNodeId=" + siteNodeId + ":" + e.getMessage()));
                                }
                            }
                            if (propertyName.equals("CacheKey") && !path.equals("")) {
                                component.setCacheKey(path);
                            }
                            if (propertyName.equals("PreRenderOrder") && !path.equals("")) {
                                component.setPreProcessingOrder(path);
                            }
                            ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
                            List bindingNodeList = propertyElement.selectNodes("binding");
                            for (Element bindingElement : bindingNodeList) {
                                String entity = bindingElement.attributeValue("entity");
                                String entityId = bindingElement.attributeValue("entityId");
                                String assetKey = bindingElement.attributeValue("assetKey");
                                ComponentBinding componentBinding = new ComponentBinding();
                                componentBinding.setEntityClass(entity);
                                componentBinding.setEntityId(new Integer(entityId));
                                componentBinding.setAssetKey(assetKey);
                                componentBinding.setBindingPath(path);
                                bindings.add(componentBinding);
                            }
                            property.put("bindings", bindings);
                            component.getProperties().put(propertyName, property);
                        }
                    }
                    this.getComponentRestrictions(componentElement, component, locale);
                    try {
                        String componentString = this.getComponentTemplateString(contentId, languageId, db, principal);
                        int offset = 0;
                        int slotStartIndex = componentString.indexOf("<ig:slot", offset);
                        while (slotStartIndex > -1) {
                            int slotStopIndex = componentString.indexOf("</ig:slot>", slotStartIndex);
                            String slotString = componentString.substring(slotStartIndex, slotStopIndex + 10);
                            String slotId = slotString.substring(slotString.indexOf("id") + 4, slotString.indexOf("\"", slotString.indexOf("id") + 4));
                            boolean inherit = true;
                            int inheritIndex = slotString.indexOf("inherit");
                            if (inheritIndex > -1) {
                                String inheritString = slotString.substring(inheritIndex + 9, slotString.indexOf("\"", inheritIndex + 9));
                                inherit = Boolean.parseBoolean(inheritString);
                            }
                            boolean disableAccessControl = false;
                            int disableAccessControlIndex = slotString.indexOf("disableAccessControl");
                            if (disableAccessControlIndex > -1) {
                                String disableAccessControlString = slotString.substring(disableAccessControlIndex + "disableAccessControl".length() + 2, slotString.indexOf("\"", disableAccessControlIndex + "disableAccessControl".length() + 2));
                                disableAccessControl = Boolean.parseBoolean(disableAccessControlString);
                            }
                            String[] allowedComponentNamesArray = null;
                            int allowedComponentNamesIndex = slotString.indexOf(" allowedComponentNames");
                            if (allowedComponentNamesIndex > -1) {
                                String allowedComponentNames = slotString.substring(allowedComponentNamesIndex + 24, slotString.indexOf("\"", allowedComponentNamesIndex + 24));
                                allowedComponentNamesArray = allowedComponentNames.split(",");
                            }
                            String[] disallowedComponentNamesArray = null;
                            int disallowedComponentNamesIndex = slotString.indexOf(" disallowedComponentNames");
                            if (disallowedComponentNamesIndex > -1) {
                                String disallowedComponentNames = slotString.substring(disallowedComponentNamesIndex + 27, slotString.indexOf("\"", disallowedComponentNamesIndex + 27));
                                disallowedComponentNamesArray = disallowedComponentNames.split(",");
                            }
                            String addComponentText = null;
                            int addComponentTextIndex = slotString.indexOf("addComponentText");
                            if (addComponentTextIndex > -1) {
                                addComponentText = slotString.substring(addComponentTextIndex + "addComponentText".length() + 2, slotString.indexOf("\"", addComponentTextIndex + "addComponentText".length() + 2));
                            }
                            String addComponentLinkHTML = null;
                            int addComponentLinkHTMLIndex = slotString.indexOf("addComponentLinkHTML");
                            if (addComponentLinkHTMLIndex > -1) {
                                addComponentLinkHTML = slotString.substring(addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2, slotString.indexOf("\"", addComponentLinkHTMLIndex + "addComponentLinkHTML".length() + 2));
                            }
                            int allowedNumberOfComponentsInt = -1;
                            int allowedNumberOfComponentsIndex = slotString.indexOf("allowedNumberOfComponents");
                            if (allowedNumberOfComponentsIndex > -1) {
                                String allowedNumberOfComponents = slotString.substring(allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2, slotString.indexOf("\"", allowedNumberOfComponentsIndex + "allowedNumberOfComponents".length() + 2));
                                try {
                                    allowedNumberOfComponentsInt = new Integer(allowedNumberOfComponents);
                                }
                                catch (Exception e) {
                                    allowedNumberOfComponentsInt = -1;
                                }
                            }
                            Slot slot = new Slot();
                            slot.setId(slotId);
                            slot.setInherit(inherit);
                            slot.setDisableAccessControl(disableAccessControl);
                            slot.setAllowedComponentsArray(allowedComponentNamesArray);
                            slot.setDisallowedComponentsArray(disallowedComponentNamesArray);
                            slot.setAddComponentLinkHTML(addComponentLinkHTML);
                            slot.setAddComponentText(addComponentText);
                            slot.setAllowedNumberOfComponents(new Integer(allowedNumberOfComponentsInt));
                            Element componentsElement = (Element)componentElement.selectSingleNode("components");
                            List subComponents = this.getPageComponents(db, componentXML, componentsElement, slotId, slot, component, siteNodeId, languageId, principal);
                            slot.setComponents(subComponents);
                            component.getSlotList().add(slot);
                            offset = slotStopIndex;
                            slotStartIndex = componentString.indexOf("<ig:slot", offset);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn((Object)("An component with either an empty template or with no template in the sitelanguages was found:" + e.getMessage()), (Throwable)e);
                    }
                    components.add(component);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn((Object)("There was deleted referenced component or some other problem when rendering siteNode: " + siteNodeId + ") in language " + languageId + ":" + e.getMessage()), (Throwable)e);
                }
                ++slotPosition;
            }
        }
        if (groups == null) {
            groups = new String[]{"selectiveCacheUpdateNonApplicable"};
        }
        if (components != null) {
            CacheController.cacheObjectInAdvancedCache("pageComponentsCache", key, components, groups, false);
        } else {
            CacheController.cacheObjectInAdvancedCache("pageComponentsCache", key, new NullObject(), groups, false);
        }
        return components;
    }

    private void getComponentRestrictions(Element child, InfoGlueComponent component, Locale locale) throws Exception {
        List restrictionsNodeList = child.selectNodes("restrictions");
        if (restrictionsNodeList.size() > 0) {
            Element restrictionsElement = (Element)restrictionsNodeList.get(0);
            List restrictionNodeList = restrictionsElement.selectNodes("restriction");
            for (Element restrictionElement : restrictionNodeList) {
                ComponentRestriction restriction = new ComponentRestriction();
                String type = restrictionElement.attributeValue("type");
                if (type.equals("blockComponents")) {
                    String slotId = restrictionElement.attributeValue("slotId");
                    String arguments = restrictionElement.attributeValue("arguments");
                    restriction.setType(type);
                    restriction.setSlotId(slotId);
                    restriction.setArguments(arguments);
                }
                component.getRestrictions().add(restriction);
            }
        }
    }

    private InfoGlueComponent getComponentWithId(InfoGlueComponent parentComponent, Integer componentId) {
        InfoGlueComponent component = null;
        block0: for (Slot slot : parentComponent.getSlotList()) {
            List components = slot.getComponents();
            for (InfoGlueComponent subComponent : components) {
                if (subComponent.getId().equals(componentId)) {
                    component = subComponent;
                    break block0;
                }
                component = this.getComponentWithId(subComponent, componentId);
                if (component != null) continue block0;
            }
        }
        return component;
    }

    private List getComponentTasks(Integer componentId, Document document) throws Exception {
        ArrayList<ComponentTask> componentTasks = new ArrayList<ComponentTask>();
        Timer timer = new Timer();
        timer.setActive(false);
        try {
            if (document != null) {
                timer.printElapsedTime("Read document");
                String propertyXPath = "//task";
                List anl = document.selectNodes(propertyXPath);
                timer.printElapsedTime("Set property xpath");
                for (Element binding : anl) {
                    String name = binding.attributeValue("name");
                    String view = binding.attributeValue("view");
                    String openInPopup = binding.attributeValue("openInPopup");
                    String icon = binding.attributeValue("icon");
                    if (openInPopup == null || !openInPopup.equals("true") && !openInPopup.equals("false")) {
                        openInPopup = "true";
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("name:" + name));
                        logger.info((Object)("view:" + view));
                        logger.info((Object)("openInPopup:" + openInPopup));
                    }
                    ComponentTask task = new ComponentTask();
                    task.setName(name);
                    task.setView(view);
                    task.setIcon(icon);
                    task.setOpenInPopup(new Boolean(openInPopup));
                    task.setComponentId(componentId);
                    componentTasks.add(task);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("The component with id " + componentId + " had a incorrect xml defining it's properties:" + e.getMessage()), (Throwable)e);
        }
        return componentTasks;
    }

    protected Document getComponentTasksDOM4JDocument(Integer masterLanguageId, Integer metaInfoContentId, Database db) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "componentTasksDocument_" + masterLanguageId + "_" + metaInfoContentId;
        Document cachedComponentTasksDocument = (Document)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedComponentTasksDocument != null) {
            return cachedComponentTasksDocument;
        }
        Document componentTasksDocument = null;
        try {
            String xml = this.getComponentTasksString(masterLanguageId, metaInfoContentId, db);
            if (xml != null && xml.length() > 0) {
                componentTasksDocument = domBuilder.getDocument(xml);
                CacheController.cacheObject(cacheName, cacheKey, componentTasksDocument);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return componentTasksDocument;
    }

    private String getComponentTasksString(Integer masterLanguageId, Integer metaInfoContentId, Database db) throws SystemException, Exception {
        String cacheName = "componentEditorCache";
        String cacheKey = "componentTasksString_" + masterLanguageId + "_" + metaInfoContentId;
        String cachedComponentTasksString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        if (cachedComponentTasksString != null) {
            return cachedComponentTasksString;
        }
        String componentTasksString = null;
        try {
            componentTasksString = ContentController.getContentController().getContentAttribute(db, metaInfoContentId, masterLanguageId, "ComponentTasks");
            if (componentTasksString == null) {
                throw new SystemException("There was no tasks assigned to this content.");
            }
            CacheController.cacheObject(cacheName, cacheKey, componentTasksString);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return componentTasksString;
    }

    public static String transformAttribute(String plainAttribute, String languageId) {
        String newAttribute = "";
        String remainingAttribute = plainAttribute;
        int startPosition = remainingAttribute.indexOf("$templateLogic.getInlineAssetUrl(");
        while (startPosition > -1) {
            newAttribute = String.valueOf(newAttribute) + remainingAttribute.substring(0, startPosition);
            remainingAttribute = remainingAttribute.substring(startPosition + 33);
            int seperatorCharIndex = remainingAttribute.indexOf(",");
            String contentId = remainingAttribute.substring(0, seperatorCharIndex);
            String assetKey = remainingAttribute.substring(seperatorCharIndex + 1, remainingAttribute.indexOf(")")).trim();
            assetKey = assetKey.substring(1, assetKey.length() - 1);
            newAttribute = String.valueOf(newAttribute) + "DownloadAsset.action?contentId=" + contentId + "&languageId=" + languageId + "&assetKey=" + assetKey + "\"";
            int endIndex = remainingAttribute.indexOf(")");
            remainingAttribute = remainingAttribute.substring(endIndex + 1);
            startPosition = remainingAttribute.indexOf("$templateLogic.getInlineAssetUrl(");
        }
        newAttribute = String.valueOf(newAttribute) + remainingAttribute;
        return newAttribute;
    }

    public static String untransformAttribute(String plainAttribute) {
        String newAttribute = "";
        String remainingAttribute = plainAttribute;
        int startPosition = remainingAttribute.indexOf("DownloadAsset.action?contentId=");
        while (startPosition > -1) {
            newAttribute = String.valueOf(newAttribute) + remainingAttribute.substring(0, startPosition);
            remainingAttribute = remainingAttribute.substring(startPosition + 31);
            int seperatorCharIndex = remainingAttribute.indexOf("&amp;");
            String contentId = remainingAttribute.substring(0, seperatorCharIndex);
            String assetKey = remainingAttribute.substring(seperatorCharIndex + 1, remainingAttribute.indexOf("\""));
            int assetStartIndex = assetKey.indexOf("assetKey=") + 9;
            assetKey = assetKey.substring(assetStartIndex);
            newAttribute = String.valueOf(newAttribute) + "$templateLogic.getInlineAssetUrl(" + contentId + ", \"" + assetKey + "\")\"";
            int endIndex = remainingAttribute.indexOf("\"");
            remainingAttribute = remainingAttribute.substring(endIndex + 1);
            startPosition = remainingAttribute.indexOf("DownloadAsset.action?contentId=");
        }
        newAttribute = String.valueOf(newAttribute) + remainingAttribute;
        return newAttribute;
    }

    public void addSystemProperties(List componentProperties, Integer componentId, Integer siteNodeId, Integer languageId, Integer contentId, Locale locale, Database db, InfoGluePrincipal principal) throws Exception {
        ComponentProperty cacheResultProperty = new ComponentProperty();
        cacheResultProperty.setComponentId(componentId);
        cacheResultProperty.setName("CacheResult");
        cacheResultProperty.setDisplayName("Cache Result");
        cacheResultProperty.setDescription("Do you want to cache the components rendered result.");
        cacheResultProperty.setDefaultValue("false");
        cacheResultProperty.setDataProvider("");
        cacheResultProperty.setType("select");
        cacheResultProperty.setVisualizingAction("");
        cacheResultProperty.setCreateAction("");
        ComponentPropertyOption cpoNo = new ComponentPropertyOption("No", "false");
        ComponentPropertyOption cpoYes = new ComponentPropertyOption("Yes", "true");
        cacheResultProperty.getOptions().add(cpoNo);
        cacheResultProperty.getOptions().add(cpoYes);
        String value = this.getComponentPropertyValue(componentId, "CacheResult", siteNodeId, languageId, contentId, locale, db, principal, cacheResultProperty);
        cacheResultProperty.setValue(value);
        componentProperties.add(cacheResultProperty);
        ComponentProperty cacheIntervalProperty = new ComponentProperty();
        cacheIntervalProperty.setComponentId(componentId);
        cacheIntervalProperty.setName("UpdateInterval");
        cacheIntervalProperty.setDisplayName("Cache Update Interval");
        cacheIntervalProperty.setDescription("Interval before the cache gets updated");
        cacheIntervalProperty.setDefaultValue("-1");
        cacheIntervalProperty.setDataProvider("");
        cacheIntervalProperty.setType("select");
        cacheIntervalProperty.setVisualizingAction("");
        cacheIntervalProperty.setCreateAction("");
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("1 second", "1"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("2 seconds", "2"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("3 seconds", "3"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("4 seconds", "4"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("5 seconds", "5"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("10 seconds", "10"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("15 seconds", "15"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("20 seconds", "20"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("30 seconds", "30"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("1 minute", "60"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("2 minutes", "120"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("5 minutes", "300"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("10 minutes", "600"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("30 minutes", "1800"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("1 hour", "3600"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("2 hours", "7200"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("6 hours", "21600"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("12 hours", "43200"));
        cacheIntervalProperty.getOptions().add(new ComponentPropertyOption("24 hours", "86400"));
        String updateIntervalValue = this.getComponentPropertyValue(componentId, "UpdateInterval", siteNodeId, languageId, contentId, locale, db, principal, cacheIntervalProperty);
        cacheIntervalProperty.setValue(updateIntervalValue);
        componentProperties.add(cacheIntervalProperty);
        ComponentProperty cacheKeyProperty = new ComponentProperty();
        cacheKeyProperty.setComponentId(componentId);
        cacheKeyProperty.setName("CacheKey");
        cacheKeyProperty.setDisplayName("Cache Key");
        cacheKeyProperty.setDescription("Key for the component cache");
        cacheKeyProperty.setDefaultValue("");
        cacheKeyProperty.setDataProvider("");
        cacheKeyProperty.setType("textfield");
        cacheKeyProperty.setVisualizingAction("");
        cacheKeyProperty.setCreateAction("");
        String cacheKeyValue = this.getComponentPropertyValue(componentId, "CacheKey", siteNodeId, languageId, contentId, locale, db, principal, cacheKeyProperty);
        cacheKeyProperty.setValue(cacheKeyValue);
        componentProperties.add(cacheKeyProperty);
        ComponentProperty priorityProperty = new ComponentProperty();
        priorityProperty.setComponentId(componentId);
        priorityProperty.setName("PreRenderOrder");
        priorityProperty.setDisplayName("Pre processing order");
        priorityProperty.setDescription("State the order in which the component get's prerendered");
        priorityProperty.setDefaultValue("99");
        priorityProperty.setDataProvider("");
        priorityProperty.setType("select");
        priorityProperty.setVisualizingAction("");
        priorityProperty.setCreateAction("");
        int i = 0;
        while (i < 15) {
            priorityProperty.getOptions().add(new ComponentPropertyOption("" + i, "" + i));
            ++i;
        }
        String preRenderOrderPropertyValue = this.getComponentPropertyValue(componentId, "PreRenderOrder", siteNodeId, languageId, contentId, locale, db, principal, priorityProperty);
        priorityProperty.setValue(preRenderOrderPropertyValue);
        componentProperties.add(priorityProperty);
    }

    public List getReferencingPages(Integer contentId, Integer siteNodeId, int maxRows, Boolean excludeCurrentPage, Database db) {
        ArrayList<Object> referencingPages;
        String cacheKey = "content_" + contentId + "_" + maxRows + "_" + excludeCurrentPage;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("cacheKey:" + cacheKey));
        }
        if ((referencingPages = (ArrayList<Object>)CacheController.getCachedObject("referencingPagesCache", cacheKey)) != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached referencingPages:" + referencingPages.size()));
            }
        } else {
            referencingPages = new ArrayList<Object>();
            try {
                List referencingObjects = RegistryController.getController().getReferencingObjectsForContent(contentId, maxRows, db);
                for (ReferenceBean referenceBean : referencingObjects) {
                    Object pageCandidate = referenceBean.getReferencingCompletingObject();
                    if (!(pageCandidate instanceof SiteNodeVO) || excludeCurrentPage.booleanValue() && ((SiteNodeVO)pageCandidate).getId().equals(siteNodeId)) continue;
                    referencingPages.add(pageCandidate);
                }
                if (referencingPages != null) {
                    CacheController.cacheObject("referencingPagesCache", cacheKey, referencingPages);
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred trying to get referencing pages for the contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
            }
        }
        return referencingPages;
    }

    public String getPagePath(Integer siteNodeId, Integer languageId, Database db, InfoGluePrincipal principal) {
        String pagePath = "";
        try {
            DeliveryContext dc = DeliveryContext.getDeliveryContext(false);
            pagePath = NodeDeliveryController.getNodeDeliveryController(dc).getPagePath(db, principal, siteNodeId, languageId, new Integer(-1), "Meta information", "NavigationTitle", true, dc);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get current page url:" + e.getMessage()), (Throwable)e);
        }
        return pagePath;
    }
}

