/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.management.AvailableServiceBinding;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.entities.management.impl.simple.SiteNodeTypeDefinitionImpl;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.services.BaseService;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.filters.URIMapperCache;
import org.infoglue.deliver.applications.filters.ViewPageFilter;
import org.infoglue.deliver.controllers.kernel.URLComposer;
import org.infoglue.deliver.controllers.kernel.impl.simple.AvailableServiceBindingDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.DigitalAssetDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.NullObject;

public class NodeDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)NodeDeliveryController.class.getName());
    private URLComposer urlComposer = null;
    protected static final String META_INFO_BINDING_NAME = "Meta information";
    protected static final String NAV_TITLE_ATTRIBUTE_NAME = "NavigationTitle";
    private static final boolean USE_INHERITANCE = true;
    private static final boolean DO_NOT_USE_INHERITANCE = false;
    protected static final Integer NO = new Integer(0);
    protected static final Integer YES = new Integer(1);
    protected static final Integer INHERITED = new Integer(2);
    private Integer siteNodeId = null;
    private Integer languageId = null;
    private Integer contentId = null;

    private NodeDeliveryController(Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        this.siteNodeId = siteNodeId;
        this.languageId = languageId;
        this.contentId = contentId;
        this.urlComposer = URLComposer.getURLComposer();
    }

    public static NodeDeliveryController getNodeDeliveryController(Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        return new NodeDeliveryController(siteNodeId, languageId, contentId);
    }

    public static NodeDeliveryController getNodeDeliveryController(DeliveryContext deliveryContext) throws SystemException, Exception {
        return new NodeDeliveryController(deliveryContext.getSiteNodeId(), deliveryContext.getLanguageId(), deliveryContext.getContentId());
    }

    private Integer getOperatingMode() {
        Integer operatingMode = new Integer(0);
        try {
            operatingMode = new Integer(CmsPropertyHandler.getOperatingMode());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the operating mode from the propertyFile:" + e.getMessage()), (Throwable)e);
        }
        return operatingMode;
    }

    public SiteNodeVersionVO getActiveSiteNodeVersionVO(Database db, Integer siteNodeId) throws Exception {
        SiteNodeVersionVO siteNodeVersionVO = null;
        SiteNodeVersion siteNodeVersion = this.getActiveSiteNodeVersion(siteNodeId, db);
        if (siteNodeVersion != null) {
            siteNodeVersionVO = siteNodeVersion.getValueObject();
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersion getActiveSiteNodeVersion(Integer siteNodeId, Database db) throws Exception {
        SiteNodeVersion siteNodeVersion = null;
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        logger.info((Object)("Loaded siteNode " + siteNode.getName()));
        Collection siteNodeVersions = siteNode.getSiteNodeVersions();
        logger.info((Object)("Loaded versions " + siteNodeVersions.size()));
        for (SiteNodeVersion siteNodeVersionCandidate : siteNodeVersions) {
            logger.info((Object)("SiteNodeVersionCandidate " + siteNodeVersionCandidate.getId()));
            if (!siteNodeVersionCandidate.getIsActive().booleanValue() || siteNodeVersionCandidate.getStateId() < this.getOperatingMode() || siteNodeVersionCandidate.getOwningSiteNode().getSiteNodeId().intValue() != siteNodeId.intValue() || siteNodeVersion != null && siteNodeVersion.getSiteNodeVersionId() >= siteNodeVersionCandidate.getId()) continue;
            siteNodeVersion = siteNodeVersionCandidate;
        }
        return siteNodeVersion;
    }

    public ServiceDefinitionVO getInheritedServiceDefinition(List qualifyerList, Integer siteNodeId, AvailableServiceBindingVO availableServiceBindingVO, Database db, boolean inheritParentBindings) throws SystemException, Exception {
        ServiceDefinitionVO serviceDefinitionVO = null;
        if (siteNodeId == null || siteNodeId <= 0) {
            return serviceDefinitionVO;
        }
        logger.info((Object)("Trying to find binding " + availableServiceBindingVO + " on siteNodeId:" + siteNodeId));
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SmallSiteNodeImpl.class, siteNodeId, db);
        logger.info((Object)("Loaded siteNode " + siteNode.getName()));
        serviceDefinitionVO = this.getServiceDefinitionVO(qualifyerList, siteNode, availableServiceBindingVO, db);
        logger.info((Object)("Loaded serviceDefinitionVO " + serviceDefinitionVO));
        if (serviceDefinitionVO == null && availableServiceBindingVO != null && availableServiceBindingVO.getIsInheritable().booleanValue() && inheritParentBindings) {
            logger.info((Object)"No binding found - lets try the parent.");
            SiteNodeImpl parent = siteNode.getParentSiteNode();
            if (parent != null) {
                serviceDefinitionVO = this.getInheritedServiceDefinition(qualifyerList, parent.getSiteNodeId(), availableServiceBindingVO, db, inheritParentBindings);
            }
        }
        logger.info((Object)"Loaded serviceDefinitionVO end...");
        return serviceDefinitionVO;
    }

    private ServiceDefinitionVO getServiceDefinitionVO(List qualifyerList, SiteNode siteNode, AvailableServiceBindingVO availableServiceBindingVO, Database db) throws Exception {
        ServiceDefinitionVO serviceDefinitionVO = null;
        String key = siteNode.getSiteNodeId() + "_" + availableServiceBindingVO.getId();
        logger.info((Object)("key:" + key));
        Object object = CacheController.getCachedObject("serviceDefinitionCache", key);
        Object object2 = CacheController.getCachedObject("qualifyerListCache", key);
        if (object != null && object2 != null) {
            logger.info((Object)("There was an cached ServiceDefinitionVO:" + object));
            if (object instanceof ServiceDefinitionVO) {
                serviceDefinitionVO = (ServiceDefinitionVO)object;
            }
            if (object2 instanceof List) {
                qualifyerList.addAll((List)object2);
            }
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT sb FROM org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl sb WHERE sb.siteNodeVersion.owningSiteNode = $1 AND sb.availableServiceBinding = $2 AND sb.siteNodeVersion.isActive = $3 AND sb.siteNodeVersion.stateId >= $4 order by sb.siteNodeVersion.siteNodeVersionId DESC");
            oql.bind((Object)siteNode);
            oql.bind((Object)availableServiceBindingVO.getId());
            oql.bind((Object)new Boolean(true));
            oql.bind((Object)this.getOperatingMode());
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                ServiceBinding serviceBinding = (ServiceBinding)results.next();
                SiteNodeVersionVO latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNode.getId());
                logger.info((Object)("serviceBinding sitenodeVersion:" + serviceBinding.getSiteNodeVersion().getId() + ":" + latestSiteNodeVersionVO.getId()));
                if (serviceBinding.getSiteNodeVersion().getId().equals(latestSiteNodeVersionVO.getId())) {
                    serviceDefinitionVO = serviceBinding.getServiceDefinition().getValueObject();
                    Collection qualifyers = serviceBinding.getBindingQualifyers();
                    qualifyers = this.sortQualifyers(qualifyers);
                    for (Qualifyer qualifyer : qualifyers) {
                        HashMap<String, String> argument = new HashMap<String, String>();
                        argument.put(qualifyer.getName(), qualifyer.getValue());
                        qualifyerList.add(argument);
                    }
                    object = serviceDefinitionVO;
                    object2 = qualifyerList;
                }
            } else {
                object = new NullObject();
                object2 = new NullObject();
            }
            results.close();
            oql.close();
            CacheController.cacheObject("serviceDefinitionCache", key, object);
            CacheController.cacheObject("qualifyerListCache", key, object2);
        }
        return serviceDefinitionVO;
    }

    private AvailableServiceBinding getAvailableServiceBindingRecursive(SiteNode siteNode, String availableServiceBindingName, boolean inheritParentBindings) {
        if (siteNode == null || availableServiceBindingName == null) {
            return null;
        }
        AvailableServiceBinding availableServiceBinding = null;
        SiteNodeTypeDefinitionImpl siteNodeTypeDefinition = siteNode.getSiteNodeTypeDefinition();
        if (siteNodeTypeDefinition != null) {
            Collection availableServiceBindings = siteNodeTypeDefinition.getAvailableServiceBindings();
            for (AvailableServiceBinding currentAvailableServiceBinding : availableServiceBindings) {
                if (!currentAvailableServiceBinding.getName().equalsIgnoreCase(availableServiceBindingName)) continue;
                availableServiceBinding = currentAvailableServiceBinding;
            }
        }
        if (availableServiceBinding == null) {
            availableServiceBinding = this.getAvailableServiceBindingRecursive(siteNode.getParentSiteNode(), availableServiceBindingName, inheritParentBindings);
        }
        return availableServiceBinding;
    }

    public SiteNode getSiteNode(Database db, Integer siteNodeId) throws SystemException {
        if (siteNodeId == null || siteNodeId < 1) {
            return null;
        }
        SiteNode siteNode = null;
        siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        return siteNode;
    }

    public SiteNodeVersionVO getLatestActiveSiteNodeVersionVO(Database db, Integer siteNodeId) throws SystemException, Exception {
        String key = "" + siteNodeId;
        logger.info((Object)("key:" + key));
        SiteNodeVersionVO siteNodeVersionVO = (SiteNodeVersionVO)CacheController.getCachedObject("latestSiteNodeVersionCache", key);
        if (siteNodeVersionVO != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached siteNodeVersionVO:" + siteNodeVersionVO));
            }
        } else {
            SiteNodeVersion siteNodeVersion = this.getLatestActiveSiteNodeVersion(siteNodeId, db);
            if (siteNodeVersion != null) {
                siteNodeVersionVO = siteNodeVersion.getValueObject();
            }
            CacheController.cacheObject("latestSiteNodeVersionCache", key, siteNodeVersionVO);
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersionVO getLatestActiveSiteNodeVersionVOForPageCache(Database db, Integer siteNodeId) throws SystemException, Exception {
        String key = "" + siteNodeId;
        logger.info((Object)("key:" + key));
        SiteNodeVersionVO siteNodeVersionVO = (SiteNodeVersionVO)CacheController.getCachedObject("pageCacheLatestSiteNodeVersions", key);
        if (siteNodeVersionVO != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached siteNodeVersionVO:" + siteNodeVersionVO));
            }
        } else {
            SiteNodeVersion siteNodeVersion = this.getLatestActiveSiteNodeVersion(siteNodeId, db);
            if (siteNodeVersion != null) {
                siteNodeVersionVO = siteNodeVersion.getValueObject();
            }
            CacheController.cacheObject("pageCacheLatestSiteNodeVersions", key, siteNodeVersionVO);
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersion getLatestActiveSiteNodeVersion(Integer siteNodeId, Database db) throws SystemException, Exception {
        SiteNodeVersion siteNodeVersion = null;
        String versionKey = siteNodeId + "_" + this.getOperatingMode() + "_siteNodeVersionId";
        Integer siteNodeVersionId = (Integer)CacheController.getCachedObject("latestSiteNodeVersionCache", versionKey);
        if (siteNodeVersionId != null) {
            logger.info((Object)("There was a cached sitenode version id:" + siteNodeVersionId));
            siteNodeVersion = (SiteNodeVersion)this.getObjectWithId(SiteNodeVersionImpl.class, siteNodeVersionId, db);
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1 AND cv.stateId >= $2 AND cv.isActive = $3 ORDER BY cv.siteNodeVersionId desc");
            oql.bind((Object)siteNodeId);
            oql.bind((Object)this.getOperatingMode());
            oql.bind(true);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                siteNodeVersion = (SiteNodeVersion)results.next();
                CacheController.cacheObject("latestSiteNodeVersionCache", versionKey, siteNodeVersion.getId());
            }
            results.close();
            oql.close();
        }
        return siteNodeVersion;
    }

    public SiteNodeVO getParentSiteNode(Database db, Integer siteNodeId) throws SystemException {
        String key = "" + siteNodeId;
        Object object = CacheController.getCachedObject("parentSiteNodeCache", key);
        SiteNodeVO parentSiteNodeVO = null;
        if (object instanceof NullObject) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached parentSiteNodeVO but it was null:" + object));
            }
        } else if (object != null) {
            parentSiteNodeVO = (SiteNodeVO)object;
        } else {
            SiteNode siteNode = (SiteNode)this.getObjectWithId(SmallSiteNodeImpl.class, siteNodeId, db);
            SiteNodeImpl parentSiteNode = siteNode.getParentSiteNode();
            if (parentSiteNode != null) {
                parentSiteNodeVO = parentSiteNode.getValueObject();
                CacheController.cacheObject("parentSiteNodeCache", key, parentSiteNodeVO);
            } else {
                CacheController.cacheObject("parentSiteNodeCache", key, new NullObject());
            }
        }
        return parentSiteNodeVO;
    }

    public SiteNodeVO getParentSiteNodeForPageCache(Database db, Integer siteNodeId) throws SystemException {
        String key = "" + siteNodeId;
        logger.info((Object)("key getParentSiteNode:" + key));
        Object object = CacheController.getCachedObject("pageCacheParentSiteNodeCache", key);
        SiteNodeVO parentSiteNodeVO = null;
        logger.info((Object)("object:" + object));
        if (object instanceof NullObject) {
            logger.info((Object)("There was an cached parentSiteNodeVO but it was null:" + object));
        } else if (object != null) {
            parentSiteNodeVO = (SiteNodeVO)object;
        } else {
            SiteNode siteNode = (SiteNode)this.getObjectWithId(SmallSiteNodeImpl.class, siteNodeId, db);
            SiteNodeImpl parentSiteNode = siteNode.getParentSiteNode();
            if (parentSiteNode != null) {
                parentSiteNodeVO = parentSiteNode.getValueObject();
                CacheController.cacheObject("pageCacheParentSiteNodeCache", key, parentSiteNodeVO);
            } else {
                CacheController.cacheObject("pageCacheParentSiteNodeCache", key, new NullObject());
            }
        }
        return parentSiteNodeVO;
    }

    public boolean getIsPageCacheDisabled(Database db, Integer siteNodeId) {
        boolean isPageCacheDisabled = false;
        try {
            SiteNodeVersionVO latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getDisablePageCache() != null) {
                SiteNodeVO parentSiteNode;
                if (latestSiteNodeVersionVO.getDisablePageCache().intValue() == NO.intValue()) {
                    isPageCacheDisabled = false;
                } else if (latestSiteNodeVersionVO.getDisablePageCache().intValue() == YES.intValue()) {
                    isPageCacheDisabled = true;
                } else if (latestSiteNodeVersionVO.getDisablePageCache().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNode(db, siteNodeId)) != null) {
                    isPageCacheDisabled = this.getIsPageCacheDisabled(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return isPageCacheDisabled;
    }

    public String getPageCacheKey(Database db, HttpSession session, HttpServletRequest request, Integer siteNodeId, Integer languageId, Integer contentId, String userAgent, String queryString, String extra) {
        return this.getPageCacheKey(db, session, request, siteNodeId, languageId, contentId, userAgent, queryString, extra, true);
    }

    public String getPageCacheKey(Database db, HttpSession session, HttpServletRequest request, Integer siteNodeId, Integer languageId, Integer contentId, String userAgent, String queryString, String extra, boolean includeOriginalRequestURL) {
        String pageKey = CacheController.getPageCacheKey(session, request, siteNodeId, languageId, contentId, userAgent, queryString, extra);
        try {
            SiteNodeVersionVO latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, siteNodeId);
            Integer currentSiteNodeId = siteNodeId;
            while (latestSiteNodeVersionVO == null || latestSiteNodeVersionVO.getPageCacheKey() == null || latestSiteNodeVersionVO.getPageCacheKey().length() == 0 || latestSiteNodeVersionVO.getPageCacheKey().equalsIgnoreCase("default")) {
                SiteNodeVO parentSiteNodeVO;
                if (currentSiteNodeId == null || (parentSiteNodeVO = this.getParentSiteNode(db, currentSiteNodeId)) == null) break;
                latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, parentSiteNodeVO.getId());
                currentSiteNodeId = latestSiteNodeVersionVO != null ? latestSiteNodeVersionVO.getSiteNodeId() : null;
            }
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getPageCacheKey() != null && latestSiteNodeVersionVO.getPageCacheKey().length() > 0 && !latestSiteNodeVersionVO.getPageCacheKey().equalsIgnoreCase("default")) {
                String originalRequestURL = request.getParameter("originalRequestURL");
                if (originalRequestURL == null || originalRequestURL.length() == 0) {
                    originalRequestURL = request.getRequestURL().toString();
                }
                pageKey = String.valueOf(originalRequestURL) + "_" + latestSiteNodeVersionVO.getPageCacheKey();
                pageKey = pageKey.replaceAll("\\$siteNodeId", "" + siteNodeId);
                pageKey = pageKey.replaceAll("\\$languageId", "" + languageId);
                pageKey = pageKey.replaceAll("\\$contentId", "" + contentId);
                pageKey = pageKey.replaceAll("\\$useragent", userAgent);
                pageKey = pageKey.replaceAll("\\$queryString", queryString);
                int sessionAttributeStartIndex = pageKey.indexOf("$session.");
                while (sessionAttributeStartIndex > -1) {
                    int sessionAttributeEndIndex = pageKey.indexOf("_", sessionAttributeStartIndex);
                    String sessionAttribute = null;
                    sessionAttribute = sessionAttributeEndIndex > -1 ? pageKey.substring(sessionAttributeStartIndex + 9, sessionAttributeEndIndex) : pageKey.substring(sessionAttributeStartIndex + 9);
                    pageKey = pageKey.replaceAll("\\$session." + sessionAttribute, "" + session.getAttribute(sessionAttribute));
                    sessionAttributeStartIndex = pageKey.indexOf("$session.");
                }
                int cookieAttributeStartIndex = pageKey.indexOf("$cookie.");
                while (cookieAttributeStartIndex > -1) {
                    int cookieAttributeEndIndex = pageKey.indexOf("_", cookieAttributeStartIndex);
                    String cookieAttribute = null;
                    cookieAttribute = cookieAttributeEndIndex > -1 ? pageKey.substring(cookieAttributeStartIndex + 8, cookieAttributeEndIndex) : pageKey.substring(cookieAttributeStartIndex + 8);
                    HttpHelper httpHelper = new HttpHelper();
                    pageKey = pageKey.replaceAll("\\$cookie." + cookieAttribute, httpHelper.getCookie(request, cookieAttribute));
                    cookieAttributeStartIndex = pageKey.indexOf("$cookie.");
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion had a different pageCacheKey:" + e.getMessage()), (Throwable)e);
        }
        return pageKey;
    }

    public boolean getIsEditOnSightDisabled(Database db, Integer siteNodeId) {
        logger.info((Object)("getIsEditOnSightDisabled:" + siteNodeId));
        boolean isEditOnSightDisabled = false;
        try {
            SiteNodeVersionVO latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getDisableEditOnSight() != null) {
                SiteNodeVO parentSiteNode;
                if (latestSiteNodeVersionVO.getDisableEditOnSight().intValue() == NO.intValue()) {
                    isEditOnSightDisabled = false;
                } else if (latestSiteNodeVersionVO.getDisableEditOnSight().intValue() == YES.intValue()) {
                    isEditOnSightDisabled = true;
                } else if (latestSiteNodeVersionVO.getDisableEditOnSight().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNode(db, siteNodeId)) != null) {
                    isEditOnSightDisabled = this.getIsEditOnSightDisabled(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)("getIsEditOnSightDisabled:" + isEditOnSightDisabled));
        return isEditOnSightDisabled;
    }

    public boolean getIsPageProtected(Database db, Integer siteNodeId) {
        boolean isPageProtected = false;
        try {
            SiteNodeVersionVO latestSiteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNode;
                if (latestSiteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    isPageProtected = false;
                } else if (latestSiteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    isPageProtected = true;
                } else if (latestSiteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNode(db, siteNodeId)) != null) {
                    isPageProtected = this.getIsPageProtected(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return isPageProtected;
    }

    public Integer getProtectedSiteNodeVersionId(Database db, Integer siteNodeId) {
        Integer protectedSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
            logger.info((Object)("siteNodeId:" + siteNodeId));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNode;
                logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getIsProtected()));
                if (siteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNode(db, siteNodeId)) != null) {
                    protectedSiteNodeVersionId = this.getProtectedSiteNodeVersionId(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return protectedSiteNodeVersionId;
    }

    public Integer getProtectedSiteNodeVersionIdForPageCache(Database db, Integer siteNodeId) {
        Integer protectedSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, siteNodeId);
            logger.info((Object)("siteNodeId:" + siteNodeId));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNode;
                logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getIsProtected()));
                if (siteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNodeForPageCache(db, siteNodeId)) != null) {
                    protectedSiteNodeVersionId = this.getProtectedSiteNodeVersionIdForPageCache(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return protectedSiteNodeVersionId;
    }

    public Integer getDisabledLanguagesSiteNodeVersionId(Database db, Integer siteNodeId) {
        Integer disabledLanguagesSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, siteNodeId);
            logger.info((Object)("siteNodeId:" + siteNodeId));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getDisableLanguages() != null) {
                SiteNodeVO parentSiteNode;
                logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getDisableLanguages()));
                if (siteNodeVersionVO.getDisableLanguages().intValue() == NO.intValue()) {
                    disabledLanguagesSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getDisableLanguages().intValue() == YES.intValue()) {
                    disabledLanguagesSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getDisableLanguages().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNodeForPageCache(db, siteNodeId)) != null) {
                    disabledLanguagesSiteNodeVersionId = this.getDisabledLanguagesSiteNodeVersionId(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled languages:" + e.getMessage()), (Throwable)e);
        }
        return disabledLanguagesSiteNodeVersionId;
    }

    public Integer getDisableForceIdentityCheckSiteNodeVersionId(Database db, Integer siteNodeId) {
        Integer disableForceIdentityCheckSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, siteNodeId);
            logger.info((Object)("siteNodeId:" + siteNodeId));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getDisableLanguages() != null) {
                SiteNodeVO parentSiteNode;
                logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getDisableForceIdentityCheck()));
                if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == NO.intValue()) {
                    disableForceIdentityCheckSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == YES.intValue()) {
                    disableForceIdentityCheckSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNodeForPageCache(db, siteNodeId)) != null) {
                    disableForceIdentityCheckSiteNodeVersionId = this.getDisableForceIdentityCheckSiteNodeVersionId(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled identity check:" + e.getMessage()), (Throwable)e);
        }
        return disableForceIdentityCheckSiteNodeVersionId;
    }

    public boolean getIsForcedIdentityCheckDisabled(Database db, Integer siteNodeId) {
        boolean isForcedIdentityCheckDisabled = false;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVOForPageCache(db, siteNodeId);
            logger.info((Object)("siteNodeId:" + siteNodeId));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getDisableLanguages() != null) {
                SiteNodeVO parentSiteNode;
                logger.info((Object)("siteNodeVersionVO:" + siteNodeVersionVO.getId() + ":" + siteNodeVersionVO.getDisableForceIdentityCheck()));
                if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == NO.intValue()) {
                    isForcedIdentityCheckDisabled = false;
                } else if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == YES.intValue()) {
                    isForcedIdentityCheckDisabled = true;
                } else if (siteNodeVersionVO.getDisableForceIdentityCheck().intValue() == INHERITED.intValue() && (parentSiteNode = this.getParentSiteNodeForPageCache(db, siteNodeId)) != null) {
                    isForcedIdentityCheckDisabled = this.getIsForcedIdentityCheckDisabled(db, parentSiteNode.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled identity check:" + e.getMessage()), (Throwable)e);
        }
        return isForcedIdentityCheckDisabled;
    }

    public ContentVO getBoundContent(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, String availableServiceBindingName, boolean inheritParentBindings, DeliveryContext deliveryContext) throws SystemException, Exception {
        List contents = this.getBoundContents(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, availableServiceBindingName, inheritParentBindings, false, deliveryContext);
        return contents != null && contents.size() > 0 ? (ContentVO)contents.get(0) : null;
    }

    public ContentVO getBoundContent(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, String availableServiceBindingName, boolean inheritParentBindings, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        List contents = this.getBoundContents(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, availableServiceBindingName, inheritParentBindings, includeFolders, deliveryContext);
        return contents != null && contents.size() > 0 ? (ContentVO)contents.get(0) : null;
    }

    public ContentVO getBoundContent(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, String availableServiceBindingName, DeliveryContext deliveryContext) throws SystemException, Exception {
        logger.info((Object)("siteNodeId:" + siteNodeId));
        logger.info((Object)("availableServiceBindingName:" + availableServiceBindingName));
        List contents = this.getBoundContents(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, availableServiceBindingName, true, true, deliveryContext);
        return contents != null && contents.size() > 0 ? (ContentVO)contents.get(0) : null;
    }

    public ContentVO getBoundContent(InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, String availableServiceBindingName, DeliveryContext deliveryContext) throws SystemException, Exception {
        List contents = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        NodeDeliveryController.beginTransaction(db);
        try {
            contents = this.getBoundContents(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, availableServiceBindingName, true, true, deliveryContext);
            NodeDeliveryController.closeTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            NodeDeliveryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contents != null && contents.size() > 0 ? (ContentVO)contents.get(0) : null;
    }

    public List getBoundContents(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, String availableServiceBindingName, boolean inheritParentBindings, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        StringBuilder boundContentsKey = new StringBuilder();
        boundContentsKey.append("").append("").append(infoGluePrincipal.getName()).append("_").append(siteNodeId).append("_").append(languageId).append("_").append(useLanguageFallback).append("_").append(includeFolders).append("_").append(availableServiceBindingName).append("_").append(true);
        ArrayList<ContentVO> boundContentVOList = (ArrayList<ContentVO>)CacheController.getCachedObject("boundContentCache", boundContentsKey.toString());
        if (boundContentVOList != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached content boundContentVOList:" + boundContentVOList.size()));
            }
        } else {
            boundContentVOList = new ArrayList<ContentVO>();
            Integer metaInfoContentId = null;
            if (availableServiceBindingName.equalsIgnoreCase(META_INFO_BINDING_NAME)) {
                SiteNode siteNode = this.getSiteNode(db, siteNodeId);
                if (siteNode != null) {
                    metaInfoContentId = siteNode.getMetaInfoContentId();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("siteNode for id: " + siteNodeId + "=" + siteNode));
                    logger.debug((Object)("metaInfoContentId: " + metaInfoContentId));
                }
            }
            if (metaInfoContentId != null && metaInfoContentId > -1) {
                ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(db, metaInfoContentId, deliveryContext);
                boundContentVOList.add(contentVO);
            } else {
                AvailableServiceBindingVO availableServiceBindingVO;
                ArrayList qualifyerList;
                ServiceDefinitionVO serviceDefinitionVO;
                if (availableServiceBindingName.equalsIgnoreCase(META_INFO_BINDING_NAME)) {
                    logger.warn((Object)("Entering the old logic - bad for performance - why is siteNode with id:" + siteNodeId + " not getting it's metaInfoContentId:" + metaInfoContentId));
                }
                if ((serviceDefinitionVO = this.getInheritedServiceDefinition(qualifyerList = new ArrayList(), siteNodeId, availableServiceBindingVO = AvailableServiceBindingDeliveryController.getAvailableServiceBindingDeliveryController().getAvailableServiceBindingVO(availableServiceBindingName, db), db, inheritParentBindings)) != null) {
                    String serviceClassName = serviceDefinitionVO.getClassName();
                    BaseService service = (BaseService)Class.forName(serviceClassName).newInstance();
                    HashMap<String, Object> arguments = new HashMap<String, Object>();
                    arguments.put("method", "selectContentListOnIdList");
                    arguments.put("arguments", qualifyerList);
                    List contents = service.selectMatchingEntities(arguments, db);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Found bound contents:" + contents.size()));
                    }
                    if (contents != null) {
                        for (ContentVO candidate : contents) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("candidate:" + candidate.getName()));
                            }
                            Content candidateContent = (Content)this.getObjectWithId(ContentImpl.class, candidate.getId(), db);
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("candidateContent:" + candidateContent.getName()));
                            }
                            if (!ContentDeliveryController.getContentDeliveryController().isValidContent(infoGluePrincipal, candidateContent, languageId, useLanguageFallback, includeFolders, db, deliveryContext)) continue;
                            deliveryContext.addUsedContent("content_" + candidate.getId());
                            boundContentVOList.add(candidate);
                        }
                    }
                }
            }
            CacheController.cacheObject("boundContentCache", boundContentsKey.toString(), boundContentVOList);
        }
        return boundContentVOList;
    }

    public List getBoundFolderContents(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, String availableServiceBindingName, boolean searchRecursive, Integer maximumNumberOfLevels, String sortAttribute, String sortOrder, boolean useLanguageFallback, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        List folderContents = new ArrayList();
        deliveryContext.addUsedContent("selectiveCacheUpdateNonApplicable");
        ContentVO contentVO = this.getBoundContent(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, availableServiceBindingName, includeFolders, deliveryContext);
        if (contentVO != null) {
            folderContents = ContentDeliveryController.getContentDeliveryController().getSortedChildContents(infoGluePrincipal, languageId, contentVO.getContentId(), siteNodeId, db, searchRecursive, maximumNumberOfLevels, sortAttribute, sortOrder, useLanguageFallback, includeFolders, deliveryContext);
        }
        return folderContents;
    }

    public List getBoundFolderContents(Database db, InfoGluePrincipal infoGluePrincipal, Integer contentId, Integer languageId, boolean searchRecursive, Integer maximumNumberOfLevels, String sortAttribute, String sortOrder, boolean useLanguageFallback, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        List folderContents = new ArrayList();
        folderContents = ContentDeliveryController.getContentDeliveryController().getSortedChildContents(infoGluePrincipal, languageId, contentId, this.siteNodeId, db, searchRecursive, maximumNumberOfLevels, sortAttribute, sortOrder, useLanguageFallback, includeFolders, deliveryContext);
        return folderContents;
    }

    public SiteNodeVO getBoundSiteNode(Database db, Integer siteNodeId, String availableServiceBindingName) throws SystemException, Exception {
        List siteNodes = this.getBoundSiteNodes(db, siteNodeId, availableServiceBindingName);
        return siteNodes != null && siteNodes.size() > 0 ? (SiteNodeVO)siteNodes.get(0) : null;
    }

    public SiteNodeVO getBoundSiteNode(Database db, Integer siteNodeId, String availableServiceBindingName, int position) throws SystemException, Exception {
        List siteNodes = this.getBoundSiteNodes(db, siteNodeId, availableServiceBindingName);
        return siteNodes != null && siteNodes.size() > position ? (SiteNodeVO)siteNodes.get(position) : null;
    }

    public List getBoundSiteNodes(Database db, Integer siteNodeId, String availableServiceBindingName) throws SystemException, Exception {
        String boundSiteNodesKey = siteNodeId + "_" + availableServiceBindingName + "_" + true;
        logger.info((Object)("boundSiteNodesKey:" + boundSiteNodesKey));
        ArrayList<SiteNodeVO> boundSiteNodeVOList = (ArrayList<SiteNodeVO>)CacheController.getCachedObject("boundSiteNodeCache", boundSiteNodesKey);
        if (boundSiteNodeVOList != null) {
            logger.info((Object)("There was an cached content boundSiteNodeVOList:" + boundSiteNodeVOList.size()));
        } else {
            boundSiteNodeVOList = new ArrayList<SiteNodeVO>();
            ArrayList qualifyerList = new ArrayList();
            AvailableServiceBindingVO availableServiceBindingVO = AvailableServiceBindingDeliveryController.getAvailableServiceBindingDeliveryController().getAvailableServiceBindingVO(availableServiceBindingName, db);
            ServiceDefinitionVO serviceDefinitionVO = this.getInheritedServiceDefinition(qualifyerList, siteNodeId, availableServiceBindingVO, db, true);
            if (serviceDefinitionVO != null) {
                String serviceClassName = serviceDefinitionVO.getClassName();
                BaseService service = (BaseService)Class.forName(serviceClassName).newInstance();
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("method", "selectSiteNodeListOnIdList");
                arguments.put("arguments", qualifyerList);
                List siteNodes = service.selectMatchingEntities(arguments, db);
                logger.info((Object)("Found bound siteNodes:" + siteNodes.size()));
                if (siteNodes != null) {
                    for (SiteNodeVO candidate : siteNodes) {
                        logger.info((Object)("candidate:" + candidate.getId()));
                        if (!this.isValidSiteNode(db, candidate.getId())) continue;
                        boundSiteNodeVOList.add(candidate);
                    }
                }
            }
            CacheController.cacheObject("boundSiteNodeCache", boundSiteNodesKey, boundSiteNodeVOList);
        }
        return boundSiteNodeVOList;
    }

    public String getPageUrl(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext deliveryContext) throws SystemException {
        String pageUrl = "";
        pageUrl = this.urlComposer.composePageUrl(db, infoGluePrincipal, siteNodeId, languageId, contentId, deliveryContext);
        return pageUrl;
    }

    public String getPageUrlAfterLanguageChange(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext deliveryContext) throws SystemException {
        return this.urlComposer.composePageUrlAfterLanguageChange(db, infoGluePrincipal, siteNodeId, languageId, contentId, deliveryContext);
    }

    public String getPageAsDigitalAssetUrl(Database database, InfoGluePrincipal principal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext context, String fileSuffix, boolean cacheUrl) throws SystemException {
        String cachedAssetUrl;
        String pageAsDigitalAssetUrl = null;
        String pageUrl = null;
        String pageContent = null;
        String fileName = null;
        boolean fullUrl = context.getUseFullUrl();
        context.setUseFullUrl(true);
        boolean disableNiceUri = context.getDisableNiceUri();
        context.setDisableNiceUri(true);
        String assetCacheKey = "pageAsDigitalAssetUrl_" + siteNodeId + "_" + languageId + "_" + contentId + "_" + fileSuffix;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetUrlCache";
        if (cacheUrl && (cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey)) != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            context.setDisableNiceUri(disableNiceUri);
            context.setUseFullUrl(fullUrl);
            return cachedAssetUrl;
        }
        try {
            try {
                int i = 0;
                String filePath = CmsPropertyHandler.getDigitalAssetPath0();
                while (filePath != null) {
                    try {
                        if (pageContent == null) {
                            pageUrl = this.getPageUrl(database, principal, siteNodeId, languageId, contentId, context);
                            logger.info((Object)("pageUrl:" + pageUrl));
                            pageUrl = pageUrl.replaceAll("&amp;", "&");
                            pageUrl = pageUrl.indexOf("&") > -1 ? String.valueOf(pageUrl) + "&includeUsedEntities=true" : String.valueOf(pageUrl) + "?includeUsedEntities=true";
                            logger.info((Object)("pageUrl:" + pageUrl));
                            HashMap<String, String> headers = new HashMap<String, String>();
                            Enumeration headersEnumeration = context.getHttpServletRequest().getHeaderNames();
                            while (headersEnumeration.hasMoreElements()) {
                                String headerName = (String)headersEnumeration.nextElement();
                                String headerValue = context.getHttpServletRequest().getHeader(headerName);
                                logger.info((Object)(String.valueOf(headerName) + "=" + headerValue));
                                headers.put(headerName, headerValue);
                            }
                            headers.put("User-Agent", String.valueOf(context.getHttpServletRequest().getHeader("User-Agent")) + ";Java");
                            HttpHelper helper = new HttpHelper();
                            pageContent = helper.getUrlContent(pageUrl, headers, 3000);
                            logger.info((Object)("pageContent:" + pageContent));
                            int usedEntitiesIndex = pageContent.indexOf("<usedEntities>");
                            if (usedEntitiesIndex > -1) {
                                int usedEntitiesEndIndex = pageContent.indexOf("</usedEntities>");
                                String usedEntities = pageContent.substring(usedEntitiesIndex + 14, usedEntitiesEndIndex);
                                logger.info((Object)("usedEntities:" + usedEntities));
                                String[] usedEntitiesArray = usedEntities.split(",");
                                int j = 0;
                                while (j < usedEntitiesArray.length) {
                                    String entity = usedEntitiesArray[j];
                                    logger.info((Object)("entity:" + entity));
                                    if (entity.indexOf("content_") > -1) {
                                        context.addUsedContent(entity);
                                    } else if (entity.indexOf("contentVersion_") > -1) {
                                        context.addUsedContentVersion(entity);
                                    } else if (entity.indexOf("siteNode_") > -1) {
                                        context.addUsedSiteNode(entity);
                                    } else if (entity.indexOf("siteNodeVersion_") > -1) {
                                        context.addUsedSiteNodeVersion(entity);
                                    }
                                    ++j;
                                }
                            }
                            fileName = pageContent.hashCode() + (fileSuffix == null ? "" : "." + fileSuffix);
                            logger.info((Object)("fileName:" + fileName));
                        }
                        DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAttributeToFile(pageContent, fileName, filePath);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An file could not be written or the content could not be fetched from the url:" + pageUrl + " - reason: " + e.getMessage()), (Throwable)e);
                        context.setDisablePageCache(true);
                    }
                    filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                }
                SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(database, siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                pageAsDigitalAssetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, fileName, context);
                if (cacheUrl) {
                    CacheController.cacheObject(cacheName, assetCacheKey, pageAsDigitalAssetUrl);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("An error occurred when we fetched the url which we wanted to persist as an digital asset: " + e.getMessage()), (Throwable)e);
                throw new SystemException("An error occurred when we fetched the url which we wanted to persist as an digital asset: " + e.getMessage(), e);
            }
        }
        finally {
            context.setDisableNiceUri(disableNiceUri);
            context.setUseFullUrl(fullUrl);
        }
        return pageAsDigitalAssetUrl;
    }

    public String getPagePath(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, String bindingName, String attributeName, boolean useLanguageFallBack, DeliveryContext deliveryContext) throws SystemException, Exception {
        String pagePath = "/";
        SiteNodeVO parentSiteNode = this.getParentSiteNode(db, siteNodeId);
        if (parentSiteNode != null) {
            pagePath = String.valueOf(this.getPagePath(db, infoGluePrincipal, parentSiteNode.getId(), languageId, null, bindingName, attributeName, useLanguageFallBack, deliveryContext)) + "/";
        }
        pagePath = String.valueOf(pagePath) + this.getPageNavigationTitle(db, infoGluePrincipal, siteNodeId, languageId, contentId, bindingName, attributeName, useLanguageFallBack, deliveryContext, false);
        pagePath = pagePath.replaceAll(" ", "_");
        return pagePath;
    }

    public String getPageBaseUrl(Database db) throws SystemException {
        String pageUrl = "";
        SiteNode siteNode = this.getSiteNode(db, this.siteNodeId);
        String dnsName = CmsPropertyHandler.getWebServerAddress();
        if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
            dnsName = siteNode.getRepository().getDnsName();
        }
        pageUrl = this.urlComposer.composePageBaseUrl(dnsName);
        return pageUrl;
    }

    public String getPageNavigationTitle(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, String metaBindingName, String attributeName, boolean useLanguageFallback, DeliveryContext deliveryContext, boolean escapeHTML) throws SystemException, Exception {
        String navTitle = "";
        if (contentId == null || contentId == -1) {
            ContentVO content = this.getBoundContent(db, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, metaBindingName, deliveryContext);
            if (content != null) {
                navTitle = ContentDeliveryController.getContentDeliveryController().getContentAttribute(db, content.getContentId(), languageId, attributeName, siteNodeId, useLanguageFallback, deliveryContext, infoGluePrincipal, escapeHTML);
            }
        } else {
            navTitle = ContentDeliveryController.getContentDeliveryController().getContentAttribute(db, contentId, languageId, attributeName, siteNodeId, useLanguageFallback, deliveryContext, infoGluePrincipal, escapeHTML);
        }
        return navTitle;
    }

    public Integer getSiteNodeId(Database db, InfoGluePrincipal infogluePrincipal, Integer repositoryId, String path, String attributeName, Integer parentSiteNodeId, Integer languageId, DeliveryContext deliveryContext) throws SystemException, Exception {
        if (repositoryId == null || repositoryId == -1) {
            repositoryId = RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(db).getRepositoryId();
            logger.info((Object)("RepositoryId not specifed - Resolved master repository to " + repositoryId));
        }
        if (repositoryId == null) {
            throw new SystemException("No repository given and unable to resolve master repository");
        }
        List languages = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguagesForRepository(db, repositoryId);
        List siteNodes = new ArrayList<SiteNodeVO>();
        if (parentSiteNodeId == null || parentSiteNodeId == -1) {
            SiteNodeVO rootSiteNodeVO = this.getRootSiteNode(db, repositoryId);
            siteNodes.add(rootSiteNodeVO);
        } else {
            siteNodes = this.getChildSiteNodes(db, parentSiteNodeId);
        }
        for (SiteNodeVO siteNodeVO : siteNodes) {
            if (path == null || path.length() == 0) {
                logger.info((Object)("Returning siteNode:" + siteNodeVO.getName()));
                return siteNodeVO.getId();
            }
            logger.info((Object)("Continued with siteNode: " + siteNodeVO.getName()));
            if (siteNodeVO.getMetaInfoContentId() == null) {
                throw new SystemException("The site node " + siteNodeVO.getName() + "(" + siteNodeVO.getId() + ") had no meta info. Fix this by editing the site node. Should never happen.");
            }
            ContentVO content = ContentDeliveryController.getContentDeliveryController().getContentVO(db, siteNodeVO.getMetaInfoContentId(), deliveryContext);
            if (content != null) {
                String pathCandidate = null;
                int i = 0;
                while (i < languages.size()) {
                    LanguageVO language = (LanguageVO)languages.get(i);
                    if (attributeName.equals("SiteNode.name")) {
                        pathCandidate = siteNodeVO.getName();
                    } else {
                        pathCandidate = ContentDeliveryController.getContentDeliveryController().getContentAttribute(db, content.getContentId(), language.getLanguageId(), attributeName, siteNodeVO.getSiteNodeId(), true, deliveryContext, infogluePrincipal, false);
                        if ((pathCandidate == null || pathCandidate.equals("")) && !attributeName.equals(NAV_TITLE_ATTRIBUTE_NAME)) {
                            pathCandidate = ContentDeliveryController.getContentDeliveryController().getContentAttribute(db, content.getContentId(), language.getLanguageId(), NAV_TITLE_ATTRIBUTE_NAME, siteNodeVO.getSiteNodeId(), true, deliveryContext, infogluePrincipal, false);
                        }
                    }
                    logger.info((Object)(String.valueOf(attributeName) + " [" + pathCandidate.trim() + "]==[" + path + "]"));
                    if (pathCandidate != null && pathCandidate.toLowerCase().trim().equals(path.toLowerCase())) {
                        return siteNodeVO.getSiteNodeId();
                    }
                    ++i;
                }
                continue;
            }
            throw new SystemException("You must run validation service in the management tool against this db - it needs to become up2date with the new model.");
        }
        return null;
    }

    public String getPageNavigationPath(Database db, InfoGluePrincipal infogluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext deliveryContext) throws SystemException, Exception {
        String pathPart;
        String attributeName;
        StringBuffer path = null;
        SiteNodeVO parentSiteNode = this.getParentSiteNode(db, siteNodeId);
        if (parentSiteNode == null) {
            return "";
        }
        path = new StringBuffer(this.getPageNavigationPath(db, infogluePrincipal, parentSiteNode.getId(), languageId, null, deliveryContext)).append("/");
        String niceURIEncoding = CmsPropertyHandler.getNiceURIEncoding();
        if (niceURIEncoding == null || niceURIEncoding.length() == 0) {
            niceURIEncoding = "UTF-8";
        }
        if ((attributeName = ViewPageFilter.attributeName).equals("SiteNode.name")) {
            SiteNode siteNode = this.getSiteNode(db, siteNodeId);
            pathPart = siteNode.getName();
        } else {
            pathPart = this.getPageNavigationTitle(db, infogluePrincipal, siteNodeId, languageId, null, META_INFO_BINDING_NAME, attributeName, true, deliveryContext, false);
            if ((pathPart == null || pathPart.equals("")) && !attributeName.equals(NAV_TITLE_ATTRIBUTE_NAME)) {
                pathPart = this.getPageNavigationTitle(db, infogluePrincipal, siteNodeId, languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, deliveryContext, false);
            }
        }
        String key = pathPart + "_" + niceURIEncoding;
        String encodedPath = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", key);
        if (encodedPath == null) {
            encodedPath = URLEncoder.encode(pathPart, niceURIEncoding);
            CacheController.cacheObjectInAdvancedCache("encodedStringsCache", key, encodedPath);
        }
        path.append(encodedPath);
        return path.toString();
    }

    public static Integer getSiteNodeIdFromPath(Database db, InfoGluePrincipal infogluePrincipal, RepositoryVO repositoryVO, String[] path, String attributeName, Integer languageId, DeliveryContext deliveryContext) throws SystemException, Exception {
        Integer siteNodeId = null;
        URIMapperCache uriCache = URIMapperCache.getInstance();
        int idx = path.length;
        while (idx >= 0) {
            siteNodeId = uriCache.getCachedSiteNodeId(repositoryVO.getId(), path, idx);
            if (siteNodeId != null) break;
            --idx;
        }
        String repositoryPath = null;
        int pathStartIndex = repositoryVO.getDnsName().indexOf("path=");
        if (pathStartIndex != -1) {
            repositoryPath = repositoryVO.getDnsName().substring(pathStartIndex + 5);
        }
        logger.info((Object)("repositoryPath:" + repositoryPath));
        logger.info((Object)("path:" + path.length));
        if (repositoryPath != null && path.length > 0) {
            String[] repositoryPaths = repositoryPath.split("/");
            String[] newPath = path;
            logger.info((Object)("repositoryPaths:" + repositoryPaths.length));
            logger.info((Object)("newPath:" + newPath.length));
            int repPathIndex = 0;
            while (repPathIndex < repositoryPaths.length) {
                String repPath = repositoryPaths[repPathIndex];
                logger.info((Object)("repPath:" + repPath));
                if (path.length > repPathIndex) {
                    logger.info((Object)("path:" + path[repPathIndex]));
                    if (path[repPathIndex].equals(repPath)) {
                        String[] tempNewPath = new String[newPath.length - 1];
                        int i = 1;
                        while (i < newPath.length) {
                            tempNewPath[i - 1] = newPath[i];
                            ++i;
                        }
                        newPath = tempNewPath;
                    }
                }
                ++repPathIndex;
            }
            path = newPath;
        }
        logger.info((Object)("new path:" + path.length));
        int i = idx;
        while (i < path.length) {
            siteNodeId = i < 0 ? NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNodeId(db, infogluePrincipal, repositoryVO.getId(), null, attributeName, null, languageId, deliveryContext) : NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNodeId(db, infogluePrincipal, repositoryVO.getId(), path[i], attributeName, siteNodeId, languageId, deliveryContext);
            if (siteNodeId != null) {
                uriCache.addCachedSiteNodeId(repositoryVO.getId(), path, i + 1, siteNodeId);
            }
            ++i;
        }
        return siteNodeId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer getSiteNodeIdFromPath(InfoGluePrincipal infogluePrincipal, RepositoryVO repositoryVO, String[] path, String attributeName, Integer languageId, DeliveryContext deliveryContext) throws SystemException, Exception {
        Integer siteNodeId = null;
        Database db = CastorDatabaseService.getDatabase();
        NodeDeliveryController.beginTransaction(db);
        try {
            String[] repositoryPaths;
            URIMapperCache uriCache = URIMapperCache.getInstance();
            int numberOfPaths = path.length;
            while (numberOfPaths >= 0) {
                siteNodeId = uriCache.getCachedSiteNodeId(repositoryVO.getId(), path, numberOfPaths);
                if (siteNodeId != null) break;
                --numberOfPaths;
            }
            String repositoryPath = null;
            int pathStartIndex = repositoryVO.getDnsName().indexOf("path=");
            if (pathStartIndex != -1) {
                repositoryPath = repositoryVO.getDnsName().substring(pathStartIndex + 5);
            }
            logger.info((Object)("repositoryPath:" + repositoryPath));
            logger.info((Object)("path:" + path.length));
            if (repositoryPath != null && path.length <= 0) {
                if (!logger.isInfoEnabled()) return null;
                logger.info((Object)("There was a repository path:" + repositoryPath + " but the path.length was " + path.length + " so this repository should be excluded."));
                return null;
            }
            if (repositoryPath != null && path.length > 0) {
                repositoryPaths = repositoryPath.split("/");
                int i = 0;
                while (i < repositoryPaths.length) {
                    String repositoryPathPart = repositoryPaths[i];
                    String pathPart = path[i];
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("repositoryPathPart:" + repositoryPathPart));
                        logger.info((Object)("pathPart:" + pathPart));
                    }
                    if (!repositoryPathPart.equalsIgnoreCase(pathPart)) {
                        if (!logger.isInfoEnabled()) return null;
                        logger.info((Object)"Could not match the repository paths so this repository should be excluded.");
                        return null;
                    }
                    ++i;
                }
            }
            if (repositoryPath != null && path.length > 0) {
                repositoryPaths = repositoryPath.split("/");
                String[] newPath = path;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("repositoryPaths:" + repositoryPaths.length));
                    logger.info((Object)("newPath:" + newPath.length));
                }
                int repPathIndex = 0;
                while (repPathIndex < repositoryPaths.length) {
                    String repPath = repositoryPaths[repPathIndex];
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("repPath:" + repPath));
                    }
                    if (path.length > repPathIndex) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("path:" + path[repPathIndex]));
                        }
                        if (path[repPathIndex].equals(repPath)) {
                            String[] tempNewPath = new String[newPath.length - 1];
                            int i = 1;
                            while (i < newPath.length) {
                                tempNewPath[i - 1] = newPath[i];
                                ++i;
                            }
                            newPath = tempNewPath;
                        }
                    }
                    ++repPathIndex;
                }
                path = newPath;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("new path:" + path.length));
                logger.info((Object)("numberOfPaths = " + numberOfPaths));
            }
            int i = numberOfPaths;
            while (i < path.length) {
                if (i < 0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Getting root node");
                    }
                    siteNodeId = NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNodeId(db, infogluePrincipal, repositoryVO.getId(), null, attributeName, null, languageId, deliveryContext);
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Getting normal");
                    }
                    siteNodeId = NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNodeId(db, infogluePrincipal, repositoryVO.getId(), path[i], attributeName, siteNodeId, languageId, deliveryContext);
                }
                if (siteNodeId != null) {
                    uriCache.addCachedSiteNodeId(repositoryVO.getId(), path, i + 1, siteNodeId);
                }
                ++i;
            }
            NodeDeliveryController.commitTransaction(db);
            return siteNodeId;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            NodeDeliveryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        finally {
            NodeDeliveryController.rollbackTransaction(db);
            NodeDeliveryController.closeDatabase(db);
        }
    }

    public Integer getMetaInfoContentId(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, String metaBindingName, boolean inheritParentBindings, DeliveryContext deliveryContext) throws SystemException, Exception {
        ContentVO content = this.getBoundContent(db, infoGluePrincipal, siteNodeId, this.languageId, true, metaBindingName, inheritParentBindings, deliveryContext);
        if (content != null) {
            return content.getContentId();
        }
        return null;
    }

    public static SiteNodeVO getRootSiteNode(Database db, String repositoryName) throws SystemException, Exception {
        if (repositoryName == null) {
            repositoryName = RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(db).getName();
            logger.info((Object)("Fetched name of master repository as none were given:" + repositoryName));
        }
        SiteNode siteNode = null;
        logger.info((Object)("Fetching the root siteNode for the repository " + repositoryName));
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl c WHERE is_undefined(c.parentSiteNode) AND c.repository.name = $1");
        oql.bind((Object)repositoryName);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            siteNode = (SiteNode)results.next();
            logger.info((Object)("The root node was found:" + siteNode.getName()));
        }
        results.close();
        oql.close();
        logger.info((Object)("siteNode:" + siteNode));
        return siteNode == null ? null : siteNode.getValueObject();
    }

    public SiteNodeVO getRootSiteNode(Database db, Integer repositoryId) throws SystemException, Exception {
        SiteNodeVO siteNodeVO = null;
        String key = "" + repositoryId;
        logger.info((Object)("key in getRootSiteNode:" + key));
        siteNodeVO = (SiteNodeVO)CacheController.getCachedObject("rootSiteNodeCache", key);
        if (siteNodeVO != null) {
            logger.info((Object)("There was an cached master root siteNode:" + siteNodeVO.getName()));
        } else {
            if (repositoryId == null) {
                repositoryId = RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(db).getRepositoryId();
                logger.info((Object)("Fetched name of master repository as none were given:" + repositoryId));
            }
            logger.info((Object)("Fetching the root siteNode for the repository " + repositoryId));
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl c WHERE is_undefined(c.parentSiteNode) AND c.repository = $1");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                siteNodeVO = ((SiteNode)results.next()).getValueObject();
                logger.info((Object)("The root node was found:" + siteNodeVO.getName()));
            }
            results.close();
            oql.close();
            logger.info((Object)("siteNodeVO:" + siteNodeVO));
            CacheController.cacheObject("rootSiteNodeCache", key, siteNodeVO);
        }
        return siteNodeVO;
    }

    public List getChildSiteNodes(Database db, Integer siteNodeId) throws SystemException, Exception {
        if (siteNodeId == null) {
            return null;
        }
        String key = "" + siteNodeId;
        logger.info((Object)("key in getChildSiteNodes:" + key));
        ArrayList<SiteNodeVO> siteNodeVOList = (ArrayList<SiteNodeVO>)CacheController.getCachedObject("childSiteNodesCache", key);
        if (siteNodeVOList != null) {
            logger.info((Object)("There was a cached list of child sitenodes:" + siteNodeVOList.size()));
        } else {
            siteNodeVOList = new ArrayList<SiteNodeVO>();
            OQLQuery oql = db.getOQLQuery("SELECT s FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeImpl s WHERE s.parentSiteNode.siteNodeId = $1 ORDER BY s.siteNodeId");
            oql.bind((Object)siteNodeId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                SiteNode siteNode = (SiteNode)results.next();
                if (!this.isValidSiteNode(siteNode, db)) continue;
                siteNodeVOList.add(siteNode.getValueObject());
            }
            results.close();
            oql.close();
            CacheController.cacheObject("childSiteNodesCache", key, siteNodeVOList);
        }
        return siteNodeVOList;
    }

    private List getBindingQualifyers(Integer serviceBindingId, Database db) throws SystemException, Bug, Exception {
        ArrayList<Qualifyer> qualifyers = new ArrayList<Qualifyer>();
        OQLQuery oql = db.getOQLQuery("SELECT q FROM org.infoglue.cms.entities.structure.impl.simple.QualifyerImpl q WHERE q.serviceBinding.serviceBindingId = $1 ORDER BY q.sortOrder");
        oql.bind((Object)serviceBindingId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            Qualifyer qualifyer = (Qualifyer)results.next();
            qualifyers.add(qualifyer);
        }
        results.close();
        oql.close();
        return qualifyers;
    }

    private boolean isValidOnDates(Date publishDate, Date expireDate) {
        boolean isValid = true;
        Date now = new Date();
        if (publishDate.after(now) || expireDate.before(now)) {
            isValid = false;
        }
        return isValid;
    }

    public boolean isValidSiteNode(Database db, Integer siteNodeId) throws Exception {
        boolean isValidSiteNode = false;
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        isValidSiteNode = this.isValidSiteNode(siteNode, db);
        return isValidSiteNode;
    }

    public boolean isValidSiteNode(SiteNode siteNode, Database db) throws Exception {
        boolean isValidContent = false;
        if (this.isValidOnDates(siteNode.getPublishDateTime(), siteNode.getExpireDateTime()) && this.getLatestActiveSiteNodeVersion(siteNode.getId(), db) != null) {
            isValidContent = true;
        }
        if (isValidContent && !siteNode.getExpireDateTime().before(new Date())) {
            Date expireDateTimeCandidate = siteNode.getExpireDateTime();
            if (CacheController.expireDateTime == null || expireDateTimeCandidate.before(CacheController.expireDateTime)) {
                CacheController.expireDateTime = expireDateTimeCandidate;
            }
        } else if (siteNode.getPublishDateTime().after(new Date())) {
            Date publishDateTimeCandidate = siteNode.getPublishDateTime();
            if (CacheController.publishDateTime == null || publishDateTimeCandidate.after(CacheController.publishDateTime)) {
                CacheController.publishDateTime = publishDateTimeCandidate;
            }
        }
        return isValidContent;
    }

    private List sortQualifyers(Collection qualifyers) {
        ArrayList<Qualifyer> sortedQualifyers = new ArrayList<Qualifyer>();
        try {
            for (Qualifyer qualifyer : qualifyers) {
                int index = 0;
                for (Qualifyer sortedQualifyer : sortedQualifyers) {
                    if (sortedQualifyer.getSortOrder() > qualifyer.getSortOrder()) break;
                    ++index;
                }
                sortedQualifyers.add(index, qualifyer);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("The sorting of qualifyers failed:" + e.getMessage()), (Throwable)e);
        }
        return sortedQualifyers;
    }
}

