/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class LanguageDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)LanguageDeliveryController.class.getName());
    private static final LanguageDeliveryController languageDeliveryController = new LanguageDeliveryController();

    private LanguageDeliveryController() {
    }

    public static LanguageDeliveryController getLanguageDeliveryController() {
        return languageDeliveryController;
    }

    public LanguageVO getLanguageVO(Database db, Integer languageId) throws SystemException, Exception {
        if (languageId == null || languageId == 0) {
            return null;
        }
        String key = "" + languageId;
        logger.info((Object)("key:" + key));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("languageCache", key);
        if (languageVO != null) {
            logger.info((Object)("There was an cached languageVO:" + languageVO));
        } else {
            Language language = (Language)this.getObjectWithId(LanguageImpl.class, languageId, db);
            if (language != null) {
                languageVO = language.getValueObject();
            }
            CacheController.cacheObject("languageCache", key, languageVO);
        }
        return languageVO;
    }

    public List getAvailableLanguagesForRepository(Database db, Integer repositoryId) throws SystemException, Exception {
        String key = repositoryId + "_allLanguages";
        logger.info((Object)("key:" + key));
        ArrayList<LanguageVO> list = (ArrayList<LanguageVO>)CacheController.getCachedObject("languageCache", key);
        if (list != null) {
            logger.info((Object)("There was an cached list:" + list));
        } else {
            list = new ArrayList<LanguageVO>();
            Repository repository = (Repository)this.getObjectWithId(RepositoryImpl.class, repositoryId, db);
            if (repository != null) {
                for (RepositoryLanguage repositoryLanguage : repository.getRepositoryLanguages()) {
                    Language language = repositoryLanguage.getLanguage();
                    if (language == null) continue;
                    list.add(language.getValueObject());
                }
            }
            if (list.size() > 0) {
                CacheController.cacheObject("languageCache", key, list);
            }
        }
        return list;
    }

    public List getAvailableLanguages(Database db, Integer siteNodeId) throws SystemException, Exception {
        RepositoryImpl repository;
        logger.info((Object)("getAvailableLanguages for " + siteNodeId + " start."));
        ArrayList<LanguageVO> languageVOList = new ArrayList<LanguageVO>();
        logger.info((Object)("siteNodeId:" + siteNodeId));
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        if (siteNode != null && (repository = siteNode.getRepository()) != null) {
            logger.info((Object)("repository:" + repository.getName()));
            Collection repositoryLanguages = repository.getRepositoryLanguages();
            logger.info((Object)("repositoryLanguages:" + repositoryLanguages.size()));
            for (RepositoryLanguage repositoryLanguage : repositoryLanguages) {
                Language language = repositoryLanguage.getLanguage();
                if (language == null) continue;
                logger.info((Object)("Adding " + language.getName() + " to the list of available languages"));
                languageVOList.add(language.getValueObject());
            }
        }
        logger.info((Object)("getAvailableLanguages for " + siteNodeId + " end."));
        return languageVOList;
    }

    public LanguageVO getMasterLanguage(Database db, String repositoryName) throws SystemException, Exception {
        Language language = null;
        OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.name = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
        oql.bind((Object)repositoryName);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            language = (Language)results.next();
        }
        results.close();
        oql.close();
        return language == null ? null : language.getValueObject();
    }

    public LanguageVO getMasterLanguageForRepository(Database db, Integer repositoryId) throws SystemException, Exception {
        String languageKey = "" + repositoryId;
        logger.info((Object)("languageKey in getMasterLanguageForRepository:" + languageKey));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.repositoryId = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                Language language = (Language)results.next();
                languageVO = language.getValueObject();
            }
            results.close();
            oql.close();
            CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
        }
        return languageVO;
    }

    public LanguageVO getMasterLanguageForRepository(Integer repositoryId, Database db) throws SystemException, Exception {
        LanguageVO languageVO = null;
        String languageKey = "" + repositoryId;
        logger.info((Object)("languageKey in getMasterLanguageForRepository:" + languageKey));
        languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.repositoryId = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                Language language = (Language)results.next();
                languageVO = language.getValueObject();
            }
            results.close();
            oql.close();
            CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
        }
        return languageVO;
    }

    public LanguageVO getMasterLanguageForSiteNode(Database db, Integer siteNodeId) throws SystemException, Exception {
        String languageKey = "siteNodeId_" + siteNodeId;
        logger.info((Object)("languageKey in getMasterLanguageForSiteNode:" + languageKey));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
            Integer repositoryId = siteNode.getRepository().getRepositoryId();
            OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.repositoryId = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                Language language = (Language)results.next();
                languageVO = language.getValueObject();
            }
            results.close();
            oql.close();
            CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
        }
        return languageVO;
    }

    public LanguageVO getMasterLanguageForSiteNodeWithValityCheck(Database db, NodeDeliveryController ndc, Integer siteNodeId) throws SystemException, Exception {
        String languageKey = "validLanguage_siteNodeId_" + siteNodeId;
        logger.info((Object)("languageKey in getMasterLanguageForSiteNode:" + languageKey));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
            Integer repositoryId = siteNode.getRepository().getRepositoryId();
            OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.repositoryId = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Language language = (Language)results.next();
                LanguageVO languageVOCandidate = language.getValueObject();
                if (!this.getIsValidLanguage(db, ndc, siteNode, languageVOCandidate.getId())) continue;
                languageVO = languageVOCandidate;
                break;
            }
            results.close();
            oql.close();
            if (languageVO != null) {
                CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
            }
        }
        return languageVO;
    }

    public Locale getLocaleWithId(Database db, Integer languageId) {
        String key = "" + languageId;
        logger.info((Object)("key:" + key));
        Locale locale = (Locale)CacheController.getCachedObject("localeCache", key);
        if (locale != null) {
            logger.info((Object)("There was an cached locale:" + locale));
        } else {
            locale = Locale.getDefault();
            if (languageId != null) {
                try {
                    LanguageVO languageVO = this.getLanguageVO(db, languageId);
                    locale = new Locale(languageVO.getLanguageCode());
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred in getLocaleWithId: getting locale with languageid:" + languageId + "," + e), (Throwable)e);
                }
            }
            CacheController.cacheObject("localeCache", key, locale);
        }
        return locale;
    }

    public Locale getLocaleWithCode(String languageCode) {
        String key = languageCode;
        logger.info((Object)("key:" + key));
        Locale locale = (Locale)CacheController.getCachedObject("localeCache", key);
        if (locale != null) {
            logger.info((Object)("There was an cached locale:" + locale));
        } else {
            locale = Locale.getDefault();
            if (languageCode != null) {
                try {
                    locale = new Locale(languageCode);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred in getLocaleWithCode: getting locale with languageCode:" + languageCode + "," + e), (Throwable)e);
                }
            }
            CacheController.cacheObject("localeCache", key, locale);
        }
        return locale;
    }

    public LanguageVO getLanguageWithCode(Database db, String languageCode) throws SystemException, Exception {
        String key = languageCode;
        logger.info((Object)("key:" + key));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("languageCache", key);
        if (languageVO != null) {
            logger.info((Object)("There was an cached languageVO:" + languageVO));
        } else {
            Language language = null;
            OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.languageCode = $1");
            oql.bind((Object)languageCode);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                language = (Language)results.next();
                languageVO = language.getValueObject();
            }
            results.close();
            oql.close();
            CacheController.cacheObject("languageCache", key, languageVO);
        }
        return languageVO;
    }

    public LanguageVO getLanguageIfRepositorySupportsIt(Database db, String languageCodes, Integer siteNodeId) throws SystemException, Exception {
        if (languageCodes == null) {
            return null;
        }
        int index = Integer.MAX_VALUE;
        int currentIndex = 0;
        logger.info((Object)("Coming in with languageCodes:" + languageCodes));
        Language language = null;
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        RepositoryImpl repository = siteNode.getRepository();
        if (repository != null) {
            Collection languages = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : languages) {
                Language currentLanguage = repositoryLanguage.getLanguage();
                logger.info((Object)("CurrentLanguageCode:" + currentLanguage.getLanguageCode()));
                currentIndex = languageCodes.toLowerCase().indexOf(currentLanguage.getLanguageCode().toLowerCase());
                if (currentIndex <= -1 || currentIndex >= index) continue;
                index = currentIndex;
                logger.info((Object)("Found the language in the list of supported languages for this site: " + currentLanguage.getName() + " - priority:" + index));
                language = currentLanguage;
                if (index == 0) break;
            }
        }
        return language == null ? null : language.getValueObject();
    }

    public LanguageVO getLanguageIfSiteNodeSupportsIt(Database db, String languageCodes, Integer siteNodeId, InfoGluePrincipal principal) throws SystemException, Exception {
        if (languageCodes == null) {
            return null;
        }
        String key = siteNodeId + "_" + languageCodes;
        Object languageVOCandidate = CacheController.getCachedObject("siteNodeLanguageCache", key);
        if (languageVOCandidate != null) {
            if (languageVOCandidate instanceof NullObject) {
                return null;
            }
            return (LanguageVO)languageVOCandidate;
        }
        int index = Integer.MAX_VALUE;
        int currentIndex = 0;
        logger.info((Object)("Coming in with languageCodes:" + languageCodes));
        Language language = null;
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        RepositoryImpl repository = siteNode.getRepository();
        if (repository != null) {
            Collection languages = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : languages) {
                ContentVersionVO contentVersionVO;
                Language currentLanguage = repositoryLanguage.getLanguage();
                logger.info((Object)("CurrentLanguageCode:" + currentLanguage.getLanguageCode()));
                NodeDeliveryController ndc = NodeDeliveryController.getNodeDeliveryController(siteNodeId, currentLanguage.getId(), new Integer(-1));
                currentIndex = languageCodes.toLowerCase().indexOf(currentLanguage.getLanguageCode().toLowerCase());
                if (!this.getIsValidLanguage(db, ndc, siteNode, currentLanguage.getId()) || currentIndex <= -1 || currentIndex >= index) continue;
                index = currentIndex;
                logger.info((Object)("Found the language in the list of supported languages for this site: " + currentLanguage.getName() + " - priority:" + index));
                DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext();
                ContentVO contentVO = ndc.getBoundContent(db, principal, siteNodeId, currentLanguage.getId(), false, "Meta information", deliveryContext);
                if (contentVO != null && (contentVersionVO = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(db, siteNodeId, contentVO.getId(), currentLanguage.getId(), false, deliveryContext, principal)) != null) {
                    language = currentLanguage;
                    logger.info((Object)("Language now: " + language.getName()));
                }
                if (index == 0) break;
            }
        }
        if (language != null) {
            CacheController.cacheObject("siteNodeLanguageCache", key, language.getValueObject());
        } else {
            CacheController.cacheObject("siteNodeLanguageCache", key, new NullObject());
        }
        logger.info((Object)("Returning language: " + language));
        return language == null ? null : language.getValueObject();
    }

    public LanguageVO getLanguageIfSiteNodeSupportsIt(Database db, Integer languageId, Integer siteNodeId) throws SystemException, Exception {
        if (languageId == null) {
            return null;
        }
        String key = siteNodeId + "_" + languageId;
        Object languageVOCandidate = CacheController.getCachedObject("siteNodeLanguageCache", key);
        if (languageVOCandidate != null) {
            if (languageVOCandidate instanceof NullObject) {
                return null;
            }
            return (LanguageVO)languageVOCandidate;
        }
        NodeDeliveryController ndc = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, new Integer(-1));
        logger.info((Object)("Coming in with languageId:" + languageId));
        Language language = null;
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        if (!this.getIsValidLanguage(db, ndc, siteNode, languageId)) {
            return null;
        }
        RepositoryImpl repository = siteNode.getRepository();
        if (repository != null) {
            Collection languages = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : languages) {
                Language currentLanguage = repositoryLanguage.getLanguage();
                logger.info((Object)("CurrentLanguage:" + currentLanguage.getId()));
                if (currentLanguage.getId().intValue() != languageId.intValue()) continue;
                logger.info((Object)("Found the language in the list of supported languages for this site: " + currentLanguage.getName()));
                if (!this.getIsValidLanguage(db, ndc, siteNode, currentLanguage.getId())) continue;
                language = currentLanguage;
                break;
            }
        }
        if (language != null) {
            CacheController.cacheObject("siteNodeLanguageCache", key, language.getValueObject());
        } else {
            CacheController.cacheObject("siteNodeLanguageCache", key, new NullObject());
        }
        logger.info((Object)("Returning language: " + language));
        return language == null ? null : language.getValueObject();
    }

    public List getLanguagesForSiteNode(Database db, Integer siteNodeId, InfoGluePrincipal principal) throws SystemException, Exception {
        String key = "" + siteNodeId;
        ArrayList<LanguageVO> languageVOList = (ArrayList<LanguageVO>)CacheController.getCachedObject("siteNodeLanguageCache", key);
        if (languageVOList != null) {
            return languageVOList;
        }
        logger.info((Object)("Looking for languages on page with id:" + siteNodeId));
        languageVOList = new ArrayList<LanguageVO>();
        SiteNode siteNode = (SiteNode)this.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        RepositoryImpl repository = siteNode.getRepository();
        if (repository != null) {
            Collection languages = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : languages) {
                Language currentLanguage = repositoryLanguage.getLanguage();
                logger.info((Object)("CurrentLanguageCode:" + currentLanguage.getLanguageCode()));
                NodeDeliveryController ndc = NodeDeliveryController.getNodeDeliveryController(siteNodeId, currentLanguage.getId(), new Integer(-1));
                if (!this.getIsValidLanguage(db, ndc, siteNode, currentLanguage.getId())) continue;
                logger.info((Object)("Found the language in the list of supported languages for this site: " + currentLanguage.getName()));
                languageVOList.add(currentLanguage.getValueObject());
            }
        }
        if (languageVOList != null) {
            CacheController.cacheObject("siteNodeLanguageCache", key, languageVOList);
        }
        logger.info((Object)("Returning languageVOList: " + languageVOList.size()));
        return languageVOList;
    }

    public boolean getIsValidLanguage(Database db, NodeDeliveryController ndc, SiteNode siteNode, Integer languageId) throws Exception {
        boolean isValidLanguage = true;
        SiteNodeVersion siteNodeVersion = ndc.getLatestActiveSiteNodeVersion(siteNode.getId(), db);
        Integer disabledLanguagesSiteNodeVersionId = ndc.getDisabledLanguagesSiteNodeVersionId(db, siteNode.getId());
        logger.info((Object)("disabledLanguagesSiteNodeVersionId:" + disabledLanguagesSiteNodeVersionId));
        if (disabledLanguagesSiteNodeVersionId != null) {
            String enabledLanguagesString;
            SiteNodeVersion disabledLanguagesSiteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(disabledLanguagesSiteNodeVersionId, db);
            String disabledLanguagesString = CmsPropertyHandler.getPropertySetValue("siteNode_" + disabledLanguagesSiteNodeVersion.getValueObject().getSiteNodeId() + "_disabledLanguages");
            logger.info((Object)("disabledLanguagesString:" + disabledLanguagesString));
            if (disabledLanguagesString != null && !disabledLanguagesString.equalsIgnoreCase("")) {
                String[] disabledLanguagesStringArray = disabledLanguagesString.split(",");
                int i = 0;
                while (i < disabledLanguagesStringArray.length) {
                    logger.info((Object)("languageId.intValue():" + languageId));
                    logger.info((Object)("disabledLanguagesStringArray:" + disabledLanguagesStringArray));
                    if (languageId.intValue() == new Integer(disabledLanguagesStringArray[i]).intValue()) {
                        isValidLanguage = false;
                        logger.info((Object)("isValidLanguage:" + isValidLanguage));
                        break;
                    }
                    ++i;
                }
            }
            if ((enabledLanguagesString = CmsPropertyHandler.getPropertySetValue("siteNode_" + disabledLanguagesSiteNodeVersion.getValueObject().getSiteNodeId() + "_enabledLanguages")) != null && !enabledLanguagesString.equalsIgnoreCase("")) {
                isValidLanguage = false;
                String[] enabledLanguagesStringArray = enabledLanguagesString.split(",");
                int i = 0;
                while (i < enabledLanguagesStringArray.length) {
                    if (languageId.intValue() == new Integer(enabledLanguagesStringArray[i]).intValue()) {
                        isValidLanguage = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        logger.info((Object)("languageId:" + languageId + " was valid:" + isValidLanguage));
        return isValidLanguage;
    }
}

