/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeAttributeParameter;
import org.infoglue.cms.entities.management.ContentTypeAttributeParameterValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FormDeliveryController {
    private static final Logger logger = Logger.getLogger((String)FormDeliveryController.class.getName());

    private FormDeliveryController() {
    }

    public static FormDeliveryController getFormDeliveryController() {
        return new FormDeliveryController();
    }

    public List getContentTypeAttributes(String schemaValue) {
        logger.info((Object)("schemaValue:" + schemaValue));
        ArrayList<ContentTypeAttribute> attributes = new ArrayList<ContentTypeAttribute>();
        try {
            InputSource xmlSource = new InputSource(new StringReader(schemaValue));
            DOMParser parser = new DOMParser();
            parser.parse(xmlSource);
            Document document = parser.getDocument();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            int i = 0;
            while (i < anl.getLength()) {
                Element child = (Element)anl.item(i);
                String attributeName = child.getAttribute("name");
                String attributeType = child.getAttribute("type");
                ContentTypeAttribute contentTypeAttribute = new ContentTypeAttribute();
                contentTypeAttribute.setPosition(i);
                contentTypeAttribute.setName(attributeName);
                contentTypeAttribute.setInputType(attributeType);
                Node paramsNode = XPathAPI.selectSingleNode((Node)child, (String)"xs:annotation/xs:appinfo/params");
                if (paramsNode != null) {
                    NodeList childnl = ((Element)paramsNode).getElementsByTagName("param");
                    int ci = 0;
                    while (ci < childnl.getLength()) {
                        Element param = (Element)childnl.item(ci);
                        String paramId = param.getAttribute("id");
                        String paramInputTypeId = param.getAttribute("inputTypeId");
                        ContentTypeAttributeParameter contentTypeAttributeParameter = new ContentTypeAttributeParameter();
                        contentTypeAttributeParameter.setId(paramId);
                        if (paramInputTypeId != null && paramInputTypeId.length() > 0) {
                            contentTypeAttributeParameter.setType(Integer.parseInt(paramInputTypeId));
                        }
                        contentTypeAttribute.putContentTypeAttributeParameter(paramId, contentTypeAttributeParameter);
                        NodeList valuesNodeList = param.getElementsByTagName("values");
                        int vsnli = 0;
                        while (vsnli < valuesNodeList.getLength()) {
                            Element values = (Element)valuesNodeList.item(vsnli);
                            NodeList valueNodeList = param.getElementsByTagName("value");
                            int vnli = 0;
                            while (vnli < valueNodeList.getLength()) {
                                Element value = (Element)valueNodeList.item(vnli);
                                String valueId = value.getAttribute("id");
                                ContentTypeAttributeParameterValue contentTypeAttributeParameterValue = new ContentTypeAttributeParameterValue();
                                contentTypeAttributeParameterValue.setId(valueId);
                                NamedNodeMap nodeMap = value.getAttributes();
                                int nmi = 0;
                                while (nmi < nodeMap.getLength()) {
                                    Node attribute = nodeMap.item(nmi);
                                    String valueAttributeName = attribute.getNodeName();
                                    String valueAttributeValue = attribute.getNodeValue();
                                    contentTypeAttributeParameterValue.addAttribute(valueAttributeName, valueAttributeValue);
                                    ++nmi;
                                }
                                contentTypeAttributeParameter.addContentTypeAttributeParameterValue(valueId, contentTypeAttributeParameterValue);
                                ++vnli;
                            }
                            ++vsnli;
                        }
                        ++ci;
                    }
                }
                attributes.add(contentTypeAttribute);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the attributes of the content type: " + e.getMessage()), (Throwable)e);
        }
        return attributes;
    }
}

