/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.DigitalAssetDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;

public class ExtranetController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)ExtranetController.class.getName());

    private ExtranetController() {
    }

    public static ExtranetController getController() {
        return new ExtranetController();
    }

    public Principal getAuthenticatedPrincipal(Database db, Map request) throws Exception {
        InfoGluePrincipal principal = null;
        try {
            String authenticatorClass = InfoGlueAuthenticationFilter.authenticatorClass;
            String authorizerClass = InfoGlueAuthenticationFilter.authorizerClass;
            String invalidLoginUrl = InfoGlueAuthenticationFilter.invalidLoginUrl;
            String loginUrl = InfoGlueAuthenticationFilter.loginUrl;
            String serverName = InfoGlueAuthenticationFilter.serverName;
            Properties extraProperties = InfoGlueAuthenticationFilter.extraProperties;
            String casRenew = InfoGlueAuthenticationFilter.casRenew;
            String casServiceUrl = InfoGlueAuthenticationFilter.casServiceUrl;
            String casValidateUrl = InfoGlueAuthenticationFilter.casValidateUrl;
            String casProxyValidateUrl = InfoGlueAuthenticationFilter.casProxyValidateUrl;
            AuthenticationModule authenticationModule = (AuthenticationModule)Class.forName(authenticatorClass).newInstance();
            authenticationModule.setAuthenticatorClass(authenticatorClass);
            authenticationModule.setAuthorizerClass(authorizerClass);
            authenticationModule.setInvalidLoginUrl(invalidLoginUrl);
            authenticationModule.setLoginUrl(loginUrl);
            authenticationModule.setServerName(serverName);
            authenticationModule.setExtraProperties(extraProperties);
            authenticationModule.setCasRenew(casRenew);
            authenticationModule.setCasServiceUrl(casServiceUrl);
            authenticationModule.setCasValidateUrl(casValidateUrl);
            authenticationModule.setCasProxyValidateUrl(casProxyValidateUrl);
            authenticationModule.setTransactionObject(db);
            String authenticatedUserName = authenticationModule.authenticateUser(request);
            logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
            if (authenticatedUserName != null) {
                principal = UserControllerProxy.getController(db).getUser(authenticatedUserName);
            }
            logger.info((Object)("principal:" + principal));
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException("The login process failed: " + e.getMessage(), e);
        }
        return principal;
    }

    public Principal getAuthenticatedPrincipal(Map request) throws Exception {
        InfoGluePrincipal principal = null;
        try {
            String authenticatedUserName = AuthenticationModule.getAuthenticationModule(null, null).authenticateUser(request);
            logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
            if (authenticatedUserName != null) {
                principal = UserControllerProxy.getController().getUser(authenticatedUserName);
                logger.info((Object)("principal:" + principal));
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException("The login process failed: " + e.getMessage(), e);
        }
        return principal;
    }

    public String getPrincipalAssetUrl(Database db, InfoGluePrincipal infoGluePrincipal, String assetKey, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext) throws Exception {
        LanguageVO masterLanguageVO;
        SiteNode siteNode;
        Collection assets;
        String assetUrl = "";
        if (infoGluePrincipal == null || assetKey == null) {
            return null;
        }
        List userPropertiesList = UserPropertiesController.getController().getUserPropertiesList(infoGluePrincipal.getName(), languageId, db, true);
        logger.info((Object)("userProperties:" + userPropertiesList.size()));
        block0: for (UserProperties userProperties : userPropertiesList) {
            logger.info((Object)("userProperties:" + userProperties.getValue()));
            logger.info((Object)("assetKey:" + assetKey));
            if (userProperties == null || !userProperties.getLanguage().getLanguageId().equals(languageId)) continue;
            Collection assets2 = userProperties.getDigitalAssets();
            logger.info((Object)("assets:" + assets2.size()));
            for (DigitalAsset digitalAsset : assets2) {
                logger.info((Object)("digitalAsset:" + digitalAsset.getAssetKey()));
                if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                SiteNode siteNode2 = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetUrl(digitalAsset, siteNode2.getRepository(), deliveryContext);
                logger.info((Object)("assetUrl:" + assetUrl));
                continue block0;
            }
        }
        if (assetUrl.equals("")) {
            List roles = infoGluePrincipal.getRoles();
            for (InfoGlueRole role : roles) {
                List rolePropertiesList = RolePropertiesController.getController().getRolePropertiesList(role.getName(), languageId, db, true);
                block3: for (RoleProperties roleProperties : rolePropertiesList) {
                    if (roleProperties == null || !roleProperties.getLanguage().getLanguageId().equals(languageId)) continue;
                    assets = roleProperties.getDigitalAssets();
                    for (DigitalAsset digitalAsset : assets) {
                        if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                        siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                        assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetUrl(digitalAsset, siteNode.getRepository(), deliveryContext);
                        continue block3;
                    }
                }
            }
            if (assetUrl.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                return this.getPrincipalAssetUrl(db, infoGluePrincipal, assetKey, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, deliveryContext);
            }
        }
        if (assetUrl.equals("")) {
            List groups = infoGluePrincipal.getGroups();
            for (InfoGlueGroup group : groups) {
                List groupPropertiesList = GroupPropertiesController.getController().getGroupPropertiesList(group.getName(), languageId, db, true);
                block6: for (GroupProperties groupProperties : groupPropertiesList) {
                    if (groupProperties == null || !groupProperties.getLanguage().getLanguageId().equals(languageId)) continue;
                    assets = groupProperties.getDigitalAssets();
                    for (DigitalAsset digitalAsset : assets) {
                        if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                        siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                        assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetUrl(digitalAsset, siteNode.getRepository(), deliveryContext);
                        continue block6;
                    }
                }
            }
            if (assetUrl.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                return this.getPrincipalAssetUrl(db, infoGluePrincipal, assetKey, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, deliveryContext);
            }
        }
        return assetUrl;
    }

    public String getPrincipalThumbnailAssetUrl(Database db, InfoGluePrincipal infoGluePrincipal, String assetKey, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, int width, int height, DeliveryContext deliveryContext) throws Exception {
        LanguageVO masterLanguageVO;
        SiteNode siteNode;
        Collection assets;
        String assetUrl = "";
        if (infoGluePrincipal == null || assetKey == null) {
            return null;
        }
        List userPropertiesList = UserPropertiesController.getController().getUserPropertiesList(infoGluePrincipal.getName(), languageId, db, true);
        block0: for (UserProperties userProperties : userPropertiesList) {
            if (userProperties == null || !userProperties.getLanguage().getLanguageId().equals(languageId)) continue;
            Collection assets2 = userProperties.getDigitalAssets();
            for (DigitalAsset digitalAsset : assets2) {
                if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                SiteNode siteNode2 = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetThumbnailUrl(digitalAsset, siteNode2.getRepository(), width, height, deliveryContext);
                continue block0;
            }
        }
        if (assetUrl.equals("")) {
            List roles = infoGluePrincipal.getRoles();
            for (InfoGlueRole role : roles) {
                List rolePropertiesList = RolePropertiesController.getController().getRolePropertiesList(role.getName(), languageId, db, true);
                block3: for (RoleProperties roleProperties : rolePropertiesList) {
                    if (roleProperties == null || !roleProperties.getLanguage().getLanguageId().equals(languageId)) continue;
                    assets = roleProperties.getDigitalAssets();
                    for (DigitalAsset digitalAsset : assets) {
                        if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                        siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                        assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetThumbnailUrl(digitalAsset, siteNode.getRepository(), width, height, deliveryContext);
                        continue block3;
                    }
                }
            }
            if (assetUrl.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                return this.getPrincipalThumbnailAssetUrl(db, infoGluePrincipal, assetKey, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, width, height, deliveryContext);
            }
        }
        if (assetUrl.equals("")) {
            List groups = infoGluePrincipal.getGroups();
            for (InfoGlueGroup group : groups) {
                List groupPropertiesList = GroupPropertiesController.getController().getGroupPropertiesList(group.getName(), languageId, db, true);
                block6: for (GroupProperties groupProperties : groupPropertiesList) {
                    if (groupProperties == null || !groupProperties.getLanguage().getLanguageId().equals(languageId)) continue;
                    assets = groupProperties.getDigitalAssets();
                    for (DigitalAsset digitalAsset : assets) {
                        if (!digitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                        siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
                        assetUrl = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().getAssetThumbnailUrl(digitalAsset, siteNode.getRepository(), width, height, deliveryContext);
                        continue block6;
                    }
                }
            }
            if (assetUrl.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                return this.getPrincipalThumbnailAssetUrl(db, infoGluePrincipal, assetKey, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, width, height, deliveryContext);
            }
        }
        return assetUrl;
    }
}

