/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.graphics.ThumbnailGenerator;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.URLComposer;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.Timer;

public class DigitalAssetDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)DigitalAssetDeliveryController.class.getName());
    private static final DigitalAssetDeliveryController digitalAssetController = new DigitalAssetDeliveryController();

    private DigitalAssetDeliveryController() {
    }

    public static DigitalAssetDeliveryController getDigitalAssetDeliveryController() {
        return digitalAssetController;
    }

    public String getAssetUrl(DigitalAssetVO digitalAssetVO, Repository repository, DeliveryContext deliveryContext, Database db) throws SystemException, Exception {
        String assetUrl = "";
        if (digitalAssetVO != null) {
            String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
            int i = 0;
            String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    this.dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (repository != null && repository.getDnsName() != null && !repository.getDnsName().equals("")) {
                dnsName = repository.getDnsName();
            }
            assetUrl = URLComposer.getURLComposer().composeDigitalAssetUrl(dnsName, fileName, deliveryContext);
        }
        return assetUrl;
    }

    public String getAssetUrl(DigitalAsset digitalAsset, Repository repository, DeliveryContext deliveryContext) throws SystemException, Exception {
        String assetUrl = "";
        if (digitalAsset != null) {
            String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
            int i = 0;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath);
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (repository != null && repository.getDnsName() != null && !repository.getDnsName().equals("")) {
                dnsName = repository.getDnsName();
            }
            assetUrl = URLComposer.getURLComposer().composeDigitalAssetUrl(dnsName, fileName, deliveryContext);
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(DigitalAssetVO digitalAsset, Repository repository, int width, int height, DeliveryContext deliveryContext, Database db) throws SystemException, Exception {
        String assetUrl = "";
        if (digitalAsset != null) {
            String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
            String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
            int i = 0;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (repository != null && repository.getDnsName() != null && !repository.getDnsName().equals("")) {
                dnsName = repository.getDnsName();
            }
            assetUrl = URLComposer.getURLComposer().composeDigitalAssetUrl(dnsName, thumbnailFileName, deliveryContext);
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(DigitalAsset digitalAsset, Repository repository, int width, int height, DeliveryContext deliveryContext) throws SystemException, Exception {
        String assetUrl = "";
        if (digitalAsset != null) {
            String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
            String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
            int i = 0;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath);
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (repository != null && repository.getDnsName() != null && !repository.getDnsName().equals("")) {
                dnsName = repository.getDnsName();
            }
            assetUrl = URLComposer.getURLComposer().composeDigitalAssetUrl(dnsName, thumbnailFileName, deliveryContext);
        }
        return assetUrl;
    }

    public void dumpAttributeToFile(String attributeValue, String fileName, String filePath) throws Exception {
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + Thread.currentThread().getId() + "_tmp_" + fileName);
        logger.info((Object)("outputFile:" + outputFile.getAbsolutePath()));
        if (!outputFile.exists() || outputFile.length() == 0L) {
            PrintWriter pw = new PrintWriter(new FileWriter(tmpOutputFile));
            pw.println(attributeValue);
            pw.close();
        }
        if (tmpOutputFile.length() == 0L || outputFile.exists()) {
            logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
            tmpOutputFile.delete();
        } else {
            logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
            this.renameFile(tmpOutputFile, outputFile);
        }
    }

    public synchronized File dumpUrlToFile(String fileName, String filePath, String pageContent) throws Exception {
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + Thread.currentThread().getId() + "_tmp_" + fileName);
        logger.info((Object)("outputFile:" + outputFile.getAbsolutePath()));
        if (!outputFile.exists() || outputFile.length() == 0L) {
            PrintWriter pw = new PrintWriter(new FileWriter(tmpOutputFile));
            pw.println(pageContent);
            pw.close();
        }
        if (tmpOutputFile.length() == 0L || outputFile.exists()) {
            logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
            tmpOutputFile.delete();
        } else {
            logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
            this.renameFile(tmpOutputFile, outputFile);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpDigitalAsset(DigitalAssetVO digitalAssetVO, String fileName, String filePath, Database db) throws Exception {
        Timer timer = new Timer();
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + Thread.currentThread().getId() + "_tmp_" + fileName);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        if (outputFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"The file allready exists so we don't need to dump it again..");
            }
            return outputFile;
        }
        try {
            File outputFileDir = new File(filePath);
            outputFileDir.mkdirs();
            DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetVO.getId(), db);
            String cmsBaseUrl = CmsPropertyHandler.getCmsFullBaseUrl();
            if (CmsPropertyHandler.getEnableDiskAssets().equals("true")) {
                HttpHelper httpHelper = new HttpHelper();
                httpHelper.downloadFile(cmsBaseUrl + "/DownloadProtectedAsset.action?digitalAssetId=" + digitalAssetVO.getId(), tmpOutputFile);
            }
            if (tmpOutputFile.exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Time for dumping file " + fileName + ":" + timer.getElapsedTime() + ":" + tmpOutputFile.exists() + ":" + tmpOutputFile.lastModified()));
                    logger.info((Object)("tmpOutputFile:" + tmpOutputFile.length() + ":" + tmpOutputFile.exists()));
                }
                if (tmpOutputFile.length() == 0L || outputFile.exists()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                    }
                    tmpOutputFile.delete();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Time for deleting file " + timer.getElapsedTime()));
                    }
                } else {
                    logger.info((Object)("written file:" + tmpOutputFile.getAbsolutePath() + " - renaming it to " + outputFile.getAbsolutePath()));
                    logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
                    tmpOutputFile.renameTo(outputFile);
                    logger.info((Object)("Time for renaming file " + timer.getElapsedTime()));
                }
            } else {
                InputStream inputStream = digitalAsset.getAssetBlob();
                if (inputStream != null) {
                    logger.info((Object)("inputStream:" + inputStream + ":" + inputStream.getClass().getName() + ":" + digitalAsset));
                    InputStream inputStream2 = inputStream;
                    synchronized (inputStream2) {
                        int character;
                        logger.info((Object)"reading inputStream and writing to disk....");
                        FileOutputStream fos = new FileOutputStream(tmpOutputFile);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        BufferedInputStream bis = new BufferedInputStream(inputStream);
                        int i = 0;
                        while ((character = bis.read()) != -1) {
                            bos.write(character);
                            ++i;
                        }
                        if (i == 0) {
                            logger.info((Object)("Wrote " + i + " chars to " + fileName));
                        }
                        bos.flush();
                        fos.close();
                        bos.close();
                        bis.close();
                        logger.info((Object)"done reading inputStream and writing to disk....");
                    }
                } else {
                    logger.warn((Object)"There was no asset blob in the database - checking the cms-disk - could be a mistake");
                    HttpHelper httpHelper = new HttpHelper();
                    httpHelper.downloadFile(cmsBaseUrl + "/DownloadProtectedAsset.action?digitalAssetId=" + digitalAssetVO.getId(), tmpOutputFile);
                    if (tmpOutputFile.exists()) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Time for dumping file " + fileName + ":" + timer.getElapsedTime() + ":" + tmpOutputFile.exists() + ":" + tmpOutputFile.lastModified()));
                            logger.info((Object)("tmpOutputFile:" + tmpOutputFile.length() + ":" + tmpOutputFile.exists()));
                        }
                        if (tmpOutputFile.length() == 0L || outputFile.exists()) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                            }
                            tmpOutputFile.delete();
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Time for deleting file " + timer.getElapsedTime()));
                            }
                        } else {
                            logger.info((Object)("written file:" + tmpOutputFile.getAbsolutePath() + " - renaming it to " + outputFile.getAbsolutePath()));
                            logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
                            tmpOutputFile.renameTo(outputFile);
                            logger.info((Object)("Time for renaming file " + timer.getElapsedTime()));
                        }
                    }
                }
                logger.info((Object)("Time for dumping file " + fileName + ":" + timer.getElapsedTime()));
                if (tmpOutputFile.length() == 0L || outputFile.exists()) {
                    logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                    tmpOutputFile.delete();
                    logger.info((Object)("Time for deleting file " + timer.getElapsedTime()));
                } else {
                    logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
                    tmpOutputFile.renameTo(outputFile);
                    logger.info((Object)("Time for renaming file " + timer.getElapsedTime()));
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Could not write file " + outputFile.getAbsolutePath() + " - error reported:" + e.getMessage(), e);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpDigitalAsset(DigitalAsset digitalAsset, String fileName, String filePath) throws Exception {
        Timer timer = new Timer();
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + Thread.currentThread().getId() + "_tmp_" + fileName);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        if (outputFile.exists()) {
            return outputFile;
        }
        try {
            InputStream inputStream = digitalAsset.getAssetBlob();
            logger.info((Object)("inputStream:" + inputStream + ":" + inputStream.getClass().getName() + ":" + digitalAsset));
            InputStream inputStream2 = inputStream;
            synchronized (inputStream2) {
                int character;
                logger.info((Object)"reading inputStream and writing to disk....");
                FileOutputStream fos = new FileOutputStream(tmpOutputFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                int i = 0;
                while ((character = bis.read()) != -1) {
                    bos.write(character);
                    ++i;
                }
                if (i == 0) {
                    logger.info((Object)("Wrote " + i + " chars to " + fileName));
                }
                bos.flush();
                fos.close();
                bos.close();
                bis.close();
                logger.info((Object)"done reading inputStream and writing to disk....");
            }
            logger.info((Object)("Time for dumping file " + fileName + ":" + timer.getElapsedTime()));
            if (tmpOutputFile.length() == 0L || outputFile.exists()) {
                logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                tmpOutputFile.delete();
                logger.info((Object)("Time for deleting file " + timer.getElapsedTime()));
            } else {
                logger.info((Object)("written file:" + tmpOutputFile.length() + " - renaming it to " + outputFile.getAbsolutePath()));
                tmpOutputFile.renameTo(outputFile);
                logger.info((Object)("Time for renaming file " + timer.getElapsedTime()));
            }
        }
        catch (IOException e) {
            throw new Exception("Could not write file " + outputFile.getAbsolutePath() + " - error reported:" + e.getMessage(), e);
        }
        return outputFile;
    }

    public File dumpDigitalAsset(File masterFile, String fileName, String filePath) throws Exception {
        long timer = System.currentTimeMillis();
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        if (outputFile.exists() && outputFile.length() > 0L) {
            return outputFile;
        }
        try {
            int character;
            new File(filePath).mkdirs();
            outputFile.createNewFile();
            FileOutputStream fis = new FileOutputStream(outputFile);
            BufferedOutputStream bos = new BufferedOutputStream(fis);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(masterFile));
            while ((character = bis.read()) != -1) {
                bos.write(character);
            }
            bos.flush();
            bis.close();
            fis.close();
            bos.close();
        }
        catch (IOException e) {
            throw new Exception("Could not write file " + outputFile.getAbsolutePath() + " - error reported:" + e.getMessage(), e);
        }
        return outputFile;
    }

    public File dumpDigitalAssetThumbnail(String fileName, String thumbnailFile, String filePath, int width, int height) throws Exception {
        long timer = System.currentTimeMillis();
        logger.info((Object)("fileName:" + fileName));
        logger.info((Object)("thumbnailFile:" + thumbnailFile));
        File outputFile = new File(String.valueOf(filePath) + File.separator + thumbnailFile);
        if (outputFile.exists()) {
            logger.info((Object)"The file allready exists so we don't need to dump it again..");
            return outputFile;
        }
        ThumbnailGenerator tg = new ThumbnailGenerator();
        tg.transform(String.valueOf(filePath) + File.separator + fileName, String.valueOf(filePath) + File.separator + thumbnailFile, width, height, 100);
        logger.info((Object)("Time for dumping file " + fileName + ":" + (System.currentTimeMillis() - timer)));
        return outputFile;
    }

    public File dumpAndUnzipDigitalAsset(DigitalAssetVO digitalAsset, String fileName, String filePath, File unzipDirectory, Database db) throws Exception {
        File zipFile = this.dumpDigitalAsset(digitalAsset, fileName, filePath, db);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        this.unzipFile(outputFile, unzipDirectory);
        return zipFile;
    }

    public File dumpAndUnzipDigitalAsset(File masterFile, String fileName, String filePath, File unzipDirectory) throws Exception {
        File zipFile = this.dumpDigitalAsset(masterFile, fileName, filePath);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        this.unzipFile(outputFile, unzipDirectory);
        return zipFile;
    }

    public Vector dumpAndGetZipEntries(DigitalAssetVO digitalAsset, String fileName, String filePath, File unzipDirectory, Database db) throws Exception {
        this.dumpDigitalAsset(digitalAsset, fileName, filePath, db);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        return this.getZipFileEntries(outputFile, unzipDirectory);
    }

    public Vector dumpAndGetZipEntries(File masterFile, String fileName, String filePath, File unzipDirectory) throws Exception {
        this.dumpDigitalAsset(masterFile, fileName, filePath);
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        return this.getZipFileEntries(outputFile, unzipDirectory);
    }

    public void deleteContentVersionAssets(Integer contentVersionId) throws SystemException, Exception {
        try {
            DigitalAssetController.getController();
            List digitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentVersionId);
            for (DigitalAssetVO digitalAssetVO : digitalAssetVOList) {
                this.deleteDigitalAssets(digitalAssetVO.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete the assets for the contentVersion " + contentVersionId + ":" + e.getMessage()), (Throwable)e);
        }
    }

    public void deleteDigitalAssets(Integer digitalAssetId) throws SystemException, Exception {
        try {
            File file;
            int j;
            File[] files;
            File assetDirectory;
            String folderName = "" + digitalAssetId / 1000;
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                assetDirectory = new File(filePath);
                files = assetDirectory.listFiles(new FilenameFilterImpl(digitalAssetId.toString()));
                j = 0;
                while (j < files.length) {
                    file = files[j];
                    logger.info((Object)("Deleting file " + file.getPath()));
                    file.delete();
                    ++j;
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            i = 0;
            filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                assetDirectory = new File(filePath);
                assetDirectory.mkdirs();
                files = assetDirectory.listFiles(new FilenameFilterImpl(digitalAssetId.toString()));
                if (files == null) {
                    logger.error((Object)("There was a problem deleting files in:" + filePath + " - looking for " + digitalAssetId));
                } else {
                    j = 0;
                    while (j < files.length) {
                        file = files[j];
                        logger.info((Object)("Deleting file " + file.getPath()));
                        file.delete();
                        ++j;
                    }
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete the assets for the digitalAsset " + digitalAssetId + ":" + e.getMessage()), (Throwable)e);
        }
    }

    private void unzipFile(File assetFile, File targetFolder) throws Exception {
        logger.info((Object)("Unzipping file " + assetFile.getPath() + " to " + targetFolder));
        ZipFile zipFile = new ZipFile(assetFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(targetFolder + File.separator + entry.getName()).mkdirs();
                continue;
            }
            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(targetFolder + File.separator + entry.getName())));
        }
        zipFile.close();
    }

    private Vector getZipFileEntries(File assetFile, File targetFolder) throws Exception {
        logger.info((Object)("Getting entries from " + assetFile.getPath()));
        Vector<ZipEntry> entryCopies = new Vector<ZipEntry>();
        ZipFile zipFile = new ZipFile(assetFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            ZipEntry entryCopy = (ZipEntry)entry.clone();
            entryCopies.add(entryCopy);
        }
        zipFile.close();
        return entryCopies;
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private synchronized void renameFile(File tempFile, File newFileName) {
        if (tempFile.length() == 0L || newFileName.exists()) {
            tempFile.delete();
            logger.info((Object)("written file:" + newFileName.length() + " - removing temp and not renaming it..."));
        } else {
            tempFile.renameTo(newFileName);
            logger.info((Object)("written file:" + tempFile.length() + " - renaming it to " + newFileName.getAbsolutePath()));
        }
    }

    class FilenameFilterImpl
    implements FilenameFilter {
        private String filter = ".";

        public FilenameFilterImpl(String aFilter) {
            this.filter = aFilter;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.filter);
        }
    }
}

