/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentCategory;
import org.infoglue.cms.entities.content.ContentCategoryVO;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumContentImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallishContentImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.URLComposer;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.DigitalAssetDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class ContentDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)ContentDeliveryController.class.getName());
    private URLComposer urlComposer = null;
    private VisualFormatter formatter = new VisualFormatter();

    private ContentDeliveryController() {
        this.urlComposer = URLComposer.getURLComposer();
    }

    public static ContentDeliveryController getContentDeliveryController() {
        return new ContentDeliveryController();
    }

    private Integer getOperatingMode() {
        Integer operatingMode = new Integer(0);
        try {
            operatingMode = new Integer(CmsPropertyHandler.getOperatingMode());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the operating mode from the propertyFile:" + e.getMessage()), (Throwable)e);
        }
        return operatingMode;
    }

    public ContentVO getContentVO(Integer contentId, Database db) throws SystemException, Exception {
        if (contentId == null || contentId < 1) {
            return null;
        }
        ContentVO contentVO = null;
        contentVO = (ContentVO)this.getVOWithId(SmallContentImpl.class, contentId, db);
        return contentVO;
    }

    public ContentVO getContentVO(Database db, Integer contentId, DeliveryContext deliveryContext) throws SystemException, Exception {
        if (contentId == null || contentId < 1) {
            return null;
        }
        deliveryContext.addUsedContent("content_" + contentId);
        ContentVO contentVO = (ContentVO)this.getVOWithId(SmallContentImpl.class, contentId, db);
        return contentVO;
    }

    public ContentVersionVO getContentVersionVO(Database db, Integer siteNodeId, Integer contentId, Integer languageId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        ContentVersion contentVersion;
        ContentVersionVO contentVersionVO = null;
        SiteNodeVO siteNodeVO = (SiteNodeVO)this.getVOWithId(SiteNodeImpl.class, siteNodeId, db);
        String contentVersionKey = "contentVersionVO_" + siteNodeVO.getRepositoryId() + "_" + contentId + "_" + languageId + "_" + useLanguageFallback;
        logger.info((Object)("contentVersionKey:" + contentVersionKey));
        contentVersionVO = (ContentVersionVO)CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", contentVersionKey);
        if (contentVersionVO == null && (contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal)) != null) {
            contentVersionVO = contentVersion.getValueObject();
            CacheController.cacheObjectInAdvancedCache("contentVersionCache", contentVersionKey, contentVersionVO, new String[]{"contentVersion_" + contentVersionVO.getId(), "content_" + contentVersionVO.getContentId()}, true);
        }
        if (contentVersionVO != null && deliveryContext != null) {
            deliveryContext.addUsedContentVersion("contentVersion_" + contentVersionVO.getId());
        }
        return contentVersionVO;
    }

    private ContentVersion getContentVersion(Integer siteNodeId, Integer contentId, Integer languageId, Database db, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        if (contentId == null || contentId < 1) {
            return null;
        }
        ContentVersion contentVersion = null;
        MediumContentImpl content = (MediumContentImpl)this.getObjectWithId(MediumContentImpl.class, contentId, db);
        boolean isValidContent = this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, false, db, deliveryContext);
        if (isValidContent && (contentVersion = this.getContentVersion(content, languageId, this.getOperatingMode(), deliveryContext, db)) == null && useLanguageFallback) {
            Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId).getLanguageId();
            if (languageId != null && !languageId.equals(masterLanguageId)) {
                contentVersion = this.getContentVersion(content, masterLanguageId, this.getOperatingMode(), deliveryContext, db);
            }
            if (languageId != null && contentVersion == null && useLanguageFallback) {
                Integer contentMasterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(db, content.getRepositoryId()).getLanguageId();
                if (languageId != null && !languageId.equals(contentMasterLanguageId) && !masterLanguageId.equals(contentMasterLanguageId)) {
                    contentVersion = this.getContentVersion(content, contentMasterLanguageId, this.getOperatingMode(), deliveryContext, db);
                }
            }
        }
        return contentVersion;
    }

    public List getContentVersionVOList(Database db, Integer siteNodeId, Integer contentId, Integer languageId, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        MediumContentImpl content;
        boolean isValidContent;
        if (contentId == null || contentId < 1) {
            return null;
        }
        List contentVersionVOList = new ArrayList();
        boolean useLanguageFallback = false;
        if (languageId == null) {
            useLanguageFallback = true;
        }
        if (isValidContent = this.isValidContent(infoGluePrincipal, content = (MediumContentImpl)this.getObjectWithId(MediumContentImpl.class, contentId, db), languageId, useLanguageFallback, false, db, deliveryContext)) {
            contentVersionVOList = this.getContentVersionVOList(content, languageId, this.getOperatingMode(), deliveryContext, db);
        }
        return contentVersionVOList;
    }

    private ContentVersion getContentVersion(Content content, Integer languageId, Integer operatingMode, DeliveryContext deliveryContext, Database db) throws Exception {
        IBaseEntity contentVersion = null;
        logger.info((Object)("content:" + content.getId()));
        logger.info((Object)("operatingMode:" + operatingMode));
        logger.info((Object)("languageId:" + languageId));
        String versionKey = content.getId() + "_" + languageId + "_" + operatingMode + "_contentVersionId";
        Object object = CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", versionKey);
        if (object instanceof NullObject) {
            logger.info((Object)("There was an cached parentSiteNodeVO but it was null:" + object));
        } else if (object != null) {
            Integer contentVersionId = (Integer)object;
            logger.info((Object)("There was a cached content version id:" + contentVersionId));
            contentVersion = (ContentVersion)this.getObjectWithId(ContentVersionImpl.class, contentVersionId, db);
            logger.info((Object)"contentVersion read");
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.contentId = $1 AND cv.language.languageId = $2 AND cv.stateId >= $3 AND cv.isActive = $4 ORDER BY cv.contentVersionId desc");
            oql.bind((Object)content.getId());
            oql.bind((Object)languageId);
            oql.bind((Object)operatingMode);
            oql.bind(true);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                contentVersion = (ContentVersion)results.next();
                logger.info((Object)("found one:" + contentVersion.getId()));
                CacheController.cacheObjectInAdvancedCache("contentVersionCache", versionKey, contentVersion.getId(), new String[]{"contentVersion_" + contentVersion.getId(), "content_" + contentVersion.getValueObject().getContentId()}, true);
            } else {
                CacheController.cacheObjectInAdvancedCache("contentVersionCache", versionKey, new NullObject(), new String[]{"content_" + content.getId()}, true);
            }
            results.close();
            oql.close();
        }
        if (contentVersion != null) {
            deliveryContext.addUsedContentVersion("contentVersion_" + contentVersion.getId());
        }
        logger.info((Object)"end getContentVersion");
        return contentVersion;
    }

    private List getContentVersionVOList(Content content, Integer languageId, Integer operatingMode, DeliveryContext deliveryContext, Database db) throws Exception {
        ArrayList<ContentVersionVO> contentVersionVOList = new ArrayList<ContentVersionVO>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.contentId = $1 AND cv.language.languageId = $2 AND cv.stateId >= $3 AND cv.isActive = $4 ORDER BY cv.contentVersionId desc");
        if (languageId == null) {
            oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.contentId = $1 AND cv.stateId >= $2 AND cv.isActive = $3 ORDER BY cv.contentVersionId desc");
        }
        oql.bind((Object)content.getId());
        if (languageId != null) {
            oql.bind((Object)languageId);
        }
        oql.bind((Object)operatingMode);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            if (contentVersion != null) {
                deliveryContext.addUsedContentVersion("contentVersion_" + contentVersion.getId());
            }
            contentVersionVOList.add(contentVersion.getValueObject());
        }
        results.close();
        oql.close();
        return contentVersionVOList;
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infogluePrincipal, boolean escapeHTML) throws SystemException, Exception {
        return this.getContentAttribute(db, contentId, languageId, attributeName, siteNodeId, useLanguageFallback, deliveryContext, infogluePrincipal, escapeHTML, false, null);
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infogluePrincipal, boolean escapeHTML, boolean isMetaInfoQuery) throws SystemException, Exception {
        return this.getContentAttribute(db, contentId, languageId, attributeName, siteNodeId, useLanguageFallback, deliveryContext, infogluePrincipal, escapeHTML, isMetaInfoQuery, null);
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infogluePrincipal, boolean escapeHTML, Set usedContentVersionId) throws SystemException, Exception {
        return this.getContentAttribute(db, contentId, languageId, attributeName, siteNodeId, useLanguageFallback, deliveryContext, infogluePrincipal, escapeHTML, false, usedContentVersionId);
    }

    public boolean getHasUserContentAccess(Database db, InfoGluePrincipal infoGluePrincipal, Integer contentId) {
        boolean hasUserContentAccess = true;
        try {
            if (contentId != null) {
                Integer protectedContentId = ContentDeliveryController.getContentDeliveryController().getProtectedContentId(db, contentId);
                logger.info((Object)("IsProtected:" + protectedContentId));
                if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Read", protectedContentId.toString())) {
                    hasUserContentAccess = false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return hasUserContentAccess;
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infogluePrincipal, boolean escapeHTML, boolean isMetaInfoQuery, Set usedContentVersionId) throws SystemException, Exception {
        boolean hasUserContentAccess;
        if (contentId == null || contentId < 1) {
            return "";
        }
        String enforceRigidContentAccess = CmsPropertyHandler.getEnforceRigidContentAccess();
        if (enforceRigidContentAccess != null && enforceRigidContentAccess.equalsIgnoreCase("true") && !(hasUserContentAccess = this.getHasUserContentAccess(db, infogluePrincipal, contentId))) {
            return "";
        }
        StringBuilder attributeKey = new StringBuilder();
        if (!isMetaInfoQuery) {
            attributeKey.append("").append(contentId).append("_").append(languageId).append("_").append(attributeName).append("_").append(siteNodeId).append("_").append(useLanguageFallback).append("_").append(escapeHTML);
        } else {
            attributeKey.append("").append(contentId).append("_").append(languageId).append("_").append(attributeName).append("_").append(useLanguageFallback).append("_").append(escapeHTML);
        }
        String versionKey = attributeKey + "_contentVersionId";
        String attribute = (String)CacheController.getCachedObjectFromAdvancedCache("contentAttributeCache", attributeKey.toString());
        Integer contentVersionId = null;
        if (attribute != null) {
            contentVersionId = (Integer)CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", versionKey);
        } else {
            ContentVersionVO contentVersionVO = this.getContentVersionVO(db, siteNodeId, contentId, languageId, useLanguageFallback, deliveryContext, infogluePrincipal);
            if (contentVersionVO != null) {
                attribute = this.getAttributeValue(db, contentVersionVO, attributeName, escapeHTML);
                contentVersionId = contentVersionVO.getId();
            } else {
                attribute = "";
            }
            StringBuilder groupKey1 = new StringBuilder("contentVersion_").append(contentVersionId);
            StringBuilder groupKey2 = new StringBuilder("content_").append(contentId);
            CacheController.cacheObjectInAdvancedCache("contentAttributeCache", attributeKey, attribute, new String[]{groupKey1.toString(), groupKey2.toString()}, true);
            if (contentVersionId != null) {
                CacheController.cacheObjectInAdvancedCache("contentVersionCache", versionKey, contentVersionId, new String[]{groupKey1.toString(), groupKey2.toString()}, true);
            }
        }
        if (deliveryContext != null) {
            deliveryContext.addUsedContentVersion("contentVersion_" + contentVersionId);
            if (isMetaInfoQuery && contentVersionId != null) {
                deliveryContext.getUsedPageMetaInfoContentVersionIdSet().add(contentVersionId);
            }
        }
        if (usedContentVersionId != null && contentVersionId != null) {
            usedContentVersionId.add(contentVersionId);
        }
        return attribute == null ? "" : attribute;
    }

    public String getContentAttribute(Database db, ContentVersionVO contentVersionVO, String attributeName, boolean escapeHTML) throws SystemException, Exception {
        String attribute = this.getAttributeValue(db, contentVersionVO, attributeName, escapeHTML);
        return attribute;
    }

    public List findContentVersionVOsForCategory(Database db, Integer categoryId, String attributeName, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, DeliveryContext deliveryContext) throws SystemException, Exception {
        deliveryContext.addUsedContent("selectiveCacheUpdateNonApplicable");
        List results = this.findContentCategories(db, categoryId, attributeName);
        List versions = this.findContentVersionsForCategories(results, db);
        Iterator iter = versions.iterator();
        while (iter.hasNext()) {
            ContentVersion version = (ContentVersion)iter.next();
            if (this.isValidContentVersion(version, infoGluePrincipal, siteNodeId, languageId, useLanguageFallback, db, deliveryContext)) continue;
            iter.remove();
        }
        return ContentDeliveryController.toVOList(versions);
    }

    public List getAssignedCategoryVOsForContentVersionId(Database db, Integer contentId, Integer languageId, String categoryKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws Exception {
        ArrayList<CategoryVO> assignedCategoryVOList = new ArrayList<CategoryVO>();
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        List assignedContentCategories = ContentCategoryController.getController().findByContentVersionAttribute(categoryKey, contentVersion, db, true);
        if ((assignedCategoryVOList == null || assignedCategoryVOList.size() == 0) && useLanguageFallback) {
            LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId);
            contentVersion = this.getContentVersion(siteNodeId, contentId, masterLanguageVO.getLanguageId(), db, useLanguageFallback, deliveryContext, infoGluePrincipal);
            assignedContentCategories = ContentCategoryController.getController().findByContentVersionAttribute(categoryKey, contentVersion, db, true);
        }
        for (ContentCategory contentCategory : assignedContentCategories) {
            assignedCategoryVOList.add(contentCategory.getCategory().getValueObject());
        }
        return assignedCategoryVOList;
    }

    public List findContentCategoryVOsForContentVersionId(Database db, Integer contentVersionId, String categoryKey, DeliveryContext deliveryContext) throws SystemException, Exception {
        List contentCategories = this.findContentVersionCategories(db, contentVersionId, categoryKey);
        return ContentDeliveryController.toVOList(contentCategories);
    }

    public List findContentCategoriesForContentVersionId(Database db, Integer contentVersionId, String categoryKey, DeliveryContext deliveryContext) throws SystemException, Exception {
        List contentCategories = this.findContentVersionCategories(db, contentVersionId, categoryKey);
        return contentCategories;
    }

    private List findContentCategories(Database db, Integer categoryId, String attributeName) throws SystemException, Exception {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl c ");
        oql.append("WHERE c.category.categoryId = $1 AND c.attributeName = $2");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(categoryId);
        params.add(attributeName);
        return ContentDeliveryController.toVOList(ContentDeliveryController.executeQuery(db, oql.toString(), params));
    }

    private List findContentVersionCategories(Database db, Integer contentVersionId, String categoryKey) throws SystemException, Exception {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl c ");
        oql.append("WHERE c.contentVersion.contentVersionId = $1 AND c.attributeName = $2");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(contentVersionId);
        params.add(categoryKey);
        return ContentDeliveryController.executeQuery(db, oql.toString(), params);
    }

    private List findContentVersionsForCategories(List contentCategories, Database db) throws Exception {
        if (contentCategories.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl c ").append("WHERE c.contentVersionId IN LIST ").append(this.toVersionIdList(contentCategories));
        ArrayList params = new ArrayList();
        return ContentDeliveryController.executeQuery(db, oql.toString(), params);
    }

    private boolean isValidContentVersion(ContentVersion version, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, boolean useLanguageFallback, Database db, DeliveryContext deliveryContext) throws Exception {
        Integer contentId = version.getValueObject().getContentId();
        logger.info((Object)("contentId:" + contentId));
        MediumContentImpl content = (MediumContentImpl)this.getObjectWithId(MediumContentImpl.class, contentId, db);
        ContentVersionVO mostRecentVersion = this.getContentVersionVO(db, siteNodeId, content.getContentId(), languageId, useLanguageFallback, deliveryContext, infoGluePrincipal);
        boolean isProperVersion = mostRecentVersion != null && mostRecentVersion.getId().equals(version.getId());
        boolean isValidContent = this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, false, db, deliveryContext);
        return isProperVersion && isValidContent;
    }

    private String toVersionIdList(List results) {
        StringBuffer ids = new StringBuffer("(");
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            ids.append(((ContentCategoryVO)iter.next()).getContentVersionId() + (iter.hasNext() ? ", " : ""));
        }
        ids.append(")");
        return ids.toString();
    }

    public Collection getAssetKeys(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        ArrayList<String> assetKeys = new ArrayList<String>();
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            Collection assets = contentVersion.getDigitalAssets();
            for (DigitalAsset asset : assets) {
                String assetKey = asset.getAssetKey();
                assetKeys.add(assetKey);
            }
        }
        return assetKeys;
    }

    public Collection getAssetIds(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        ArrayList<Integer> assetIds = new ArrayList<Integer>();
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            Collection assets = contentVersion.getDigitalAssets();
            for (DigitalAsset asset : assets) {
                assetIds.add(asset.getId());
            }
        }
        return assetIds;
    }

    public List getAssets(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        ArrayList<BaseEntityVO> digitalAssetVOLIst = new ArrayList<BaseEntityVO>();
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            Collection assets = contentVersion.getDigitalAssets();
            for (DigitalAsset asset : assets) {
                digitalAssetVOLIst.add(asset.getVO());
            }
        }
        return digitalAssetVOLIst;
    }

    public DigitalAssetVO getAsset(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        DigitalAssetVO digitalAssetVO = null;
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            Collection assets = contentVersion.getDigitalAssets();
            for (DigitalAsset asset : assets) {
                if (!asset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
                digitalAssetVO = asset.getValueObject();
                break;
            }
        }
        return digitalAssetVO;
    }

    private DigitalAssetVO getLanguageIndependentAssetVO(Integer contentId, Integer languageId, Integer siteNodeId, Database db, String assetKey, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        DigitalAssetVO asset = null;
        List langs = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguages(db, siteNodeId);
        for (LanguageVO langVO : langs) {
            DigitalAssetVO digitalAsset;
            ContentVersion contentVersion;
            if (langVO.getLanguageId().compareTo(languageId) == 0 || (contentVersion = this.getContentVersion(siteNodeId, contentId, langVO.getLanguageId(), db, false, deliveryContext, infoGluePrincipal)) == null) continue;
            DigitalAssetVO digitalAssetVO = digitalAsset = assetKey == null ? DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), db) : DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
            if (digitalAsset == null) continue;
            asset = digitalAsset;
            break;
        }
        return asset;
    }

    private String getLanguageIndependentAssetUrl(Integer contentId, Integer languageId, Integer siteNodeId, Database db, String assetKey, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetUrl = "";
        assetUrl = this.urlComposer.composeDigitalAssetUrl("", null, "", deliveryContext);
        DigitalAssetVO digitalAssetVO = this.getLanguageIndependentAssetVO(contentId, languageId, siteNodeId, db, assetKey, deliveryContext, infoGluePrincipal);
        if (digitalAssetVO != null) {
            String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
            int i = 0;
            File masterFile = null;
            String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    if (masterFile == null) {
                        masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
                    } else {
                        DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = deliveryContext.getUseDownloadAction() ? this.urlComposer.composeDigitalAssetUrl(dnsName, siteNodeId, contentId, languageId, assetKey, deliveryContext) : this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName, deliveryContext);
        }
        return assetUrl;
    }

    private String getLanguageIndependentAssetThumbnailUrl(Integer contentId, Integer languageId, Integer siteNodeId, Database db, String assetKey, int width, int height, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetUrl = "";
        assetUrl = this.urlComposer.composeDigitalAssetUrl("", null, "", deliveryContext);
        DigitalAssetVO digitalAsset = this.getLanguageIndependentAssetVO(contentId, languageId, siteNodeId, db, assetKey, deliveryContext, infoGluePrincipal);
        if (digitalAsset != null) {
            String fileName = digitalAsset.getAssetFileName();
            String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
            int i = 0;
            File masterFile = null;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                if (masterFile == null) {
                    masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                } else {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, thumbnailFileName, deliveryContext);
        }
        return assetUrl;
    }

    public Integer getDigitalAssetId(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        DigitalAssetVO digitalAsset;
        Integer digitalAssetId = null;
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null && (digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getContentVersionId(), assetKey, db)) != null) {
            digitalAssetId = digitalAsset.getId();
        }
        return digitalAssetId;
    }

    public String getAssetUrl(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetCacheKey = languageId + "_" + contentId + "_" + siteNodeId + "_" + useLanguageFallback;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            return cachedAssetUrl;
        }
        String assetUrl = "";
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), db);
            if (digitalAsset != null) {
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                int i = 0;
                File masterFile = null;
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                logger.info((Object)("folderName:" + folderName));
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
                while (filePath != null) {
                    try {
                        if (masterFile == null) {
                            masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                    }
                    filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                    if (filePath == null) continue;
                    filePath = String.valueOf(filePath) + File.separator + folderName;
                }
                SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName, deliveryContext);
            } else {
                assetUrl = this.getLanguageIndependentAssetUrl(contentId, languageId, siteNodeId, db, null, deliveryContext, infoGluePrincipal);
            }
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public String getAssetUrl(Database db, Integer digitalAssetId, Integer siteNodeId, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetCacheKey = digitalAssetId + "_" + siteNodeId;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            return cachedAssetUrl;
        }
        String assetUrl = "";
        DigitalAssetVO digitalAsset = DigitalAssetController.getSmallDigitalAssetVOWithId(digitalAssetId, db);
        if (digitalAsset != null) {
            String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
            int i = 0;
            File masterFile = null;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    if (masterFile == null) {
                        masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                    } else {
                        DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName, deliveryContext);
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public String getAssetUrl(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        if (contentId == null || contentId < 1) {
            return "";
        }
        SiteNodeController.getController();
        SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
        String assetCacheKey = languageId + "_" + contentId + "_" + siteNodeVO.getRepositoryId() + "_" + assetKey + "_" + useLanguageFallback + "_" + deliveryContext.getUseFullUrl() + "_" + deliveryContext.getUseDownloadAction();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("assetCacheKey:" + assetCacheKey));
        }
        assetKey = URLDecoder.decode(assetKey, "utf-8");
        String cacheName = "assetUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            }
            return cachedAssetUrl;
        }
        String assetUrl = "";
        assetUrl = this.urlComposer.composeDigitalAssetUrl("", null, "", deliveryContext);
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        ContentVO contentVO = this.getContentVO(db, contentId, deliveryContext);
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(contentVO.getRepositoryId(), db);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("masterLanguageVO:" + masterLanguageVO));
        }
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
            if (digitalAsset != null) {
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                int i = 0;
                File masterFile = null;
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                logger.info((Object)("folderName:" + folderName));
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
                while (filePath != null) {
                    try {
                        if (masterFile == null) {
                            masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                    }
                    filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                    if (filePath == null) continue;
                    filePath = String.valueOf(filePath) + File.separator + folderName;
                }
                SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                assetUrl = deliveryContext.getUseDownloadAction() ? this.urlComposer.composeDigitalAssetUrl(dnsName, siteNodeId, contentId, languageId, assetKey, deliveryContext) : this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName, deliveryContext);
            } else if (useLanguageFallback) {
                assetUrl = this.getLanguageIndependentAssetUrl(contentId, languageId, siteNodeId, db, assetKey, deliveryContext, infoGluePrincipal);
            }
        } else if (useLanguageFallback && languageId != null && masterLanguageVO != null && languageId.intValue() != masterLanguageVO.getId().intValue()) {
            contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
            logger.info((Object)("contentVersion:" + contentVersion));
            if (contentVersion != null) {
                DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
                if (digitalAsset != null) {
                    String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                    int i = 0;
                    File masterFile = null;
                    String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                    logger.info((Object)("folderName:" + folderName));
                    String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
                    while (filePath != null) {
                        try {
                            if (masterFile == null) {
                                masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                            } else {
                                DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                        }
                        filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                        if (filePath == null) continue;
                        filePath = String.valueOf(filePath) + File.separator + folderName;
                    }
                    SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
                    String dnsName = CmsPropertyHandler.getWebServerAddress();
                    if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                        dnsName = siteNode.getRepository().getDnsName();
                    }
                    assetUrl = deliveryContext.getUseDownloadAction() ? this.urlComposer.composeDigitalAssetUrl(dnsName, siteNodeId, contentId, languageId, assetKey, deliveryContext) : this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName, deliveryContext);
                } else if (useLanguageFallback) {
                    assetUrl = this.getLanguageIndependentAssetUrl(contentId, languageId, siteNodeId, db, assetKey, deliveryContext, infoGluePrincipal);
                }
            }
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public String getAssetThumbnailUrl(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, int width, int height, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetCacheKey = languageId + "_" + contentId + "_" + siteNodeId + "_" + useLanguageFallback + "_" + width + "_" + height;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetThumbnailUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            return cachedAssetUrl;
        }
        String assetUrl = "";
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), db);
            if (digitalAsset != null) {
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
                int i = 0;
                File masterFile = null;
                File masterThumbFile = null;
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                logger.info((Object)("folderName:" + folderName));
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
                while (filePath != null) {
                    try {
                        if (masterFile == null) {
                            masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                        }
                        if (masterThumbFile == null) {
                            masterThumbFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                    }
                    filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                    if (filePath == null) continue;
                    filePath = String.valueOf(filePath) + File.separator + folderName;
                }
                SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, thumbnailFileName, deliveryContext);
            } else {
                assetUrl = this.getLanguageIndependentAssetThumbnailUrl(contentId, languageId, siteNodeId, db, null, width, height, deliveryContext, infoGluePrincipal);
            }
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public String getAssetThumbnailUrl(Database db, Integer digitalAssetId, Integer siteNodeId, int width, int height, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetCacheKey = digitalAssetId + "_" + siteNodeId + "_" + width + "_" + height;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetThumbnailUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            return cachedAssetUrl;
        }
        String assetUrl = "";
        DigitalAssetVO digitalAsset = DigitalAssetController.getSmallDigitalAssetVOWithId(digitalAssetId, db);
        if (digitalAsset != null) {
            String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
            String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
            int i = 0;
            File masterFile = null;
            File masterThumbFile = null;
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
            while (filePath != null) {
                try {
                    if (masterFile == null) {
                        masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                    } else {
                        DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(masterFile, fileName, filePath);
                    }
                    if (masterThumbFile == null) {
                        masterThumbFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                    } else {
                        DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, thumbnailFileName, deliveryContext);
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public String getAssetThumbnailUrl(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, int width, int height, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        String assetCacheKey = languageId + "_" + contentId + "_" + siteNodeId + "_" + assetKey + "_" + useLanguageFallback + "_" + width + "_" + height;
        logger.info((Object)("assetCacheKey:" + assetCacheKey));
        String cacheName = "assetThumbnailUrlCache";
        String cachedAssetUrl = (String)CacheController.getCachedObject(cacheName, assetCacheKey);
        if (cachedAssetUrl != null) {
            logger.info((Object)("There was an cached cachedAssetUrl:" + cachedAssetUrl));
            return cachedAssetUrl;
        }
        String assetUrl = "";
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
            if (digitalAsset != null) {
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                String thumbnailFileName = "thumbnail_" + width + "_" + height + "_" + fileName;
                int i = 0;
                File masterFile = null;
                File masterThumbFile = null;
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                logger.info((Object)("folderName:" + folderName));
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath0()) + File.separator + folderName;
                while (filePath != null) {
                    try {
                        if (masterFile == null) {
                            masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAsset(digitalAsset, fileName, filePath, db);
                        }
                        if (masterThumbFile == null) {
                            masterThumbFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                        } else {
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpDigitalAssetThumbnail(fileName, thumbnailFileName, filePath, width, height);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("An file could not be written:" + e.getMessage()), (Throwable)e);
                    }
                    filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                    if (filePath == null) continue;
                    filePath = String.valueOf(filePath) + File.separator + folderName;
                }
                SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, thumbnailFileName, deliveryContext);
            } else {
                assetUrl = this.getLanguageIndependentAssetThumbnailUrl(contentId, languageId, siteNodeId, db, assetKey, width, height, deliveryContext, infoGluePrincipal);
            }
        }
        CacheController.cacheObject(cacheName, assetCacheKey, assetUrl);
        return assetUrl;
    }

    public Integer getAssetFileSize(Database db, Integer contentId, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        return this.getAssetFileSize(db, contentId, languageId, null, siteNodeId, useLanguageFallback, deliveryContext, infoGluePrincipal);
    }

    public Integer getAssetFileSize(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        Integer fileSize = null;
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset;
            DigitalAssetVO digitalAssetVO = digitalAsset = assetKey == null ? DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), db) : DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
            if (digitalAsset == null) {
                digitalAsset = this.getLanguageIndependentAssetVO(contentId, languageId, siteNodeId, db, assetKey, deliveryContext, infoGluePrincipal);
            }
            if (digitalAsset != null) {
                fileSize = digitalAsset.getAssetFileSize();
            }
        }
        return fileSize;
    }

    public String getArchiveBaseUrl(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        DigitalAssetVO digitalAsset;
        String archiveBaseUrl = null;
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null && (digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getContentVersionId(), assetKey, db)) != null) {
            String fileName = digitalAsset.getAssetFileName();
            int i = 0;
            File masterFile = null;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
            logger.info((Object)("folderName:" + folderName));
            while (filePath != null) {
                File unzipDirectory = new File(String.valueOf(filePath) + File.separator + fileName.substring(0, fileName.lastIndexOf(".")));
                unzipDirectory.mkdirs();
                if (masterFile == null) {
                    masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndUnzipDigitalAsset(digitalAsset, fileName, filePath, unzipDirectory, db);
                } else {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndUnzipDigitalAsset(masterFile, fileName, filePath, unzipDirectory);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
                if (filePath == null) continue;
                filePath = String.valueOf(filePath) + File.separator + folderName;
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            archiveBaseUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, folderName, fileName.substring(0, fileName.lastIndexOf(".")), deliveryContext);
        }
        return archiveBaseUrl;
    }

    public String getArchiveBaseUrl(Database db, Integer digitalAssetId, Integer siteNodeId, DeliveryContext deliveryContext) throws SystemException, Exception {
        String archiveBaseUrl = null;
        DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(digitalAssetId, db);
        if (digitalAsset != null) {
            String fileName = digitalAsset.getAssetFileName();
            int i = 0;
            File masterFile = null;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File unzipDirectory = new File(String.valueOf(filePath) + File.separator + fileName.substring(0, fileName.lastIndexOf(".")));
                unzipDirectory.mkdirs();
                if (masterFile == null) {
                    masterFile = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndUnzipDigitalAsset(digitalAsset, fileName, filePath, unzipDirectory, db);
                } else {
                    DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndUnzipDigitalAsset(masterFile, fileName, filePath, unzipDirectory);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = NodeDeliveryController.getNodeDeliveryController(null, null, null).getSiteNode(db, siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            archiveBaseUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName.substring(0, fileName.lastIndexOf(".")), deliveryContext);
        }
        return archiveBaseUrl;
    }

    public Vector getArchiveEntries(Database db, Integer contentId, Integer languageId, String assetKey, Integer siteNodeId, boolean useLanguageFallback, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        DigitalAssetVO digitalAsset;
        Vector entries = null;
        ContentVersion contentVersion = this.getContentVersion(siteNodeId, contentId, languageId, db, useLanguageFallback, deliveryContext, infoGluePrincipal);
        if (contentVersion != null && (digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getContentVersionId(), assetKey, db)) != null) {
            String fileName = digitalAsset.getAssetFileName();
            int i = 0;
            File masterFile = null;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File unzipDirectory = new File(String.valueOf(filePath) + File.separator + fileName.substring(0, fileName.lastIndexOf(".")));
                unzipDirectory.mkdirs();
                if (masterFile == null) {
                    entries = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndGetZipEntries(digitalAsset, fileName, filePath, unzipDirectory, db);
                    masterFile = new File(String.valueOf(filePath) + File.separator + fileName);
                } else {
                    entries = DigitalAssetDeliveryController.getDigitalAssetDeliveryController().dumpAndGetZipEntries(masterFile, fileName, filePath, unzipDirectory);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
        }
        return entries;
    }

    public String getAttributeValue(Database db, ContentVersionVO contentVersionVO, String key, boolean escapeHTML) {
        String value = "";
        if (contentVersionVO != null) {
            try {
                String xml = contentVersionVO.getVersionValue();
                int startTagIndex = xml.indexOf("<" + key + ">");
                int endTagIndex = xml.indexOf("]]></" + key + ">");
                if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
                    value = xml.substring(startTagIndex + key.length() + 11, endTagIndex);
                }
                if (escapeHTML) {
                    value = this.formatter.escapeHTML(value);
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not return the attribute value:" + e), (Throwable)e);
            }
        }
        return value;
    }

    public List getChildContents(Database db, InfoGluePrincipal infoGluePrincipal, Integer contentId, Integer languageId, boolean useLanguageFallback, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        ArrayList childContents = new ArrayList();
        this.getChildContents(infoGluePrincipal, childContents, contentId, languageId, useLanguageFallback, 0, false, includeFolders, 1, db, deliveryContext);
        return childContents;
    }

    public List getSortedChildContents(InfoGluePrincipal infoGluePrincipal, Integer languageId, Integer contentId, Integer siteNodeId, Database db, boolean searchRecursive, Integer maximumNumberOfLevels, String sortAttribute, String sortOrder, boolean useLanguageFallback, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        String sortedChildContentsKey = infoGluePrincipal.getName() + "_" + languageId + "_" + contentId + "_" + siteNodeId + "_" + searchRecursive + "_" + maximumNumberOfLevels + "_" + sortAttribute + "_" + sortOrder + "_" + useLanguageFallback + "_" + includeFolders;
        logger.info((Object)("sortedChildContentsKey:" + sortedChildContentsKey));
        String cacheName = "sortedChildContentsCache";
        List cachedSortedContentVOList = (List)CacheController.getCachedObject(cacheName, sortedChildContentsKey);
        if (cachedSortedContentVOList != null) {
            logger.info((Object)("There was an cached content cachedSortedContentVOList:" + cachedSortedContentVOList.size()));
            return cachedSortedContentVOList;
        }
        ArrayList<ContentVO> sortedContentVOList = new ArrayList<ContentVO>();
        List unsortedChildren = this.getChildContents(infoGluePrincipal, languageId, useLanguageFallback, contentId, siteNodeId, searchRecursive, maximumNumberOfLevels, db, includeFolders, deliveryContext);
        List sortedContents = this.sortContents(db, unsortedChildren, languageId, siteNodeId, sortAttribute, sortOrder, useLanguageFallback, includeFolders, deliveryContext, infoGluePrincipal);
        for (Content content : sortedContents) {
            sortedContentVOList.add(content.getValueObject());
        }
        CacheController.cacheObject(cacheName, sortedChildContentsKey, sortedContentVOList);
        return sortedContentVOList;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO(Database db, Integer contentId) throws SystemException, Exception {
        ContentTypeDefinitionVO contentTypeDefinitionVO = null;
        if (contentId != null && contentId > 0) {
            Content content = (Content)this.getObjectWithId(ContentImpl.class, contentId, db);
            contentTypeDefinitionVO = content.getContentTypeDefinition().getValueObject();
        }
        return contentTypeDefinitionVO;
    }

    private List getChildContents(InfoGluePrincipal infoGluePrincipal, Integer languageId, boolean useLanguageFallback, Integer contentId, Integer siteNodeId, boolean searchRecursive, Integer maximumNumberOfLevels, Database db, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        ArrayList contents = new ArrayList();
        this.getChildContents(infoGluePrincipal, contents, contentId, languageId, useLanguageFallback, 0, searchRecursive, maximumNumberOfLevels, db, includeFolders, deliveryContext);
        return contents;
    }

    private void getChildContents(InfoGluePrincipal infoGluePrincipal, List contents, Integer contentId, Integer languageId, boolean useLanguageFallback, int currentLevel, boolean searchRecursive, int maximumNumberOfLevels, Database db, boolean includeFolders, DeliveryContext deliveryContext) throws SystemException, Exception {
        deliveryContext.addUsedContent("selectiveCacheUpdateNonApplicable");
        OQLQuery oql = db.getOQLQuery("SELECT content FROM org.infoglue.cms.entities.content.impl.simple.ContentImpl content WHERE content.parentContent.contentId = $1 ORDER BY content.contentId");
        oql.bind((Object)contentId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            Content content = (Content)results.next();
            if (searchRecursive && currentLevel < maximumNumberOfLevels) {
                this.getChildContents(infoGluePrincipal, contents, content.getContentId(), languageId, useLanguageFallback, currentLevel + 1, searchRecursive, maximumNumberOfLevels, db, includeFolders, deliveryContext);
            }
            if (!this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, includeFolders, db, deliveryContext)) continue;
            contents.add(content);
        }
        results.close();
        oql.close();
    }

    private void getChildContents(InfoGluePrincipal infoGluePrincipal, List contents, Integer contentId, Integer languageId, boolean useLanguageFallback, int currentLevel, boolean searchRecursive, boolean includeFolders, int maximumNumberOfLevels, Database db, DeliveryContext deliveryContext) throws SystemException, Exception {
        deliveryContext.addUsedContent("selectiveCacheUpdateNonApplicable");
        OQLQuery oql = db.getOQLQuery("SELECT content FROM org.infoglue.cms.entities.content.impl.simple.ContentImpl content WHERE content.parentContent.contentId = $1 ORDER BY content.contentId");
        oql.bind((Object)contentId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            Content content = (Content)results.next();
            if (searchRecursive && currentLevel < maximumNumberOfLevels) {
                this.getChildContents(infoGluePrincipal, contents, content.getContentId(), languageId, useLanguageFallback, currentLevel + 1, searchRecursive, includeFolders, maximumNumberOfLevels, db, deliveryContext);
            }
            if (content.getIsBranch().booleanValue() && includeFolders && this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, includeFolders, db, deliveryContext)) {
                contents.add(content);
                continue;
            }
            if (!this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, includeFolders, db, deliveryContext)) continue;
            contents.add(content);
        }
        results.close();
        oql.close();
    }

    private boolean isValidOnDates(Date publishDate, Date expireDate, boolean validateOnDates) {
        if (!validateOnDates) {
            return true;
        }
        return this.isValidOnDates(publishDate, expireDate);
    }

    private boolean isValidOnDates(Date publishDate, Date expireDate) {
        boolean isValid = true;
        Date now = new Date();
        if (publishDate.after(now) || expireDate.before(now)) {
            isValid = false;
        }
        return isValid;
    }

    public boolean isValidContent(Database db, Integer contentId, Integer languageId, boolean useLanguageFallback, boolean includeFolders, InfoGluePrincipal infoGluePrincipal, DeliveryContext deliveryContext) throws Exception {
        boolean isValidContent = false;
        Content content = (Content)this.getObjectWithId(ContentImpl.class, contentId, db);
        isValidContent = this.isValidContent(infoGluePrincipal, content, languageId, useLanguageFallback, includeFolders, db, deliveryContext);
        return isValidContent;
    }

    public boolean isValidContent(InfoGluePrincipal infoGluePrincipal, Content content, Integer languageId, boolean useLanguageFallBack, boolean includeFolders, Database db, DeliveryContext deliveryContext) throws Exception {
        boolean isValidContent = false;
        if (infoGluePrincipal == null) {
            throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.");
        }
        if (content.getContentTypeDefinition() != null && content.getContentTypeDefinition().getName().equalsIgnoreCase("Meta info")) {
            return true;
        }
        boolean validateOnDates = true;
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        if (operatingMode.equals("0")) {
            validateOnDates = deliveryContext.getValidateOnDates();
        }
        Integer protectedContentId = this.getProtectedContentId(db, content);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("content:" + content.getName()));
            logger.info((Object)("IsProtected:" + protectedContentId));
        }
        if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Content.Read", protectedContentId.toString())) {
            return false;
        }
        if (includeFolders && content.getIsBranch().booleanValue() && this.isValidOnDates(content.getPublishDateTime(), content.getExpireDateTime(), validateOnDates)) {
            isValidContent = true;
        } else if (this.isValidOnDates(content.getPublishDateTime(), content.getExpireDateTime(), validateOnDates)) {
            LanguageVO masterLanguage;
            ContentVersion contentVersion = this.getContentVersion(content, languageId, this.getOperatingMode(), deliveryContext, db);
            Integer repositoryId = null;
            RepositoryImpl repository = content.getRepository();
            if (repository == null) {
                if (content instanceof MediumContentImpl) {
                    repositoryId = ((MediumContentImpl)content).getRepositoryId();
                }
                if (content instanceof SmallishContentImpl) {
                    repositoryId = ((SmallishContentImpl)content).getRepositoryId();
                } else if (content instanceof SmallContentImpl) {
                    repositoryId = ((SmallContentImpl)content).getRepositoryId();
                }
            } else {
                repositoryId = repository.getId();
            }
            if (contentVersion == null && useLanguageFallBack && repositoryId != null && (masterLanguage = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(repositoryId, db)) != null && !masterLanguage.getId().equals(languageId)) {
                contentVersion = this.getContentVersion(content, masterLanguage.getId(), this.getOperatingMode(), deliveryContext, db);
            }
            if (contentVersion != null) {
                isValidContent = true;
            }
        }
        if (isValidContent && !content.getExpireDateTime().before(new Date())) {
            Date expireDateTimeCandidate = content.getExpireDateTime();
            if (CacheController.expireDateTime == null || expireDateTimeCandidate.before(CacheController.expireDateTime)) {
                CacheController.expireDateTime = expireDateTimeCandidate;
            }
        } else if (content.getPublishDateTime().after(new Date())) {
            Date publishDateTimeCandidate = content.getPublishDateTime();
            if (CacheController.publishDateTime == null || publishDateTimeCandidate.after(CacheController.publishDateTime)) {
                CacheController.publishDateTime = publishDateTimeCandidate;
            }
        }
        return isValidContent;
    }

    public Integer getProtectedContentId(Database db, Integer contentId) throws SystemException, Exception {
        Integer protectedContentId = null;
        Content content = (Content)this.getObjectWithId(ContentImpl.class, contentId, db);
        protectedContentId = this.getProtectedContentId(db, content);
        return protectedContentId;
    }

    public Integer getProtectedContentId(Database db, Content content) {
        Integer protectedContentId = null;
        try {
            logger.info((Object)("content:" + content.getId() + ":" + content.getIsProtected()));
            if (content != null && content.getIsProtected() != null) {
                if (content.getIsProtected().intValue() == ContentVO.NO.intValue()) {
                    protectedContentId = null;
                } else if (content.getIsProtected().intValue() == ContentVO.YES.intValue()) {
                    protectedContentId = content.getId();
                } else if (content.getIsProtected().intValue() == ContentVO.INHERITED.intValue()) {
                    ContentImpl parentContent = null;
                    if (content instanceof MediumContentImpl) {
                        Integer parentContentId = ((MediumContentImpl)content).getParentContentId();
                        if (parentContentId != null) {
                            parentContent = (MediumContentImpl)this.getObjectWithId(MediumContentImpl.class, parentContentId, db);
                        }
                    } else if (content instanceof SmallContentImpl) {
                        Integer parentContentId = ((SmallContentImpl)content).getParentContentId();
                        if (parentContentId != null) {
                            parentContent = (SmallContentImpl)this.getObjectWithId(SmallContentImpl.class, parentContentId, db);
                        }
                    } else if (content instanceof ContentImpl) {
                        parentContent = content.getParentContent();
                    }
                    if (parentContent != null) {
                        protectedContentId = this.getProtectedContentId(db, parentContent);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return protectedContentId;
    }

    public List sortContents(Database db, Collection contents, Integer languageId, Integer siteNodeId, String sortAttributeName, String sortOrder, boolean useLanguageFallback, boolean includeFolders, DeliveryContext deliveryContext, InfoGluePrincipal infoGluePrincipal) {
        ArrayList<Content> sortedContents = new ArrayList<Content>();
        try {
            for (Content content : contents) {
                if (!includeFolders && content.getIsBranch().booleanValue()) continue;
                int index = 0;
                for (Content sortedContent : sortedContents) {
                    Date sortedDate;
                    Date date;
                    if (sortAttributeName.equalsIgnoreCase("name")) {
                        String name = content.getName();
                        String sortedName = sortedContent.getName();
                        if (name != null && sortedName != null && sortOrder.equalsIgnoreCase("asc") && name.compareTo(sortedName) < 0 || name != null && sortedName != null && sortOrder.equalsIgnoreCase("desc") && name.compareTo(sortedName) > 0) {
                            break;
                        }
                    } else if (sortAttributeName.equalsIgnoreCase("publishDateTime")) {
                        date = content.getPublishDateTime();
                        sortedDate = sortedContent.getPublishDateTime();
                        if (date != null && sortedDate != null && sortOrder.equalsIgnoreCase("asc") && date.before(sortedDate) || date != null && sortedDate != null && sortOrder.equalsIgnoreCase("desc") && date.after(sortedDate)) {
                            break;
                        }
                    } else if (sortAttributeName.equalsIgnoreCase("expireDateTime")) {
                        date = content.getExpireDateTime();
                        sortedDate = sortedContent.getExpireDateTime();
                        if (date != null && sortedDate != null && sortOrder.equalsIgnoreCase("asc") && date.before(sortedDate) || date != null && sortedDate != null && sortOrder.equalsIgnoreCase("desc") && date.after(sortedDate)) {
                            break;
                        }
                    } else {
                        String contentAttribute = this.getContentAttribute(db, content.getId(), languageId, sortAttributeName, siteNodeId, useLanguageFallback, deliveryContext, infoGluePrincipal, false);
                        String sortedContentAttribute = this.getContentAttribute(db, sortedContent.getId(), languageId, sortAttributeName, siteNodeId, useLanguageFallback, deliveryContext, infoGluePrincipal, false);
                        if (contentAttribute != null && sortedContentAttribute != null && sortOrder.equalsIgnoreCase("asc") && contentAttribute.compareTo(sortedContentAttribute) < 0 || contentAttribute != null && sortedContentAttribute != null && sortOrder.equalsIgnoreCase("desc") && contentAttribute.compareTo(sortedContentAttribute) > 0) break;
                    }
                    ++index;
                }
                sortedContents.add(index, content);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("The sorting of contents failed:" + e.getMessage()), (Throwable)e);
        }
        return sortedContents;
    }
}

